/*
 * Decompiled with CFR 0.152.
 */
package jhpro.stat.limit;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import java.util.Random;

public class LimitCalculatorGui
implements ActionListener {
    private static final long serialVersionUID = 1L;
    static final int NMAX = 10;
    static final double EPSILON = 1.0E-4;
    double S;
    double sigma;
    static Integer INT = new Integer(1);
    static Math M;
    static NumberFormat NF;
    static Random rrr;
    static Float FLO;
    Panel p;
    Panel top;
    Panel bottom;
    Panel middle;
    TextField textfield1 = new TextField("3", 10);
    TextField textfield2 = new TextField("1", 10);
    TextField textfield3 = new TextField("0.0", 10);
    TextField textfield4 = new TextField("5", 10);
    TextField textfield5 = new TextField("10000", 10);
    TextField textfield9 = new TextField("0", 10);
    TextField textfield10 = new TextField("0", 10);
    TextField textfield6 = new TextField(10);
    TextField textfield7 = new TextField(10);
    TextField textfield8 = new TextField(10);
    ExperimentData elist;
    myFrame f;
    boolean allzero;
    boolean upperLimits;
    double epsilon;

    public static void main(String[] args) {
        LimitCalculatorGui ut = new LimitCalculatorGui();
        ut.init();
    }

    public static int prand(double f) {
        if (f < 0.0) {
            return 0;
        }
        double prob = rrr.nextDouble();
        int n = 0;
        double probi = Math.exp(-f);
        while (n < 1000) {
            if ((prob -= probi) <= 0.0) {
                return n;
            }
            probi *= f / (double)(++n);
        }
        return 0;
    }

    public void init() {
        this.elist = new ExperimentData();
        this.f = new myFrame("Limits and Systematics");
        this.f.setLayout(new BorderLayout());
        this.epsilon = 1.0E-4;
        this.upperLimits = true;
        this.top = new Panel();
        this.bottom = new Panel();
        this.f.add("North", this.top);
        this.f.add("Center", this.elist);
        this.f.add("South", this.bottom);
        this.top.setLayout(new GridLayout(6, 2));
        this.top.add(new Label("syslimit", 2));
        this.top.add(new Label(" v1.00", 0));
        this.top.add(new Label("Adjust upper fields", 2));
        this.top.add(new Label(" as desired", 0));
        this.top.add(new Label("Sensitivity factor  ", 1));
        this.top.add(this.textfield2);
        this.top.add(new Label(" Error on Sensitivity  ", 1));
        this.top.add(this.textfield3);
        this.top.add(new Label("Limit guess  ", 1));
        this.top.add(this.textfield4);
        this.top.add(new Label("N Monte Carlo   ", 1));
        this.top.add(this.textfield5);
        this.bottom.setLayout(new GridLayout(4, 3));
        this.bottom.setBackground(Color.green);
        this.bottom.add(new Label("Probability  (BaBar SWG) ", 1));
        this.bottom.add(new Label("Probability  (Cousins+Highland) ", 1));
        this.bottom.add(new Label("Probability  (Jeffreys) ", 1));
        this.bottom.add(this.textfield6);
        this.bottom.add(this.textfield7);
        this.bottom.add(this.textfield8);
        this.bottom.setBackground(Color.white);
        Button a = new Button(" Calculate for Upper Limit");
        a.setBackground(Color.green);
        a.setForeground(Color.black);
        a.setActionCommand("RunU");
        Button d = new Button(" Calculate for Lower Limit");
        d.setBackground(Color.yellow);
        d.setForeground(Color.black);
        d.setActionCommand("RunL");
        Button b = new Button(" Stop");
        b.setBackground(Color.red);
        b.setForeground(Color.black);
        b.setActionCommand("Stop");
        Button c = new Button(" Add Expt");
        c.setBackground(Color.pink);
        c.setForeground(Color.black);
        c.setActionCommand("Add");
        this.bottom.add(a);
        this.bottom.add(c);
        this.bottom.add(d);
        Label empty = new Label("");
        this.bottom.add(empty);
        this.bottom.add(b);
        a.addActionListener(this.f);
        b.addActionListener(this.f);
        c.addActionListener(this.f);
        d.addActionListener(this.f);
        this.f.pack();
        this.f.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
    }

    static {
        NF = NumberFormat.getInstance();
        rrr = new Random();
        FLO = new Float(1.0);
    }

    public class ExperimentData
    extends Panel {
        int[] nobs = new int[10];
        double[] back = new double[10];
        double[] errback = new double[10];
        double[] fraction = new double[10];
        double[] errfraction = new double[10];
        TextField[][] textfields = new TextField[10][5];
        int nexp;
        double pole;

        ExperimentData() {
            this.add(new Label("Number Seen ", 1));
            this.add(new Label("Background   ", 2));
            this.add(new Label("+- Error ", 0));
            this.nexp = 0;
            this.addexperiment();
            this.setLayout(new GridLayout(0, 3));
        }

        void addexperiment() {
            if (this.nexp == 10) {
                return;
            }
            this.textfields[this.nexp][0] = new TextField("0", 10);
            this.textfields[this.nexp][1] = new TextField("0.0", 10);
            this.textfields[this.nexp][2] = new TextField("0.0", 10);
            this.textfields[this.nexp][3] = new TextField("1.0", 10);
            this.textfields[this.nexp][4] = new TextField("0.0", 10);
            if (this.nexp == 1) {
                this.remove(this.textfields[0][0]);
                this.remove(this.textfields[0][1]);
                this.remove(this.textfields[0][2]);
                this.add(new Label("Specific sensitivity ", 2));
                this.add(new Label("+- Error ", 0));
                for (int j = 0; j < 5; ++j) {
                    this.add(this.textfields[0][j]);
                }
                this.setLayout(new GridLayout(0, 5));
            }
            int icount = this.nexp > 0 ? 5 : 3;
            for (int j = 0; j < icount; ++j) {
                this.add(this.textfields[this.nexp][j]);
            }
            ++this.nexp;
        }

        boolean getdata() {
            LimitCalculatorGui.this.allzero = true;
            this.pole = 1.0;
            for (int i = 0; i < this.nexp; ++i) {
                String s = this.textfields[i][0].getText();
                this.nobs[i] = Integer.parseInt(s);
                s = this.textfields[i][1].getText();
                this.back[i] = Float.valueOf(s).floatValue();
                s = this.textfields[i][2].getText();
                this.errback[i] = Float.valueOf(s).floatValue();
                s = this.textfields[i][3].getText();
                this.fraction[i] = Float.valueOf(s).floatValue();
                s = this.textfields[i][4].getText();
                this.errfraction[i] = Float.valueOf(s).floatValue();
                if (this.nobs[i] == 0) continue;
                LimitCalculatorGui.this.allzero = false;
                double p = -this.back[i] / this.fraction[i];
                if (!(p > this.pole) && !(this.pole > 0.0)) continue;
                this.pole = p;
            }
            return LimitCalculatorGui.this.allzero;
        }
    }

    public class myFrame
    extends Frame
    implements ActionListener {
        private static final long serialVersionUID = 1L;

        myFrame(String s) {
            super(s);
        }

        public double q(double R, int[] n, double c, ExperimentData e) {
            double result = 0.0;
            for (int i = 0; i < e.nexp; ++i) {
                double cs = c * LimitCalculatorGui.this.elist.fraction[i];
                result += (double)n[i] * cs / (R * cs + LimitCalculatorGui.this.elist.back[i]) - cs;
            }
            return result;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            String opt = evt.getActionCommand();
            if (opt.equals("RunU") || opt.equals("RunL")) {
                LimitCalculatorGui.this.allzero = LimitCalculatorGui.this.elist.getdata();
                if (opt.equals("RunU")) {
                    LimitCalculatorGui.this.epsilon = 1.0E-4;
                } else {
                    LimitCalculatorGui.this.epsilon = -1.0E-4;
                    if (LimitCalculatorGui.this.allzero) {
                        LimitCalculatorGui.this.textfield6.setText("That's impossible!");
                        return;
                    }
                }
                String s = LimitCalculatorGui.this.textfield2.getText();
                LimitCalculatorGui.this.S = Float.valueOf(s).floatValue();
                s = LimitCalculatorGui.this.textfield3.getText();
                LimitCalculatorGui.this.sigma = Float.valueOf(s).floatValue();
                s = LimitCalculatorGui.this.textfield4.getText();
                float limit = Float.valueOf(s).floatValue();
                s = LimitCalculatorGui.this.textfield5.getText();
                int NTODO = Integer.parseInt(s);
                double R3 = 0.0;
                if (!LimitCalculatorGui.this.allzero) {
                    double Q2;
                    double Q1;
                    LimitCalculatorGui.this.textfield6.setText("Seek");
                    double p = LimitCalculatorGui.this.elist.pole / LimitCalculatorGui.this.S;
                    double R1 = 0.0;
                    while (true) {
                        double d;
                        Q1 = this.q(R1, LimitCalculatorGui.this.elist.nobs, LimitCalculatorGui.this.S, LimitCalculatorGui.this.elist);
                        if (!(d < 0.0)) break;
                        R1 = (p + R1) / 2.0;
                    }
                    double R2 = 1.0;
                    while (true) {
                        double d;
                        Q2 = this.q(R2, LimitCalculatorGui.this.elist.nobs, LimitCalculatorGui.this.S, LimitCalculatorGui.this.elist);
                        if (!(d > 0.0)) break;
                        R2 *= 2.0;
                    }
                    int safetycount = 0;
                    do {
                        double Q3;
                        if (Q1 * (Q3 = this.q(R3 = 0.5 * (R1 + R2), LimitCalculatorGui.this.elist.nobs, LimitCalculatorGui.this.S, LimitCalculatorGui.this.elist)) > 0.0) {
                            R1 = R3;
                            Q1 = Q3;
                        } else {
                            R2 = R3;
                            Q2 = Q3;
                        }
                        if (Math.abs(Q3) <= 10.0 * (double)1.4E-45f || ++safetycount > 100) break;
                    } while (!(Math.abs(R1 - R2) <= 10.0 * (double)1.4E-45f));
                }
                int scoreSWG = 0;
                int scoreCH = 0;
                int scoreJ = 0;
                LimitCalculatorGui.this.textfield6.setText("I'm thinking!");
                int[] resultSWG = new int[10];
                int[] resultCH = new int[10];
                int[] resultJ = new int[10];
                for (int j = 0; j < NTODO; ++j) {
                    boolean gotallzeroSWG = true;
                    boolean gotallzeroCH = true;
                    boolean gotallzeroJ = true;
                    double thing = LimitCalculatorGui.this.sigma * rrr.nextGaussian() / LimitCalculatorGui.this.S;
                    double aCH = LimitCalculatorGui.this.S * (1.0 + thing);
                    double aSWG = LimitCalculatorGui.this.S / (1.0 + thing);
                    double aJ = LimitCalculatorGui.this.S * Math.exp(thing);
                    for (int i = 0; i < LimitCalculatorGui.this.elist.nexp; ++i) {
                        thing = LimitCalculatorGui.this.elist.errfraction[i] * rrr.nextGaussian() / LimitCalculatorGui.this.elist.fraction[i];
                        double cCH = LimitCalculatorGui.this.elist.fraction[i] * (1.0 + thing);
                        double cSWG = LimitCalculatorGui.this.elist.fraction[i] / (1.0 + thing);
                        double cJ = LimitCalculatorGui.this.elist.fraction[i] * Math.exp(thing);
                        double b = LimitCalculatorGui.this.elist.back[i] + LimitCalculatorGui.this.elist.errback[i] * rrr.nextGaussian();
                        resultSWG[i] = LimitCalculatorGui.prand((double)limit * aSWG * cSWG + b);
                        if (resultSWG[i] != 0) {
                            gotallzeroSWG = false;
                        }
                        resultCH[i] = LimitCalculatorGui.prand((double)limit * aCH * cCH + b);
                        if (resultCH[i] != 0) {
                            gotallzeroCH = false;
                        }
                        resultJ[i] = LimitCalculatorGui.prand((double)limit * aJ * cJ + b);
                        if (resultJ[i] == 0) continue;
                        gotallzeroJ = false;
                    }
                    if (LimitCalculatorGui.this.allzero) {
                        if (gotallzeroSWG) {
                            ++scoreSWG;
                        }
                        if (gotallzeroCH) {
                            ++scoreCH;
                        }
                        if (!gotallzeroJ) continue;
                        ++scoreJ;
                        continue;
                    }
                    if (this.q(R3, resultSWG, LimitCalculatorGui.this.S, LimitCalculatorGui.this.elist) < LimitCalculatorGui.this.epsilon) {
                        ++scoreSWG;
                    }
                    if (this.q(R3, resultCH, LimitCalculatorGui.this.S, LimitCalculatorGui.this.elist) < LimitCalculatorGui.this.epsilon) {
                        ++scoreCH;
                    }
                    if (!(this.q(R3, resultJ, LimitCalculatorGui.this.S, LimitCalculatorGui.this.elist) < LimitCalculatorGui.this.epsilon)) continue;
                    ++scoreJ;
                }
                LimitCalculatorGui.this.textfield6.setText(NF.format((float)scoreSWG / (float)NTODO));
                LimitCalculatorGui.this.textfield7.setText(NF.format((float)scoreCH / (float)NTODO));
                LimitCalculatorGui.this.textfield8.setText(NF.format((float)scoreJ / (float)NTODO));
            }
            if (opt.equals("Stop")) {
                this.dispose();
                System.exit(1);
            }
            if (opt.equals("Add")) {
                LimitCalculatorGui.this.elist.addexperiment();
                LimitCalculatorGui.this.f.add("Center", LimitCalculatorGui.this.elist);
            }
            LimitCalculatorGui.this.f.pack();
            LimitCalculatorGui.this.f.setVisible(true);
        }
    }
}

