/*
 * Decompiled with CFR 0.152.
 */
package jhpro.stat;

import jhplot.P0D;

public class ConfInterval {
    private double lo;
    private double hi;
    private double variance;
    private double stddev;
    private double xbar;

    public ConfInterval(P0D p0d) {
        double sumx = 0.0;
        for (int i = 0; i < p0d.size(); ++i) {
            sumx += p0d.get(i);
        }
        this.xbar = sumx / (double)p0d.size();
        double xxbar = 0.0;
        for (int i = 0; i < p0d.size(); ++i) {
            xxbar += (p0d.get(i) - this.xbar) * (p0d.get(i) - this.xbar);
        }
        this.variance = xxbar / (double)(p0d.size() - 1);
        this.stddev = Math.sqrt(this.variance);
        this.lo = this.xbar - 1.96 * this.stddev;
        this.hi = this.xbar + 1.96 * this.stddev;
    }

    double getMean() {
        return this.xbar;
    }

    double getVariance() {
        return this.variance;
    }

    double getStdDev() {
        return this.stddev;
    }

    double getMinCon() {
        return this.lo;
    }

    double getMaxCon() {
        return this.hi;
    }
}

