/*
 * Decompiled with CFR 0.152.
 */
package jhpro.nnet;

import java.io.Serializable;
import jhpro.nnet.InputValue;
import jhpro.nnet.Neuron;
import jhpro.nnet.Pattern;
import jhpro.nnet.WeightMatrix;

public class NeuronLayer
implements Serializable {
    Neuron[] neuron;

    public NeuronLayer(int i) {
        this.neuron = new Neuron[i];
        for (int j = 0; j < i; ++j) {
            this.neuron[j] = new Neuron();
        }
    }

    public void setInput(Pattern pattern) {
        for (int i = 0; i < this.neuron.length; ++i) {
            this.neuron[i].init(pattern.getValue(i));
        }
    }

    public void setInput(InputValue inputvalue) {
        float[] af = new float[]{(float)inputvalue.getX(), (float)inputvalue.getY(), (float)inputvalue.getZ()};
        for (int i = 0; i < this.neuron.length; ++i) {
            this.neuron[i].init(af[i]);
        }
    }

    public void computeInput(NeuronLayer neuronlayer, WeightMatrix weightmatrix) {
        for (int i = 0; i < this.neuron.length; ++i) {
            this.neuron[i].computeInput(neuronlayer.getOutput(), weightmatrix.getInputWeights(i));
        }
    }

    public void computeOutput() {
        for (int i = 0; i < this.neuron.length; ++i) {
            this.neuron[i].activateSigmoid();
        }
    }

    public void computeLayerError(Pattern pattern) {
        for (int i = 0; i < this.neuron.length; ++i) {
            this.neuron[i].computeOutputError(pattern.getValue(i));
        }
    }

    public void computeLayerError(NeuronLayer neuronlayer, WeightMatrix weightmatrix) {
        for (int i = 0; i < this.neuron.length; ++i) {
            this.neuron[i].computeOutputError(neuronlayer.getLayerError(), weightmatrix.getOutputWeights(i));
        }
    }

    public float[] getOutput() {
        float[] af = new float[this.neuron.length];
        for (int i = 0; i < this.neuron.length; ++i) {
            af[i] = this.neuron[i].getOutput();
        }
        return af;
    }

    public float[] getLayerError() {
        float[] af = new float[this.neuron.length];
        for (int i = 0; i < this.neuron.length; ++i) {
            af[i] = this.neuron[i].getOutputError();
        }
        return af;
    }

    public int size() {
        return this.neuron.length;
    }
}

