/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.jforests.tools;

import edu.uci.jforests.input.FeatureValuePair;
import edu.uci.jforests.input.sparse.FeatureMetaData;
import edu.uci.jforests.input.sparse.MetaData;
import edu.uci.jforests.input.sparse.MetaLineParser;
import edu.uci.jforests.input.sparse.SparseTextFileLine;
import edu.uci.jforests.input.sparse.SparseTextFileReader;
import java.io.File;
import java.io.PrintStream;

public class Sparse2ArffConvertor {
    private SparseTextFileReader reader;
    private PrintStream output;
    private boolean dumpAsSparse;
    private SparseTextFileLine line;
    private int featureCount;
    private StringBuilder sb;
    private int targetColIdx;

    public void init(String inputFile, String outputFile, boolean dumpAsSparse) throws Exception {
        this.reader = new SparseTextFileReader();
        this.reader.open(inputFile);
        this.dumpAsSparse = dumpAsSparse;
        this.output = new PrintStream(new File(outputFile));
        this.output.println("@RELATION myrel");
        this.output.println();
        this.sb = new StringBuilder();
        this.line = new SparseTextFileLine();
    }

    public void dumpHeaderFromInputFile() {
        this.featureCount = 0;
        while (this.reader.loadNextLine(this.line)) {
            if (this.line.meta) {
                MetaData metaData = MetaLineParser.parse(this.line.content);
                if (!(metaData instanceof FeatureMetaData)) continue;
                this.output.println("@ATTRIBUTE " + ((FeatureMetaData)metaData).name + " REAL");
                ++this.featureCount;
                continue;
            }
            this.output.println("@ATTRIBUTE target REAL");
            this.output.println("");
            this.output.println("@DATA");
            this.targetColIdx = this.featureCount;
            this.processLine(this.line);
            break;
        }
    }

    public void dumpHeader(int featureCount) {
        for (int f = 0; f < featureCount; ++f) {
            this.output.println("@ATTRIBUTE f" + (f + 1) + " REAL");
        }
        this.featureCount = featureCount;
        this.output.println("@ATTRIBUTE target REAL");
        this.output.println("");
        this.output.println("@DATA");
        this.targetColIdx = featureCount;
    }

    private void processLine(SparseTextFileLine line) {
        this.sb.setLength(0);
        if (this.dumpAsSparse) {
            this.sb.append("{");
            for (int i = 0; i < line.numPairs; ++i) {
                FeatureValuePair pair = line.pairs[i];
                if (this.sb.length() > 1) {
                    this.sb.append(",");
                }
                this.sb.append(pair.featureIndex - 1 + " " + pair.featureValue);
            }
            this.sb.append(", " + this.targetColIdx + " " + line.target);
            this.sb.append("}\n");
        } else {
            int i;
            int prevFeatureIdx = 0;
            for (i = 0; i < line.numPairs; ++i) {
                String fValue;
                FeatureValuePair pair = line.pairs[i];
                while (pair.featureIndex > prevFeatureIdx + 1) {
                    if (this.sb.length() > 0) {
                        this.sb.append(",");
                    }
                    this.sb.append("0");
                    ++prevFeatureIdx;
                }
                if (this.sb.length() > 0) {
                    this.sb.append(",");
                }
                if ((fValue = "" + pair.featureValue).endsWith(".0")) {
                    fValue = fValue.substring(0, fValue.length() - 2);
                }
                this.sb.append(fValue);
                prevFeatureIdx = pair.featureIndex;
            }
            for (i = prevFeatureIdx; i < this.featureCount; ++i) {
                this.sb.append(",0");
            }
            this.sb.append("," + line.target + "\n");
        }
        this.output.print(this.sb.toString());
    }

    public void convert() throws Exception {
        int count = 0;
        while (this.reader.loadNextLine(this.line)) {
            this.processLine(this.line);
            if (++count % 10000 != 0) continue;
            System.out.println("\t Processed: " + count);
        }
        this.reader.close();
        this.output.close();
    }
}

