/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.jforests.input;

import edu.uci.jforests.input.FeatureStatistics;
import edu.uci.jforests.input.FeatureValuePair;
import edu.uci.jforests.input.sparse.FeatureMetaData;
import edu.uci.jforests.input.sparse.MetaData;
import edu.uci.jforests.input.sparse.MetaLineParser;
import edu.uci.jforests.input.sparse.SparseTextFileLine;
import edu.uci.jforests.input.sparse.SparseTextFileReader;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.TreeMap;

public class FeatureAnalyzer {
    private static final int MAX_FEATURE_VALUE = 32766;
    private TreeMap<Integer, FeatureStatistics> fid2statistics = new TreeMap();
    private HashMap<Integer, String> fid2name = new HashMap();
    public double[] min;
    public double[] max;
    public double[] factor;
    public boolean[] onLogScale;

    public void clear() {
        this.fid2statistics.clear();
        this.fid2name.clear();
    }

    public void processFolder(String folder, String extension) {
        File[] files;
        for (File file : files = new File(folder).listFiles()) {
            if (!file.getAbsolutePath().endsWith(extension)) continue;
            this.processFile(file.getAbsolutePath());
        }
    }

    public void processFiles(String folder, String[] files) {
        for (String file : files) {
            this.processFile(folder + file);
        }
    }

    public void processFile(String inputFile) {
        System.out.println("Processing: " + inputFile);
        SparseTextFileReader reader = new SparseTextFileReader();
        reader.open(inputFile);
        SparseTextFileLine line = new SparseTextFileLine();
        int count = 0;
        int maxFeatureIndex = 0;
        while (reader.loadNextLine(line)) {
            FeatureStatistics stat;
            if (line.meta) {
                MetaData metaData = MetaLineParser.parse(line.content);
                if (!(metaData instanceof FeatureMetaData)) continue;
                this.fid2name.put(((FeatureMetaData)metaData).id, ((FeatureMetaData)metaData).name);
                continue;
            }
            int prevIdx = 0;
            for (int i = 0; i < line.numPairs; ++i) {
                FeatureValuePair pair = line.pairs[i];
                if (pair.featureIndex != prevIdx + 1) {
                    for (int f = prevIdx + 1; f < pair.featureIndex; ++f) {
                        stat = this.fid2statistics.get(f);
                        if (stat == null) continue;
                        if (stat.maxValue < 0.0) {
                            stat.maxValue = 0.0;
                        }
                        if (!(stat.minValue > 0.0)) continue;
                        stat.minValue = 0.0;
                    }
                }
                if ((stat = this.fid2statistics.get(pair.featureIndex)) == null) {
                    stat = new FeatureStatistics();
                    this.fid2statistics.put(pair.featureIndex, stat);
                    if (count > 0) {
                        stat.minValue = 0.0;
                        stat.maxValue = 0.0;
                    }
                    if (pair.featureIndex > maxFeatureIndex) {
                        maxFeatureIndex = pair.featureIndex;
                    }
                }
                if (Double.isInfinite(pair.featureValue)) {
                    System.out.println(count + "\t" + pair.featureValue);
                }
                if (pair.featureValue > stat.maxValue) {
                    stat.maxValue = pair.featureValue;
                }
                if (pair.featureValue < stat.minValue) {
                    stat.minValue = pair.featureValue;
                }
                prevIdx = pair.featureIndex;
            }
            if (prevIdx < maxFeatureIndex) {
                for (int f = prevIdx + 1; f <= maxFeatureIndex; ++f) {
                    stat = this.fid2statistics.get(f);
                    if (stat == null) continue;
                    if (stat.maxValue < 0.0) {
                        stat.maxValue = 0.0;
                    }
                    if (!(stat.minValue > 0.0)) continue;
                    stat.minValue = 0.0;
                }
            }
            if (++count % 100000 != 0) continue;
            System.out.println("\t Processed: " + count);
            this.dumpStatistics(System.out);
        }
        reader.close();
        this.loadStatistics();
    }

    private void loadStatistics() {
        int featureCount = this.getFeatureCount();
        this.min = new double[featureCount];
        this.max = new double[featureCount];
        this.factor = new double[featureCount];
        this.onLogScale = new boolean[featureCount];
        for (int f = 0; f < featureCount; ++f) {
            FeatureStatistics stat = this.getStatistics(f + 1);
            if (stat == null) {
                this.min[f] = 0.0;
                this.max[f] = 0.0;
            } else {
                this.min[f] = stat.minValue;
                this.max[f] = stat.maxValue;
            }
            double range = this.max[f] - this.min[f];
            if (range < 32766.0) {
                this.factor[f] = 32766.0 / range;
                continue;
            }
            this.factor[f] = 32766.0 / Math.log(range + 1.0);
            this.onLogScale[f] = true;
        }
    }

    public FeatureStatistics getStatistics(int fid) {
        return this.fid2statistics.get(fid);
    }

    public String getFeatureName(int fid) {
        return this.fid2name.get(fid);
    }

    public int getFeatureCount() {
        return this.fid2statistics.lastKey();
    }

    public void loadFeaturesFromFile(String filename) {
        try {
            BufferedReader reader = new BufferedReader(new FileReader(new File(filename)));
            String line = reader.readLine();
            while ((line = reader.readLine()) != null) {
                String[] parts = line.split("\t");
                int fid = Integer.parseInt(parts[0]);
                String name = parts[1];
                FeatureStatistics stat = new FeatureStatistics();
                stat.minValue = Double.parseDouble(parts[2]);
                stat.maxValue = Double.parseDouble(parts[3]);
                this.fid2statistics.put(fid, stat);
                this.fid2name.put(fid, name);
            }
            reader.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.loadStatistics();
    }

    public void dumpStatistics(PrintStream output) {
        output.println("FeatureIndex\tName\tMin\tMax");
        Integer key = this.fid2statistics.firstKey();
        do {
            FeatureStatistics stat = this.fid2statistics.get(key);
            String name = this.fid2name.get(key);
            output.println(key + "\t" + name + "\t" + stat.minValue + "\t" + stat.maxValue);
        } while ((key = this.fid2statistics.higherKey(key)) != null);
    }

    public void printStatistics() {
        this.dumpStatistics(System.out);
    }
}

