/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.jforests.input;

import edu.uci.jforests.dataset.Feature;
import edu.uci.jforests.dataset.NumericArrayFactory;
import edu.uci.jforests.util.Util;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;

public class BinaryFileReader {
    BufferedInputStream input;
    private int version;
    private Feature[] features;
    private double[] targets;
    private int[] featureSizes;
    private NumericArrayFactory.NumericArrayType[] featureTypes;

    public BinaryFileReader(InputStream in) {
        try {
            this.input = new BufferedInputStream(in);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void read(byte[] buf, int offset, int len) {
        try {
            int toRead = len;
            while (toRead > 0) {
                int ret = this.input.read(buf, offset, toRead);
                if (ret < 0) {
                    throw new IOException("Premeture EOF from inputStream");
                }
                toRead -= ret;
                offset += ret;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void read(double[] arr) {
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = this.readDouble();
        }
    }

    protected int readInt() {
        byte[] buf = new byte[4];
        this.read(buf, 0, 4);
        return Util.toInt(buf, 0);
    }

    protected double readDouble() {
        byte[] buf = new byte[8];
        this.read(buf, 0, 8);
        return Util.toDouble(buf, 0);
    }

    private byte readByte() {
        byte[] buf = new byte[1];
        this.read(buf, 0, 1);
        return buf[0];
    }

    private Feature readFeature(int featureSize, NumericArrayFactory.NumericArrayType type) throws Exception {
        byte[] buf = new byte[featureSize];
        this.read(buf, 0, featureSize);
        Feature feature = new Feature(NumericArrayFactory.createNumericArray(type, this.targets.length));
        feature.loadFromByteArray(buf, 0);
        return feature;
    }

    public void close() {
        try {
            this.input.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected void readHeader() throws Exception {
        int f;
        this.version = this.readInt();
        if (this.version != 3) {
            throw new Exception("Expected bin file version: 3, found: " + this.version);
        }
        this.features = new Feature[this.readInt()];
        this.targets = new double[this.readInt()];
        this.featureSizes = new int[this.features.length];
        for (f = 0; f < this.features.length; ++f) {
            this.featureSizes[f] = this.readInt();
        }
        this.featureTypes = new NumericArrayFactory.NumericArrayType[this.features.length];
        for (f = 0; f < this.features.length; ++f) {
            this.featureTypes[f] = NumericArrayFactory.NumericArrayType.getFromOrdinal(this.readByte());
        }
    }

    public void read() throws Exception {
        this.readHeader();
        this.read(this.targets);
        for (int f = 0; f < this.features.length; ++f) {
            this.features[f] = this.readFeature(this.featureSizes[f], this.featureTypes[f]);
        }
    }

    public int getVersion() {
        return this.version;
    }

    public Feature[] getFeatures() {
        return this.features;
    }

    public double[] getTargets() {
        return this.targets;
    }
}

