/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.jforests.input;

import edu.uci.jforests.dataset.BitNumericArray;
import edu.uci.jforests.dataset.ByteNumericArray;
import edu.uci.jforests.dataset.Feature;
import edu.uci.jforests.dataset.IntNumericArray;
import edu.uci.jforests.dataset.NullNumericArray;
import edu.uci.jforests.dataset.NumericArray;
import edu.uci.jforests.dataset.ShortNumericArray;
import edu.uci.jforests.input.BinaryFileWriter;
import edu.uci.jforests.input.FeatureAnalyzer;
import edu.uci.jforests.input.FeatureValuePair;
import edu.uci.jforests.input.sparse.SparseTextFileLine;
import edu.uci.jforests.input.sparse.SparseTextFileReader;
import edu.uci.jforests.util.ArraysUtil;
import edu.uci.jforests.util.Timer;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BinaryFileGenerator {
    private List<HashMap<Integer, Integer>> valueHashMaps;
    private int[][] valueDistributions;
    private int[] totalCount;
    private NumericArray[] bins;
    protected double[] targets;
    protected Feature[] features;
    private FeatureAnalyzer featureAnalyzer;
    private int featureCount;
    private int instanceCount;
    private String textFile;
    private String featuresStatFile;
    private Timer timer;
    protected String binFile;
    protected BinaryFileWriter writer;

    public BinaryFileGenerator(String textFile, String featuresStatFile, String binFile) {
        this.textFile = textFile;
        this.featuresStatFile = featuresStatFile;
        this.binFile = binFile;
        this.timer = new Timer();
    }

    protected void handle(SparseTextFileLine line) {
    }

    protected void loadValueHashMaps() {
        this.timer.start();
        System.out.print("Loading values...");
        this.valueHashMaps = new ArrayList<HashMap<Integer, Integer>>(this.featureCount);
        for (int f = 0; f < this.featureCount; ++f) {
            this.valueHashMaps.add(new HashMap());
        }
        SparseTextFileReader reader = new SparseTextFileReader();
        reader.open(this.textFile);
        SparseTextFileLine line = new SparseTextFileLine();
        this.instanceCount = 0;
        while (reader.loadNextLine(line)) {
            if (line.meta) continue;
            for (int i = 0; i < line.numPairs; ++i) {
                int key;
                FeatureValuePair pair = line.pairs[i];
                HashMap<Integer, Integer> curMap = this.valueHashMaps.get(pair.featureIndex - 1);
                Integer count = curMap.get(key = (int)pair.featureValue);
                if (count == null) {
                    count = 0;
                }
                Integer n = count;
                count = count + 1;
                curMap.put(key, count);
            }
            this.handle(line);
            ++this.instanceCount;
        }
        reader.close();
        System.out.println("  [Done in: " + this.timer.getElapsedSeconds() + " seconds.]");
    }

    private void makeDistributions() {
        this.timer.start();
        System.out.print("Making distributions...");
        this.valueDistributions = new int[this.featureCount][];
        this.totalCount = new int[this.featureCount];
        ArrayList<Integer> valueMap = new ArrayList<Integer>();
        for (int f = 0; f < this.featureCount; ++f) {
            valueMap.clear();
            HashMap<Integer, Integer> curMap = this.valueHashMaps.get(f);
            this.totalCount[f] = 0;
            for (Map.Entry<Integer, Integer> entry : curMap.entrySet()) {
                valueMap.add(entry.getKey());
                int n = f;
                this.totalCount[n] = this.totalCount[n] + entry.getValue();
            }
            if (!valueMap.contains(0)) {
                valueMap.add(0);
            }
            Collections.sort(valueMap);
            this.valueDistributions[f] = ArraysUtil.toArray(valueMap);
        }
        System.out.println("  [Done in: " + this.timer.getElapsedSeconds() + " seconds.]");
    }

    private void makeBins() throws Exception {
        System.out.println("Making bins...");
        this.timer.start();
        this.bins = new NumericArray[this.featureCount];
        for (int i = 0; i < this.featureCount; ++i) {
            int numValues = this.valueDistributions[i].length;
            if (numValues == 1 && this.valueDistributions[i][0] == 0) {
                this.bins[i] = NullNumericArray.getInstance();
            } else if (numValues <= 2) {
                this.bins[i] = new BitNumericArray(this.instanceCount);
            } else if (numValues <= 127) {
                this.bins[i] = new ByteNumericArray(this.instanceCount);
            } else if (numValues <= Short.MAX_VALUE) {
                this.bins[i] = new ShortNumericArray(this.instanceCount);
            } else if (numValues <= Integer.MAX_VALUE) {
                this.bins[i] = new IntNumericArray(this.instanceCount);
            } else {
                throw new Exception("One of your features (" + i + ") have more than " + Integer.MAX_VALUE + " distinct values. The support for this feature is not implemented yet.");
            }
            System.out.println("Feature: " + i + ", type: " + this.bins[i].getType().toString());
        }
        this.targets = new double[this.instanceCount];
        int[] zeroCount = new int[this.featureCount];
        SparseTextFileReader reader = new SparseTextFileReader();
        reader.open(this.textFile);
        SparseTextFileLine line = new SparseTextFileLine();
        int instanceIdx = 0;
        while (reader.loadNextLine(line)) {
            if (line.meta) continue;
            this.targets[instanceIdx] = line.target;
            for (int i = 0; i < line.numPairs; ++i) {
                FeatureValuePair pair = line.pairs[i];
                int fidx = pair.featureIndex - 1;
                int index = Arrays.binarySearch(this.valueDistributions[fidx], (int)pair.featureValue);
                this.bins[fidx].set(instanceIdx, index);
                if (index != 0) continue;
                int n = fidx;
                zeroCount[n] = zeroCount[n] + 1;
            }
            ++instanceIdx;
        }
        reader.close();
        System.out.println("  [Done in: " + this.timer.getElapsedSeconds() + " seconds.]");
    }

    private void makeFeatures() {
        System.out.print("Making features...");
        this.timer.start();
        this.features = new Feature[this.featureCount];
        for (int f = 0; f < this.featureCount; ++f) {
            this.features[f] = new Feature(this.bins[f]);
            this.features[f].upperBounds = this.valueDistributions[f];
            this.features[f].setName(this.featureAnalyzer.getFeatureName(f + 1));
            this.features[f].setMin(this.featureAnalyzer.min[f]);
            this.features[f].setMax(this.featureAnalyzer.max[f]);
            this.features[f].setFactor(this.featureAnalyzer.factor[f]);
            this.features[f].setOnLogScale(this.featureAnalyzer.onLogScale[f]);
        }
        System.out.println("  [Done in: " + this.timer.getElapsedSeconds() + " seconds.]");
    }

    protected void createBinFile() {
        this.writer = new BinaryFileWriter(this.binFile, this.features, this.targets);
    }

    private void writeBinFile() {
        this.timer.start();
        System.out.print("Creating bin file...");
        this.writer.write();
        this.writer.close();
        System.out.println("  [Done in: " + this.timer.getElapsedSeconds() + " seconds.]");
    }

    public void convert() throws Exception {
        if (new File(this.binFile).exists()) {
            System.out.println("File: " + this.binFile + " already exists. Skipping it.");
            return;
        }
        this.featureAnalyzer = new FeatureAnalyzer();
        this.featureAnalyzer.loadFeaturesFromFile(this.featuresStatFile);
        this.featureCount = this.featureAnalyzer.getFeatureCount();
        this.loadValueHashMaps();
        this.makeDistributions();
        this.makeBins();
        this.makeFeatures();
        this.createBinFile();
        this.writeBinFile();
    }
}

