/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.jforests.eval.ranking;

import edu.uci.jforests.dataset.RankingDataset;
import edu.uci.jforests.sample.RankingSample;
import edu.uci.jforests.util.ArraysUtil;
import edu.uci.jforests.util.ScoreBasedComparator;

public class RankGenerator {
    public static int[] getInstanceRanks(double[] scores, RankingSample sample) {
        ScoreBasedComparator comparator = new ScoreBasedComparator();
        comparator.labels = sample.targets;
        comparator.scores = scores;
        int[] ranks = new int[sample.size];
        int[] permutation = new int[((RankingDataset)sample.dataset).maxDocsPerQuery];
        for (int q = 0; q < sample.numQueries; ++q) {
            int d;
            int begin = sample.queryBoundaries[q];
            int numDocs = sample.queryBoundaries[q + 1] - begin;
            comparator.offset = begin;
            for (d = 0; d < numDocs; ++d) {
                permutation[d] = d;
            }
            ArraysUtil.sort(permutation, numDocs, comparator);
            for (d = 0; d < numDocs; ++d) {
                ranks[begin + permutation[d]] = d;
            }
        }
        return ranks;
    }

    public static int[] getRanks(double[] scores, RankingSample sample) {
        ScoreBasedComparator comparator = new ScoreBasedComparator();
        comparator.labels = sample.targets;
        comparator.scores = scores;
        int[] ranks = new int[sample.size];
        int[] permutation = new int[((RankingDataset)sample.dataset).maxDocsPerQuery];
        for (int q = 0; q < sample.numQueries; ++q) {
            int begin = sample.queryBoundaries[q];
            int numDocs = sample.queryBoundaries[q + 1] - begin;
            comparator.offset = begin;
            for (int d = 0; d < numDocs; ++d) {
                permutation[d] = d;
            }
            ArraysUtil.sort(permutation, numDocs, comparator);
            System.arraycopy(permutation, 0, ranks, begin, numDocs);
        }
        return ranks;
    }
}

