/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.jforests.dataset;

import edu.uci.jforests.dataset.BitNumericArray;
import edu.uci.jforests.dataset.ByteNumericArray;
import edu.uci.jforests.dataset.IntNumericArray;
import edu.uci.jforests.dataset.NullNumericArray;
import edu.uci.jforests.dataset.NumericArray;
import edu.uci.jforests.dataset.ShortNumericArray;

public class NumericArrayFactory {
    public static NumericArray createNumericArray(NumericArrayType type, int length) throws Exception {
        switch (type) {
            case NULL: {
                return NullNumericArray.getInstance();
            }
            case BIT: {
                return new BitNumericArray(length);
            }
            case BYTE: {
                return new ByteNumericArray(length);
            }
            case SHORT: {
                return new ShortNumericArray(length);
            }
            case INT: {
                return new IntNumericArray(length);
            }
        }
        throw new Exception((Object)((Object)type) + " is not implemented yet.");
    }

    public static enum NumericArrayType {
        NULL,
        BIT,
        BYTE,
        SHORT,
        INT;


        public static NumericArrayType getFromOrdinal(int ordinal) {
            for (NumericArrayType type : NumericArrayType.values()) {
                if (type.ordinal() != ordinal) continue;
                return type;
            }
            return null;
        }
    }
}

