/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.jforests.dataset;

import edu.uci.jforests.dataset.Feature;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;

public class Dataset {
    public Feature[] features;
    public double[] targets;
    public int numInstances;
    public int numFeatures;
    public String uri;
    public boolean needsInitialization;

    public void init(Feature[] features, double[] targets) {
        this.features = features;
        this.targets = targets;
        this.numInstances = targets.length;
        this.numFeatures = features.length;
    }

    public void printFeatureValueCounts() {
        int sum = 0;
        for (int f = 0; f < this.numFeatures; ++f) {
            int count = this.features[f].upperBounds.length;
            System.out.println(count);
            sum += count;
        }
        System.out.println("Avg: " + sum / this.numFeatures);
    }

    public int getFeatureValue(int instanceIndex, int featureIndex) {
        Feature feature = this.features[featureIndex];
        try {
            return feature.upperBounds[feature.bins.get(instanceIndex)];
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    public double getOriginalFeatureValue(int instanceIndex, int featureIndex) {
        Feature feature = this.features[featureIndex];
        try {
            int scaledValue = feature.upperBounds[feature.bins.get(instanceIndex)];
            return feature.getOriginalValue(scaledValue);
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0.0;
        }
    }

    public int getMaxFeatureValues() {
        int max = 0;
        for (Feature f : this.features) {
            if (f.getNumberOfValues() <= max) continue;
            max = f.getNumberOfValues();
        }
        return max;
    }

    public int getFeatureIdx(String featureName) {
        for (int p = 0; p < this.features.length; ++p) {
            Feature f = this.features[p];
            if (!featureName.equals(f.getName())) continue;
            return p;
        }
        return -1;
    }

    public void loadFeatureNamesFromExternalResource(InputStream inputStream) throws Exception {
        String line;
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
        int fIdx = 0;
        while ((line = reader.readLine()) != null) {
            if (fIdx >= this.features.length) {
                throw new Exception("Number of lines in feature names file is more than expected number of features which is " + this.features.length);
            }
            this.features[fIdx].setName(line.trim());
            ++fIdx;
        }
        reader.close();
    }
}

