/*
 * Decompiled with CFR 0.152.
 */
package com.lagodiuk.gp.symbolic.example;

import com.lagodiuk.gp.symbolic.SymbolicRegressionEngine;
import com.lagodiuk.gp.symbolic.SymbolicRegressionIterationListener;
import com.lagodiuk.gp.symbolic.example.TestExpressionFitness2;
import com.lagodiuk.gp.symbolic.interpreter.Expression;
import com.lagodiuk.gp.symbolic.interpreter.Functions;
import java.util.LinkedList;
import java.util.List;

public class Launcher {
    public static void main(String[] args) {
        SymbolicRegressionEngine sr = new SymbolicRegressionEngine(new TestExpressionFitness2(), Launcher.list("x", "y"), Launcher.list(Functions.values()));
        sr.addIterationListener(new SymbolicRegressionIterationListener(){
            private double prevFitValue = -1.0;

            @Override
            public void update(SymbolicRegressionEngine engine) {
                Expression bestSyntaxTree = engine.getBestSyntaxTree();
                double currFitValue = engine.fitness(bestSyntaxTree);
                if (Double.compare(currFitValue, this.prevFitValue) != 0) {
                    System.out.println("Func = " + bestSyntaxTree.print());
                }
                System.out.println(String.format("%s \t %s", engine.getIteration(), currFitValue));
                this.prevFitValue = currFitValue;
                if (currFitValue < 10.0) {
                    engine.terminate();
                }
            }
        });
        sr.evolve(200);
        System.out.println(sr.getBestSyntaxTree().print());
    }

    private static <T> List<T> list(T ... items) {
        LinkedList<T> list = new LinkedList<T>();
        for (T item : items) {
            list.add(item);
        }
        return list;
    }
}

