/*
 * Decompiled with CFR 0.152.
 */
package jvx.volume;

import java.awt.Color;
import java.util.Vector;
import jv.geom.PgEdgeStar;
import jv.geom.PgElementSet;
import jv.geom.PgPolygonSet;
import jv.geom.PgTetraSet;
import jv.geom.PuCleanMesh;
import jv.object.PsDebug;
import jv.project.PgGeometry;
import jv.project.PvDisplayIf;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jv.vecmath.PuMath;
import jvx.project.PjWorkshop;
import jvx.volume.PgTetraVertexStar;
import jvx.volume.PwTetraSet;

public class PwTex2Cubes
extends PjWorkshop {
    protected PgTetraSet m_tetraSet;
    private PiVector[][] m_coords;
    private int m_quantization;
    private boolean m_showOuterPlanes = true;
    private PiVector[][] m_matching;
    public PgPolygonSet m_polygonSet;
    public PgPolygonSet m_polygonSetCleaned;
    private static boolean m_bVerboseGlobal = false;
    private int m_numNewVertices;
    public static final int VERTEX_GRID_POINT = 0;
    public static final int EDGE_INTERSECTION = 1;
    public static final int FACE_INTERSECTION = 2;
    public static final int INSIDE_TETRAHEDRON = 3;
    static /* synthetic */ Class class$jvx$volume$PwTex2Cubes;

    public PwTex2Cubes() {
        super("Tex2Cubes workshop");
        if (((Object)((Object)this)).getClass() == (class$jvx$volume$PwTex2Cubes == null ? (class$jvx$volume$PwTex2Cubes = PwTex2Cubes.class$("jvx.volume.PwTex2Cubes")) : class$jvx$volume$PwTex2Cubes)) {
            this.init();
        }
    }

    public PwTex2Cubes(PgTetraSet pgTetraSet) {
        this();
        this.setGeometry((PgGeometry)pgTetraSet);
    }

    public void init() {
        super.init();
    }

    public void setGeometry(PgGeometry pgGeometry) {
        if (pgGeometry == null || !(pgGeometry instanceof PgTetraSet)) {
            PsDebug.warning((String)"Geom is not an PgTetraSet.");
            return;
        }
        super.setGeometry(pgGeometry);
        this.m_tetraSet = (PgTetraSet)pgGeometry;
        this.update((Object)this);
    }

    public void setDisplay(PvDisplayIf pvDisplayIf) {
        super.setDisplay(pvDisplayIf);
    }

    public boolean update(Object object) {
        return super.update(object);
    }

    public String getName() {
        return "Tex2Cubes workshop";
    }

    public void setTextures(PiVector[][] piVectorArray, int n) {
        this.m_coords = piVectorArray;
        this.m_quantization = n;
    }

    public void shiftTextures() {
        int n = this.m_coords.length;
        int n2 = this.m_quantization / 2;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < 4; ++j) {
                this.m_coords[i][j].add(n2);
            }
        }
    }

    public static PgElementSet remesh(PgTetraSet pgTetraSet, PiVector[][] piVectorArray, int n) {
        PwTex2Cubes pwTex2Cubes = new PwTex2Cubes(pgTetraSet);
        pwTex2Cubes.setTextures(piVectorArray, n);
        return pwTex2Cubes.remesh();
    }

    public static PgElementSet remesh(PgTetraSet pgTetraSet, PdVector[][] pdVectorArray, boolean bl) {
        int n = pgTetraSet.getNumTetras();
        PiVector[][] piVectorArray = new PiVector[n][4];
        int n2 = 144;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < 4; ++j) {
                piVectorArray[i][j] = new PiVector(3);
                for (int k = 0; k < 3; ++k) {
                    piVectorArray[i][j].m_data[k] = (int)Math.round(pdVectorArray[i][j].m_data[k] * (double)n2);
                }
            }
        }
        PwTex2Cubes pwTex2Cubes = new PwTex2Cubes(pgTetraSet);
        pwTex2Cubes.setTextures(piVectorArray, n2);
        pwTex2Cubes.showOuterPlanes(bl);
        return pwTex2Cubes.remesh();
    }

    private void showOuterPlanes(boolean bl) {
        this.m_showOuterPlanes = bl;
    }

    public PgElementSet remesh() {
        int n;
        Object object;
        int n2 = this.m_tetraSet.getNumTetras();
        PiVector piVector = new PiVector(4);
        PiVector piVector2 = new PiVector(4);
        Vector<PdVector> vector = new Vector<PdVector>();
        Vector<PiVector> vector2 = new Vector<PiVector>();
        int n3 = 0;
        int[] nArray = new int[3];
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < n2; ++j) {
                PiVector piVector3 = this.m_tetraSet.getTetra(j);
                for (int k = 0; k < 4; ++k) {
                    piVector.m_data[k] = this.m_coords[j][k].m_data[i];
                }
                PuMath.heapsort((int)4, (int[])piVector.m_data, (int[])piVector2.m_data);
                PiVector piVector4 = this.m_coords[j][piVector2.m_data[0]];
                PiVector piVector5 = this.m_coords[j][piVector2.m_data[1]];
                PiVector piVector6 = this.m_coords[j][piVector2.m_data[2]];
                object = this.m_coords[j][piVector2.m_data[3]];
                PdVector pdVector = this.m_tetraSet.getVertex(piVector3.m_data[piVector2.m_data[0]]);
                PdVector pdVector2 = this.m_tetraSet.getVertex(piVector3.m_data[piVector2.m_data[1]]);
                PdVector pdVector3 = this.m_tetraSet.getVertex(piVector3.m_data[piVector2.m_data[2]]);
                PdVector pdVector4 = this.m_tetraSet.getVertex(piVector3.m_data[piVector2.m_data[3]]);
                int n4 = (int)Math.ceil(1.0 * (double)piVector4.m_data[i] / (double)this.m_quantization);
                int n5 = (int)Math.floor(1.0 * (double)object.m_data[i] / (double)this.m_quantization);
                if (!this.m_showOuterPlanes) {
                    if (piVector4.m_data[i] == piVector5.m_data[i] && piVector4.m_data[i] == piVector6.m_data[i] && this.m_tetraSet.getNeighbour((int)j).m_data[piVector2.m_data[3]] < 0) {
                        ++n4;
                    }
                    if (piVector5.m_data[i] == object.m_data[i] && piVector6.m_data[i] == object.m_data[i] && this.m_tetraSet.getNeighbour((int)j).m_data[piVector2.m_data[0]] < 0) {
                        --n5;
                    }
                }
                for (int k = n4; k <= n5; ++k) {
                    PdVector pdVector5;
                    PdVector pdVector6;
                    PdVector pdVector7;
                    int n6 = k * this.m_quantization;
                    if (piVector4.m_data[i] != piVector5.m_data[i] && n6 <= piVector.m_data[piVector2.m_data[1]]) {
                        if (n6 == piVector4.m_data[i]) continue;
                        pdVector7 = this.makeVertexOnEdge(pdVector, pdVector2, piVector4.m_data[i], piVector5.m_data[i], n6);
                        pdVector6 = this.makeVertexOnEdge(pdVector, pdVector4, piVector4.m_data[i], object.m_data[i], n6);
                        pdVector5 = this.makeVertexOnEdge(pdVector, pdVector3, piVector4.m_data[i], piVector6.m_data[i], n6);
                        if (pdVector7 == null || pdVector6 == null || pdVector5 == null) continue;
                        vector.addElement(pdVector7);
                        vector.addElement(pdVector6);
                        vector.addElement(pdVector5);
                        vector2.addElement(new PiVector(n3, n3 + 1, n3 + 2));
                        n3 += 3;
                        continue;
                    }
                    if (piVector6.m_data[i] != object.m_data[i] && n6 >= piVector.m_data[piVector2.m_data[2]]) {
                        if (n6 == object.m_data[i]) continue;
                        pdVector7 = this.makeVertexOnEdge(pdVector3, pdVector4, piVector6.m_data[i], object.m_data[i], n6);
                        pdVector6 = this.makeVertexOnEdge(pdVector2, pdVector4, piVector5.m_data[i], object.m_data[i], n6);
                        pdVector5 = this.makeVertexOnEdge(pdVector, pdVector4, piVector4.m_data[i], object.m_data[i], n6);
                        if (pdVector7 == null || pdVector6 == null || pdVector5 == null) continue;
                        vector.addElement(pdVector7);
                        vector.addElement(pdVector6);
                        vector.addElement(pdVector5);
                        vector2.addElement(new PiVector(n3, n3 + 1, n3 + 2));
                        n3 += 3;
                        continue;
                    }
                    if (piVector5.m_data[i] == piVector6.m_data[i] || n6 < piVector.m_data[piVector2.m_data[1]] || n6 > piVector.m_data[piVector2.m_data[2]]) continue;
                    pdVector7 = this.makeVertexOnEdge(pdVector2, pdVector3, piVector5.m_data[i], piVector6.m_data[i], n6);
                    pdVector6 = this.makeVertexOnEdge(pdVector2, pdVector4, piVector5.m_data[i], object.m_data[i], n6);
                    pdVector5 = this.makeVertexOnEdge(pdVector, pdVector4, piVector4.m_data[i], object.m_data[i], n6);
                    PdVector pdVector8 = this.makeVertexOnEdge(pdVector, pdVector3, piVector4.m_data[i], piVector6.m_data[i], n6);
                    if (pdVector7 == null || pdVector6 == null || pdVector5 == null || pdVector8 == null) continue;
                    vector.addElement(pdVector7);
                    vector.addElement(pdVector6);
                    vector.addElement(pdVector5);
                    vector.addElement(pdVector8);
                    vector2.addElement(new PiVector(n3, n3 + 1, n3 + 2, n3 + 3));
                    n3 += 4;
                }
            }
            nArray[i] = vector2.size();
        }
        Color[] colorArray = new Color[]{Color.red, Color.green, Color.blue};
        PgElementSet pgElementSet = new PgElementSet(3);
        pgElementSet.setName("Hopefully Cubes");
        int n7 = vector.size();
        pgElementSet.setNumVertices(vector.size());
        for (n = 0; n < n7; ++n) {
            pgElementSet.setVertex(n, (PdVector)vector.elementAt(n));
        }
        pgElementSet.setNumElements(vector2.size());
        pgElementSet.showElementColors(true);
        n = vector2.size();
        for (int i = 0; i < n; ++i) {
            pgElementSet.setElement(i, (PiVector)vector2.elementAt(i));
            int n8 = i < nArray[0] ? 0 : (i < nArray[1] ? 1 : 2);
            object = colorArray[n8];
            pgElementSet.setElementColor(i, (Color)object);
        }
        PuCleanMesh.identifyVertices((PgGeometry)pgElementSet);
        pgElementSet.makeNeighbour();
        pgElementSet.makeElementNormals();
        return pgElementSet;
    }

    private PdVector makeVertexOnEdge(PdVector pdVector, PdVector pdVector2, int n, int n2, int n3) {
        if (n == n2) {
            return null;
        }
        double d = 1.0 * (double)(n3 - n) / (double)(n2 - n);
        return PdVector.blendNew((double)(1.0 - d), (PdVector)pdVector, (double)d, (PdVector)pdVector2);
    }

    public static PgElementSet makeIsoSurface(PgTetraSet pgTetraSet, PdVector[][] pdVectorArray, double d) {
        int n = pgTetraSet.getNumTetras();
        PiVector[][] piVectorArray = new PiVector[n][4];
        int n2 = 144;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < 4; ++j) {
                piVectorArray[i][j] = new PiVector(3);
                for (int k = 0; k < 3; ++k) {
                    piVectorArray[i][j].m_data[k] = (int)Math.round((pdVectorArray[i][j].m_data[k] - d) * (double)n2);
                }
            }
        }
        PwTex2Cubes pwTex2Cubes = new PwTex2Cubes(pgTetraSet);
        pwTex2Cubes.setTextures(piVectorArray, Integer.MAX_VALUE);
        return pwTex2Cubes.remesh();
    }

    public static PgElementSet makeIsoSurface(PgTetraSet pgTetraSet, PiVector[][] piVectorArray, int n, double d) {
        int n2 = pgTetraSet.getNumTetras();
        PiVector[][] piVectorArray2 = new PiVector[n2][4];
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < 4; ++j) {
                piVectorArray2[i][j] = new PiVector(3);
                for (int k = 0; k < 3; ++k) {
                    piVectorArray2[i][j].m_data[k] = (int)Math.round(((double)piVectorArray[i][j].m_data[k] - d * (double)n) * (double)n);
                }
            }
        }
        PwTex2Cubes pwTex2Cubes = new PwTex2Cubes(pgTetraSet);
        pwTex2Cubes.setTextures(piVectorArray2, Integer.MAX_VALUE);
        return pwTex2Cubes.remesh();
    }

    public void setMatching(PiVector[][] piVectorArray) {
        this.m_matching = piVectorArray;
    }

    public static PiVector[][] quantizeTexture(PdVector[][] pdVectorArray, int n) {
        int n2 = pdVectorArray.length;
        PiVector[][] piVectorArray = new PiVector[n2][4];
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < 4; ++j) {
                piVectorArray[i][j] = new PiVector(3);
                for (int k = 0; k < 3; ++k) {
                    piVectorArray[i][j].m_data[k] = (int)Math.round(pdVectorArray[i][j].m_data[k] * (double)n);
                }
            }
        }
        return piVectorArray;
    }

    public void setTextures(PdVector[][] pdVectorArray) {
        int n = 128;
        this.setTextures(PwTex2Cubes.quantizeTexture(pdVectorArray, n), n);
    }

    public void readMatchingsFromField() {
        PiVector[][] piVectorArray;
        int n;
        PiVector[][] piVectorArray2 = null;
        int n2 = this.m_tetraSet.getNumVectorFields();
        for (n = 0; n < n2; ++n) {
            piVectorArray = this.m_tetraSet.getVectorField(n);
            if (!piVectorArray.getName().equalsIgnoreCase("matching")) continue;
            piVectorArray2 = piVectorArray;
            break;
        }
        n = this.m_tetraSet.getNumTetras();
        if (piVectorArray2 != null && piVectorArray2.getBasedOn() == 1 && piVectorArray2.getDimOfVectors() == 4) {
            piVectorArray = new PiVector[n][4];
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < 4; ++j) {
                    double d = piVectorArray2.getVector((int)i).m_data[j];
                    if (!(d >= 0.0)) continue;
                    PiVector piVector = new PiVector(3);
                    piVector.m_data[0] = (int)(d / 100.0);
                    piVector.m_data[1] = (int)(d / 10.0) - 10 * piVector.m_data[0];
                    piVector.m_data[2] = (int)d - 100 * piVector.m_data[0] - 10 * piVector.m_data[1];
                    piVectorArray[i][j] = piVector;
                }
            }
            this.setMatching(piVectorArray);
        }
    }

    public PgElementSet remesh2() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        vertexInfo vertexInfo2;
        int n10;
        PgElementSet pgElementSet = new PgElementSet(this.m_tetraSet.getDimOfVertices());
        pgElementSet.setName("Levels in " + this.m_tetraSet.getName());
        this.m_polygonSet = new PgPolygonSet(this.m_tetraSet.getDimOfVertices());
        this.m_polygonSet.setName("Edges in " + this.m_tetraSet.getName());
        int n11 = this.m_tetraSet.getNumVertices();
        int n12 = this.m_tetraSet.getNumTetras();
        int n13 = 2;
        Vector vector = new Vector();
        PiVector piVector = new PiVector(n12);
        this.m_numNewVertices = 0;
        this.findVerticesOnGrid(vector, piVector);
        this.findEdgeIntersections(vector, piVector);
        vertexInfo[][] vertexInfoArray = new vertexInfo[n12][];
        for (int i = 0; i < n12; ++i) {
            vertexInfoArray[i] = new vertexInfo[piVector.m_data[i]];
        }
        PiVector piVector2 = new PiVector(n12);
        piVector2.setConstant(0);
        for (n10 = 0; n10 < this.m_numNewVertices; ++n10) {
            vertexInfo2 = (vertexInfo)vector.elementAt(n10);
            n9 = vertexInfo2.m_numTets;
            for (n8 = 0; n8 < n9; ++n8) {
                vertexInfoArray[vertexInfo2.m_tetIndex.m_data[n8]][piVector2.m_data[vertexInfo2.m_tetIndex.m_data[n8]]] = vertexInfo2;
                int n14 = vertexInfo2.m_tetIndex.m_data[n8];
                piVector2.m_data[n14] = piVector2.m_data[n14] + 1;
            }
        }
        this.findFaceIntersections(vector, piVector, vertexInfoArray);
        for (int i = 0; i < n12; ++i) {
            vertexInfoArray[i] = new vertexInfo[piVector.m_data[i]];
        }
        Object object = new PiVector(n12);
        object.setConstant(0);
        for (n10 = 0; n10 < this.m_numNewVertices; ++n10) {
            vertexInfo2 = (vertexInfo)vector.elementAt(n10);
            n9 = vertexInfo2.m_numTets;
            for (n8 = 0; n8 < n9; ++n8) {
                vertexInfoArray[vertexInfo2.m_tetIndex.m_data[n8]][((PiVector)object).m_data[vertexInfo2.m_tetIndex.m_data[n8]]] = vertexInfo2;
                int n15 = vertexInfo2.m_tetIndex.m_data[n8];
                ((PiVector)object).m_data[n15] = ((PiVector)object).m_data[n15] + 1;
            }
        }
        object = new Vector();
        this.findPointsInTets(vector, piVector, vertexInfoArray, (Vector)object);
        for (n10 = 0; n10 < n12; ++n10) {
            vertexInfoArray[n10] = new vertexInfo[piVector.m_data[n10]];
        }
        PiVector piVector3 = new PiVector(n12);
        piVector3.setConstant(0);
        for (int i = 0; i < this.m_numNewVertices; ++i) {
            vertexInfo vertexInfo3 = (vertexInfo)vector.elementAt(i);
            n8 = vertexInfo3.m_numTets;
            for (n7 = 0; n7 < n8; ++n7) {
                vertexInfoArray[vertexInfo3.m_tetIndex.m_data[n7]][piVector3.m_data[vertexInfo3.m_tetIndex.m_data[n7]]] = vertexInfo3;
                int n16 = vertexInfo3.m_tetIndex.m_data[n7];
                piVector3.m_data[n16] = piVector3.m_data[n16] + 1;
            }
        }
        boolean bl = m_bVerboseGlobal;
        Vector<PiVector> vector2 = new Vector<PiVector>();
        for (n6 = 0; n6 < n12; ++n6) {
            for (n8 = 0; n8 < piVector.m_data[n6] - 1; ++n8) {
                n7 = vertexInfoArray[n6][n8].m_tetIndex.getIndexOf(n6);
                for (int i = n8 + 1; i < piVector.m_data[n6]; ++i) {
                    n5 = vertexInfoArray[n6][i].m_tetIndex.getIndexOf(n6);
                    if (vertexInfoArray[n6][n8].m_texture[n7].m_data[0] != vertexInfoArray[n6][i].m_texture[n5].m_data[0] || vertexInfoArray[n6][n8].m_texture[n7].m_data[1] != vertexInfoArray[n6][i].m_texture[n5].m_data[1] || vertexInfoArray[n6][n8].m_texture[n7].m_data[2] != vertexInfoArray[n6][i].m_texture[n5].m_data[2] || vertexInfoArray[n6][n8].m_texture[n7].m_data[0] % n13 != 0 || vertexInfoArray[n6][n8].m_texture[n7].m_data[1] % n13 != 0 || vertexInfoArray[n6][n8].m_texture[n7].m_data[2] % n13 != 0) continue;
                    vector2.addElement(new PiVector(vertexInfoArray[n6][n8].m_vertexIndex, vertexInfoArray[n6][i].m_vertexIndex));
                    if (!bl) continue;
                    PsDebug.message((String)("identify vertex " + vertexInfoArray[n6][n8].m_vertexIndex + " with " + vertexInfoArray[n6][i].m_vertexIndex));
                }
            }
        }
        n6 = vector2.size();
        if (bl) {
            PsDebug.message((String)("Number of identifications: " + n6));
        }
        PiVector piVector4 = new PiVector(this.m_numNewVertices);
        for (n7 = 0; n7 < this.m_numNewVertices; ++n7) {
            piVector4.m_data[n7] = n7;
        }
        for (n7 = 0; n7 < n6; ++n7) {
            PiVector piVector5 = (PiVector)vector2.elementAt(n7);
            if (piVector5.m_data[0] < piVector5.m_data[1]) {
                n4 = piVector5.m_data[0];
                n5 = piVector5.m_data[1];
            } else {
                n4 = piVector5.m_data[1];
                n5 = piVector5.m_data[0];
            }
            while (piVector4.m_data[n5] != n4) {
                n3 = piVector4.m_data[n5];
                int n17 = piVector4.m_data[n4];
                if (n17 < n4) {
                    n4 = n17;
                    continue;
                }
                if (n4 < n3) {
                    piVector4.m_data[n5] = n4;
                    piVector4.m_data[n3] = n4;
                    continue;
                }
                piVector4.m_data[n4] = n3;
                n4 = n3;
            }
        }
        for (n7 = 0; n7 < this.m_numNewVertices; ++n7) {
            while (piVector4.m_data[piVector4.m_data[n7]] != piVector4.m_data[n7]) {
                piVector4.m_data[n7] = piVector4.m_data[piVector4.m_data[n7]];
            }
        }
        n7 = 1;
        PiVector piVector6 = new PiVector(n11);
        if (n7 != 0) {
            for (n5 = n11 - 1; n5 >= 0; --n5) {
                if (piVector4.m_data[n5] != n5) {
                    if (((vertexInfo)vector.elementAt((int)piVector4.m_data[n5])).m_bIsBoundary == ((vertexInfo)vector.elementAt((int)n5)).m_bIsBoundary) {
                        ((vertexInfo)vector.elementAt((int)piVector4.m_data[n5])).m_vertex.add(((vertexInfo)vector.elementAt((int)n5)).m_vertex);
                        int n18 = piVector4.m_data[n5];
                        piVector6.m_data[n18] = piVector6.m_data[n18] + 1;
                    } else if (!((vertexInfo)vector.elementAt((int)piVector4.m_data[n5])).m_bIsBoundary) {
                        ((vertexInfo)vector.elementAt((int)piVector4.m_data[n5])).m_vertex.copy(((vertexInfo)vector.elementAt((int)n5)).m_vertex);
                        ((vertexInfo)vector.elementAt((int)piVector4.m_data[n5])).m_bIsBoundary = true;
                        if (piVector6.m_data[piVector4.m_data[n5]] != 0) {
                            piVector6.m_data[piVector4.m_data[n5]] = 0;
                        }
                    }
                } else {
                    int n19 = n5;
                    piVector6.m_data[n19] = piVector6.m_data[n19] + 1;
                }
                if (piVector6.m_data[n5] <= 1) continue;
                ((vertexInfo)vector.elementAt((int)n5)).m_vertex.multScalar(1.0 / (double)piVector6.m_data[n5]);
            }
        } else {
            for (n5 = n11 - 1; n5 >= 0; --n5) {
                if (piVector4.m_data[n5] != n5) {
                    ((vertexInfo)vector.elementAt((int)piVector4.m_data[n5])).m_vertex.add(((vertexInfo)vector.elementAt((int)n5)).m_vertex);
                }
                int n20 = piVector4.m_data[n5];
                piVector6.m_data[n20] = piVector6.m_data[n20] + 1;
                if (piVector6.m_data[n5] <= 1) continue;
                ((vertexInfo)vector.elementAt((int)n5)).m_vertex.multScalar(1.0 / (double)piVector6.m_data[n5]);
            }
        }
        n5 = ((Vector)object).size();
        n4 = 0;
        for (n3 = 0; n3 < n5; ++n3) {
            PiVector piVector7 = (PiVector)((Vector)object).elementAt(n5 - n3 - 1);
            for (int i = 0; i < 2; ++i) {
                piVector7.m_data[i] = piVector4.m_data[piVector7.m_data[i]];
            }
            if (piVector7.m_data[0] != piVector7.m_data[1]) continue;
            ++n4;
            ((Vector)object).removeElementAt(n5 - n3 - 1);
        }
        if (bl) {
            PsDebug.message((String)("Removed " + n4 + " Edges"));
        }
        this.m_polygonSet.setNumVertices(this.m_numNewVertices);
        this.m_polygonSet.assureVertexColors();
        this.m_polygonSet.showVertexColors(true);
        bl = false;
        for (n2 = 0; n2 < this.m_numNewVertices; ++n2) {
            vertexInfo vertexInfo4 = (vertexInfo)vector.elementAt(n2);
            this.m_polygonSet.setVertex(n2, vertexInfo4.m_vertex);
            if (bl) {
                if (vertexInfo4.m_type == 0) {
                    this.m_polygonSet.setVertexColor(n2, new Color(255, 0, 0));
                } else if (vertexInfo4.m_type == 1) {
                    this.m_polygonSet.setVertexColor(n2, new Color(255, 255, 0));
                } else if (vertexInfo4.m_type == 2) {
                    this.m_polygonSet.setVertexColor(n2, new Color(0, 0, 255));
                } else {
                    this.m_polygonSet.setVertexColor(n2, new Color(0, 255, 255));
                }
            } else if (vertexInfo4.m_texture[0].m_data[0] % n13 == 0 && vertexInfo4.m_texture[0].m_data[1] % n13 == 0 && vertexInfo4.m_texture[0].m_data[2] % n13 == 0) {
                this.m_polygonSet.setVertexColor(n2, new Color(255, 0, 0));
            } else {
                this.m_polygonSet.setVertexColor(n2, new Color(255, 255, 0));
            }
            if (vertexInfo4.m_texture[0].m_data[0] % n13 != 0 || vertexInfo4.m_texture[0].m_data[1] % n13 != 0 || vertexInfo4.m_texture[0].m_data[2] % n13 != 0) continue;
            this.m_polygonSet.setTagVertex(n2, 1);
        }
        this.m_polygonSet.showVertices(true);
        n2 = ((Vector)object).size();
        this.m_polygonSet.setNumPolygons(n2);
        for (n = 0; n < n2; ++n) {
            this.m_polygonSet.setPolygon(n, (PiVector)((Vector)object).elementAt(n));
        }
        this.cleanPolygonSet();
        pgElementSet.setNumVertices(this.m_numNewVertices);
        pgElementSet.assureVertexColors();
        pgElementSet.showVertexColors(true);
        n = 1;
        for (int i = 0; i < this.m_numNewVertices; ++i) {
            vertexInfo vertexInfo5 = (vertexInfo)vector.elementAt(i);
            pgElementSet.setVertex(i, vertexInfo5.m_vertex);
            if (n != 0) {
                if (vertexInfo5.m_type == 0) {
                    pgElementSet.setVertexColor(i, new Color(255, 0, 0));
                } else if (vertexInfo5.m_type == 1) {
                    pgElementSet.setVertexColor(i, new Color(255, 255, 0));
                } else if (vertexInfo5.m_type == 2) {
                    pgElementSet.setVertexColor(i, new Color(0, 0, 255));
                } else {
                    pgElementSet.setVertexColor(i, new Color(0, 255, 255));
                }
            } else if (vertexInfo5.m_texture[0].m_data[0] % n13 == 0 && vertexInfo5.m_texture[0].m_data[1] % n13 == 0 && vertexInfo5.m_texture[0].m_data[2] % n13 == 0) {
                pgElementSet.setVertexColor(i, new Color(255, 0, 0));
            } else {
                pgElementSet.setVertexColor(i, new Color(255, 255, 0));
            }
            if (vertexInfo5.m_texture[0].m_data[0] % n13 != 0 || vertexInfo5.m_texture[0].m_data[1] % n13 != 0 || vertexInfo5.m_texture[0].m_data[2] % n13 != 0) continue;
            pgElementSet.setTagVertex(i, 1);
        }
        PwTex2Cubes.guessElements(pgElementSet, this.m_polygonSetCleaned);
        pgElementSet.showVertices(true);
        return pgElementSet;
    }

    private void findVerticesOnGrid(Vector vector, PiVector piVector) {
        int n = this.m_tetraSet.getNumVertices();
        int n2 = this.m_tetraSet.getNumTetras();
        int n3 = 2;
        boolean[] blArray = new boolean[n];
        for (int i = 0; i < n; ++i) {
            blArray[i] = false;
        }
        PgTetraVertexStar pgTetraVertexStar = new PgTetraVertexStar();
        boolean bl = m_bVerboseGlobal;
        for (int i = 0; i < n2; ++i) {
            PiVector piVector2 = this.m_tetraSet.getTetra(i);
            for (int j = 0; j < 4; ++j) {
                int n4 = piVector2.m_data[j];
                if (blArray[n4]) continue;
                blArray[n4] = true;
                PiVector piVector3 = this.m_coords[i][j];
                if (bl) {
                    PsDebug.message((String)("Check vertex " + n4 + " at tex " + piVector3.m_data[0] + " " + piVector3.m_data[1] + " " + piVector3.m_data[2] + " ..."));
                }
                if (piVector3.m_data[0] % this.m_quantization != 0 && piVector3.m_data[1] % this.m_quantization != 0 && piVector3.m_data[2] % this.m_quantization != 0) {
                    if (!bl) continue;
                    PsDebug.message((String)"     ... not a grid point.");
                    continue;
                }
                if (bl) {
                    PsDebug.message((String)("     ... add grid point - index will be " + this.m_numNewVertices));
                }
                pgTetraVertexStar.makeVertexStar(this.m_tetraSet, n4, i);
                int n5 = pgTetraVertexStar.getSize();
                vertexInfo vertexInfo2 = new vertexInfo(n5, 0, this.m_numNewVertices);
                vertexInfo2.m_bIsBoundary = !pgTetraVertexStar.isClosed();
                ++this.m_numNewVertices;
                vertexInfo2.m_vertex = PdVector.copyNew((PdVector)this.m_tetraSet.getVertex(n4));
                vertexInfo2.m_tetIndex.copy(pgTetraVertexStar.getTetIndex());
                for (int k = 0; k < n5; ++k) {
                    vertexInfo2.m_localIndex.m_data[k] = this.m_tetraSet.getTetra(vertexInfo2.m_tetIndex.m_data[k]).getIndexOf(n4);
                    for (int i2 = 0; i2 < 3; ++i2) {
                        int n6 = this.m_coords[vertexInfo2.m_tetIndex.m_data[k]][vertexInfo2.m_localIndex.m_data[k]].m_data[i2];
                        if (bl) {
                            PsDebug.message((String)("Coord " + i2 + " in tet " + vertexInfo2.m_tetIndex.m_data[k] + ": " + n6));
                        }
                        if (n6 % this.m_quantization == 0) {
                            if (bl) {
                                PsDebug.message((String)("Integer coordinate - tex value: " + n6 * n3 / this.m_quantization));
                            }
                            vertexInfo2.m_texture[k].m_data[i2] = n6 * n3 / this.m_quantization;
                            continue;
                        }
                        if (n6 >= 0) {
                            vertexInfo2.m_texture[k].m_data[i2] = n6 / this.m_quantization * n3 + 1;
                            if (!bl) continue;
                            PsDebug.message((String)("Not an integer coordinate - tex value: " + (n6 / this.m_quantization * n3 + 1)));
                            continue;
                        }
                        vertexInfo2.m_texture[k].m_data[i2] = (-1 - -n6 / this.m_quantization) * n3 + 1;
                        if (!bl) continue;
                        PsDebug.message((String)("Not an integer coordinate - tex value: " + ((-1 - -n6 / this.m_quantization) * n3 + 1)));
                    }
                    int n7 = vertexInfo2.m_tetIndex.m_data[k];
                    piVector.m_data[n7] = piVector.m_data[n7] + 1;
                }
                vector.addElement(vertexInfo2);
            }
        }
    }

    private void findEdgeIntersections(Vector vector, PiVector piVector) {
        int n;
        int n2 = this.m_tetraSet.getNumTetras();
        int n3 = 2;
        boolean[][] blArray = new boolean[n2][6];
        boolean bl = m_bVerboseGlobal;
        for (int i = 0; i < n2; ++i) {
            for (n = 0; n < 6; ++n) {
                blArray[i][n] = false;
            }
        }
        PgEdgeStar pgEdgeStar = new PgEdgeStar();
        for (n = 0; n < n2; ++n) {
            for (int i = 0; i < 6; ++i) {
                int n4;
                int n5;
                if (blArray[n][i]) continue;
                pgEdgeStar = new PgEdgeStar();
                PwTetraSet.computeEdgeStar(this.m_tetraSet, n, i, pgEdgeStar);
                int[] nArray = pgEdgeStar.getElementInd();
                int n6 = nArray.length;
                int[] nArray2 = pgEdgeStar.getNeighbourLocInd();
                int[] nArray3 = new int[]{pgEdgeStar.getVertexInd(0), pgEdgeStar.getVertexInd(1)};
                for (n5 = 0; n5 < n6; ++n5) {
                    blArray[nArray[n5]][nArray2[n5]] = true;
                }
                n5 = nArray[0];
                PiVector piVector2 = this.m_tetraSet.getTetra(n5);
                PiVector[] piVectorArray = new PiVector[2];
                for (n4 = 0; n4 < 2; ++n4) {
                    piVectorArray[n4] = this.m_coords[n5][piVector2.getIndexOf(nArray3[n4])];
                }
                if (bl) {
                    PsDebug.message((String)("++++++++++++++++++ Check edge " + i + " in tetrahedron " + n + " ++++++++++++++++++++++"));
                    PsDebug.message((String)("End points are " + nArray3[0] + " with tex " + piVectorArray[0].m_data[0] + " " + piVectorArray[0].m_data[1] + " " + piVectorArray[0].m_data[2]));
                    PsDebug.message((String)("           and " + nArray3[1] + " with tex " + piVectorArray[1].m_data[0] + " " + piVectorArray[1].m_data[1] + " " + piVectorArray[1].m_data[2]));
                }
                for (n4 = 0; n4 < 3; ++n4) {
                    int n7;
                    int n8;
                    if (piVectorArray[0].m_data[n4] < piVectorArray[1].m_data[n4]) {
                        n8 = 0;
                        n7 = 1;
                    } else {
                        n7 = 0;
                        n8 = 1;
                    }
                    if (bl) {
                        PsDebug.message((String)("Koordinate " + n4 + " - smaller value is at vertex " + nArray3[n8]));
                    }
                    int n9 = piVectorArray[n7].m_data[n4] - piVectorArray[n8].m_data[n4];
                    if (bl) {
                        PsDebug.message((String)("Difference of values is " + n9));
                    }
                    int n10 = piVectorArray[n8].m_data[n4] >= 0 ? (piVectorArray[n8].m_data[n4] / this.m_quantization + 1) * this.m_quantization : -((-piVectorArray[n8].m_data[n4] - 1) / this.m_quantization) * this.m_quantization;
                    if (bl) {
                        PsDebug.message((String)("First value to be checked is " + n10));
                    }
                    for (int j = n10; j < piVectorArray[n7].m_data[n4]; j += this.m_quantization) {
                        int n11;
                        if (bl) {
                            PsDebug.message((String)("Check " + j + ""));
                        }
                        PiVector piVector3 = new PiVector(3);
                        piVector3.m_data[n4] = n3 * j / this.m_quantization;
                        for (int k = 1; k < 3; ++k) {
                            if (bl) {
                                PsDebug.message((String)("Compute coordinate " + (n4 + k) % 3 + " ..."));
                            }
                            n11 = 0;
                            if (piVectorArray[n7].m_data[(n4 + k) % 3] < 0) {
                                n11 = (1 + -piVectorArray[n7].m_data[(n4 + k) % 3] / this.m_quantization) * this.m_quantization;
                            }
                            if (piVectorArray[n8].m_data[(n4 + k) % 3] + n11 < 0) {
                                n11 = (1 + -piVectorArray[n8].m_data[(n4 + k) % 3] / this.m_quantization) * this.m_quantization;
                            }
                            if (bl) {
                                PsDebug.message((String)("     ... Offset by " + n11 + " ..."));
                            }
                            if (bl) {
                                PsDebug.message((String)("     ... Blend between offset values " + (n11 + piVectorArray[n7].m_data[(n4 + k) % 3]) + " and " + (n11 + piVectorArray[n8].m_data[(n4 + k) % 3]) + " ..."));
                            }
                            if (((j - piVectorArray[n8].m_data[n4]) * (n11 + piVectorArray[n7].m_data[(n4 + k) % 3]) - (j - piVectorArray[n7].m_data[n4]) * (n11 + piVectorArray[n8].m_data[(n4 + k) % 3])) % (n9 * this.m_quantization) == 0) {
                                if (bl) {
                                    PsDebug.message((String)"     ... YES    computed value is a grid value.");
                                }
                                piVector3.m_data[(n4 + k) % 3] = (((j - piVectorArray[n8].m_data[n4]) * (n11 + piVectorArray[n7].m_data[(n4 + k) % 3]) - (j - piVectorArray[n7].m_data[n4]) * (n11 + piVectorArray[n8].m_data[(n4 + k) % 3])) / (n9 * this.m_quantization) - n11 / this.m_quantization) * n3;
                            } else {
                                if (bl) {
                                    PsDebug.message((String)"     ... NO      computed value is not a grid value.");
                                }
                                piVector3.m_data[(n4 + k) % 3] = (((j - piVectorArray[n8].m_data[n4]) * (n11 + piVectorArray[n7].m_data[(n4 + k) % 3]) - (j - piVectorArray[n7].m_data[n4]) * (n11 + piVectorArray[n8].m_data[(n4 + k) % 3])) / (n9 * this.m_quantization) - n11 / this.m_quantization) * n3 + 1;
                            }
                            if (!bl) continue;
                            PsDebug.message((String)("Computed tex coord: " + piVector3.m_data[(n4 + k) % 3]));
                        }
                        if (n4 > 0 && piVector3.m_data[0] % n3 == 0 && piVectorArray[0].m_data[0] != piVectorArray[1].m_data[0] || n4 > 1 && piVector3.m_data[1] % n3 == 0 && piVectorArray[0].m_data[1] != piVectorArray[1].m_data[1]) continue;
                        if (bl) {
                            PsDebug.message((String)("Add Edge intersection point - it will have the vertex index " + this.m_numNewVertices));
                        }
                        vertexInfo vertexInfo2 = new vertexInfo(n6, 1, this.m_numNewVertices);
                        vertexInfo2.m_bIsBoundary = !PwTetraSet.edgeStarIsClosed(this.m_tetraSet, pgEdgeStar);
                        ++this.m_numNewVertices;
                        vertexInfo2.m_vertex = PdVector.blendNew((double)(1.0 * (double)(j - piVectorArray[n8].m_data[n4]) / (1.0 * (double)n9)), (PdVector)this.m_tetraSet.getVertex(nArray3[n7]), (double)(-1.0 * (double)(j - piVectorArray[n7].m_data[n4]) / (1.0 * (double)n9)), (PdVector)this.m_tetraSet.getVertex(nArray3[n8]));
                        vertexInfo2.m_texture[0] = piVector3;
                        vertexInfo2.m_localIndex.m_data[0] = nArray2[0];
                        vertexInfo2.m_tetIndex.m_data[0] = nArray[0];
                        int n12 = nArray[0];
                        piVector.m_data[n12] = piVector.m_data[n12] + 1;
                        for (n11 = 1; n11 < n6; ++n11) {
                            vertexInfo2.m_localIndex.m_data[n11] = nArray2[n11];
                            vertexInfo2.m_tetIndex.m_data[n11] = nArray[n11];
                            int n13 = nArray[n11];
                            piVector.m_data[n13] = piVector.m_data[n13] + 1;
                            vertexInfo2.m_texture[n11] = this.computeTexFromNeighbour(vertexInfo2.m_texture[n11 - 1], vertexInfo2.m_tetIndex.m_data[n11], vertexInfo2.m_tetIndex.m_data[n11 - 1], nArray3[0]);
                        }
                        vector.addElement(vertexInfo2);
                    }
                }
            }
        }
    }

    private void findFaceIntersections(Vector vector, PiVector piVector, vertexInfo[][] vertexInfoArray) {
        boolean bl = m_bVerboseGlobal;
        int n = this.m_tetraSet.getNumTetras();
        int n2 = 2;
        for (int i = 0; i < n; ++i) {
            int n3 = piVector.m_data[i];
            for (int j = 0; j < 4; ++j) {
                int n4;
                int n5;
                Object object;
                int n6;
                vertexInfo vertexInfo2;
                int n7;
                int n8 = this.m_tetraSet.getNeighbour((int)i).m_data[j];
                if (n8 > i) continue;
                if (bl) {
                    PsDebug.message((String)("++++++++++++++++++ Check face " + j + " in tetrahedron " + i + " ++++++++++++++++++++++"));
                }
                int[] nArray = PgTetraSet.LOCAL_FACE_TO_EDGE[j];
                if (bl) {
                    PsDebug.message((String)"Collect vertices:");
                }
                int[] nArray2 = new int[3];
                int[] nArray3 = new int[3];
                for (n7 = 0; n7 < 3; ++n7) {
                    nArray2[n7] = Integer.MAX_VALUE;
                    nArray3[n7] = Integer.MIN_VALUE;
                }
                n7 = 0;
                for (int k = 0; k < n3; ++k) {
                    vertexInfo2 = vertexInfoArray[i][k];
                    n6 = vertexInfo2.m_tetIndex.getIndexOf(i);
                    if ((vertexInfo2.m_type != 0 || vertexInfo2.m_localIndex.m_data[n6] == j) && (vertexInfo2.m_type != 1 || vertexInfo2.m_localIndex.m_data[n6] != nArray[0] && vertexInfo2.m_localIndex.m_data[n6] != nArray[1] && vertexInfo2.m_localIndex.m_data[n6] != nArray[2])) continue;
                    ++n7;
                }
                vertexInfo[] vertexInfoArray2 = new vertexInfo[n7];
                vertexInfo2 = new PiVector(n7);
                n7 = 0;
                for (n6 = 0; n6 < n3; ++n6) {
                    object = vertexInfoArray[i][n6];
                    n5 = ((vertexInfo)object).m_tetIndex.getIndexOf(i);
                    if ((((vertexInfo)object).m_type != 0 || ((vertexInfo)object).m_localIndex.m_data[n5] == j) && (((vertexInfo)object).m_type != 1 || ((vertexInfo)object).m_localIndex.m_data[n5] != nArray[0] && ((vertexInfo)object).m_localIndex.m_data[n5] != nArray[1] && ((vertexInfo)object).m_localIndex.m_data[n5] != nArray[2])) continue;
                    ((PiVector)vertexInfo2).m_data[n7] = n5;
                    vertexInfoArray2[n7] = object;
                    for (n4 = 0; n4 < 3; ++n4) {
                        if (nArray2[n4] > ((vertexInfo)object).m_texture[n5].m_data[n4]) {
                            nArray2[n4] = ((vertexInfo)object).m_texture[n5].m_data[n4];
                        }
                        if (nArray3[n4] >= ((vertexInfo)object).m_texture[n5].m_data[n4]) continue;
                        nArray3[n4] = ((vertexInfo)object).m_texture[n5].m_data[n4];
                    }
                    if (bl) {
                        PsDebug.message((String)("- vertex " + ((vertexInfo)object).m_vertexIndex + " with tex coords " + ((vertexInfo)object).m_texture[((PiVector)vertexInfo2).m_data[n7]].m_data[0] + " " + ((vertexInfo)object).m_texture[((PiVector)vertexInfo2).m_data[n7]].m_data[1] + " " + ((vertexInfo)object).m_texture[((PiVector)vertexInfo2).m_data[n7]].m_data[2]));
                    }
                    ++n7;
                }
                if (bl) {
                    PsDebug.message((String)("Minimum: " + nArray2[0] + " " + nArray2[1] + " " + nArray2[2]));
                    PsDebug.message((String)("Maximum: " + nArray3[0] + " " + nArray3[1] + " " + nArray3[2]));
                    PsDebug.message((String)"Make even ...");
                }
                for (n6 = 0; n6 < 3; ++n6) {
                    if (nArray2[n6] >= 0 && nArray2[n6] % 2 == 1 || nArray2[n6] < 0 && -nArray2[n6] % 2 == 1) {
                        int n9 = n6;
                        nArray2[n9] = nArray2[n9] - 1;
                    }
                    if ((nArray3[n6] < 0 || nArray3[n6] % 2 != 1) && (nArray3[n6] >= 0 || -nArray3[n6] % 2 != 1)) continue;
                    int n10 = n6;
                    nArray3[n10] = nArray3[n10] + 1;
                }
                if (bl) {
                    PsDebug.message((String)("Minimum: " + nArray2[0] + " " + nArray2[1] + " " + nArray2[2]));
                    PsDebug.message((String)("Maximum: " + nArray3[0] + " " + nArray3[1] + " " + nArray3[2]));
                }
                PiVector[] piVectorArray = new PiVector[3];
                for (int k = 0; k < 3; ++k) {
                    piVectorArray[k] = PiVector.copyNew((PiVector)this.m_coords[i][(j + 1 + k) % 4]);
                    for (n5 = 0; n5 < 3; ++n5) {
                        int n11 = n5;
                        piVectorArray[k].m_data[n11] = piVectorArray[k].m_data[n11] - nArray2[n5] * this.m_quantization / n2;
                    }
                }
                object = new boolean[]{false, false, false};
                for (n5 = 0; n5 < 3; ++n5) {
                    n4 = (piVectorArray[2].m_data[(n5 + 1) % 3] - piVectorArray[0].m_data[(n5 + 1) % 3]) * (piVectorArray[1].m_data[(n5 + 2) % 3] - piVectorArray[0].m_data[(n5 + 2) % 3]) - (piVectorArray[2].m_data[(n5 + 2) % 3] - piVectorArray[0].m_data[(n5 + 2) % 3]) * (piVectorArray[1].m_data[(n5 + 1) % 3] - piVectorArray[0].m_data[(n5 + 1) % 3]);
                    if (bl) {
                        PsDebug.message((String)("Check coordinate direction " + n5));
                    }
                    if (n4 == 0) {
                        if (bl) {
                            PsDebug.message((String)("Projection " + n5 + " degenerates."));
                        }
                        object[n5] = true;
                        continue;
                    }
                    int n12 = 1;
                    if (n4 < 0) {
                        n12 = -1;
                        n4 *= -1;
                    }
                    for (int k = this.m_quantization; k < this.m_quantization * (nArray3[(n5 + 1) % 3] - nArray2[(n5 + 1) % 3]) / n2; k += this.m_quantization) {
                        for (int i2 = this.m_quantization; i2 < this.m_quantization * (nArray3[(n5 + 2) % 3] - nArray2[(n5 + 2) % 3]) / n2; i2 += this.m_quantization) {
                            int[] nArray4 = new int[3];
                            int n13 = 0;
                            while (n13 < 3) {
                                nArray4[n13] = (piVectorArray[(n13 + 2) % 3].m_data[(n5 + 1) % 3] - k) * (piVectorArray[(n13 + 1) % 3].m_data[(n5 + 2) % 3] - i2) - (piVectorArray[(n13 + 2) % 3].m_data[(n5 + 2) % 3] - i2) * (piVectorArray[(n13 + 1) % 3].m_data[(n5 + 1) % 3] - k);
                                int n14 = n13++;
                                nArray4[n14] = nArray4[n14] * n12;
                            }
                            if (nArray4[0] <= 0 || nArray4[1] <= 0 || nArray4[2] <= 0) continue;
                            if (n4 == 0) {
                                PsDebug.message((String)"Area == 0");
                            }
                            if (this.m_quantization == 0) {
                                PsDebug.message((String)"m_quantization == 0");
                            }
                            if (n4 * this.m_quantization == 0) {
                                PsDebug.message((String)("Area: " + n4));
                                PsDebug.message((String)("m_quantization: " + this.m_quantization));
                                PsDebug.message((String)"Area * m_quantization == 0");
                            }
                            if ((nArray4[0] * piVectorArray[0].m_data[n5] + nArray4[1] * piVectorArray[1].m_data[n5] + nArray4[2] * piVectorArray[2].m_data[n5]) % (n4 * this.m_quantization) == 0) {
                                n13 = (nArray4[0] * piVectorArray[0].m_data[n5] + nArray4[1] * piVectorArray[1].m_data[n5] + nArray4[2] * piVectorArray[2].m_data[n5]) * n2 / (n4 * this.m_quantization) + nArray2[n5];
                                if (bl) {
                                    PsDebug.message((String)"Grid found point on face.");
                                }
                            } else {
                                n13 = (nArray4[0] * piVectorArray[0].m_data[n5] + nArray4[1] * piVectorArray[1].m_data[n5] + nArray4[2] * piVectorArray[2].m_data[n5]) / (n4 * this.m_quantization) * n2 + 1 + nArray2[n5];
                                if (bl) {
                                    PsDebug.message((String)"Off-grid found point on face.");
                                }
                            }
                            if (n13 % n2 == 0 && (n5 == 1 && object[0] == false || n5 == 2 && (object[0] == false || object[1] == false))) {
                                if (!bl) continue;
                                PsDebug.message((String)"... don't add, it was computed earlier already.");
                                continue;
                            }
                            PiVector piVector2 = new PiVector(3);
                            piVector2.m_data[(n5 + 0) % 3] = n13;
                            piVector2.m_data[(n5 + 1) % 3] = k * n2 / this.m_quantization + nArray2[(n5 + 1) % 3];
                            piVector2.m_data[(n5 + 2) % 3] = i2 * n2 / this.m_quantization + nArray2[(n5 + 2) % 3];
                            if (bl) {
                                PsDebug.message((String)("Computed face intersection point has tex coords " + piVector2.m_data[0] + " " + piVector2.m_data[1] + " " + piVector2.m_data[2]));
                            }
                            int n15 = 1;
                            if (n8 != -1) {
                                ++n15;
                            }
                            vertexInfo vertexInfo3 = new vertexInfo(n15, 2, this.m_numNewVertices);
                            vertexInfo3.m_bIsBoundary = n8 == -1;
                            ++this.m_numNewVertices;
                            PiVector piVector3 = this.m_tetraSet.getTetra(i);
                            PdVector pdVector = PdVector.blendNew((double)(1.0 * (double)nArray4[0] / (1.0 * (double)n4)), (PdVector)this.m_tetraSet.getVertex(piVector3.m_data[(j + 1 + 0) % 4]), (double)(1.0 * (double)nArray4[1] / (1.0 * (double)n4)), (PdVector)this.m_tetraSet.getVertex(piVector3.m_data[(j + 1 + 1) % 4]));
                            pdVector.blendBase(pdVector, 1.0 * (double)nArray4[2] / (1.0 * (double)n4), this.m_tetraSet.getVertex(piVector3.m_data[(j + 1 + 2) % 4]));
                            vertexInfo3.m_vertex = pdVector;
                            vertexInfo3.m_texture[0] = piVector2;
                            vertexInfo3.m_localIndex.m_data[0] = j;
                            vertexInfo3.m_tetIndex.m_data[0] = i;
                            int n16 = i;
                            piVector.m_data[n16] = piVector.m_data[n16] + 1;
                            if (n8 != -1) {
                                vertexInfo3.m_texture[1] = this.computeTexFromNeighbour(piVector2, n8, i, piVector3.m_data[(j + 1) % 4]);
                                vertexInfo3.m_localIndex.m_data[1] = this.m_tetraSet.getOppVertexLocInd(i, j);
                                vertexInfo3.m_tetIndex.m_data[1] = n8;
                                int n17 = n8;
                                piVector.m_data[n17] = piVector.m_data[n17] + 1;
                            }
                            vector.addElement(vertexInfo3);
                        }
                    }
                }
            }
        }
    }

    private void findPointsInTets(Vector vector, PiVector piVector, vertexInfo[][] vertexInfoArray, Vector vector2) {
        int n = this.m_tetraSet.getNumTetras();
        int n2 = 2;
        boolean bl = m_bVerboseGlobal;
        for (int i = 0; i < n; ++i) {
            PiVector piVector2;
            int n3;
            int n4;
            if (bl) {
                PsDebug.message((String)("+++++++++++++++++++ Check Tetrahedron " + i + " for interiour points ++++++++++++++++++++++++"));
            }
            PiVector piVector3 = this.m_tetraSet.getTetra(i);
            int n5 = piVector.m_data[i];
            if (bl) {
                PsDebug.message((String)("Tet " + i + " has " + n5 + " vertices on its surface."));
            }
            PiVector piVector4 = new PiVector(n5);
            int[] nArray = new int[3];
            int[] nArray2 = new int[3];
            for (n4 = 0; n4 < 3; ++n4) {
                nArray[n4] = Integer.MAX_VALUE;
                nArray2[n4] = Integer.MIN_VALUE;
            }
            for (n4 = 0; n4 < n5; ++n4) {
                int n6;
                vertexInfo vertexInfo2 = vertexInfoArray[i][n4];
                piVector4.m_data[n4] = n6 = vertexInfo2.m_tetIndex.getIndexOf(i);
                for (n3 = 0; n3 < 3; ++n3) {
                    if (nArray[n3] > vertexInfo2.m_texture[n6].m_data[n3]) {
                        nArray[n3] = vertexInfo2.m_texture[n6].m_data[n3];
                    }
                    if (nArray2[n3] >= vertexInfo2.m_texture[n6].m_data[n3]) continue;
                    nArray2[n3] = vertexInfo2.m_texture[n6].m_data[n3];
                }
            }
            int[] nArray3 = new int[3];
            if (bl) {
                PsDebug.message((String)("Minimum: " + nArray[0] + " " + nArray[1] + " " + nArray[2]));
                PsDebug.message((String)("Maximum: " + nArray2[0] + " " + nArray2[1] + " " + nArray2[2]));
                PsDebug.message((String)"Make even ...");
            }
            int n7 = -2;
            PiVector[] piVectorArray = new PiVector[]{this.m_coords[i][0], this.m_coords[i][1], this.m_coords[i][2], this.m_coords[i][3]};
            double d = (piVectorArray[1].m_data[0] - piVectorArray[0].m_data[0]) * (piVectorArray[2].m_data[1] - piVectorArray[0].m_data[1]) * (piVectorArray[3].m_data[2] - piVectorArray[0].m_data[2]) - (piVectorArray[2].m_data[0] - piVectorArray[0].m_data[0]) * (piVectorArray[1].m_data[1] - piVectorArray[0].m_data[1]) * (piVectorArray[3].m_data[2] - piVectorArray[0].m_data[2]) + (piVectorArray[2].m_data[0] - piVectorArray[0].m_data[0]) * (piVectorArray[3].m_data[1] - piVectorArray[0].m_data[1]) * (piVectorArray[1].m_data[2] - piVectorArray[0].m_data[2]) - (piVectorArray[3].m_data[0] - piVectorArray[0].m_data[0]) * (piVectorArray[2].m_data[1] - piVectorArray[0].m_data[1]) * (piVectorArray[1].m_data[2] - piVectorArray[0].m_data[2]) + (piVectorArray[3].m_data[0] - piVectorArray[0].m_data[0]) * (piVectorArray[1].m_data[1] - piVectorArray[0].m_data[1]) * (piVectorArray[2].m_data[2] - piVectorArray[0].m_data[2]) - (piVectorArray[1].m_data[0] - piVectorArray[0].m_data[0]) * (piVectorArray[3].m_data[1] - piVectorArray[0].m_data[1]) * (piVectorArray[2].m_data[2] - piVectorArray[0].m_data[2]);
            Object[] objectArray = new PdVector[]{this.m_tetraSet.getVertex(piVector3.m_data[0]), this.m_tetraSet.getVertex(piVector3.m_data[1]), this.m_tetraSet.getVertex(piVector3.m_data[2]), this.m_tetraSet.getVertex(piVector3.m_data[3])};
            double d2 = (objectArray[1].m_data[0] - objectArray[0].m_data[0]) * (objectArray[2].m_data[1] - objectArray[0].m_data[1]) * (objectArray[3].m_data[2] - objectArray[0].m_data[2]) - (objectArray[2].m_data[0] - objectArray[0].m_data[0]) * (objectArray[1].m_data[1] - objectArray[0].m_data[1]) * (objectArray[3].m_data[2] - objectArray[0].m_data[2]) + (objectArray[2].m_data[0] - objectArray[0].m_data[0]) * (objectArray[3].m_data[1] - objectArray[0].m_data[1]) * (objectArray[1].m_data[2] - objectArray[0].m_data[2]) - (objectArray[3].m_data[0] - objectArray[0].m_data[0]) * (objectArray[2].m_data[1] - objectArray[0].m_data[1]) * (objectArray[1].m_data[2] - objectArray[0].m_data[2]) + (objectArray[3].m_data[0] - objectArray[0].m_data[0]) * (objectArray[1].m_data[1] - objectArray[0].m_data[1]) * (objectArray[2].m_data[2] - objectArray[0].m_data[2]) - (objectArray[1].m_data[0] - objectArray[0].m_data[0]) * (objectArray[3].m_data[1] - objectArray[0].m_data[1]) * (objectArray[2].m_data[2] - objectArray[0].m_data[2]);
            if (d == 0.0 || d2 == 0.0) {
                n7 = 0;
            } else if (d / d2 > 0.0) {
                n7 = 1;
                this.m_tetraSet.setTagTetra(i, 1);
            } else {
                n7 = -1;
            }
            for (int j = 0; j < 3; ++j) {
                if (nArray[j] >= 0 && nArray[j] % 2 == 1 || nArray[j] < 0 && -nArray[j] % 2 == 1) {
                    int n8 = j;
                    nArray[n8] = nArray[n8] - 1;
                }
                if (nArray2[j] >= 0 && nArray2[j] % 2 == 1 || nArray2[j] < 0 && -nArray2[j] % 2 == 1) {
                    int n9 = j;
                    nArray2[n9] = nArray2[n9] + 1;
                }
                nArray3[j] = nArray2[j] - nArray[j] + 1;
            }
            if (bl) {
                PsDebug.message((String)("Minimum: " + nArray[0] + " " + nArray[1] + " " + nArray[2]));
                PsDebug.message((String)("Maximum: " + nArray2[0] + " " + nArray2[1] + " " + nArray2[2]));
            }
            vertexInfo[][][] vertexInfoArray2 = new vertexInfo[nArray3[0]][nArray3[1]][nArray3[2]];
            for (n3 = 0; n3 < n5; ++n3) {
                vertexInfo vertexInfo3 = vertexInfoArray[i][n3];
                objectArray = new int[]{vertexInfo3.m_texture[piVector4.m_data[n3]].m_data[0] - nArray[0], vertexInfo3.m_texture[piVector4.m_data[n3]].m_data[1] - nArray[1], vertexInfo3.m_texture[piVector4.m_data[n3]].m_data[2] - nArray[2]};
                String string = "";
                if (bl) {
                    string = "position " + (int)objectArray[0] + " " + (int)objectArray[1] + " " + (int)objectArray[2] + " ";
                    string = vertexInfo3.m_type == 0 ? string + "V " : (vertexInfo3.m_type == 1 ? string + "E " : (vertexInfo3.m_type == 2 ? string + "F " : string + "T "));
                }
                if (vertexInfoArray2[objectArray[0]][objectArray[1]][objectArray[2]] != null) {
                    if (vertexInfo3.m_texture[0].m_data[0] % n2 == 0 && vertexInfo3.m_texture[0].m_data[1] % n2 == 0 || vertexInfo3.m_texture[0].m_data[1] % n2 == 0 && vertexInfo3.m_texture[0].m_data[2] % n2 == 0 || vertexInfo3.m_texture[0].m_data[2] % n2 == 0 && vertexInfo3.m_texture[0].m_data[0] % n2 == 0) {
                        piVector2 = new PiVector(vertexInfo3.m_vertexIndex, vertexInfoArray2[objectArray[0]][objectArray[1]][objectArray[2]].m_vertexIndex);
                        if (n7 < 0) {
                            piVector2.setTag(1);
                        }
                        vector2.addElement(piVector2);
                    }
                    if (bl) {
                        string = string + "already occupied - don't add " + vertexInfo3.m_vertexIndex;
                    }
                } else {
                    vertexInfoArray2[objectArray[0]][objectArray[1]][objectArray[2]] = vertexInfo3;
                    if (bl) {
                        string = string + "add " + vertexInfo3.m_vertexIndex;
                    }
                }
                if (!bl) continue;
                PsDebug.message((String)string);
            }
            for (n3 = 0; n3 < nArray3[0]; n3 += n2) {
                for (int j = 0; j < nArray3[1]; j += n2) {
                    int n10;
                    int n11 = -1;
                    int n12 = -1;
                    for (n10 = 0; n10 < nArray3[2]; ++n10) {
                        if (vertexInfoArray2[n3][j][n10] == null) continue;
                        if (n11 == -1) {
                            n11 = n10;
                        }
                        n12 = n10;
                    }
                    if (n11 == -1) continue;
                    for (n10 = 0; n10 < nArray3[2]; n10 += n2) {
                        double d3;
                        Object object;
                        Object object2;
                        if (n10 <= n11 || n10 >= n12 || vertexInfoArray2[n3][j][n10] != null) continue;
                        if (bl) {
                            PsDebug.message((String)("Tet " + i + " add new vertex " + this.m_numNewVertices));
                            PsDebug.message((String)("Start: " + n11 + " " + vertexInfoArray2[n3][j][n11].m_vertexIndex));
                            object2 = "";
                            object2 = vertexInfoArray2[n3][j][n11].m_type == 0 ? (String)object2 + "V " : (vertexInfoArray2[n3][j][n11].m_type == 1 ? (String)object2 + "E " : (vertexInfoArray2[n3][j][n11].m_type == 2 ? (String)object2 + "F " : (String)object2 + "T "));
                            object2 = (String)object2 + vertexInfoArray2[n3][j][n11].m_texture[vertexInfoArray2[n3][j][n11].m_tetIndex.getIndexOf(i)].toShortString();
                            PsDebug.message((String)object2);
                            PsDebug.message((String)("End: " + n12 + " " + vertexInfoArray2[n3][j][n12].m_vertexIndex));
                            object = "";
                            object = vertexInfoArray2[n3][j][n12].m_type == 0 ? (String)object + "V " : (vertexInfoArray2[n3][j][n12].m_type == 1 ? (String)object + "E " : (vertexInfoArray2[n3][j][n12].m_type == 2 ? (String)object + "F " : (String)object + "T "));
                            object = (String)object + vertexInfoArray2[n3][j][n12].m_texture[vertexInfoArray2[n3][j][n12].m_tetIndex.getIndexOf(i)].toShortString();
                            PsDebug.message((String)object);
                        }
                        object2 = new vertexInfo(1, 3, this.m_numNewVertices);
                        ((vertexInfo)object2).m_bIsBoundary = false;
                        ++this.m_numNewVertices;
                        ((vertexInfo)object2).m_tetIndex.m_data[0] = i;
                        int n13 = i;
                        piVector.m_data[n13] = piVector.m_data[n13] + 1;
                        ((vertexInfo)object2).m_texture[0] = object = new PiVector(nArray[0] + n3, nArray[1] + j, nArray[2] + n10);
                        PiVector piVector5 = new PiVector((nArray[0] + n3) / n2 * this.m_quantization, (nArray[1] + j) / n2 * this.m_quantization, (nArray[2] + n10) / n2 * this.m_quantization);
                        PiVector[] piVectorArray2 = new PiVector[]{this.m_coords[i][0], this.m_coords[i][1], this.m_coords[i][2], this.m_coords[i][3]};
                        if (bl) {
                            PsDebug.message((String)("Tex 0: " + piVectorArray2[0].toShortString()));
                            PsDebug.message((String)("Tex 1: " + piVectorArray2[1].toShortString()));
                            PsDebug.message((String)("Tex 2: " + piVectorArray2[2].toShortString()));
                            PsDebug.message((String)("Tex 3: " + piVectorArray2[3].toShortString()));
                            PsDebug.message((String)("New Vertex Tex: " + piVector5.toShortString()));
                        }
                        if ((d3 = (double)((piVectorArray2[1].m_data[0] - piVectorArray2[0].m_data[0]) * (piVectorArray2[2].m_data[1] - piVectorArray2[0].m_data[1]) * (piVectorArray2[3].m_data[2] - piVectorArray2[0].m_data[2]) - (piVectorArray2[2].m_data[0] - piVectorArray2[0].m_data[0]) * (piVectorArray2[1].m_data[1] - piVectorArray2[0].m_data[1]) * (piVectorArray2[3].m_data[2] - piVectorArray2[0].m_data[2]) + (piVectorArray2[2].m_data[0] - piVectorArray2[0].m_data[0]) * (piVectorArray2[3].m_data[1] - piVectorArray2[0].m_data[1]) * (piVectorArray2[1].m_data[2] - piVectorArray2[0].m_data[2]) - (piVectorArray2[3].m_data[0] - piVectorArray2[0].m_data[0]) * (piVectorArray2[2].m_data[1] - piVectorArray2[0].m_data[1]) * (piVectorArray2[1].m_data[2] - piVectorArray2[0].m_data[2]) + (piVectorArray2[3].m_data[0] - piVectorArray2[0].m_data[0]) * (piVectorArray2[1].m_data[1] - piVectorArray2[0].m_data[1]) * (piVectorArray2[2].m_data[2] - piVectorArray2[0].m_data[2]) - (piVectorArray2[1].m_data[0] - piVectorArray2[0].m_data[0]) * (piVectorArray2[3].m_data[1] - piVectorArray2[0].m_data[1]) * (piVectorArray2[2].m_data[2] - piVectorArray2[0].m_data[2]))) == 0.0) {
                            PsDebug.message((String)("degenerated tetrahedron " + i + " - here no inner point should be found!"));
                            d3 = 1.0;
                        }
                        double[] dArray = new double[]{(piVectorArray2[1].m_data[0] - piVector5.m_data[0]) * (piVectorArray2[2].m_data[1] - piVector5.m_data[1]) * (piVectorArray2[3].m_data[2] - piVector5.m_data[2]) - (piVectorArray2[2].m_data[0] - piVector5.m_data[0]) * (piVectorArray2[1].m_data[1] - piVector5.m_data[1]) * (piVectorArray2[3].m_data[2] - piVector5.m_data[2]) + (piVectorArray2[2].m_data[0] - piVector5.m_data[0]) * (piVectorArray2[3].m_data[1] - piVector5.m_data[1]) * (piVectorArray2[1].m_data[2] - piVector5.m_data[2]) - (piVectorArray2[3].m_data[0] - piVector5.m_data[0]) * (piVectorArray2[2].m_data[1] - piVector5.m_data[1]) * (piVectorArray2[1].m_data[2] - piVector5.m_data[2]) + (piVectorArray2[3].m_data[0] - piVector5.m_data[0]) * (piVectorArray2[1].m_data[1] - piVector5.m_data[1]) * (piVectorArray2[2].m_data[2] - piVector5.m_data[2]) - (piVectorArray2[1].m_data[0] - piVector5.m_data[0]) * (piVectorArray2[3].m_data[1] - piVector5.m_data[1]) * (piVectorArray2[2].m_data[2] - piVector5.m_data[2]), (piVector5.m_data[0] - piVectorArray2[0].m_data[0]) * (piVectorArray2[2].m_data[1] - piVectorArray2[0].m_data[1]) * (piVectorArray2[3].m_data[2] - piVectorArray2[0].m_data[2]) - (piVectorArray2[2].m_data[0] - piVectorArray2[0].m_data[0]) * (piVector5.m_data[1] - piVectorArray2[0].m_data[1]) * (piVectorArray2[3].m_data[2] - piVectorArray2[0].m_data[2]) + (piVectorArray2[2].m_data[0] - piVectorArray2[0].m_data[0]) * (piVectorArray2[3].m_data[1] - piVectorArray2[0].m_data[1]) * (piVector5.m_data[2] - piVectorArray2[0].m_data[2]) - (piVectorArray2[3].m_data[0] - piVectorArray2[0].m_data[0]) * (piVectorArray2[2].m_data[1] - piVectorArray2[0].m_data[1]) * (piVector5.m_data[2] - piVectorArray2[0].m_data[2]) + (piVectorArray2[3].m_data[0] - piVectorArray2[0].m_data[0]) * (piVector5.m_data[1] - piVectorArray2[0].m_data[1]) * (piVectorArray2[2].m_data[2] - piVectorArray2[0].m_data[2]) - (piVector5.m_data[0] - piVectorArray2[0].m_data[0]) * (piVectorArray2[3].m_data[1] - piVectorArray2[0].m_data[1]) * (piVectorArray2[2].m_data[2] - piVectorArray2[0].m_data[2]), (piVectorArray2[1].m_data[0] - piVectorArray2[0].m_data[0]) * (piVector5.m_data[1] - piVectorArray2[0].m_data[1]) * (piVectorArray2[3].m_data[2] - piVectorArray2[0].m_data[2]) - (piVector5.m_data[0] - piVectorArray2[0].m_data[0]) * (piVectorArray2[1].m_data[1] - piVectorArray2[0].m_data[1]) * (piVectorArray2[3].m_data[2] - piVectorArray2[0].m_data[2]) + (piVector5.m_data[0] - piVectorArray2[0].m_data[0]) * (piVectorArray2[3].m_data[1] - piVectorArray2[0].m_data[1]) * (piVectorArray2[1].m_data[2] - piVectorArray2[0].m_data[2]) - (piVectorArray2[3].m_data[0] - piVectorArray2[0].m_data[0]) * (piVector5.m_data[1] - piVectorArray2[0].m_data[1]) * (piVectorArray2[1].m_data[2] - piVectorArray2[0].m_data[2]) + (piVectorArray2[3].m_data[0] - piVectorArray2[0].m_data[0]) * (piVectorArray2[1].m_data[1] - piVectorArray2[0].m_data[1]) * (piVector5.m_data[2] - piVectorArray2[0].m_data[2]) - (piVectorArray2[1].m_data[0] - piVectorArray2[0].m_data[0]) * (piVectorArray2[3].m_data[1] - piVectorArray2[0].m_data[1]) * (piVector5.m_data[2] - piVectorArray2[0].m_data[2]), (piVectorArray2[1].m_data[0] - piVectorArray2[0].m_data[0]) * (piVectorArray2[2].m_data[1] - piVectorArray2[0].m_data[1]) * (piVector5.m_data[2] - piVectorArray2[0].m_data[2]) - (piVectorArray2[2].m_data[0] - piVectorArray2[0].m_data[0]) * (piVectorArray2[1].m_data[1] - piVectorArray2[0].m_data[1]) * (piVector5.m_data[2] - piVectorArray2[0].m_data[2]) + (piVectorArray2[2].m_data[0] - piVectorArray2[0].m_data[0]) * (piVector5.m_data[1] - piVectorArray2[0].m_data[1]) * (piVectorArray2[1].m_data[2] - piVectorArray2[0].m_data[2]) - (piVector5.m_data[0] - piVectorArray2[0].m_data[0]) * (piVectorArray2[2].m_data[1] - piVectorArray2[0].m_data[1]) * (piVectorArray2[1].m_data[2] - piVectorArray2[0].m_data[2]) + (piVector5.m_data[0] - piVectorArray2[0].m_data[0]) * (piVectorArray2[1].m_data[1] - piVectorArray2[0].m_data[1]) * (piVectorArray2[2].m_data[2] - piVectorArray2[0].m_data[2]) - (piVectorArray2[1].m_data[0] - piVectorArray2[0].m_data[0]) * (piVector5.m_data[1] - piVectorArray2[0].m_data[1]) * (piVectorArray2[2].m_data[2] - piVectorArray2[0].m_data[2])};
                        if (bl) {
                            PsDebug.message((String)("Weights: " + dArray[0] / d3 + " " + dArray[1] / d3 + " " + dArray[2] / d3 + " " + dArray[3] / d3));
                        }
                        ((vertexInfo)object2).m_vertex = PdVector.blendNew((double)(dArray[0] / d3), (PdVector)this.m_tetraSet.getVertex(piVector3.m_data[0]), (double)(dArray[1] / d3), (PdVector)this.m_tetraSet.getVertex(piVector3.m_data[1]));
                        ((vertexInfo)object2).m_vertex.blendBase(((vertexInfo)object2).m_vertex, dArray[2] / d3, this.m_tetraSet.getVertex(piVector3.m_data[2]));
                        ((vertexInfo)object2).m_vertex.blendBase(((vertexInfo)object2).m_vertex, dArray[3] / d3, this.m_tetraSet.getVertex(piVector3.m_data[3]));
                        vector.addElement(object2);
                        vertexInfoArray2[n3][j][n10] = object2;
                    }
                }
            }
            for (n3 = 0; n3 < nArray3[1]; n3 += 2) {
                for (int j = 0; j < nArray3[2]; j += 2) {
                    int n14 = -1;
                    for (int k = 0; k < nArray3[0]; ++k) {
                        if (vertexInfoArray2[k][n3][j] == null) continue;
                        if (n14 != -1) {
                            piVector2 = new PiVector(n14, vertexInfoArray2[k][n3][j].m_vertexIndex);
                            if (n7 < 0) {
                                piVector2.setTag(1);
                            }
                            vector2.addElement(piVector2);
                        }
                        n14 = vertexInfoArray2[k][n3][j].m_vertexIndex;
                    }
                }
            }
            for (n3 = 0; n3 < nArray3[2]; n3 += 2) {
                for (int j = 0; j < nArray3[0]; j += 2) {
                    int n15 = -1;
                    for (int k = 0; k < nArray3[1]; ++k) {
                        if (vertexInfoArray2[j][k][n3] == null) continue;
                        if (n15 != -1) {
                            piVector2 = new PiVector(n15, vertexInfoArray2[j][k][n3].m_vertexIndex);
                            if (n7 < 0) {
                                piVector2.setTag(1);
                            }
                            vector2.addElement(piVector2);
                        }
                        n15 = vertexInfoArray2[j][k][n3].m_vertexIndex;
                    }
                }
            }
            for (n3 = 0; n3 < nArray3[0]; n3 += 2) {
                for (int j = 0; j < nArray3[1]; j += 2) {
                    int n16 = -1;
                    for (int k = 0; k < nArray3[2]; ++k) {
                        if (vertexInfoArray2[n3][j][k] == null) continue;
                        if (n16 != -1) {
                            piVector2 = new PiVector(n16, vertexInfoArray2[n3][j][k].m_vertexIndex);
                            if (n7 < 0) {
                                piVector2.setTag(1);
                            }
                            vector2.addElement(piVector2);
                        }
                        n16 = vertexInfoArray2[n3][j][k].m_vertexIndex;
                    }
                }
            }
        }
    }

    public static void guessElements(PgElementSet pgElementSet, PgPolygonSet pgPolygonSet) {
        int n;
        int n2;
        int n3;
        int n4 = pgPolygonSet.getNumVertices();
        int n5 = pgPolygonSet.getNumPolygons();
        PiVector piVector = new PiVector(n4);
        for (int i = 0; i < n5; ++i) {
            PiVector piVector2 = pgPolygonSet.getPolygon(i);
            int n6 = piVector2.m_data[0];
            piVector.m_data[n6] = piVector.m_data[n6] + 1;
            int n7 = piVector2.m_data[1];
            piVector.m_data[n7] = piVector.m_data[n7] + 1;
        }
        PiVector[] piVectorArray = new PiVector[n4];
        for (n3 = 0; n3 < n4; ++n3) {
            piVectorArray[n3] = new PiVector(piVector.m_data[n3]);
        }
        piVector.setConstant(0);
        for (n3 = 0; n3 < n5; ++n3) {
            PiVector piVector3 = pgPolygonSet.getPolygon(n3);
            piVectorArray[piVector3.m_data[0]].m_data[piVector.m_data[piVector3.m_data[0]]] = piVector3.m_data[1];
            piVectorArray[piVector3.m_data[1]].m_data[piVector.m_data[piVector3.m_data[1]]] = piVector3.m_data[0];
            int n8 = piVector3.m_data[0];
            piVector.m_data[n8] = piVector.m_data[n8] + 1;
            int n9 = piVector3.m_data[1];
            piVector.m_data[n9] = piVector.m_data[n9] + 1;
        }
        Vector<PiVector> vector = new Vector<PiVector>();
        for (n2 = 0; n2 < n4; ++n2) {
            if (piVector.m_data[n2] < 2) continue;
            for (n = 0; n < piVector.m_data[n2] - 1; ++n) {
                int n10 = piVectorArray[n2].m_data[n];
                if (n10 < n2) continue;
                PiVector piVector4 = piVectorArray[n10];
                for (int i = n + 1; i < piVector.m_data[n2]; ++i) {
                    int n11 = piVectorArray[n2].m_data[i];
                    if (n11 < n2) continue;
                    PiVector piVector5 = piVectorArray[n11];
                    for (int j = 0; j < piVector.m_data[n10]; ++j) {
                        int n12 = piVector4.m_data[j];
                        if (n12 < n2 || n12 == n2) continue;
                        if (n12 == n11) {
                            vector.addElement(new PiVector(n2, n10, n11));
                            continue;
                        }
                        if (piVector5.getIndexOf(n12) < 0) continue;
                        vector.addElement(new PiVector(n2, n10, n12, n11));
                    }
                }
            }
        }
        n2 = vector.size();
        pgElementSet.setNumElements(n2);
        for (n = 0; n < n2; ++n) {
            pgElementSet.setElement(n, (PiVector)vector.elementAt(n));
            if (pgElementSet.getElement(n).getSize() == 4) continue;
            pgElementSet.getElement(n).setTag(1);
        }
        pgElementSet.assureDimOfElements();
    }

    private void cleanPolygonSet() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        this.m_polygonSetCleaned = (PgPolygonSet)this.m_polygonSet.clone();
        this.m_polygonSetCleaned.setName("Edges for cubeSet");
        int n6 = this.m_polygonSet.getNumVertices();
        int n7 = this.m_polygonSet.getNumPolygons();
        PiVector piVector = new PiVector(n6);
        for (int i = 0; i < n7; ++i) {
            PiVector piVector2 = this.m_polygonSet.getPolygon(i);
            int n8 = piVector2.m_data[0];
            piVector.m_data[n8] = piVector.m_data[n8] + 1;
            int n9 = piVector2.m_data[1];
            piVector.m_data[n9] = piVector.m_data[n9] + 1;
        }
        PiVector[] piVectorArray = new PiVector[n6];
        for (n5 = 0; n5 < n6; ++n5) {
            piVectorArray[n5] = new PiVector(piVector.m_data[n5]);
        }
        piVector.setConstant(0);
        for (n5 = 0; n5 < n7; ++n5) {
            PiVector piVector3 = this.m_polygonSet.getPolygon(n5);
            piVectorArray[piVector3.m_data[0]].m_data[piVector.m_data[piVector3.m_data[0]]] = piVector3.m_data[1];
            piVectorArray[piVector3.m_data[1]].m_data[piVector.m_data[piVector3.m_data[1]]] = piVector3.m_data[0];
            int n10 = piVector3.m_data[0];
            piVector.m_data[n10] = piVector.m_data[n10] + 1;
            int n11 = piVector3.m_data[1];
            piVector.m_data[n11] = piVector.m_data[n11] + 1;
        }
        for (n5 = 0; n5 < n6; ++n5) {
            if (this.m_polygonSet.hasTagVertex(n5, 1) || piVector.m_data[n5] == 0) continue;
            int n12 = -1;
            for (n4 = 0; n4 < piVector.m_data[n5]; ++n4) {
                if (piVectorArray[n5].m_data[n4] == n5) continue;
                if (n12 == -1) {
                    n12 = piVectorArray[n5].m_data[n4];
                    continue;
                }
                if (!this.m_polygonSet.hasTagVertex(piVectorArray[n5].m_data[n4], 1)) continue;
                n12 = piVectorArray[n5].m_data[n4];
            }
            if (n12 == -1) continue;
            PiVector piVector4 = piVectorArray[n12];
            for (n3 = 0; n3 < piVector.m_data[n5]; ++n3) {
                for (n2 = 0; n2 < piVector.m_data[piVectorArray[n5].m_data[n3]]; ++n2) {
                    if (piVectorArray[piVectorArray[n5].m_data[n3]].m_data[n2] != n5) continue;
                    piVectorArray[piVectorArray[n5].m_data[n3]].m_data[n2] = n12;
                    if (piVector4.getIndexOf(piVectorArray[n5].m_data[n3]) >= 0) continue;
                    piVector4.setSize(piVector.m_data[n12] + 1);
                    piVector4.m_data[piVector.m_data[n12]] = piVectorArray[n5].m_data[n3];
                    int n13 = n12;
                    piVector.m_data[n13] = piVector.m_data[n13] + 1;
                }
            }
        }
        Vector<PiVector> vector = new Vector<PiVector>();
        for (n = 0; n < n6; ++n) {
            if (!this.m_polygonSet.hasTagVertex(n, 1)) continue;
            for (n4 = 0; n4 < piVector.m_data[n]; ++n4) {
                if (piVectorArray[n].m_data[n4] == n || piVectorArray[n].m_data[n4] < n) continue;
                n3 = 0;
                for (n2 = 0; n2 < n4; ++n2) {
                    if (piVectorArray[n].m_data[n4] != piVectorArray[n].m_data[n2]) continue;
                    n3 = 1;
                }
                if (n3 != 0) continue;
                vector.addElement(new PiVector(n, piVectorArray[n].m_data[n4]));
            }
        }
        n7 = vector.size();
        this.m_polygonSetCleaned.setNumPolygons(n7);
        for (n = 0; n < n7; ++n) {
            this.m_polygonSetCleaned.setPolygon(n, (PiVector)vector.elementAt(n));
        }
    }

    private PiVector computeTexFromNeighbour(PiVector piVector, int n, int n2, int n3) {
        PiVector piVector2;
        PiVector piVector3 = new PiVector(3);
        int n4 = 2;
        int n5 = this.m_tetraSet.getNeighbour(n2).getIndexOf(n);
        if (n5 == -1) {
            PsDebug.warning((String)"Error in transforming texture to neighbour tetrahedron.");
        }
        if ((piVector2 = this.m_matching[n2][n5]) == null) {
            piVector2 = new PiVector(0, 1, 2);
        }
        int n6 = this.m_tetraSet.getTetra(n2).getIndexOf(n3);
        int n7 = this.m_tetraSet.getTetra(n).getIndexOf(n3);
        PiVector piVector4 = this.m_coords[n2][n6];
        PiVector piVector5 = new PiVector(3);
        for (int i = 0; i < 3; ++i) {
            piVector5.m_data[piVector2.m_data[i] % 3] = piVector4.m_data[i];
            if (piVector2.m_data[i] / 3 != 1) continue;
            int n8 = piVector2.m_data[i] % 3;
            piVector5.m_data[n8] = piVector5.m_data[n8] * -1;
        }
        PiVector piVector6 = this.m_coords[n][n7];
        PiVector piVector7 = PiVector.subNew((PiVector)piVector6, (PiVector)piVector5);
        int n9 = 0;
        while (n9 < 3) {
            int n10 = n9;
            piVector7.m_data[n10] = piVector7.m_data[n10] / this.m_quantization;
            int n11 = n9++;
            piVector7.m_data[n11] = piVector7.m_data[n11] * n4;
        }
        for (n6 = 0; n6 < 3; ++n6) {
            piVector3.m_data[piVector2.m_data[n6] % 3] = piVector.m_data[n6];
            if (piVector2.m_data[n6] / 3 != 1) continue;
            int n12 = piVector2.m_data[n6] % 3;
            piVector3.m_data[n12] = piVector3.m_data[n12] * -1;
        }
        piVector3.add(piVector7);
        return piVector3;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class vertexInfo {
        public PdVector m_vertex;
        public int m_vertexIndex;
        public PiVector m_tetIndex;
        public PiVector[] m_texture;
        public PiVector m_localIndex;
        public int m_type = -1;
        public int m_numTets;
        public boolean m_bIsBoundary = false;

        public vertexInfo(int n, int n2, int n3) {
            this.m_numTets = n;
            this.m_type = n2;
            this.m_vertexIndex = n3;
            this.m_tetIndex = new PiVector(n);
            this.m_localIndex = new PiVector(n);
            this.m_texture = PiVector.realloc(null, (int)n, (int)3);
        }
    }
}

