/*
 * Decompiled with CFR 0.152.
 */
package jvx.vector;

import java.util.Enumeration;
import java.util.Vector;
import jv.geom.PgElementSet;
import jv.geom.PgPointSet;
import jv.geom.PgPolygonSet;
import jv.geom.PgVectorField;
import jv.geom.PuCleanMesh;
import jv.number.PuDouble;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.object.PsUpdateIf;
import jv.project.PgGeometry;
import jv.project.PgGeometryIf;
import jv.project.PvDisplayIf;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jvx.geom.PwCleanMesh;
import jvx.project.PjWorkshop;

public class PwIsoline
extends PjWorkshop {
    public static final int RANGE_MAJOR = 0;
    public static final int RANGE_LOWER = 1;
    public static final int RANGE_HIGHER = 2;
    public static final int RANGE_FULL = 3;
    protected PgElementSet m_geomBase;
    protected PgPolygonSet m_isolines = new PgPolygonSet();
    protected PuDouble m_minLevel = new PuDouble(PsConfig.getMessage((int)54515), (PsUpdateIf)this);
    protected PuDouble m_maxLevel = new PuDouble(PsConfig.getMessage((int)54516), (PsUpdateIf)this);
    protected PuDouble m_mainLevel = new PuDouble(PsConfig.getMessage((int)54517), (PsUpdateIf)this);
    protected PuDouble m_discr = new PuDouble(PsConfig.getMessage((int)54097), (PsUpdateIf)this);
    protected PdVector m_scalar;
    protected PdVector m_level = new PdVector();
    protected int m_range;
    protected boolean m_bIsShowingElements = false;
    protected boolean m_bIsShowingEdges = false;
    static /* synthetic */ Class class$jvx$vector$PwIsoline;

    public PwIsoline() {
        super(PsConfig.getMessage((int)54514));
        this.m_scalar = new PdVector();
        if (((Object)((Object)this)).getClass() == (class$jvx$vector$PwIsoline == null ? (class$jvx$vector$PwIsoline = PwIsoline.class$("jvx.vector.PwIsoline")) : class$jvx$vector$PwIsoline)) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.m_mainLevel.init();
        this.m_range = 0;
        this.m_minLevel.setDefBounds(0.0, 10.0, 0.1, 1.0);
        this.m_minLevel.setDefValue(0.5);
        this.m_minLevel.init();
        this.m_maxLevel.setDefBounds(0.0, 10.0, 0.1, 1.0);
        this.m_maxLevel.setDefValue(0.5);
        this.m_maxLevel.init();
        this.m_mainLevel.setDefBounds(0.0, 10.0, 0.1, 1.0);
        this.m_mainLevel.setDefValue(0.5);
        this.m_mainLevel.init();
        this.m_discr.setDefBounds(0.0, 10.0, 0.1, 1.0);
        this.m_discr.setDefValue(0.5);
        this.m_discr.init();
    }

    public void reset() {
        super.reset();
        if (this.m_geomBase != null && this.m_geomSave != null) {
            this.m_geomBase.copy((PsObject)this.m_geomSave);
        }
        this.setGeometry((PgGeometry)this.m_geomBase);
    }

    public boolean update(Object object) {
        if (object == this.m_geomBase) {
            if (this.isUpdateSender()) {
                return true;
            }
            if (this.isModal()) {
                return true;
            }
            this.setGeometry((PgGeometry)this.m_geomBase);
            return true;
        }
        if (object == this) {
            return super.update((Object)this);
        }
        if (object == this.m_minLevel || object == this.m_maxLevel) {
            this.computeLevels();
            this.makeIsolines();
            return super.update((Object)this);
        }
        if (object == this.m_mainLevel) {
            this.computeLevels();
            this.makeIsolines();
            return super.update((Object)this);
        }
        if (object == this.m_discr) {
            this.computeLevels();
            this.makeIsolines();
            return super.update((Object)this);
        }
        return super.update(object);
    }

    public void setGeometry(PgGeometry pgGeometry) {
        int n;
        int n2;
        super.setGeometry(pgGeometry);
        this.m_geomBase = (PgElementSet)pgGeometry;
        this.m_bIsShowingEdges = this.m_geomBase.isShowingEdges();
        this.m_bIsShowingElements = this.m_geomBase.isShowingElements();
        if (this.m_geomBase.getDimOfElements() != 3) {
            PsDebug.warning((String)"geometry must be a triangulation");
            PgElementSet.triangulate((PgElementSet)this.m_geomBase);
        }
        if ((n2 = this.m_geomBase.getNumVectorFields()) == 0) {
            PsDebug.warning((String)"geometry has no vector field");
            return;
        }
        PgVectorField pgVectorField = null;
        for (n = 0; n < n2 && (pgVectorField = this.m_geomBase.getVectorField(n)).getDimOfVectors() != 1; ++n) {
        }
        if (pgVectorField == null) {
            PsDebug.warning((String)"geometry has no scalar field");
            return;
        }
        this.m_geomBase.showElements(false);
        this.m_geomBase.showEdges(true);
        n = this.m_geomBase.getNumVertices();
        this.m_scalar.setSize(n);
        for (int i = 0; i < n; ++i) {
            double d = pgVectorField.getVector(i).getEntry(0);
            this.m_scalar.setEntry(i, d);
        }
        double d = this.m_scalar.min();
        double d2 = this.m_scalar.max();
        this.m_discr.setBounds(0.0, (d2 - d) / 2.0, (d2 - d) / 100.0, (d2 - d) / 25.0);
        this.m_discr.setValue((d2 - d) / 10.0);
        this.m_discr.update((Object)this.m_discr);
        this.m_minLevel.setBounds(d, d2, (d2 - d) / 100.0, (d2 - d) / 25.0);
        this.m_minLevel.setValue(d);
        this.m_minLevel.update((Object)this.m_minLevel);
        this.m_maxLevel.setBounds(d, d2, (d2 - d) / 100.0, (d2 - d) / 25.0);
        this.m_maxLevel.setValue(d2);
        this.m_maxLevel.update((Object)this.m_maxLevel);
        this.m_mainLevel.setBounds(d, d2, (d2 - d) / 100.0, (d2 - d) / 25.0);
        this.m_mainLevel.setValue((d + d2) / 2.0);
        this.m_mainLevel.update((Object)this.m_mainLevel);
        this.computeLevels();
        int n3 = this.m_geomBase.getDimOfVertices();
        this.m_isolines.setDimOfVertices(n3);
        this.makeIsolines();
        Vector vector = this.m_geomBase.getDisplayList();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            PvDisplayIf pvDisplayIf = (PvDisplayIf)enumeration.nextElement();
            if (pvDisplayIf.containsGeometry((PgGeometryIf)this.m_isolines)) continue;
            pvDisplayIf.addGeometry((PgGeometryIf)this.m_isolines);
        }
    }

    public void cancel() {
        this.m_geomBase.showElements(this.m_bIsShowingElements);
        this.m_geomBase.showEdges(this.m_bIsShowingEdges);
        if (this.m_isolines != null) {
            Vector vector = this.m_geomBase.getDisplayList();
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                PvDisplayIf pvDisplayIf = (PvDisplayIf)enumeration.nextElement();
                if (pvDisplayIf.containsGeometry((PgGeometryIf)this.m_isolines)) {
                    pvDisplayIf.removeGeometry((PgGeometryIf)this.m_isolines);
                }
                pvDisplayIf.update((Object)pvDisplayIf);
            }
        }
        super.cancel();
    }

    public PdVector getLevels() {
        return this.m_level;
    }

    public void setLevels(PdVector pdVector) {
        if (pdVector == null) {
            return;
        }
        this.m_level.copy(pdVector);
    }

    public int getRangeType() {
        return this.m_range;
    }

    public void setRangeType(int n) {
        this.m_range = n;
    }

    protected void computeLevels() {
        double d = this.m_mainLevel.getValue();
        if (this.m_range == 0) {
            this.m_level.setSize(1);
            this.m_level.setEntry(0, d);
            return;
        }
        double d2 = this.m_minLevel.getValue();
        double d3 = this.m_maxLevel.getValue();
        double d4 = this.m_discr.getValue();
        switch (this.m_range) {
            case 1: {
                int n = (int)Math.ceil((d - d2) / d4) + 1;
                if (n <= 0) break;
                this.m_level.setSize(n);
                double d5 = d2;
                for (int i = 0; i < n - 1; ++i) {
                    this.m_level.m_data[i] = d5;
                    d5 += d4;
                }
                this.m_level.m_data[n - 1] = d;
                break;
            }
            case 2: {
                int n = (int)Math.ceil((d - d2) / d4);
                double d6 = d2 + (double)n * d4;
                n = (int)Math.ceil((d3 - d6) / d4) + 2;
                if (n <= 0) break;
                this.m_level.setSize(n);
                double d7 = d6;
                for (int i = 1; i < n; ++i) {
                    this.m_level.m_data[i] = d7;
                    d7 += d4;
                }
                this.m_level.m_data[0] = d;
                this.m_level.m_data[n - 1] = d3;
                break;
            }
            case 3: {
                int n = (int)Math.ceil((d3 - d2) / d4);
                if (n <= 0) break;
                this.m_level.setSize(n);
                double d8 = d2;
                for (int i = 0; i < n; ++i) {
                    this.m_level.m_data[i] = d8;
                    d8 += d4;
                }
                break;
            }
        }
    }

    public void makeIsolines() {
        PwIsoline.makeIsolines(this.m_geomBase, this.m_level, this.m_isolines, this.m_scalar);
        this.m_isolines.update((Object)this.m_isolines);
    }

    public static PgPolygonSet makeIsolines(PgElementSet pgElementSet, PdVector pdVector, PgPolygonSet pgPolygonSet, PdVector pdVector2) {
        if (pgElementSet.getDimOfElements() != 3) {
            return pgPolygonSet;
        }
        if (pdVector2.m_data.length < pgElementSet.getNumVertices()) {
            PsDebug.warning((String)"Given PdVector does not contain a fuction value for each vertex of the given geometry.");
            return pgPolygonSet;
        }
        if (pgPolygonSet == null) {
            pgPolygonSet = new PgPolygonSet(pgElementSet.getDimOfVertices());
        } else {
            pgPolygonSet.setNumPolygons(0);
            pgPolygonSet.setNumVertices(0);
        }
        if (pdVector == null) {
            PsDebug.warning((String)"No value to compute the isolines specified.");
            return pgPolygonSet;
        }
        int n = pgElementSet.getNumElements();
        PiVector[] piVectorArray = pgElementSet.getElements();
        PdVector[] pdVectorArray = pgElementSet.getVertices();
        PiVector piVector = new PiVector(2);
        int[] nArray = new int[3];
        int[] nArray2 = new int[3];
        for (int i = 0; i < n; ++i) {
            int n2;
            PiVector piVector2 = piVectorArray[i];
            int n3 = 0;
            int n4 = 2;
            for (n2 = 1; n2 < 3; ++n2) {
                if (pdVector2.m_data[piVector2.m_data[2 - n2]] > pdVector2.m_data[piVector2.m_data[n4]]) {
                    n4 = 2 - n2;
                }
                if (!(pdVector2.m_data[piVector2.m_data[n2]] < pdVector2.m_data[piVector2.m_data[n3]])) continue;
                n3 = n2;
            }
            if (pdVector2.m_data[piVector2.m_data[n3]] > pdVector.getLastEntry() || pdVector2.m_data[piVector2.m_data[n4]] < pdVector.getFirstEntry()) continue;
            n2 = pdVector.indexOfValueInOrdering(pdVector2.m_data[piVector2.m_data[n3]]);
            int n5 = pdVector.indexOfValueInOrdering(pdVector2.m_data[piVector2.m_data[n4]]);
            if (n2 == -1) {
                n2 = 0;
            }
            int n6 = pgPolygonSet.getNumPolygons();
            if (pgPolygonSet.getMaxNumPolygons() < n6 + n5 - n2 + 1) {
                pgPolygonSet.setNumPolygons(2 * pgPolygonSet.getMaxNumPolygons());
                pgPolygonSet.setNumPolygons(n6);
            }
            int n7 = pgPolygonSet.getNumVertices();
            if (pgPolygonSet.getMaxNumVertices() < n7 + 2 * (n5 - n2 + 1)) {
                pgPolygonSet.setNumVertices(2 * pgPolygonSet.getMaxNumVertices());
                pgPolygonSet.setNumVertices(n7);
            }
            block7: for (int j = n2; j <= n5; ++j) {
                int n8;
                double d = pdVector.m_data[j];
                int n9 = 0;
                for (n8 = 0; n8 < 3; ++n8) {
                    if (pdVector2.m_data[piVector2.m_data[n8]] != d) continue;
                    nArray[n9] = piVector2.m_data[n8];
                    nArray2[n9] = n8;
                    ++n9;
                }
                switch (n9) {
                    case 1: {
                        int n10 = piVector2.m_data[(nArray2[0] + 1) % 3];
                        int n11 = piVector2.m_data[(nArray2[0] + 2) % 3];
                        if (pdVector2.m_data[n10] < pdVector2.m_data[nArray[0]] && pdVector2.m_data[n11] < pdVector2.m_data[nArray[0]] || pdVector2.m_data[n10] > pdVector2.m_data[nArray[0]] && pdVector2.m_data[n11] > pdVector2.m_data[nArray[0]]) {
                            piVector.setSize(1);
                            piVector.m_data[0] = pgPolygonSet.addVertex(pdVectorArray[nArray[0]]);
                            pgPolygonSet.addPolygon(piVector);
                            piVector.setSize(2);
                            continue block7;
                        }
                        piVector.m_data[0] = pgPolygonSet.addVertex(pdVectorArray[nArray[0]]);
                        double d2 = (d - pdVector2.m_data[n10]) / (pdVector2.m_data[n11] - pdVector2.m_data[n10]);
                        piVector.m_data[1] = pgPolygonSet.addVertex(PdVector.blendNew((double)d2, (PdVector)pdVectorArray[n11], (double)(1.0 - d2), (PdVector)pdVectorArray[n10]));
                        pgPolygonSet.addPolygon(piVector);
                        continue block7;
                    }
                    case 2: {
                        for (n8 = 0; n8 < 2; ++n8) {
                            piVector.m_data[n8] = pgPolygonSet.addVertex(pdVectorArray[nArray[n8]]);
                        }
                        pgPolygonSet.addPolygon(piVector);
                        continue block7;
                    }
                    case 3: {
                        piVector.setSize(3);
                        for (n8 = 0; n8 < 3; ++n8) {
                            piVector.m_data[n8] = pgPolygonSet.addVertex(pdVectorArray[piVector2.m_data[n8]]);
                        }
                        int n10 = pgPolygonSet.addPolygon(piVector);
                        pgPolygonSet.setClosed(n10, true);
                        piVector.setSize(2);
                        continue block7;
                    }
                    default: {
                        double d2;
                        int n10;
                        int n11 = 0;
                        for (n8 = 0; n8 < 3; ++n8) {
                            n10 = (n8 + 1) % 3;
                            if (!(pdVector2.m_data[piVector2.m_data[n8]] < d && pdVector2.m_data[piVector2.m_data[n10]] > d) && (!(pdVector2.m_data[piVector2.m_data[n8]] > d) || !(pdVector2.m_data[piVector2.m_data[n10]] < d))) continue;
                            d2 = (d - pdVector2.m_data[piVector2.m_data[n8]]) / (pdVector2.m_data[piVector2.m_data[n10]] - pdVector2.m_data[piVector2.m_data[n8]]);
                            piVector.m_data[n11] = pgPolygonSet.addVertex(PdVector.blendNew((double)d2, (PdVector)pdVectorArray[piVector2.m_data[n10]], (double)(1.0 - d2), (PdVector)pdVectorArray[piVector2.m_data[n8]]));
                            ++n11;
                        }
                        if (n11 != 2) continue block7;
                        pgPolygonSet.addPolygon(piVector);
                    }
                }
            }
        }
        PuCleanMesh.identifyVertices((PgPointSet)pgPolygonSet, (double)1.0E-10);
        PwCleanMesh.joinPolygons(pgPolygonSet);
        return pgPolygonSet;
    }

    protected void showFunctionAsVertexLabels(boolean bl) {
        int n = this.m_geomBase.getNumVertices();
        PdVector[] pdVectorArray = this.m_geomBase.getVertices();
        if (bl) {
            for (int i = 0; i < n; ++i) {
                pdVectorArray[i].setName(Double.toString(this.m_scalar.getEntry(i)));
            }
        } else {
            for (int i = 0; i < n; ++i) {
                pdVectorArray[i].setName(Integer.toString(i));
            }
        }
        this.m_geomBase.showVertices(bl);
        this.m_geomBase.showVertexLabels(true);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

