/*
 * Decompiled with CFR 0.152.
 */
package jvx.vector;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import jv.geom.PgElementSet;
import jv.geom.PgPolygonSet;
import jv.geom.PgVectorField;
import jv.number.PuDouble;
import jv.number.PuInteger;
import jv.object.PsActionSupport;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.object.PsUpdateIf;
import jv.project.PgGeometry;
import jv.project.PgGeometryIf;
import jv.project.PvDisplayIf;
import jv.vecmath.PdBary;
import jv.vecmath.PiVector;
import jvx.geom.PgPolygonOnElementSet;
import jvx.numeric.PnElementRK;
import jvx.numeric.PnGeodesicRK;
import jvx.numeric.PnVertexRK;
import jvx.numeric.PnVertexRKIgnoreDirection;
import jvx.project.PjWorkshop;

public class PwIntegralLineSet
extends PjWorkshop {
    protected PuInteger m_vfIndex;
    protected PuDouble m_stepsize;
    protected PuInteger m_numSteps;
    protected PuInteger m_whichElements;
    protected PgPolygonSet m_lines = null;
    protected PgElementSet m_elemset = null;
    private PsActionSupport m_actionSupport = new PsActionSupport();
    protected boolean m_bFast = false;
    protected boolean m_bBackward = false;
    protected boolean m_bLimitNumLinesPerElement = false;
    protected PuInteger m_maxNumLinesPerElement;
    protected boolean m_bIgnoreDir = false;
    static /* synthetic */ Class class$jvx$vector$PwIntegralLineSet;

    public PwIntegralLineSet() {
        super(PsConfig.getMessage((int)51067));
        this.setModal(false);
        this.m_vfIndex = new PuInteger(PsConfig.getMessage((int)54096), null);
        this.m_stepsize = new PuDouble(PsConfig.getMessage((int)54097), null);
        this.m_numSteps = new PuInteger(PsConfig.getMessage((int)54098), null);
        this.m_whichElements = new PuInteger(PsConfig.getMessage((int)54099), null);
        this.m_maxNumLinesPerElement = new PuInteger(PsConfig.getMessage((int)54300), null);
        if (((Object)((Object)this)).getClass() == (class$jvx$vector$PwIntegralLineSet == null ? (class$jvx$vector$PwIntegralLineSet = PwIntegralLineSet.class$("jvx.vector.PwIntegralLineSet")) : class$jvx$vector$PwIntegralLineSet)) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.m_vfIndex.setDefBounds(0, 0, 1, 2);
        this.m_vfIndex.setDefValue(0);
        this.m_vfIndex.init();
        if (this.m_elemset != null) {
            this.update(this.m_elemset);
        }
        this.m_stepsize.setDefBounds(0.001, 1.0, 0.01, 0.1);
        this.m_stepsize.setDefValue(0.4);
        this.m_stepsize.init();
        this.m_numSteps.setDefBounds(1, 200, 1, 25);
        this.m_numSteps.setDefValue(20);
        this.m_numSteps.init();
        this.m_whichElements.setDefBounds(1, 1000, 1, 10);
        this.m_whichElements.setDefValue(1);
        this.m_whichElements.init();
        this.m_maxNumLinesPerElement.setDefBounds(1, 1000, 1, 5);
        this.m_maxNumLinesPerElement.setDefValue(3);
        this.m_maxNumLinesPerElement.init();
        this.removeIntegralLines();
    }

    public void setGeometry(PgGeometry pgGeometry) {
        if (!(pgGeometry instanceof PgElementSet)) {
            PsDebug.warning((String)"geometry is no PgElementSet");
            return;
        }
        PgElementSet pgElementSet = (PgElementSet)pgGeometry;
        if (pgElementSet.getDimOfElements() != 3) {
            PsDebug.warning((String)"Geometry is not triangulated - aborted.");
            return;
        }
        if (this.m_elemset != null) {
            this.removeGeometry();
        }
        super.setGeometry((PgGeometry)pgElementSet);
        this.m_elemset = pgElementSet;
        if (this.m_elemset != null) {
            this.m_elemset.addUpdateListener((PsUpdateIf)this);
            this.update(this.m_elemset);
        }
    }

    public void removeGeometry() {
        this.m_elemset.removeUpdateListener((PsUpdateIf)this);
        this.m_elemset = null;
        super.removeGeometry();
    }

    public void setDisplay(PvDisplayIf pvDisplayIf) {
        if (this.m_display != null && this.m_lines != null) {
            this.m_display.removeGeometry((PgGeometryIf)this.m_lines);
        }
        super.setDisplay(pvDisplayIf);
        if (this.m_display != null && this.m_lines != null) {
            this.m_display.addGeometry((PgGeometryIf)this.m_lines);
        }
    }

    public boolean update(Object object) {
        if (object == null) {
            return true;
        }
        if (object == this.m_elemset) {
            int n = this.m_elemset.getNumVectorFields();
            if (n > 0) {
                this.m_vfIndex.setBounds(1, n, 1, 2);
                this.m_vfIndex.update((Object)this.m_vfIndex);
            } else {
                this.m_vfIndex.setBounds(0, 0, 1, 2);
                this.m_vfIndex.setValue(0);
                this.m_vfIndex.update((Object)this.m_vfIndex);
            }
            return super.update(null);
        }
        return super.update(object);
    }

    public void setStepSize(double d) {
        this.m_stepsize.setValue(d);
    }

    public void setFast(boolean bl) {
        this.m_bFast = bl;
        this.update((Object)this);
    }

    public boolean getFast() {
        return this.m_bFast;
    }

    public void setBackwardIntegration(boolean bl) {
        this.m_bBackward = bl;
        this.update((Object)this);
    }

    public boolean getBackwardIntegration() {
        return this.m_bBackward;
    }

    public void setLimitNumLinesPerElement(boolean bl) {
        this.m_bLimitNumLinesPerElement = bl;
        this.update((Object)this);
    }

    public boolean getLimitNumLinesPerElement() {
        return this.m_bLimitNumLinesPerElement;
    }

    public void setMaxNumLinesPerElement(int n) {
        if (n < 0) {
            n = 0;
        }
        if (this.m_maxNumLinesPerElement.getMax() < n) {
            this.m_maxNumLinesPerElement.setBounds(this.m_maxNumLinesPerElement.getMin(), n);
        }
        if (this.m_maxNumLinesPerElement.getMin() > n) {
            this.m_maxNumLinesPerElement.setBounds(n, this.m_maxNumLinesPerElement.getMax());
        }
        this.m_maxNumLinesPerElement.setValue(n);
        this.m_maxNumLinesPerElement.update(null);
    }

    public int getMaxNumLinesPerElement() {
        return this.m_maxNumLinesPerElement.getValue();
    }

    public void setIgnoreDirection(boolean bl) {
        this.m_bIgnoreDir = bl;
        this.update((Object)this);
    }

    public boolean getIgnoreDirection() {
        return this.m_bIgnoreDir;
    }

    public double getStepSize() {
        return this.m_stepsize.getValue();
    }

    public void setNumSteps(int n) {
        this.m_numSteps.setValue(n);
    }

    public int getNumSteps() {
        return this.m_numSteps.getValue();
    }

    public void setVectorFieldIndex(int n) {
        this.m_vfIndex.setValue(n + 1);
    }

    public int getVectorFieldIndex() {
        return this.m_vfIndex.getValue() - 1;
    }

    public void makeIntegralLines() {
        if (this.m_vfIndex.getValue() <= 0 || this.m_vfIndex.getValue() > this.m_elemset.getNumVectorFields()) {
            PsDebug.warning((String)"no valid vector field selected");
            return;
        }
        if (this.m_elemset == null) {
            PsDebug.warning((String)"no geometry, use setGeometry(...).");
            return;
        }
        boolean bl = this.m_lines == null;
        PgVectorField pgVectorField = this.m_elemset.getVectorField(this.m_vfIndex.getValue() - 1);
        double d = this.m_stepsize.getValue();
        int n = this.m_numSteps.getValue();
        int n2 = this.m_whichElements.getValue();
        int[] nArray = null;
        int n3 = -1;
        if (this.m_bLimitNumLinesPerElement) {
            nArray = new int[this.m_elemset.getNumElements()];
            n3 = this.m_maxNumLinesPerElement.getValue();
        }
        this.m_lines = PwIntegralLineSet.makeIntegralLines(this.m_elemset, pgVectorField, this.m_lines, d, n, n2, this.m_bFast, this.m_bIgnoreDir, this.m_bBackward, n3, nArray);
        if (bl && this.m_lines != null && this.m_display != null) {
            this.m_display.addGeometry((PgGeometryIf)this.m_lines);
        }
        if (this.m_lines != null) {
            this.m_lines.update((Object)this.m_lines);
        }
    }

    public PgPolygonSet getIntegralLines() {
        return this.m_lines;
    }

    public void removeIntegralLines() {
        if (this.m_lines != null) {
            if (this.m_display != null) {
                this.m_display.removeGeometry((PgGeometryIf)this.m_lines);
            }
            this.m_display.update(null);
            this.m_lines = null;
        }
    }

    public void addActionListener(ActionListener actionListener) {
        this.m_actionSupport.addActionListener(actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.m_actionSupport.removeActionListener(actionListener);
    }

    protected void fireAction(ActionEvent actionEvent) {
        this.m_actionSupport.fireAction(actionEvent);
    }

    public void cancel() {
        this.removeIntegralLines();
        super.cancel();
    }

    public static PgPolygonSet makeIntegralLines(PgElementSet pgElementSet, PgVectorField pgVectorField, PgPolygonSet pgPolygonSet, double d, int n) {
        return PwIntegralLineSet.makeIntegralLines(pgElementSet, pgVectorField, pgPolygonSet, d, n, 1, false, false, false, -1, null);
    }

    public static PgPolygonSet makeIntegralLines(PgElementSet pgElementSet, PgVectorField pgVectorField, PgPolygonSet pgPolygonSet, double d, int n, int n2) {
        return PwIntegralLineSet.makeIntegralLines(pgElementSet, pgVectorField, pgPolygonSet, d, n, n2, false, false, false, -1, null);
    }

    public static PgPolygonSet makeIntegralLines(PgElementSet pgElementSet, PgVectorField pgVectorField, PgPolygonSet pgPolygonSet, double d, int n, int n2, boolean bl, boolean bl2, boolean bl3, int n3, int[] nArray) {
        PnGeodesicRK pnGeodesicRK;
        if (pgElementSet == null) {
            PsDebug.warning((String)"missing geometry");
            return null;
        }
        if (pgElementSet.getDimOfElements() != 3) {
            PsDebug.warning((String)"geometry is not triangulated");
        }
        if (pgVectorField == null) {
            PsDebug.warning((String)"missing vector field");
            return null;
        }
        int n4 = pgElementSet.getDimOfVertices();
        if (pgPolygonSet == null) {
            pgPolygonSet = new PgPolygonSet(n4);
            pgPolygonSet.setName(PsConfig.getMessage((int)45017) + " " + pgVectorField.getName() + " [" + PsObject.getNumObjects() + "]");
            pgPolygonSet.setGlobalPolygonSize(1.0);
        }
        int n5 = pgElementSet.getNumElements();
        pgPolygonSet.setNumVertices(0);
        pgPolygonSet.setNumPolygons(0);
        pgPolygonSet.showVertices(false);
        PdBary pdBary = new PdBary(0.3333333333333333, 0.3333333333333333, 0.3333333333333333);
        if (pgVectorField.getBasedOn() == 0) {
            if (bl2) {
                pnGeodesicRK = new PnVertexRKIgnoreDirection(pgElementSet);
                ((PnVertexRKIgnoreDirection)pnGeodesicRK).setVectorField(pgVectorField);
            } else {
                pnGeodesicRK = new PnVertexRK(pgElementSet);
                ((PnVertexRK)pnGeodesicRK).setVectorField(pgVectorField);
            }
        } else {
            pnGeodesicRK = new PnElementRK(pgElementSet);
            ((PnElementRK)pnGeodesicRK).setVectorField(pgVectorField);
        }
        pnGeodesicRK.setFirstOrder(bl);
        if (n3 > 0 && nArray == null) {
            nArray = new int[n5];
        }
        PgPolygonOnElementSet pgPolygonOnElementSet = new PgPolygonOnElementSet(pgElementSet);
        PgPolygonOnElementSet pgPolygonOnElementSet2 = null;
        PdBary[] pdBaryArray = null;
        PiVector piVector = null;
        if (bl3) {
            pgPolygonOnElementSet2 = new PgPolygonOnElementSet(pgElementSet);
        }
        int n6 = 0;
        int n7 = 0;
        for (int i = 0; i < n5; i += n2) {
            int n8;
            int n9;
            pnGeodesicRK.solve(pgPolygonOnElementSet, i, pdBary, d, n);
            PdBary[] pdBaryArray2 = pgPolygonOnElementSet.getVertexBary();
            int n10 = n9 = pgPolygonOnElementSet.getNumVertices();
            PiVector piVector2 = new PiVector(0);
            if (bl3) {
                pnGeodesicRK.setInvertDirection(true);
                pnGeodesicRK.solve(pgPolygonOnElementSet2, i, pdBary, d, n);
                pnGeodesicRK.setInvertDirection(false);
                pdBaryArray = pgPolygonOnElementSet2.getVertexBary();
                n6 = pgPolygonOnElementSet2.getNumVertices();
                if (n6 > n9) {
                    n10 = n6;
                }
                piVector = new PiVector(0);
            }
            for (int j = 0; j < n10; ++j) {
                if (j < n9) {
                    pgPolygonSet.addVertex(pgPolygonOnElementSet.getVertex(j));
                    n8 = pdBaryArray2[j].m_elementInd;
                    piVector2.addEntry(n7);
                    ++n7;
                    if (n3 > 0 && (j == 0 || pdBaryArray2[j - 1].m_elementInd != n8)) {
                        if (nArray[n8] >= n3) {
                            --n7;
                            pgPolygonSet.setNumVertices(pgPolygonSet.getNumVertices() - 1);
                            piVector2.setSize(piVector2.getSize() - 1);
                            n9 = -1;
                        } else {
                            int n11 = n8;
                            nArray[n11] = nArray[n11] + 1;
                        }
                    }
                }
                if (!bl3 || j >= n6) continue;
                pgPolygonSet.addVertex(pgPolygonOnElementSet2.getVertex(j));
                n8 = pdBaryArray[j].m_elementInd;
                piVector.addEntry(n7);
                ++n7;
                if (n3 <= 0 || j != 0 && pdBaryArray[j - 1].m_elementInd == n8 || j == 0 && n9 != -1) continue;
                if (nArray[n8] >= n3) {
                    n6 = -1;
                    continue;
                }
                int n12 = n8;
                nArray[n12] = nArray[n12] + 1;
            }
            if (bl3 && piVector.getSize() > 1) {
                piVector.invert();
                n8 = piVector.getSize() - 1;
                int n13 = piVector2.getSize();
                piVector.setSize(n8 + n13);
                for (int j = 0; j < n13; ++j) {
                    piVector.m_data[n8 + j] = piVector2.m_data[j];
                }
                piVector2.setSize(n8 + n13);
                piVector2.copy(piVector);
            }
            if (piVector2.getSize() <= 1) continue;
            pgPolygonSet.addPolygon(piVector2);
        }
        pgPolygonSet.removeUnusedVertices();
        return pgPolygonSet;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

