/*
 * Decompiled with CFR 0.152.
 */
package jvx.vector;

import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import jv.geom.PgElementSet;
import jv.geom.PgPointSet;
import jv.geom.PgPolygonSet;
import jv.geom.PgVectorField;
import jv.number.PuDouble;
import jv.number.PuInteger;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.object.PsUpdateIf;
import jv.project.PgGeometry;
import jv.project.PgGeometryIf;
import jv.project.PvDisplayIf;
import jv.project.PvViewerIf;
import jv.vecmath.PdBary;
import jv.vecmath.PdBaryDir;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jvx.geom.PgVertexStar;
import jvx.geom.PwBary;
import jvx.numeric.PnEnergyMinimizer;
import jvx.numeric.PnHodgeU;
import jvx.numeric.PnHodgeW;
import jvx.project.PjWorkshop;
import jvx.surface.PgSurfaceGraph;

public class PwHodge
extends PjWorkshop {
    private static final int M_NUM_LOOPS = 1;
    protected int m_dimOfDomain = 2;
    protected PgElementSet m_domain;
    protected PgElementSet[] m_decDomain;
    protected PgVectorField m_vf;
    protected PnEnergyMinimizer m_diriU;
    protected PgElementSet m_u;
    protected PgSurfaceGraph m_uGraph;
    protected PgVectorField m_gradU = new PgVectorField(this.m_dimOfDomain);
    protected PnEnergyMinimizer m_diriV;
    protected PgElementSet m_v;
    protected PgSurfaceGraph m_vGraph;
    protected PgVectorField m_coGradV;
    protected PgVectorField m_harmW;
    protected PuInteger m_selectedVF;
    protected int m_numVF;
    protected boolean m_bZeroBoundsU = false;
    protected boolean m_bZeroBoundsV = false;
    protected PnHodgeU m_hodgeUEnergy;
    protected PnHodgeW m_hodgeVEnergy;
    protected boolean m_bAutoDecompose = false;
    protected boolean m_bAutoFit = false;
    private boolean m_bUComputed = false;
    private boolean m_bVComputed = false;
    private boolean m_bLock = false;
    private boolean m_bMinimizing = false;
    private boolean m_bFirstTime = true;
    protected PvDisplayIf[] m_display;
    protected Frame[] m_frames;
    protected PgPolygonSet m_rotSing;
    protected PgPolygonSet m_divSing;
    protected PgPolygonSet m_rotIcon;
    protected PgPolygonSet m_divIcon;
    protected PgVectorField m_rotDir1;
    protected PgVectorField m_divDir1;
    protected PgVectorField m_rotDir2;
    protected PgVectorField m_divDir2;
    protected PuDouble m_offset;
    protected PuDouble m_scale;
    protected PuDouble m_scaleEmblem;
    private int m_detectionFlag = 0;
    public static final int DETECT_SINKS_SOURCES = 1;
    public static final int DETECT_VORTICES = 2;
    public static final int DETECT_SADDLES = 4;
    static /* synthetic */ Class class$jvx$vector$PwHodge;

    public PwHodge() {
        super(PsConfig.getMessage((int)51021));
        this.m_gradU.setBasedOn(1);
        this.m_gradU.setName(PsConfig.getMessage((int)45011) + " u");
        this.m_coGradV = new PgVectorField(this.m_dimOfDomain);
        this.m_coGradV.setBasedOn(1);
        this.m_coGradV.setName(PsConfig.getMessage((int)45013) + " v");
        this.m_harmW = new PgVectorField(this.m_dimOfDomain);
        this.m_harmW.setBasedOn(1);
        this.m_harmW.setName(PsConfig.getMessage((int)45014) + " w");
        this.m_u = new PgElementSet(1);
        this.m_u.setName("u");
        this.m_v = new PgElementSet(1);
        this.m_v.setName("v");
        this.m_decDomain = new PgElementSet[3];
        for (int i = 0; i < 3; ++i) {
            this.m_decDomain[i] = new PgElementSet(this.m_dimOfDomain);
            this.m_decDomain[i].setName(PsConfig.getMessage((int)45015) + " " + i);
            this.m_decDomain[i].showElements(false);
            this.m_decDomain[i].showEdges(false);
            this.m_decDomain[i].showVectorArrows(true);
            this.m_decDomain[i].setGlobalVectorColor(Color.black);
            this.m_decDomain[i].setVisible(false);
        }
        this.m_decDomain[0].addVectorField(this.m_gradU);
        this.m_gradU.setGeometry((PgPointSet)this.m_decDomain[0]);
        this.m_decDomain[1].addVectorField(this.m_coGradV);
        this.m_coGradV.setGeometry((PgPointSet)this.m_decDomain[1]);
        this.m_decDomain[2].addVectorField(this.m_harmW);
        this.m_harmW.setGeometry((PgPointSet)this.m_decDomain[2]);
        this.m_uGraph = new PgSurfaceGraph(this.m_dimOfDomain + 1);
        this.m_uGraph.setName(PsConfig.getMessage((int)45012) + " u");
        this.m_uGraph.setSurfaces(this.m_decDomain[0], this.m_u);
        if (this.m_dimOfDomain > 2) {
            this.m_uGraph.showAsNormalVariation(true);
        } else {
            this.m_uGraph.setOffset(4.0);
        }
        this.m_uGraph.showTransparency(true);
        this.m_uGraph.setVisible(false);
        this.m_vGraph = new PgSurfaceGraph(this.m_dimOfDomain + 1);
        this.m_vGraph.setName(PsConfig.getMessage((int)45012) + " v");
        this.m_vGraph.setSurfaces(this.m_decDomain[1], this.m_v);
        if (this.m_dimOfDomain > 2) {
            this.m_vGraph.showAsNormalVariation(true);
        } else {
            this.m_vGraph.setOffset(4.0);
        }
        this.m_vGraph.showTransparency(true);
        this.m_vGraph.setVisible(false);
        this.m_hodgeUEnergy = new PnHodgeU();
        this.m_hodgeUEnergy.setZeroGradientAtBounds(this.m_bZeroBoundsU);
        this.m_hodgeVEnergy = new PnHodgeW();
        this.m_hodgeVEnergy.setZeroGradientAtBounds(this.m_bZeroBoundsV);
        this.m_diriU = new PnEnergyMinimizer();
        this.m_diriU.setName("u " + PsConfig.getMessage((int)45010));
        this.m_diriU.setParent((PsUpdateIf)this);
        this.m_diriU.setEnergy(this.m_hodgeUEnergy);
        this.m_diriU.enableUpdateDomain(false);
        this.m_diriU.setNumLoops(1);
        this.m_diriV = new PnEnergyMinimizer();
        this.m_diriV.setName("v " + PsConfig.getMessage((int)45010));
        this.m_diriV.setParent((PsUpdateIf)this);
        this.m_diriV.setEnergy(this.m_hodgeVEnergy);
        this.m_diriV.enableUpdateDomain(false);
        this.m_diriV.setNumLoops(1);
        this.m_rotSing = new PgPolygonSet(this.m_dimOfDomain + 1);
        this.m_rotSing.setName(PsConfig.getMessage((int)45060));
        this.m_rotSing.setVisible(false);
        this.m_divSing = new PgPolygonSet(this.m_dimOfDomain + 1);
        this.m_divSing.setName(PsConfig.getMessage((int)45061));
        this.m_divSing.setVisible(false);
        this.m_rotDir1 = new PgVectorField(this.m_dimOfDomain + 1);
        this.m_rotDir1.setName(PsConfig.getMessage((int)45062));
        this.m_rotDir1.setBasedOn(0);
        this.m_divDir1 = new PgVectorField(this.m_dimOfDomain + 1);
        this.m_divDir1.setName(PsConfig.getMessage((int)45063));
        this.m_divDir1.setBasedOn(0);
        this.m_rotDir2 = new PgVectorField(this.m_dimOfDomain + 1);
        this.m_rotDir2.setName(PsConfig.getMessage((int)45064));
        this.m_rotDir2.setBasedOn(0);
        this.m_divDir2 = new PgVectorField(this.m_dimOfDomain + 1);
        this.m_divDir2.setName(PsConfig.getMessage((int)45065));
        this.m_divDir2.setBasedOn(0);
        this.m_rotIcon = new PgPolygonSet(this.m_dimOfDomain);
        this.m_rotIcon.setName(PsConfig.getMessage((int)45066));
        this.m_rotIcon.setVisible(false);
        this.m_divIcon = new PgPolygonSet(this.m_dimOfDomain);
        this.m_divIcon.setName(PsConfig.getMessage((int)45067));
        this.m_divIcon.setVisible(false);
        this.m_selectedVF = new PuInteger(PsConfig.getMessage((int)54078), (PsUpdateIf)this);
        this.m_offset = new PuDouble(PsConfig.getMessage((int)54419), (PsUpdateIf)this);
        this.m_scale = new PuDouble(PsConfig.getMessage((int)54420), (PsUpdateIf)this);
        this.m_scaleEmblem = new PuDouble(PsConfig.getMessage((int)54421), (PsUpdateIf)this);
        if (((Object)((Object)this)).getClass() == (class$jvx$vector$PwHodge == null ? (class$jvx$vector$PwHodge = PwHodge.class$("jvx.vector.PwHodge")) : class$jvx$vector$PwHodge)) {
            this.init();
        }
    }

    public void init() {
        this.m_selectedVF.setDefBounds(-1, Math.max(0, this.m_numVF - 1), 1, 2);
        this.m_selectedVF.setDefValue(Math.max(0, this.m_numVF - 1));
        this.m_selectedVF.init();
        this.m_selectedVF.setValue(-1);
        this.m_selectedVF.setEnabled(this.m_numVF > 0);
        this.m_offset.setDefBounds(-50.0, 50.0, 1.0, 5.0);
        this.m_offset.setDefValue(4.0);
        this.m_offset.init();
        this.m_scale.setDefBounds(0.0, 10.0, 0.001, 0.5);
        this.m_scale.setDefValue(1.0);
        this.m_scale.init();
        this.m_scaleEmblem.setDefBounds(0.0, 10.0, 0.1, 0.5);
        this.m_scaleEmblem.setDefValue(1.0);
        this.m_scaleEmblem.init();
        super.init();
    }

    public void close() {
        this.removeGeometry();
        if (this.m_display != null) {
            PvViewerIf pvViewerIf = this.getViewer();
            for (int i = 0; i < 3; ++i) {
                if (this.m_display[i] == null) continue;
                if (pvViewerIf != null) {
                    pvViewerIf.removeDisplay(this.m_display[i]);
                }
                this.m_display[i] = null;
            }
        }
        super.close();
    }

    public void reset() {
    }

    public void removeGeometry() {
        this.m_domain = null;
        super.removeGeometry();
    }

    public void setGeometry(PgGeometry pgGeometry) {
        int n;
        if (pgGeometry == null || !(pgGeometry instanceof PgElementSet)) {
            PsDebug.warning((String)"geometry is no instance of PgElementSet");
            return;
        }
        PgElementSet pgElementSet = (PgElementSet)pgGeometry;
        int n2 = pgElementSet.getNumVectorFields();
        if (n2 <= 0) {
            PsDebug.warning((String)"argument geom has no vector field");
            this.m_selectedVF.setBounds(-1, 0, 1, 2);
            this.m_selectedVF.setEnabled(false);
            return;
        }
        int n3 = -1;
        PgVectorField pgVectorField = pgElementSet.getSelectedVectorField();
        if (pgVectorField != null && pgVectorField.getBasedOn() == 1) {
            n3 = pgElementSet.getIndexOfVectorField(pgVectorField);
        }
        if (n3 == -1) {
            for (n = 0; n < n2; ++n) {
                if (pgElementSet.getVectorField(n).getBasedOn() != 1) continue;
                n3 = n;
                break;
            }
        }
        if (n3 == -1) {
            PsDebug.warning((String)"missing element based vector field in geometry");
            this.m_selectedVF.setBounds(-1, 0, 1, 2);
            this.m_selectedVF.setEnabled(false);
            return;
        }
        this.m_numVF = n2;
        super.setGeometry(pgGeometry);
        if (pgElementSet.getDimOfElements() != 3) {
            PsDebug.warning((String)"Geometry not triangulated. Triangulating.");
            PgElementSet.triangulate((PgElementSet)pgElementSet);
        }
        this.m_domain = pgElementSet;
        this.m_dimOfDomain = this.m_domain.getDimOfVertices();
        if (this.m_dimOfDomain > 2) {
            this.m_uGraph.showAsNormalVariation(true);
            this.m_vGraph.showAsNormalVariation(true);
        } else {
            this.m_uGraph.setOffset(this.m_offset.getValue());
            this.m_vGraph.setOffset(this.m_offset.getValue());
        }
        this.m_u.setNumVertices(this.m_domain.getNumVertices());
        this.m_u.copyElementSet(this.m_domain);
        this.m_diriU.setSurface(this.m_domain, this.m_u);
        this.m_v.setNumVertices(this.m_domain.getNumVertices());
        this.m_v.copyElementSet(this.m_domain);
        this.m_diriV.setSurface(this.m_domain, this.m_v);
        for (n = 0; n < 3; ++n) {
            this.m_decDomain[n].copy((PsObject)this.m_domain);
        }
        this.m_gradU.setGeometry((PgPointSet)this.m_decDomain[0]);
        this.m_decDomain[0].addVectorField(this.m_gradU);
        this.m_coGradV.setGeometry((PgPointSet)this.m_decDomain[1]);
        this.m_decDomain[1].addVectorField(this.m_coGradV);
        this.m_harmW.setGeometry((PgPointSet)this.m_decDomain[2]);
        this.m_decDomain[2].addVectorField(this.m_harmW);
        this.m_bUComputed = false;
        this.m_bVComputed = false;
        if (n3 != this.m_selectedVF.getValue()) {
            this.selectVectorField(n3);
        }
        this.m_selectedVF.setBounds(0, Math.max(0, this.m_numVF - 1), 1, 2);
        this.m_selectedVF.setEnabled(true);
        if (this.m_bAutoFit && this.m_display != null) {
            this.m_display[0].fit();
            this.m_display[1].fit();
            this.m_display[2].fit();
        }
        if (this.isEnabledAutoDecompose() && !this.m_bMinimizing) {
            this.decompose();
        }
    }

    public synchronized boolean update(Object object) {
        if (this.isUpdateSender()) {
            return true;
        }
        if (object == null) {
            return super.update(null);
        }
        if (object == this) {
            this.setUpdateSender(true);
            for (int i = 0; i < 3; ++i) {
                if (this.m_decDomain[i] == null) continue;
                this.m_decDomain[i].update(null);
            }
            if (this.m_divSing != null) {
                this.m_divSing.update(null);
            }
            if (this.m_divIcon != null) {
                this.m_divIcon.update(null);
            }
            if (this.m_rotSing != null) {
                this.m_rotSing.update(null);
            }
            if (this.m_rotIcon != null) {
                this.m_rotIcon.update(null);
            }
            this.setUpdateSender(false);
        } else {
            if (object == this.m_diriU) {
                if (this.m_diriU.isStopped()) {
                    this.computeGradient();
                    this.computeFeatures(true);
                    this.m_bUComputed = true;
                    if (this.m_bVComputed) {
                        this.completeDecomposition();
                        this.update((Object)this);
                    }
                }
                return true;
            }
            if (object == this.m_diriV) {
                if (this.m_diriV.isStopped()) {
                    this.computeJGradient();
                    this.computeFeatures(false);
                    this.m_bVComputed = true;
                    if (this.m_bUComputed) {
                        this.completeDecomposition();
                        this.update((Object)this);
                    }
                }
                return true;
            }
            if (object == this.m_selectedVF) {
                this.selectVectorField(this.m_selectedVF.getValue());
                this.setUpdateSender(true);
                this.update((Object)this);
                this.setUpdateSender(false);
                return super.update(null);
            }
            if (object == this.m_offset) {
                if (this.m_uGraph != null) {
                    this.m_uGraph.setOffset(this.m_offset.getValue());
                    this.m_uGraph.update((Object)this.m_uGraph);
                }
                if (this.m_vGraph != null) {
                    this.m_vGraph.setOffset(this.m_offset.getValue());
                    this.m_vGraph.update((Object)this.m_vGraph);
                }
                return super.update(null);
            }
            if (object == this.m_scale) {
                if (this.m_uGraph != null) {
                    this.m_uGraph.setScalingFactor(this.m_scale.getValue());
                    this.m_uGraph.update((Object)this.m_uGraph);
                }
                if (this.m_vGraph != null) {
                    this.m_vGraph.setScalingFactor(this.m_scale.getValue());
                    this.m_vGraph.update((Object)this.m_vGraph);
                }
                return super.update(null);
            }
            if (object == this.m_uGraph) {
                if (this.alreadyGotSomething()) {
                    this.computeFeatures(true);
                    this.setUpdateSender(true);
                    this.m_divSing.update(null);
                    this.m_divIcon.update(null);
                    this.m_decDomain[0].update(null);
                    this.setUpdateSender(false);
                }
                if (this.m_bAutoFit) {
                    this.m_display[0].fit();
                }
                return super.update(null);
            }
            if (object == this.m_vGraph) {
                if (this.alreadyGotSomething()) {
                    this.computeFeatures(false);
                    this.setUpdateSender(true);
                    this.m_rotSing.update(null);
                    this.m_rotIcon.update(null);
                    this.m_decDomain[1].update(null);
                    this.setUpdateSender(false);
                }
                if (this.m_bAutoFit) {
                    this.m_display[1].fit();
                }
                return super.update(null);
            }
            if (object == this.m_scaleEmblem) {
                if (this.alreadyGotSomething()) {
                    this.computeFeatures(true);
                    this.computeFeatures(false);
                    this.setUpdateSender(true);
                    this.m_divSing.update(null);
                    this.m_divIcon.update(null);
                    this.m_rotSing.update(null);
                    this.m_rotIcon.update(null);
                    this.m_decDomain[0].update(null);
                    this.m_decDomain[1].update(null);
                    this.setUpdateSender(false);
                }
                return super.update(null);
            }
        }
        return super.update(object);
    }

    public int getVectorFieldIndex() {
        if (this.m_vf == null || this.m_domain == null) {
            return -1;
        }
        return this.m_domain.getIndexOfVectorField(this.m_vf);
    }

    public void selectVectorField(int n) {
        if (this.m_domain == null) {
            PsDebug.warning((String)"missing surface.");
            return;
        }
        int n2 = this.m_domain.getNumVectorFields();
        if (n2 == 0) {
            if (n != 0) {
                PsDebug.warning((String)("missing vector field, index=" + n + "."));
            }
            return;
        }
        if (n < 0 || n2 <= n) {
            PsDebug.warning((String)("vector field index out of range, index=" + n + "."));
            return;
        }
        if (this.m_domain.getVectorField(n).getBasedOn() != 1) {
            PsDebug.warning((String)"selected vector field is not element based.");
            return;
        }
        this.stop();
        this.m_bLock = true;
        this.m_bFirstTime = true;
        this.m_selectedVF.setValue(n);
        this.m_vf = this.m_domain.getVectorField(n);
        this.m_domain.selectVectorField(this.m_vf);
        this.m_hodgeUEnergy.setVectorField(this.m_vf);
        this.m_hodgeVEnergy.setVectorField(this.m_vf);
        this.m_bLock = false;
    }

    public void setZeroBounds(boolean bl) {
        int n;
        this.m_bZeroBoundsU = bl;
        this.m_bZeroBoundsV = bl;
        this.m_hodgeUEnergy.setZeroGradientAtBounds(bl);
        this.m_hodgeVEnergy.setZeroGradientAtBounds(bl);
        int n2 = this.m_u.getNumVertices();
        for (n = 0; n < n2; ++n) {
            this.m_u.setVertex(n, 0.0);
        }
        this.m_diriU.setSurface(this.m_domain, this.m_u);
        this.m_diriU.setEnergy(this.m_hodgeUEnergy);
        n2 = this.m_v.getNumVertices();
        for (n = 0; n < n2; ++n) {
            this.m_v.setVertex(n, 0.0);
        }
        this.m_diriV.setSurface(this.m_domain, this.m_v);
        this.m_diriV.setEnergy(this.m_hodgeVEnergy);
    }

    public void setZeroBoundsU(boolean bl) {
        this.m_bZeroBoundsU = bl;
        this.m_hodgeUEnergy.setZeroGradientAtBounds(bl);
        int n = this.m_u.getNumVertices();
        for (int i = 0; i < n; ++i) {
            this.m_u.setVertex(i, 0.0);
        }
        this.m_diriU.setSurface(this.m_domain, this.m_u);
        this.m_diriU.setEnergy(this.m_hodgeUEnergy);
    }

    public boolean getZeroBoundsU() {
        return this.m_bZeroBoundsU;
    }

    public void setZeroBoundsV(boolean bl) {
        this.m_bZeroBoundsV = bl;
        this.m_hodgeVEnergy.setZeroGradientAtBounds(bl);
        if (bl) {
            int n = this.m_v.getNumVertices();
            for (int i = 0; i < n; ++i) {
                this.m_v.setVertex(i, 0.0);
            }
        }
        this.m_diriV.setSurface(this.m_domain, this.m_v);
        this.m_diriV.setEnergy(this.m_hodgeVEnergy);
    }

    public boolean getZeroBoundsV() {
        return this.m_bZeroBoundsV;
    }

    public boolean isEnabledAutoDecompose() {
        return this.m_bAutoDecompose;
    }

    public void setEnabledAutoDecompose(boolean bl) {
        this.m_bAutoDecompose = bl;
    }

    public PgVectorField getRotationFree() {
        return this.m_gradU;
    }

    public PgVectorField getDivergenceFree() {
        return this.m_coGradV;
    }

    public PgVectorField getHarmonic() {
        return this.m_harmW;
    }

    public PgElementSet getPotentialU() {
        return this.m_u;
    }

    public PgElementSet getPotentialW() {
        return this.m_v;
    }

    public PgSurfaceGraph getUGraph() {
        return this.m_uGraph;
    }

    public PgSurfaceGraph getWGraph() {
        return this.m_vGraph;
    }

    public void setVisibleComponent(int n, boolean bl) {
        this.m_decDomain[n].setVisible(bl);
        this.setUpdateSender(true);
        this.m_decDomain[n].update(null);
        this.setUpdateSender(false);
    }

    public boolean getVisibleComponent(int n) {
        return this.m_decDomain[n].isVisible();
    }

    public void setVisibleGraph(int n, boolean bl) {
        if (n == 0) {
            this.m_uGraph.setVisible(bl);
            this.setUpdateSender(true);
            this.m_uGraph.update(null);
            this.setUpdateSender(false);
        } else if (n == 1) {
            this.m_vGraph.setVisible(bl);
            this.setUpdateSender(true);
            this.m_vGraph.update(null);
            this.setUpdateSender(false);
        }
    }

    public boolean getVisibleGraph(int n) {
        if (n == 0) {
            return this.m_uGraph.isVisible();
        }
        if (n == 1) {
            return this.m_vGraph.isVisible();
        }
        return false;
    }

    public void setVisibleFeat(int n, boolean bl) {
        if (n == 0) {
            this.m_divSing.setVisible(bl);
            this.m_divIcon.setVisible(bl);
            this.setUpdateSender(true);
            this.m_divSing.update(null);
            this.m_divIcon.update(null);
            this.setUpdateSender(false);
        } else if (n == 1) {
            this.m_rotSing.setVisible(bl);
            this.m_rotIcon.setVisible(bl);
            this.setUpdateSender(true);
            this.m_rotSing.update(null);
            this.m_rotIcon.update(null);
            this.setUpdateSender(false);
        }
    }

    public boolean getVisibleFeat(int n) {
        if (n == 0) {
            return this.m_divSing.isVisible();
        }
        if (n == 1) {
            return this.m_rotSing.isVisible();
        }
        return false;
    }

    public void setDetectionFlags(int n) {
        this.m_detectionFlag = n;
    }

    public int getDetectionFlags() {
        return this.m_detectionFlag;
    }

    public void setIconScale(double d) {
        this.m_scaleEmblem.setValue(d);
    }

    protected void computeGradient() {
        PdVector[][] pdVectorArray = ((PnHodgeU)this.m_diriU.getEnergy()).getGradFi();
        if (pdVectorArray == null) {
            return;
        }
        int n = this.m_domain.getNumElements();
        PiVector[] piVectorArray = this.m_domain.getElements();
        PdVector[] pdVectorArray2 = this.m_u.getVertices();
        PdVector[] pdVectorArray3 = this.m_gradU.getVectors();
        for (int i = 0; i < n; ++i) {
            pdVectorArray3[i].setConstant(0.0);
            for (int j = 0; j < 3; ++j) {
                int n2 = piVectorArray[i].m_data[j];
                for (int k = 0; k < this.m_dimOfDomain; ++k) {
                    int n3 = k;
                    pdVectorArray3[i].m_data[n3] = pdVectorArray3[i].m_data[n3] + pdVectorArray2[n2].m_data[0] * pdVectorArray[i][j].m_data[k];
                }
            }
        }
    }

    protected void computeJGradient() {
        PdVector[][] pdVectorArray = ((PnHodgeW)this.m_diriV.getEnergy()).getJGradFi();
        if (pdVectorArray == null) {
            return;
        }
        int n = this.m_domain.getNumElements();
        PiVector[] piVectorArray = this.m_domain.getElements();
        PdVector[] pdVectorArray2 = this.m_v.getVertices();
        PdVector[] pdVectorArray3 = this.m_coGradV.getVectors();
        PdVector.setConstant((PdVector[])pdVectorArray3, (double)0.0);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < 3; ++j) {
                int n2 = piVectorArray[i].m_data[j];
                for (int k = 0; k < this.m_dimOfDomain; ++k) {
                    int n3 = k;
                    pdVectorArray3[i].m_data[n3] = pdVectorArray3[i].m_data[n3] + pdVectorArray2[n2].m_data[0] * pdVectorArray[i][j].m_data[k];
                }
            }
        }
    }

    protected void computeHarmonic() {
        int n = this.m_domain.getNumElements();
        PdVector[] pdVectorArray = this.m_harmW.getVectors();
        for (int i = 0; i < n; ++i) {
            pdVectorArray[i].sub(this.m_vf.getVector(i), this.m_gradU.getVector(i));
            pdVectorArray[i].sub(this.m_coGradV.getVector(i));
        }
    }

    protected void computeFeatures(boolean bl) {
        if (bl) {
            this.computeFeatures(this.m_uGraph, this.m_decDomain[0], this.m_divSing, this.m_divIcon, this.m_divDir1, this.m_divDir2, bl, this.m_detectionFlag);
        } else {
            this.computeFeatures(this.m_vGraph, this.m_decDomain[1], this.m_rotSing, this.m_rotIcon, this.m_rotDir1, this.m_rotDir2, bl, this.m_detectionFlag);
        }
    }

    private void computeFeatures(PgElementSet pgElementSet, PgElementSet pgElementSet2, PgPolygonSet pgPolygonSet, PgPolygonSet pgPolygonSet2, PgVectorField pgVectorField, PgVectorField pgVectorField2, boolean bl, int n) {
        int n2;
        boolean bl2;
        boolean bl3 = bl && (1 & n) != 0 || !bl && (2 & n) != 0;
        boolean bl4 = bl2 = (4 & n) != 0;
        if (!bl3 && !bl2) {
            return;
        }
        int n3 = pgElementSet2.getDimOfVertices();
        PdVector[] pdVectorArray = pgElementSet.getVertices();
        PdVector[] pdVectorArray2 = pgElementSet2.getVertices();
        int n4 = pgElementSet2.getNumVertices();
        PdVector pdVector = new PdVector(n4);
        for (int i = 0; i < n4; ++i) {
            pdVector.m_data[i] = pdVectorArray[i].m_data[n3];
        }
        PgVertexStar pgVertexStar = new PgVertexStar();
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        PiVector piVector = new PiVector();
        PdBaryDir pdBaryDir = new PdBaryDir(3);
        PdBaryDir pdBaryDir2 = new PdBaryDir(3);
        PdVector pdVector2 = new PdVector(n3);
        PdVector pdVector3 = new PdVector(n3 + 1);
        PdVector pdVector4 = new PdVector(n3 + 1);
        PdVector pdVector5 = new PdVector(n3 + 1);
        pgPolygonSet2.setNumPolygons(0);
        pgPolygonSet2.setNumVertices(0);
        pgPolygonSet2.showVertices(false);
        pgPolygonSet2.showPolygonColors(true);
        PdVector pdVector6 = new PdVector(n3 + 1);
        PdVector pdVector7 = new PdVector(n3 + 1);
        PdVector pdVector8 = new PdVector(n3 + 1);
        PiVector[] piVectorArray = this.computeSingularities(pgElementSet, pgPolygonSet, pdVector3, bl3, bl2);
        int n5 = piVectorArray[0].getSize();
        pgPolygonSet.removeAllVectorFields();
        pgElementSet.removeAllVectorFields();
        pgVectorField.setGeometry((PgPointSet)pgPolygonSet);
        pgVectorField2.setGeometry((PgPointSet)pgPolygonSet);
        int n6 = pgVectorField.getNumVectors();
        pdVector3.setConstant(0.0);
        for (int i = 0; i < n6; ++i) {
            pgVectorField.setVector(i, pdVector3);
            pgVectorField2.setVector(i, pdVector3);
        }
        PgVectorField pgVectorField3 = new PgVectorField(3);
        pdVector5.setName("laplacian discrete");
        this.computeLaplacianNormalDiscrete(pgElementSet, pgVectorField3, pgVertexStar, pdVector3, pdVector4, pdVector6, pdVector7, pdVector8);
        PdVector pdVector9 = new PdVector(2);
        PdVector pdVector10 = new PdVector(2);
        PdVector pdVector11 = new PdVector(2);
        PdBaryDir[][] pdBaryDirArray = new PdBaryDir[2][n5];
        int[][] nArray = new int[2][n5];
        PdVector[] pdVectorArray3 = pgElementSet.getVertexNormals();
        PdVector[] pdVectorArray4 = PdVector.copyNew((PdVector[])pdVectorArray, (int)n4);
        double d4 = 1.0;
        for (n2 = 0; n2 < n4; ++n2) {
            int n7 = n3;
            pdVectorArray[n2].m_data[n7] = pdVectorArray[n2].m_data[n7] * d4;
        }
        for (n2 = 0; n2 < n5; ++n2) {
            int n8;
            int n9;
            int n10 = piVectorArray[0].m_data[n2];
            pgVertexStar.makeVertexStar(pgElementSet2, piVectorArray[0].m_data[n2], -1);
            PiVector piVector2 = pgVertexStar.getLink();
            int n11 = piVector2.getSize();
            d = 0.0;
            d2 = 0.0;
            d3 = 0.0;
            PdVector pdVector12 = new PdVector(pgVertexStar.getSize());
            double d5 = PwBary.getVertexAngles(pgVertexStar, pgElementSet, pdVector12);
            double d6 = 1.5707963267948966;
            pdVector5.setConstant(0.0);
            int n12 = 1;
            int n13 = n11 - 1;
            for (n9 = 0; n9 < n11; ++n9) {
                this.rotate90(pdVectorArray[n10], pdVectorArray[piVector2.m_data[n9]], pdVectorArray[piVector2.m_data[n12]], pdVector7, pdVector3, pdVector4);
                this.rotate90(pdVectorArray[n10], pdVectorArray[piVector2.m_data[n9]], pdVectorArray[piVector2.m_data[n13]], pdVector8, pdVector3, pdVector4);
                pdVector4.add(pdVector7, pdVector8);
                pdVector4.multScalar(0.5);
                pdVector5.add(pdVector4);
                ++n13;
                if (++n12 == n11) {
                    n12 = 0;
                }
                if (n13 != n11) continue;
                n13 = 0;
            }
            n12 = 1;
            n13 = n11 - 1;
            for (n9 = 0; n9 < n11; ++n9) {
                this.rotate90(pdVectorArray[n10], pdVectorArray[piVector2.m_data[n9]], pdVectorArray[piVector2.m_data[n12]], pdVector7, pdVector3, pdVector4);
                this.rotate90(pdVectorArray[n10], pdVectorArray[piVector2.m_data[n9]], pdVectorArray[piVector2.m_data[n13]], pdVector8, pdVector3, pdVector4);
                pdVector4.add(pdVector7, pdVector8);
                pdVector4.multScalar(0.5);
                double d7 = pdVector4.length();
                pdVector4.normalize();
                pdVector3.copyArray(pdVector5);
                pdVector3.normalize();
                if (n3 == 2 && pdVectorArray3 != null && PdVector.dot((PdVector)pdVector3, (PdVector)pdVectorArray3[n10]) < 0.0) {
                    pdVector3.multScalar(-1.0);
                }
                double d8 = Math.cos(d6);
                double d9 = Math.sin(d6);
                d += d8 * d8 * (d7 *= PdVector.dot((PdVector)pdVector4, (PdVector)pdVector3));
                d2 += d9 * d8 * d7;
                d3 += d9 * d9 * d7;
                d6 += pdVector12.m_data[n9] / d5 * 2.0 * Math.PI;
                ++n13;
                if (++n12 == n11) {
                    n12 = 0;
                }
                if (n13 != n11) continue;
                n13 = 0;
            }
            PwHodge.compute2DEV(d, d2, d3, pdVector2, pdVector9, pdVector10);
            double d10 = pdVector9.length();
            double d11 = pdVector10.length();
            if (!bl && piVectorArray[1].m_data[n2] > 1) {
                pdVector9.normalize();
                pdVector10.normalize();
                pdVector11.copy(pdVector9);
                pdVector9.blend(Math.sqrt(Math.abs(d11 / d10)), pdVector11, 1.0, pdVector10);
                pdVector10.blend(-Math.sqrt(Math.abs(d11 / d10)), pdVector11, 1.0, PdVector.copyNew((PdVector)pdVector10));
            }
            pdVector9.normalize();
            pdVector10.normalize();
            d6 = pdVector9.m_data[0] <= 1.0 ? Math.acos(pdVector9.m_data[0]) : 0.0;
            if (pdVector9.m_data[1] < 0.0) {
                d6 = -d6 + Math.PI * 2;
            }
            int n14 = pgVertexStar.getVertexLocInd().m_data[0];
            pdBaryDir.copyArray(PdBaryDir.TRIANGLE_EDGE[(n14 + 2) % 3]);
            int n15 = PwBary.rotateAtVertex(pgElementSet, pgVertexStar.getElement().m_data[0], n14, pdBaryDir, pdBaryDir2, new PdBary(3), d6);
            PiVector piVector3 = pgElementSet.getElement(n15);
            PdBaryDir.getVector((PdVector)pdVector2, (PdBaryDir)pdBaryDir2, (PdVector)pdVectorArray2[piVector3.m_data[0]], (PdVector)pdVectorArray2[piVector3.m_data[1]], (PdVector)pdVectorArray2[piVector3.m_data[2]]);
            pdVector3.copy(pdVector2);
            pdVector3.multScalar(Math.sqrt(Math.abs(d10) * this.m_scaleEmblem.getValue()) / pdVector3.length());
            pgVectorField.setVector(2 * n2 + 1, pdVector3);
            pdBaryDirArray[0][n2] = PdBaryDir.copyNew((PdBaryDir)pdBaryDir2);
            nArray[0][n2] = n15;
            d6 = pdVector10.m_data[0] <= 1.0 ? Math.acos(pdVector10.m_data[0]) : 0.0;
            if (pdVector10.m_data[1] < 0.0) {
                d6 = -d6 + Math.PI * 2;
            }
            n14 = pgVertexStar.getVertexLocInd().m_data[0];
            pdBaryDir.copyArray(PdBaryDir.TRIANGLE_EDGE[(n14 + 2) % 3]);
            n15 = PwBary.rotateAtVertex(pgElementSet, pgVertexStar.getElement().m_data[0], n14, pdBaryDir, pdBaryDir2, new PdBary(3), d6);
            piVector3 = pgElementSet.getElement(n15);
            PdBaryDir.getVector((PdVector)pdVector2, (PdBaryDir)pdBaryDir2, (PdVector)pdVectorArray2[piVector3.m_data[0]], (PdVector)pdVectorArray2[piVector3.m_data[1]], (PdVector)pdVectorArray2[piVector3.m_data[2]]);
            pdVector3.copy(pdVector2);
            pdVector3.multScalar(Math.sqrt(Math.abs(d11) * this.m_scaleEmblem.getValue()) / pdVector3.length());
            pgVectorField2.setVector(2 * n2 + 1, pdVector3);
            pdBaryDirArray[1][n2] = PdBaryDir.copyNew((PdBaryDir)pdBaryDir2);
            nArray[1][n2] = n15;
            if (n3 >= 3 || (n8 = piVectorArray[1].m_data[n2]) > 1) continue;
            pdVector2.copyArray(pdVectorArray2[n10]);
            pdVector9.copy(pgVectorField.getVector(2 * n2 + 1));
            pdVector10.copy(pgVectorField2.getVector(2 * n2 + 1));
            double d12 = pdVector9.length();
            double d13 = pdVector10.length();
            if (d12 > 1.0E-10 && d13 > 1.0E-10) {
                if (d12 > d13) {
                    pdVector10.multScalar(d12 * d12 / d13 / d13);
                } else {
                    pdVector9.multScalar(d13 * d13 / d12 / d12);
                }
            }
            this.addEllipse(pgPolygonSet2, piVector, pdVectorArray2[n10], pdVector9, pdVector10, pdVector11, n8);
        }
        PdVector.copy((PdVector[])pdVectorArray, (int)0, (PdVector[])pdVectorArray4, (int)0, (int)n4);
        pgPolygonSet.addVectorField(pgVectorField);
        pgPolygonSet.addVectorField(pgVectorField2);
        pgPolygonSet.setGlobalVectorColor(Color.red);
        pgPolygonSet.setGlobalVectorSize(3.0);
        pgPolygonSet.showVectorArrows(true);
    }

    private void addEllipse(PgPolygonSet pgPolygonSet, PiVector piVector, PdVector pdVector, PdVector pdVector2, PdVector pdVector3, PdVector pdVector4, int n) {
        int n2 = pgPolygonSet.getNumVertices();
        piVector.setSize(41);
        for (int i = 0; i < 41; ++i) {
            piVector.m_data[i] = n2++;
            double d = Math.cos((double)i * Math.PI / 20.0);
            double d2 = Math.sin((double)i * Math.PI / 20.0);
            pdVector4.m_data[0] = pdVector.m_data[0] + d * pdVector2.m_data[0] + d2 * pdVector3.m_data[0];
            pdVector4.m_data[1] = pdVector.m_data[1] + d * pdVector2.m_data[1] + d2 * pdVector3.m_data[1];
            pgPolygonSet.addVertex(pdVector4);
        }
        pgPolygonSet.addPolygon(piVector);
        piVector.setSize(2);
        piVector.m_data[0] = n2 - 1;
        piVector.m_data[1] = n2 - 1 - 20;
        pgPolygonSet.addPolygon(piVector);
        piVector.m_data[0] = n2 - 1 - 10;
        piVector.m_data[1] = n2 - 1 - 30;
        pgPolygonSet.addPolygon(piVector);
        Color color = Color.black;
        if (n == -1) {
            color = Color.red;
        } else if (n == 1) {
            color = Color.green;
        }
        pgPolygonSet.setPolygonColor(pgPolygonSet.getNumPolygons() - 3, color);
        pgPolygonSet.setPolygonColor(pgPolygonSet.getNumPolygons() - 2, color);
        pgPolygonSet.setPolygonColor(pgPolygonSet.getNumPolygons() - 1, color);
    }

    private void computeLaplacianNormalDiscrete(PgElementSet pgElementSet, PgVectorField pgVectorField, PgVertexStar pgVertexStar, PdVector pdVector, PdVector pdVector2, PdVector pdVector3, PdVector pdVector4, PdVector pdVector5) {
        PdVector[] pdVectorArray = pgElementSet.getVertices();
        int n = pgElementSet.getNumVertices();
        pgVectorField.setBasedOn(0);
        pgVectorField.setGeometry((PgPointSet)pgElementSet);
        for (int i = 0; i < n; ++i) {
            pgVertexStar.makeVertexStar(pgElementSet, i, -1);
            if (!pgVertexStar.isClosed()) continue;
            PiVector piVector = pgVertexStar.getLink();
            int n2 = piVector.getSize();
            int n3 = 1;
            int n4 = n2 - 1;
            pdVector3.setConstant(0.0);
            for (int j = 0; j < n2; ++j) {
                this.rotate90(pdVectorArray[i], pdVectorArray[piVector.m_data[j]], pdVectorArray[piVector.m_data[n3]], pdVector4, pdVector, pdVector2);
                this.rotate90(pdVectorArray[i], pdVectorArray[piVector.m_data[j]], pdVectorArray[piVector.m_data[n4]], pdVector5, pdVector, pdVector2);
                pdVector2.add(pdVector4, pdVector5);
                pdVector2.multScalar(0.5);
                pdVector3.add(pdVector2);
                ++n4;
                if (++n3 == n2) {
                    n3 = 0;
                }
                if (n4 != n2) continue;
                n4 = 0;
            }
            double d = pdVector3.length();
            if (d > 1.0E-10) {
                pdVector3.multScalar(1.0 / d);
            }
            pgVectorField.setVector(i, pdVector3);
        }
        pgVectorField.setGeometry((PgPointSet)pgElementSet);
        pgElementSet.addVectorField(pgVectorField);
        pgVectorField.setVisible(false);
        pgElementSet.setGlobalVectorSize(3.0);
        pgElementSet.showVectorArrows(true);
    }

    private PiVector[] computeSingularities(PgElementSet pgElementSet, PgPolygonSet pgPolygonSet, PdVector pdVector, boolean bl, boolean bl2) {
        PdVector[] pdVectorArray = pgElementSet.getVertices();
        PiVector[] piVectorArray = PwHodge.getZExtrema(pgElementSet, 1.0E-10);
        int n = piVectorArray[0].getSize();
        PiVector[] piVectorArray2 = new PiVector[]{new PiVector(n), new PiVector(n)};
        int n2 = 0;
        pgPolygonSet.setNumVertices(n * 2);
        pgPolygonSet.setNumPolygons(n);
        pgPolygonSet.assurePolygonColors();
        pgPolygonSet.assureVertexColors();
        pgPolygonSet.setGlobalVertexSize(3.0);
        pgPolygonSet.showVertexColors(true);
        pgPolygonSet.showPolygonColors(true);
        pgPolygonSet.showVertexLabels(true);
        for (int i = 0; i < n; ++i) {
            String string;
            Color color;
            if (piVectorArray[1].m_data[i] == -1) {
                if (!bl) continue;
                color = Color.red;
                string = " -";
            } else if (piVectorArray[1].m_data[i] == 1) {
                if (!bl) continue;
                color = Color.green;
                string = " +";
            } else {
                if (!bl2) continue;
                color = Color.blue;
                string = " " + piVectorArray[1].m_data[i];
            }
            pgPolygonSet.setPolygonColor(n2, color);
            pgPolygonSet.setVertexColor(2 * n2, color);
            pgPolygonSet.setVertexColor(2 * n2 + 1, color);
            pdVector.copyArray(pdVectorArray[piVectorArray[0].m_data[i]]);
            pdVector.setName(string);
            pgPolygonSet.setVertex(2 * n2, pdVector);
            pdVector.setEntry(pdVector.getSize() - 1, 0);
            pgPolygonSet.setVertex(2 * n2 + 1, pdVector);
            pgPolygonSet.setPolygon(n2, new PiVector(2 * n2, 2 * n2 + 1));
            piVectorArray2[0].m_data[n2] = piVectorArray[0].m_data[i];
            piVectorArray2[1].m_data[n2] = piVectorArray[1].m_data[i];
            ++n2;
        }
        pgPolygonSet.setNumPolygons(n2);
        pgPolygonSet.setNumVertices(2 * n2);
        piVectorArray2[0].setSize(n2);
        piVectorArray2[1].setSize(n2);
        return piVectorArray2;
    }

    private static void compute2DEV(double d, double d2, double d3, PdVector pdVector, PdVector pdVector2, PdVector pdVector3) {
        if (Math.abs(d2) < 1.0E-10) {
            if (Math.abs(d) >= Math.abs(d3)) {
                pdVector.set(d, 0.0);
                pdVector3.set(0.0, d3);
            } else {
                pdVector2.set(0.0, d3);
                pdVector3.set(d, 0.0);
            }
        } else {
            double d4 = (d + d3) / 2.0;
            double d5 = d4 * d4 - d * d3 + d2 * d2;
            d5 = d5 < 0.0 ? 0.0 : Math.sqrt(d5);
            double d6 = d4 + d5;
            double d7 = d4 - d5;
            if (Math.abs(d6) < Math.abs(d7)) {
                d5 = d6;
                d6 = d7;
                d7 = d5;
            }
            pdVector2.set(-(d3 - d6) / d2, 1.0);
            pdVector3.set(1.0, -(d - d7) / d2);
            pdVector2.normalize();
            pdVector2.multScalar(d6);
            pdVector3.normalize();
            pdVector3.multScalar(d7);
        }
    }

    protected static boolean isOk2D(PgPolygonSet pgPolygonSet, int n, PgElementSet pgElementSet, PiVector piVector, int n2) {
        if (!PwHodge.inside2D(pgPolygonSet, n, pgElementSet.getVertex(piVector.m_data[n2]))) {
            return false;
        }
        int n3 = piVector.getSize();
        for (int i = 0; i < n3; ++i) {
            if (i == n2 || !PwHodge.inside2D(pgPolygonSet, n, pgElementSet.getVertex(piVector.m_data[i]))) continue;
            return false;
        }
        return true;
    }

    protected static boolean inside2D(PgPolygonSet pgPolygonSet, int n, PdVector pdVector) {
        if (!pgPolygonSet.isClosed(n)) {
            return false;
        }
        int n2 = pgPolygonSet.getDimOfVertices();
        PdVector[] pdVectorArray = pgPolygonSet.getVertices();
        PiVector piVector = pgPolygonSet.getPolygon(n);
        int n3 = 0;
        int n4 = piVector.getSize() - 1;
        PdVector pdVector2 = new PdVector(n2);
        PdVector pdVector3 = new PdVector(n2);
        for (int i = 0; i < n4; ++i) {
            int n5 = i + 1;
            if (n5 >= n4) {
                n5 -= n4;
            }
            pdVector2.copyArray(pdVectorArray[piVector.m_data[i]]);
            pdVector3.copyArray(pdVectorArray[piVector.m_data[n5]]);
            if (pdVector2.m_data[0] < pdVector.m_data[0] && pdVector3.m_data[0] < pdVector.m_data[0] || pdVector2.m_data[1] < pdVector.m_data[1] && pdVector3.m_data[1] < pdVector.m_data[1] || pdVector2.m_data[1] > pdVector.m_data[1] && pdVector3.m_data[1] > pdVector.m_data[1] || pdVector3.m_data[0] - (pdVector3.m_data[1] - pdVector.m_data[1]) / (pdVector3.m_data[1] - pdVector2.m_data[1]) * (pdVector3.m_data[0] - pdVector2.m_data[0]) < pdVector.m_data[0]) continue;
            ++n3;
        }
        return n3 % 2 != 0;
    }

    private PdVector rotate90(PdVector pdVector, PdVector pdVector2, PdVector pdVector3, PdVector pdVector4, PdVector pdVector5, PdVector pdVector6) {
        int n = pdVector.getSize();
        if (pdVector4 == null) {
            pdVector4 = new PdVector(n);
        }
        if (pdVector5 == null) {
            pdVector5 = new PdVector(n);
        }
        if (pdVector6 == null) {
            pdVector6 = new PdVector(n);
        }
        pdVector5.sub(pdVector3, pdVector2);
        pdVector6.sub(pdVector3, pdVector);
        pdVector4.sub(pdVector2, pdVector);
        double d = PdVector.angle((PdVector)pdVector6, (PdVector)pdVector4) * Math.PI / 180.0;
        pdVector4.multScalar(-1.0);
        double d2 = PdVector.angle((PdVector)pdVector5, (PdVector)pdVector4) * Math.PI / 180.0;
        pdVector5.multScalar(Math.cos(d) / Math.sin(d));
        pdVector6.multScalar(Math.cos(d2) / Math.sin(d2));
        pdVector4.add(pdVector5, pdVector6);
        return pdVector4;
    }

    public boolean isShowingDisplay(int n) {
        return this.m_frames[n].isVisible();
    }

    public void showDisplay(int n, boolean bl) {
        if (!this.allocateDisplays()) {
            PsDebug.warning((String)"allocation of displays failed");
            return;
        }
        ((Component)this.m_frames[n]).setVisible(bl);
        if (this.m_frames[n].isVisible()) {
            return;
        }
        if (bl) {
            this.m_display[n].update((Object)this.m_display[n]);
            this.m_display[n].fit();
            this.m_frames[n].toFront();
        }
    }

    private boolean allocateDisplays() {
        int n;
        if (this.m_display != null) {
            return true;
        }
        PvViewerIf pvViewerIf = this.getViewer();
        if (pvViewerIf == null) {
            PsDebug.warning((String)"missing viewer to open displays (use setViewer)");
            return false;
        }
        this.m_display = new PvDisplayIf[3];
        this.m_display[0] = pvViewerIf.newDisplay(PsConfig.getMessage((int)54079), true);
        this.m_display[1] = pvViewerIf.newDisplay(PsConfig.getMessage((int)54080), true);
        this.m_display[2] = pvViewerIf.newDisplay(PsConfig.getMessage((int)54081), true);
        this.m_display[0].addGeometry((PgGeometryIf)this.m_uGraph);
        this.m_display[1].addGeometry((PgGeometryIf)this.m_vGraph);
        this.m_display[0].addGeometry((PgGeometryIf)this.m_divSing);
        this.m_display[0].addGeometry((PgGeometryIf)this.m_divIcon);
        this.m_display[1].addGeometry((PgGeometryIf)this.m_rotSing);
        this.m_display[1].addGeometry((PgGeometryIf)this.m_rotIcon);
        for (n = 0; n < 3; ++n) {
            this.m_display[n].addGeometry((PgGeometryIf)this.m_decDomain[n]);
            this.m_display[n].fit();
        }
        n = 350;
        int n2 = 270;
        this.m_frames = new Frame[3];
        for (int i = 0; i < 3; ++i) {
            this.m_frames[i] = this.m_display[i].getFrame();
            ((Component)this.m_frames[i]).setBounds(i / 3 * n + 10, i % 3 * n2 + 10, n, n2);
            ((Component)this.m_frames[i]).setVisible(false);
        }
        return true;
    }

    public PvDisplayIf getDisplay(int n) {
        if (this.m_display == null) {
            return null;
        }
        return this.m_display[n];
    }

    protected boolean alreadyGotSomething() {
        return !this.m_bFirstTime;
    }

    private void completeDecomposition() {
        this.computeHarmonic();
        this.m_bMinimizing = false;
        this.m_bFirstTime = false;
    }

    protected boolean isMinimizing() {
        return this.m_bMinimizing;
    }

    public void decompose() {
        if (this.m_domain == null || this.m_vf == null) {
            PsDebug.warning((String)"missing domain or vector field.");
            return;
        }
        if (this.m_bLock) {
            return;
        }
        if (this.m_bMinimizing) {
            return;
        }
        this.m_bMinimizing = true;
        this.m_bUComputed = false;
        this.m_bVComputed = false;
        if (!this.m_diriU.isRunning()) {
            this.m_diriU.minimize();
        }
        if (!this.m_diriV.isRunning()) {
            this.m_diriV.minimize();
        }
    }

    public void stop() {
        this.m_diriU.stop();
        this.m_diriV.stop();
        this.m_bMinimizing = false;
    }

    public static PgPointSet getZExtrema(PgElementSet pgElementSet, Color color, Color color2, Color color3, double d) {
        if (pgElementSet.getDimOfVertices() < 3) {
            return null;
        }
        PgPointSet pgPointSet = new PgPointSet(pgElementSet.getDimOfVertices());
        pgPointSet.setModelMatrix(pgElementSet.getModelMatrix());
        pgPointSet.assureVertexColors();
        pgPointSet.showVertexColors(true);
        pgPointSet.setName(PsConfig.getMessage((int)45016) + " " + pgElementSet.getName());
        PdVector[] pdVectorArray = pgElementSet.getVertices();
        PdVector pdVector = new PdVector(pgElementSet.getDimOfVertices());
        PiVector[] piVectorArray = PwHodge.getZExtrema(pgElementSet, d);
        int n = piVectorArray[0].getSize();
        for (int i = 0; i < n; ++i) {
            pdVector.copy(pdVectorArray[piVectorArray[0].m_data[i]]);
            if (piVectorArray[1].m_data[i] == 1) {
                pdVector.setName(" +");
                pgPointSet.addVertex(pdVector);
                pgPointSet.setVertexColor(i, color3);
                continue;
            }
            if (piVectorArray[1].m_data[i] == -1) {
                pdVector.setName(" -");
                pgPointSet.addVertex(pdVector);
                pgPointSet.setVertexColor(i, color);
                continue;
            }
            pdVector.setName(" " + piVectorArray[1].m_data[i]);
            pgPointSet.addVertex(pdVector);
            pgPointSet.setVertexColor(i, color2);
        }
        return pgPointSet;
    }

    protected static PiVector[] getZExtrema(PgElementSet pgElementSet, double d) {
        int n;
        if (pgElementSet.getDimOfVertices() < 3) {
            return null;
        }
        int n2 = pgElementSet.getDimOfVertices() - 1;
        int n3 = pgElementSet.getNumVertices();
        PiVector piVector = new PiVector();
        PiVector piVector2 = new PiVector();
        PgVertexStar pgVertexStar = new PgVertexStar();
        PdVector[] pdVectorArray = pgElementSet.getVertices();
        int n4 = 0;
        int[] nArray = new int[n3];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = -1;
        }
        PiVector[] piVectorArray = pgElementSet.getElements();
        int n5 = pgElementSet.getNumElements();
        for (n = 0; n < n5; ++n) {
            int n6 = piVectorArray[n].getSize();
            for (int i = 0; i < n6; ++i) {
                nArray[piVectorArray[n].m_data[i]] = n;
            }
        }
        for (n = 0; n < n3; ++n) {
            int n7;
            pgVertexStar.makeVertexStar(pgElementSet, n, nArray[n]);
            PiVector piVector3 = pgVertexStar.getLink();
            if (!pgVertexStar.isClosed()) continue;
            double d2 = pdVectorArray[n].getEntry(n2);
            double d3 = d2 - d;
            double d4 = d2 + d;
            int n8 = piVector3.getSize();
            boolean bl = true;
            boolean bl2 = true;
            int n9 = 0;
            int n10 = 0;
            int n11 = 0;
            for (n7 = 0; n7 < n8; ++n7) {
                double d5 = pdVectorArray[piVector3.getEntry(n7)].getEntry(n2);
                if (d5 > d3) {
                    bl2 = false;
                }
                if (d5 < d4) {
                    bl = false;
                }
                if (d5 > d4 && n10 < 0) {
                    ++n9;
                    n10 = 1;
                    continue;
                }
                if (d5 < d3 && n10 > 0) {
                    ++n9;
                    n10 = -1;
                    continue;
                }
                if (n10 != 0) continue;
                if (d5 > d4) {
                    n10 = 1;
                } else if (d5 < d3) {
                    n10 = -1;
                }
                n11 = n10;
            }
            n7 = 3;
            if (n11 != n10) {
                ++n9;
            }
            if (!bl2 && !bl && n9 < n7) continue;
            piVector.addEntry(n);
            if (bl2) {
                piVector2.addEntry(1);
            } else if (bl) {
                piVector2.addEntry(-1);
            } else {
                piVector2.addEntry(n9);
            }
            ++n4;
        }
        return new PiVector[]{piVector, piVector2};
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

