/*
 * Decompiled with CFR 0.152.
 */
package jvx.surface;

import jv.function.PuFunction;
import jv.geom.PgElementSet;
import jv.geom.PgPointSet;
import jv.number.PuDouble;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.object.PsUpdateIf;
import jv.project.PgGeometry;
import jv.vecmath.PdVector;
import jvx.surface.PgDomain;

public class PgSurfaceGraph
extends PgElementSet {
    protected int m_dimOfDomain = 0;
    protected int m_dimOfSurface = 0;
    protected PgElementSet m_domain = null;
    protected PgElementSet m_surface = null;
    protected boolean m_bSynchronize = false;
    protected boolean m_bShowAsNormalVariation = false;
    protected PuDouble m_scalingFactor;
    protected PuDouble m_offset;
    protected boolean m_bIsUpdateSender = false;
    static /* synthetic */ Class class$jvx$surface$PgSurfaceGraph;

    public PgSurfaceGraph() {
        this(3);
    }

    public PgSurfaceGraph(int n) {
        super(n);
        this.setTag(10);
        this.m_scalingFactor = new PuDouble(PsConfig.getMessage((int)54225), (PsUpdateIf)this);
        this.m_offset = new PuDouble(PsConfig.getMessage((int)54009), (PsUpdateIf)this);
        if (((Object)((Object)this)).getClass() == (class$jvx$surface$PgSurfaceGraph == null ? (class$jvx$surface$PgSurfaceGraph = PgSurfaceGraph.class$("jvx.surface.PgSurfaceGraph")) : class$jvx$surface$PgSurfaceGraph)) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.m_scalingFactor.setDefBounds(0.0, 5.0, 0.1, 1.0);
        this.m_scalingFactor.setDefValue(1.0);
        this.m_scalingFactor.init();
        this.m_offset.setDefBounds(-5.0, 5.0, 0.1, 1.0);
        this.m_offset.setDefValue(0.0);
        this.m_offset.init();
    }

    public Object clone() {
        PgSurfaceGraph pgSurfaceGraph = (PgSurfaceGraph)((Object)super.clone());
        if (pgSurfaceGraph == null) {
            return null;
        }
        if (this.m_domain != null) {
            pgSurfaceGraph.m_domain = this.m_domain instanceof PgDomain ? (PgDomain)((Object)this.m_domain.clone()) : (PgElementSet)this.m_domain.clone();
            if (pgSurfaceGraph.m_domain.hasUpdateListener((PsUpdateIf)this)) {
                pgSurfaceGraph.m_domain.removeUpdateListener((PsUpdateIf)this);
            }
        }
        if (this.m_surface != null) {
            pgSurfaceGraph.m_surface = (PgElementSet)this.m_surface.clone();
            if (pgSurfaceGraph.m_surface.hasUpdateListener((PsUpdateIf)this)) {
                pgSurfaceGraph.m_surface.addUpdateListener((PsUpdateIf)pgSurfaceGraph);
            }
        }
        pgSurfaceGraph.m_offset = (PuDouble)this.m_offset.clone();
        pgSurfaceGraph.m_offset.setParent((PsUpdateIf)pgSurfaceGraph);
        pgSurfaceGraph.m_scalingFactor = (PuDouble)this.m_scalingFactor.clone();
        pgSurfaceGraph.m_scalingFactor.setParent((PsUpdateIf)pgSurfaceGraph);
        return pgSurfaceGraph;
    }

    public void copy(PsObject psObject) {
        super.copy(psObject);
        if (!(psObject instanceof PgSurfaceGraph)) {
            return;
        }
        PgSurfaceGraph pgSurfaceGraph = (PgSurfaceGraph)psObject;
        if (this.m_domain != null && pgSurfaceGraph.m_domain != null) {
            this.m_domain.copy((PsObject)pgSurfaceGraph.m_domain);
        }
        if (this.m_surface != null && pgSurfaceGraph.m_surface != null) {
            this.m_surface.copy((PsObject)pgSurfaceGraph.m_surface);
        }
        this.m_dimOfDomain = pgSurfaceGraph.m_dimOfDomain;
        this.m_dimOfSurface = pgSurfaceGraph.m_dimOfSurface;
        this.m_bSynchronize = pgSurfaceGraph.m_bSynchronize;
        this.m_bShowAsNormalVariation = pgSurfaceGraph.m_bShowAsNormalVariation;
        this.m_offset.copy(pgSurfaceGraph.m_offset);
        this.m_scalingFactor.copy(pgSurfaceGraph.m_scalingFactor);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append(super.toString());
        stringBuffer.append("\t ******* PgGraph *********\n");
        if (this.m_domain == null) {
            stringBuffer.append("\t m_domain    = null\n");
        } else {
            stringBuffer.append(this.m_domain.toString());
        }
        if (this.m_surface == null) {
            stringBuffer.append("\t m_surface    = null\n");
        } else {
            stringBuffer.append(this.m_surface.toString());
        }
        return stringBuffer.toString();
    }

    public boolean update(Object object) {
        PsDebug.notify((String)"called");
        if (this.m_bIsUpdateSender) {
            return true;
        }
        if (object == null) {
            return super.update(null);
        }
        if (object == this) {
            boolean bl = false;
            if (this.m_bSynchronize) {
                if (this.hasVertexColors()) {
                    this.m_domain.setVertexColors(this.getVertexColors());
                    this.m_domain.showVertexColors(this.isShowingVertexColors());
                    bl = true;
                }
                if (this.hasElementColors()) {
                    this.m_domain.setElementColors(this.getElementColors());
                    this.m_domain.showElementColors(this.isShowingElementColors());
                    bl = true;
                }
            }
            if (bl) {
                this.m_bIsUpdateSender = true;
                this.m_domain.update((Object)this.m_domain);
                this.m_bIsUpdateSender = false;
            }
            this.compute();
            return super.update(object);
        }
        if (object == this.m_domain) {
            if (this.m_surface != null) {
                if (this.m_surface.getNumVertices() != this.m_domain.getNumVertices()) {
                    this.m_surface.setNumVertices(this.m_domain.getNumVertices());
                }
                this.m_surface.copyElementSet(this.m_domain);
            }
            if (this.getNumVertices() != this.m_domain.getNumVertices()) {
                this.setNumVertices(this.m_domain.getNumVertices());
            }
            this.copyConnectivity(this.m_domain);
            if (this.m_dimOfDomain != 3 || this.m_dimOfSurface != 1 || !this.m_domain.hasVertexNormals()) {
                this.m_bShowAsNormalVariation = false;
            }
            return this.update((Object)this);
        }
        if (object == this.m_surface) {
            return this.update((Object)this);
        }
        if (object == this.m_scalingFactor) {
            return this.update((Object)this);
        }
        if (object == this.m_offset) {
            return this.update((Object)this);
        }
        return super.update(object);
    }

    public PgElementSet getDomain() {
        PdVector[] pdVectorArray = this.m_domain.getVertices();
        for (int i = 0; i < ((PgPointSet)this).m_numVertices; ++i) {
            for (int j = 0; j < this.m_dimOfDomain; ++j) {
                pdVectorArray[i].m_data[j] = ((PgPointSet)this).m_vertex[i].m_data[j];
            }
        }
        return this.m_domain;
    }

    public PgElementSet getSurface() {
        PdVector[] pdVectorArray = this.m_surface.getVertices();
        for (int i = 0; i < ((PgPointSet)this).m_numVertices; ++i) {
            for (int j = 0; j < this.m_dimOfSurface; ++j) {
                pdVectorArray[i].m_data[j] = ((PgPointSet)this).m_vertex[i].m_data[this.m_dimOfDomain + j];
            }
        }
        return this.m_surface;
    }

    public void setSurfaces(PgElementSet pgElementSet, PgElementSet pgElementSet2) {
        if (pgElementSet == null && pgElementSet2 == null) {
            if (this.m_domain != null) {
                this.m_domain.removeUpdateListener((PsUpdateIf)this);
                this.m_domain = null;
            }
            if (this.m_surface != null) {
                this.m_surface.removeUpdateListener((PsUpdateIf)this);
                this.m_surface = null;
            }
            return;
        }
        if (pgElementSet.getDimOfVertices() + pgElementSet2.getDimOfVertices() != ((PgGeometry)this).m_dim) {
            PsDebug.warning((String)"Sum of vertex dimension of domain and surface unequal to m_dim");
            return;
        }
        if (pgElementSet.getNumVertices() != pgElementSet2.getNumVertices()) {
            PsDebug.warning((String)("new domain and surface differ in number of vertices.\n\tdomain  = " + pgElementSet.getName() + " numVertices = " + pgElementSet.getNumVertices() + "\n\tsurface = " + pgElementSet2.getName() + " numVertices = " + pgElementSet2.getNumVertices()));
            return;
        }
        this.m_domain = pgElementSet;
        if (!this.m_domain.hasUpdateListener((PsUpdateIf)this)) {
            this.m_domain.addUpdateListener((PsUpdateIf)this);
        }
        this.m_dimOfDomain = this.m_domain.getDimOfVertices();
        this.m_surface = pgElementSet2;
        if (!this.m_surface.hasUpdateListener((PsUpdateIf)this)) {
            this.m_surface.addUpdateListener((PsUpdateIf)this);
        }
        this.m_dimOfSurface = this.m_surface.getDimOfVertices();
        this.setNumVertices(this.m_domain.getNumVertices());
        this.copyConnectivity(this.m_domain);
        if (this.m_dimOfDomain != 3 || this.m_dimOfSurface != 1 || !this.m_domain.hasVertexNormals()) {
            this.m_bShowAsNormalVariation = false;
        }
    }

    public boolean isShowingAsNormalVariation() {
        return this.m_bShowAsNormalVariation;
    }

    public void showAsNormalVariation(boolean bl) {
        this.m_bShowAsNormalVariation = bl;
        if (this.m_dimOfDomain != 3 || this.m_dimOfSurface != 1 || !this.m_domain.hasVertexNormals()) {
            this.m_bShowAsNormalVariation = false;
        }
    }

    public boolean isEnabledSynchronization() {
        return this.m_bSynchronize;
    }

    public void setEnabledSynchronization(boolean bl) {
        this.m_bSynchronize = bl;
    }

    public PuDouble getOffsetSlider() {
        return this.m_offset;
    }

    public double getOffset() {
        return this.m_offset.getValue();
    }

    public void setOffset(double d) {
        this.m_offset.setValue(d);
    }

    public double getScalingFactor() {
        return this.m_scalingFactor.getValue();
    }

    public void setScalingFactor(double d) {
        this.m_scalingFactor.setValue(d);
    }

    public void compute(PuFunction puFunction) {
        if (this.m_domain == null || this.m_surface == null) {
            PsDebug.warning((String)"missing domain or surface");
            return;
        }
        if (puFunction == null) {
            PsDebug.warning((String)"missing function");
            return;
        }
        if (puFunction.getNumFunctions() != this.m_dimOfSurface) {
            PsDebug.warning((String)("wrong number of functions: " + puFunction.getNumFunctions() + " != dimOfSurface = " + this.m_dimOfSurface));
            return;
        }
        if (this.m_domain.getNumVertices() != this.m_surface.getNumVertices()) {
            PsDebug.warning((String)("domain and surface differ in numVertices.\n\tdomain  = " + this.m_domain.getName() + " numVertices = " + this.m_domain.getNumVertices() + "\n\tsurface = " + this.m_surface.getName() + " numVertices = " + this.m_surface.getNumVertices()));
            return;
        }
        PdVector[] pdVectorArray = this.m_domain.getVertices();
        PdVector[] pdVectorArray2 = this.m_surface.getVertices();
        for (int i = 0; i < ((PgPointSet)this).m_numVertices; ++i) {
            puFunction.eval(pdVectorArray2[i].m_data, pdVectorArray[i].m_data);
        }
    }

    public void compute() {
        if (this.m_domain == null || this.m_surface == null) {
            return;
        }
        if (this.m_domain.getNumVertices() != this.m_surface.getNumVertices()) {
            PsDebug.warning((String)("domain and surface differ in numVertices.\n\tdomain  = " + this.m_domain.getName() + " numVertices = " + this.m_domain.getNumVertices() + "\n\tsurface = " + this.m_surface.getName() + " numVertices = " + this.m_surface.getNumVertices()));
            return;
        }
        PdVector[] pdVectorArray = this.m_domain.getVertices();
        PdVector[] pdVectorArray2 = this.m_surface.getVertices();
        PdVector[] pdVectorArray3 = null;
        if (this.m_domain.hasVertexNormals()) {
            pdVectorArray3 = this.m_domain.getVertexNormals();
        }
        double d = this.m_scalingFactor.getValue();
        double d2 = this.m_offset.getValue();
        for (int i = 0; i < ((PgPointSet)this).m_numVertices; ++i) {
            int n;
            for (n = 0; n < this.m_dimOfDomain; ++n) {
                ((PgPointSet)this).m_vertex[i].m_data[n] = this.m_bShowAsNormalVariation ? pdVectorArray[i].m_data[n] + pdVectorArray3[i].m_data[n] * (d * pdVectorArray2[i].m_data[0] + d2) : pdVectorArray[i].m_data[n];
            }
            for (n = 0; n < this.m_dimOfSurface; ++n) {
                ((PgPointSet)this).m_vertex[i].m_data[this.m_dimOfDomain + n] = d * pdVectorArray2[i].m_data[n] + d2;
            }
        }
        this.makeVertexNormals();
        this.makeElementNormals();
    }

    public boolean setSurfaceVertex(int n, PdVector pdVector) {
        if (n < 0 || n > ((PgPointSet)this).m_numVertices - 1) {
            PsDebug.warning((String)("index=" + n + " out of range"));
            return false;
        }
        if (pdVector == null) {
            PsDebug.warning((String)"missing argument");
            return false;
        }
        if (pdVector.getSize() != this.m_dimOfSurface) {
            PsDebug.warning((String)"vertex size does not match dimOfSurface.");
            return false;
        }
        PdVector[] pdVectorArray = this.m_surface.getVertices();
        for (int i = this.m_dimOfDomain; i < ((PgGeometry)this).m_dim; ++i) {
            pdVectorArray[n].m_data[i - this.m_dimOfDomain] = pdVector.m_data[i];
            ((PgPointSet)this).m_vertex[n].m_data[i] = pdVector.m_data[i];
        }
        return true;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

