/*
 * Decompiled with CFR 0.152.
 */
package jvx.numeric;

import jv.geom.PgElementSet;
import jv.geom.PgVectorField;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jvx.numeric.PnSparseMatrix;

public class PnStiffMatrix
extends PnSparseMatrix {
    public int m_noe;
    static /* synthetic */ Class class$jvx$numeric$PnStiffMatrix;

    public PnStiffMatrix(PgElementSet pgElementSet) {
        this.setName(PsConfig.getMessage((int)45056) + " " + pgElementSet.getName());
        if (((Object)((Object)this)).getClass() == (class$jvx$numeric$PnStiffMatrix == null ? (class$jvx$numeric$PnStiffMatrix = PnStiffMatrix.class$("jvx.numeric.PnStiffMatrix")) : class$jvx$numeric$PnStiffMatrix)) {
            this.init(pgElementSet);
        }
    }

    public void init(PgElementSet pgElementSet) {
        super.init();
    }

    public void init(PgElementSet pgElementSet, PgElementSet pgElementSet2) {
        super.init();
    }

    public static PnSparseMatrix computeStiffnessMatrix(PgElementSet pgElementSet, boolean bl, PdVector pdVector) {
        int n = bl ? pgElementSet.getNumVertices() : pgElementSet.getNumEdges();
        PnSparseMatrix pnSparseMatrix = new PnSparseMatrix(n, n, 5);
        PdVector[] pdVectorArray = pgElementSet.getVertices();
        PdVector[] pdVectorArray2 = new PdVector[]{new PdVector(3), new PdVector(3), new PdVector(3)};
        int n2 = pgElementSet.getNumElements();
        for (int i = 0; i < n2; ++i) {
            double d = pdVector == null ? 1.0 : pdVector.m_data[i];
            PiVector piVector = pgElementSet.getNeighbours()[i];
            PiVector piVector2 = pgElementSet.getElement(i);
            PiVector piVector3 = bl ? null : pgElementSet.getElementEdges()[i];
            double d2 = 0.5 / pgElementSet.getAreaOfElement(i);
            pdVectorArray2[0].sub(pdVectorArray[piVector2.m_data[2]], pdVectorArray[piVector2.m_data[1]]);
            pdVectorArray2[1].sub(pdVectorArray[piVector2.m_data[0]], pdVectorArray[piVector2.m_data[2]]);
            pdVectorArray2[2].sub(pdVectorArray[piVector2.m_data[1]], pdVectorArray[piVector2.m_data[0]]);
            for (int j = 0; j < 3; ++j) {
                int n3;
                if (bl) {
                    n3 = piVector2.m_data[j];
                } else {
                    if (piVector.m_data[j] < 0) continue;
                    n3 = piVector3.m_data[j];
                }
                for (int k = 0; k < 3; ++k) {
                    int n4;
                    if (bl) {
                        n4 = piVector2.m_data[k];
                    } else {
                        if (piVector.m_data[k] < 0) continue;
                        n4 = piVector3.m_data[k];
                    }
                    double d3 = d * d2 * pdVectorArray2[j].dot(pdVectorArray2[k]);
                    if (!bl) {
                        d3 *= 2.0;
                    }
                    pnSparseMatrix.appendEntry(n4, n3, d3);
                }
            }
        }
        pnSparseMatrix.validate();
        return pnSparseMatrix;
    }

    public static PdVector computeRightVector(PgElementSet pgElementSet, PgVectorField pgVectorField, boolean bl, boolean bl2, PdVector pdVector) {
        if (pgElementSet.getDimOfElements() != 3) {
            PsDebug.warning((String)"Surface is not triangulated.");
            return null;
        }
        int n = bl ? pgElementSet.getNumVertices() : pgElementSet.getNumEdges();
        PdVector pdVector2 = new PdVector(n);
        PdVector[] pdVectorArray = pgElementSet.getVertices();
        PiVector[] piVectorArray = pgElementSet.getNeighbours();
        PiVector[] piVectorArray2 = pgElementSet.getElementEdges();
        int n2 = pgElementSet.getNumElements();
        PdVector pdVector3 = new PdVector(3);
        PdVector pdVector4 = new PdVector(3);
        for (int i = 0; i < n2; ++i) {
            double d = pdVector == null ? 1.0 : pdVector.m_data[i];
            PiVector piVector = pgElementSet.getElement(i);
            pdVector3.multScalar(pgVectorField.getVector(i), -1.0);
            for (int j = 0; j < 3; ++j) {
                int n3;
                pdVector4.sub(pdVectorArray[piVector.m_data[(j + 2) % 3]], pdVectorArray[piVector.m_data[(j + 1) % 3]]);
                if (bl) {
                    n3 = piVector.m_data[j];
                    pdVector4.cross(pgElementSet.getElementNormal(i), pdVector4);
                } else {
                    int n4 = piVectorArray[i].m_data[j];
                    if (n4 == -1) continue;
                    n3 = piVectorArray2[i].m_data[j];
                }
                int n5 = n3;
                pdVector2.m_data[n5] = pdVector2.m_data[n5] - d * pdVector3.dot(pdVector4);
            }
        }
        return pdVector2;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

