/*
 * Decompiled with CFR 0.152.
 */
package jvx.numeric;

import jv.object.PsDebug;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jvx.numeric.PnPreconditioner;
import jvx.numeric.PnSparseMatrix;

public class PnPreconditionerILU
extends PnPreconditioner {
    double shift = 0.1;
    double initShift = 0.0;
    private PiVector m_diag;

    public PnPreconditionerILU(PnSparseMatrix pnSparseMatrix) {
        this.setSparseMatrix(pnSparseMatrix);
    }

    public PnPreconditionerILU(PnSparseMatrix pnSparseMatrix, double d) {
        this.initShift = d;
        this.setSparseMatrix(pnSparseMatrix);
    }

    public void setSparseMatrix(PnSparseMatrix pnSparseMatrix) {
        if (!pnSparseMatrix.isSquare()) {
            PsDebug.warning((String)"Matrix is not square.");
            return;
        }
        this.m_smat = pnSparseMatrix;
        if (this.m_smat == null) {
            PsDebug.warning((String)"Sparse matrix is null");
            return;
        }
        this.factor(this.m_smat);
    }

    public PdVector apply(PdVector pdVector, PdVector pdVector2, int n) {
        if (pdVector == null) {
            PsDebug.warning((String)"Vector b is null");
            return null;
        }
        if (pdVector2 == null) {
            pdVector2 = new PdVector(pdVector.getSize());
        }
        pdVector2.copy(pdVector);
        this.solveL(pdVector2, false, n);
        this.solveU(pdVector2, true, n);
        return pdVector2;
    }

    public PdVector applyTransposed(PdVector pdVector, PdVector pdVector2, int n) {
        if (pdVector == null) {
            PsDebug.warning((String)"Vector b is null");
            return null;
        }
        if (pdVector2 == null) {
            pdVector2 = new PdVector(pdVector.getSize());
        }
        pdVector2.copy(pdVector);
        this.solveUT(pdVector2, true, n);
        this.solveLT(pdVector2, false, n);
        return pdVector2;
    }

    public void updateDiag() {
        this.m_diag = new PiVector(this.m_smat.m_iSize);
        for (int i = 0; i < this.m_diag.getSize(); ++i) {
            this.m_diag.m_data[i] = this.m_smat.getIndex(i, i);
        }
    }

    private void factor(PnSparseMatrix pnSparseMatrix) {
        double d = this.initShift;
        int n = pnSparseMatrix.m_iSize;
        double[] dArray = new double[n];
        this.m_smat = new PnSparseMatrix();
        block0: while (true) {
            int n2;
            this.m_smat.copy(pnSparseMatrix);
            if (d != 0.0) {
                this.m_smat.addDiagonal(d);
            }
            this.updateDiag();
            for (n2 = 1; n2 < n; ++n2) {
                int n3;
                int[] nArray = this.m_smat.m_sindx[n2].m_data;
                int n4 = this.m_smat.m_snoe.m_data[n2];
                for (n3 = 0; n3 < n; ++n3) {
                    dArray[n3] = 0.0;
                }
                for (n3 = 0; n3 < n4; ++n3) {
                    dArray[nArray[n3]] = this.m_smat.m_stiff[n2].m_data[n3];
                }
                for (n3 = 0; n3 < n4; ++n3) {
                    int n5 = nArray[n3];
                    if (n5 >= n2) continue;
                    int n6 = this.m_smat.m_snoe.m_data[n5];
                    int[] nArray2 = this.m_smat.m_sindx[n5].m_data;
                    double[] dArray2 = this.m_smat.m_stiff[n5].m_data;
                    int n7 = this.m_diag.m_data[n5];
                    if (n7 < 0 || dArray2[n7] == 0.0) {
                        d += this.shift;
                        continue block0;
                    }
                    double d2 = -dArray[n5] / dArray2[n7];
                    dArray[n5] = -d2;
                    for (int i = 0; i < n6; ++i) {
                        if (nArray2[i] <= n5) continue;
                        int n8 = nArray2[i];
                        dArray[n8] = dArray[n8] + d2 * dArray2[i];
                    }
                }
                for (n3 = 0; n3 < this.m_smat.m_snoe.m_data[n2]; ++n3) {
                    this.m_smat.m_stiff[n2].m_data[n3] = dArray[this.m_smat.m_sindx[n2].m_data[n3]];
                }
            }
            this.m_smat.compress();
            this.updateDiag();
            for (n2 = 0; n2 < n; ++n2) {
                int n9 = this.m_diag.m_data[n2];
                if (n9 >= 0 && this.m_smat.m_stiff[n2].m_data[n9] != 0.0) continue;
                d += this.shift;
                continue block0;
            }
            break;
        }
    }

    private void solveL(PdVector pdVector, boolean bl, int n) {
        for (int i = 0; i < this.m_smat.m_iSize; ++i) {
            int[] nArray = this.m_smat.m_sindx[i].m_data;
            double[] dArray = this.m_smat.m_stiff[i].m_data;
            for (int j = 0; j < n; ++j) {
                int n2;
                double d = 0.0;
                for (n2 = 0; n2 < nArray.length; ++n2) {
                    if (nArray[n2] >= i) continue;
                    d += dArray[n2] * pdVector.m_data[nArray[n2] * n + j];
                }
                int n3 = i * n + j;
                pdVector.m_data[n3] = pdVector.m_data[n3] - d;
                if (!bl) continue;
                int n4 = i * n + j;
                pdVector.m_data[n4] = pdVector.m_data[n4] / dArray[n2];
            }
        }
    }

    private void solveU(PdVector pdVector, boolean bl, int n) {
        if (this.m_diag == null) {
            this.updateDiag();
        }
        for (int i = this.m_smat.m_iSize - 1; i >= 0; --i) {
            int[] nArray = this.m_smat.m_sindx[i].m_data;
            double[] dArray = this.m_smat.m_stiff[i].m_data;
            for (int j = 0; j < n; ++j) {
                double d = 0.0;
                for (int k = 0; k < nArray.length; ++k) {
                    if (nArray[k] <= i) continue;
                    d += dArray[k] * pdVector.m_data[nArray[k] * n + j];
                }
                int n2 = i * n + j;
                pdVector.m_data[n2] = pdVector.m_data[n2] - d;
                if (!bl) continue;
                int n3 = i * n + j;
                pdVector.m_data[n3] = pdVector.m_data[n3] / dArray[this.m_diag.m_data[i]];
            }
        }
    }

    private void solveLT(PdVector pdVector, boolean bl, int n) {
        if (this.m_diag == null) {
            this.updateDiag();
        }
        for (int i = this.m_smat.m_iSize - 1; i >= 0; --i) {
            int[] nArray = this.m_smat.m_sindx[i].m_data;
            double[] dArray = this.m_smat.m_stiff[i].m_data;
            for (int j = 0; j < n; ++j) {
                if (bl) {
                    int n2 = i * n + j;
                    pdVector.m_data[n2] = pdVector.m_data[n2] / dArray[this.m_diag.m_data[i]];
                }
                double d = pdVector.m_data[i * n + j];
                for (int k = 0; k < nArray.length; ++k) {
                    if (nArray[k] >= i) continue;
                    int n3 = nArray[k] * n + j;
                    pdVector.m_data[n3] = pdVector.m_data[n3] - dArray[k] * d;
                }
            }
        }
    }

    private void solveUT(PdVector pdVector, boolean bl, int n) {
        if (this.m_diag == null) {
            this.updateDiag();
        }
        for (int i = 0; i < this.m_smat.m_iSize; ++i) {
            int[] nArray = this.m_smat.m_sindx[i].m_data;
            double[] dArray = this.m_smat.m_stiff[i].m_data;
            for (int j = 0; j < n; ++j) {
                if (bl) {
                    int n2 = i * n + j;
                    pdVector.m_data[n2] = pdVector.m_data[n2] / dArray[this.m_diag.m_data[i]];
                }
                double d = pdVector.m_data[i * n + j];
                for (int k = 0; k < nArray.length; ++k) {
                    if (nArray[k] <= i) continue;
                    int n3 = nArray[k] * n + j;
                    pdVector.m_data[n3] = pdVector.m_data[n3] - dArray[k] * d;
                }
            }
        }
    }
}

