/*
 * Decompiled with CFR 0.152.
 */
package jvx.numeric;

import jv.geom.PgElementSet;
import jv.object.PsDebug;
import jv.vecmath.PdMatrix;
import jvx.numeric.PnEnergy;
import jvx.numeric.PnStiffDiriConforming;
import jvx.numeric.PnStiffDiriNonConforming;

public class PnDiriEnergy
extends PnEnergy {
    static /* synthetic */ Class class$jvx$numeric$PnDiriEnergy;

    public PnDiriEnergy() {
        if (((Object)((Object)this)).getClass() == (class$jvx$numeric$PnDiriEnergy == null ? (class$jvx$numeric$PnDiriEnergy = PnDiriEnergy.class$("jvx.numeric.PnDiriEnergy")) : class$jvx$numeric$PnDiriEnergy)) {
            this.init();
        }
    }

    public void init() {
        super.init();
    }

    public void initSurface(PgElementSet pgElementSet, PgElementSet pgElementSet2) {
        if (pgElementSet == null) {
            PsDebug.warning((String)"missing domain geometry.");
            return;
        }
        if (pgElementSet2 == null) {
            PsDebug.warning((String)"missing surface geometry.");
            return;
        }
        if (this.m_stiffMatrix == null) {
            PsDebug.warning((String)"missing m_stiffMatrix, call setSurface before.");
            return;
        }
        super.initSurface(pgElementSet, pgElementSet2);
        this.m_stiffMatrix.init(pgElementSet);
    }

    public boolean setSurface(PgElementSet pgElementSet, PgElementSet pgElementSet2) {
        if (pgElementSet == null) {
            PsDebug.warning((String)"missing domain geometry.");
            return false;
        }
        if (pgElementSet2 == null) {
            PsDebug.warning((String)"missing surface geometry.");
            return false;
        }
        if (!super.setSurface(pgElementSet, pgElementSet2)) {
            return false;
        }
        if (pgElementSet.isConforming() != pgElementSet2.isConforming()) {
            PsDebug.error((String)"domain and surface have different conformality", (Object)((Object)this));
            return false;
        }
        if (pgElementSet.getDimOfElements() != 3) {
            PsDebug.warning((String)("domain=" + pgElementSet.getName() + " not triangulated"));
            PgElementSet.triangulate((PgElementSet)pgElementSet);
        }
        if (pgElementSet2.getDimOfElements() != 3) {
            PsDebug.warning((String)("surface=" + pgElementSet2.getName() + " not triangulated"));
            PgElementSet.triangulate((PgElementSet)pgElementSet2);
        }
        this.m_stiffMatrix = this.m_domain.isConforming() ? new PnStiffDiriConforming(pgElementSet) : new PnStiffDiriNonConforming(pgElementSet);
        return true;
    }

    public PdMatrix evalHessian(PdMatrix pdMatrix) {
        PsDebug.notify((String)"called");
        if (pdMatrix == null) {
            pdMatrix = new PdMatrix();
        }
        int n = this.m_index.length;
        pdMatrix.setSize(this.m_dim * n);
        pdMatrix.setConstant(0.0);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < this.m_stiffMatrix.m_snoe.m_data[this.m_index[i]]; ++j) {
                int n2 = this.m_invIndex[this.m_stiffMatrix.m_sindx[this.m_index[i]].m_data[j]];
                if (n2 == -1) continue;
                if (i == 0 && n2 == 0) {
                    PsDebug.notify((String)"(i==0 && jPos==0)");
                }
                for (int k = 0; k < this.m_dim; ++k) {
                    pdMatrix.m_data[i * this.m_dim + k][n2 * this.m_dim + k] = this.m_stiffMatrix.m_stiff[this.m_index[i]].m_data[j];
                }
            }
        }
        return pdMatrix;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

