/*
 * Decompiled with CFR 0.152.
 */
package jvx.numeric;

import jv.geom.PgBndConstraint;
import jv.geom.PgBndPolygon;
import jv.geom.PgElementSet;
import jv.object.PsDebug;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jv.vecmath.PuReflect;
import jv.vecmath.PuVectorGeom;
import jvx.numeric.PnEnergy;

public class PnAlignmentEnergy
extends PnEnergy {
    protected PdVector[][] m_Jc;
    protected PdMatrix[] m_rotMat;
    protected PiVector m_bndCompOfVertex = new PiVector();
    static /* synthetic */ Class class$jvx$numeric$PnAlignmentEnergy;

    public PnAlignmentEnergy() {
        if (((Object)((Object)this)).getClass() == (class$jvx$numeric$PnAlignmentEnergy == null ? (class$jvx$numeric$PnAlignmentEnergy = PnAlignmentEnergy.class$("jvx.numeric.PnAlignmentEnergy")) : class$jvx$numeric$PnAlignmentEnergy)) {
            this.init();
        }
    }

    public void init() {
        super.init();
    }

    public void initSurface(PgElementSet pgElementSet, PgElementSet pgElementSet2) {
    }

    public void initJc(PdVector pdVector) {
        PdVector pdVector2 = new PdVector(3);
        double[] dArray = pdVector2.m_data;
        PdVector[] pdVectorArray = PdVector.realloc(null, (int)3, (int)3);
        PdVector[] pdVectorArray2 = PdVector.realloc(null, (int)3, (int)3);
        boolean bl = false;
        PiVector[] piVectorArray = this.m_surface.getElements();
        int n = this.m_surface.getNumElements();
        for (int i = 0; i < n; ++i) {
            int n2;
            int[] nArray = piVectorArray[i].m_data;
            for (n2 = 0; n2 < 3; ++n2) {
                int n3 = 3 * nArray[n2];
                pdVectorArray2[n2].set(pdVector.m_data[n3++], pdVector.m_data[n3++], pdVector.m_data[n3++]);
            }
            PuVectorGeom.ctg((double[])dArray, (PdVector)pdVectorArray2[0], (PdVector)pdVectorArray2[1], (PdVector)pdVectorArray2[2]);
            if (!bl && pdVector2.maxAbs() > 10000.0) {
                bl = true;
                PsDebug.warning((String)("ctg out of range, first in elem = " + i));
            }
            for (n2 = 0; n2 < 3; ++n2) {
                pdVectorArray[n2].sub(pdVectorArray2[(n2 + 2) % 3], pdVectorArray2[(n2 + 1) % 3]);
            }
            for (n2 = 0; n2 < 3; ++n2) {
                this.m_Jc[i][n2].blend(dArray[(n2 + 1) % 3], pdVectorArray[(n2 + 1) % 3], -dArray[(n2 + 2) % 3], pdVectorArray[(n2 + 2) % 3]);
            }
        }
    }

    public boolean setSurface(PgElementSet pgElementSet, PgElementSet pgElementSet2) {
        int n;
        if (pgElementSet == null) {
            PsDebug.warning((String)"missing domain geometry.");
            return false;
        }
        if (pgElementSet2 == null) {
            PsDebug.warning((String)"missing surface geometry.");
            return false;
        }
        if (!super.setSurface(pgElementSet, pgElementSet2)) {
            return false;
        }
        if (pgElementSet.isConforming() != pgElementSet2.isConforming()) {
            PsDebug.error((String)"domain and surface have different conformality", (Object)((Object)this));
            return false;
        }
        if (pgElementSet.getDimOfElements() != 3) {
            PsDebug.warning((String)("domain=" + pgElementSet.getName() + " not triangulated"));
            PgElementSet.triangulate((PgElementSet)pgElementSet);
        }
        if (pgElementSet2.getDimOfElements() != 3) {
            PsDebug.warning((String)("surface=" + pgElementSet2.getName() + " not triangulated"));
            PgElementSet.triangulate((PgElementSet)pgElementSet2);
        }
        PiVector[] piVectorArray = this.m_surface.getElements();
        int n2 = this.m_surface.getNumElements();
        int n3 = this.m_surface.getDimOfVertices();
        if (this.m_Jc == null || this.m_Jc.length != n2) {
            this.m_Jc = new PdVector[n2][];
        }
        for (n = 0; n < n2; ++n) {
            this.m_Jc[n] = PdVector.realloc((PdVector[])this.m_Jc[n], (int)piVectorArray[n].getSize(), (int)n3);
        }
        this.m_rotMat = PnAlignmentEnergy.computeBndReflections(this.m_rotMat, this.m_bndList);
        this.m_bndCompOfVertex.setSize(this.m_surface.getNumVertices());
        this.m_bndCompOfVertex.setConstant(-2);
        if (this.m_bndList != null) {
            for (n = 0; n < this.m_bndList.length; ++n) {
                if (this.m_bndList[n].hasTag(2)) continue;
                int n4 = this.m_bndList[n].getNumVertices();
                int[] nArray = this.m_bndList[n].getVertexInd().m_data;
                for (int i = 0; i < n4; ++i) {
                    this.m_bndCompOfVertex.setEntry(nArray[i], n);
                }
            }
        } else {
            PiVector[] piVectorArray2 = this.m_surface.getNeighbours();
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < 3; ++j) {
                    if (piVectorArray2[i].getEntry(j) != -1) continue;
                    this.m_bndCompOfVertex.setEntry(piVectorArray[i].getEntry(j), -1);
                }
            }
        }
        return true;
    }

    public double eval(PdVector pdVector) {
        this.initJc(pdVector);
        double d = 0.0;
        d += this.evalInteriorEnergy(pdVector);
        return d += this.evalBoundaryEnergy(pdVector);
    }

    public PdVector evalGradient(PdVector pdVector, PdVector pdVector2) {
        if (pdVector2 == null) {
            if (this.m_store == null || this.m_store.getSize() == 0 && pdVector.getSize() != 0) {
                PsDebug.warning((String)"PnEnergy not initialized, cannot evaluate gradient");
                return null;
            }
            pdVector2 = this.m_store;
        }
        pdVector2.setConstant(0.0);
        if (this.m_surface.getNumVertices() != this.m_nop) {
            return pdVector2;
        }
        this.initJc(pdVector);
        PiVector[] piVectorArray = this.m_surface.getElements();
        PiVector[] piVectorArray2 = this.m_surface.getNeighbours();
        PdVector pdVector3 = new PdVector(3);
        double[] dArray = pdVector3.m_data;
        boolean bl = false;
        PdMatrix pdMatrix = new PdMatrix(3);
        PdMatrix pdMatrix2 = new PdMatrix(3);
        PdMatrix pdMatrix3 = new PdMatrix(3);
        PdVector pdVector4 = new PdVector(3);
        PdVector pdVector5 = new PdVector(3);
        PdVector pdVector6 = new PdVector(3);
        PdVector pdVector7 = new PdVector(3);
        PdVector pdVector8 = new PdVector(3);
        PdVector pdVector9 = new PdVector(3);
        PdVector pdVector10 = new PdVector(3);
        PdVector pdVector11 = new PdVector(3);
        PdVector[] pdVectorArray = PdVector.realloc(null, (int)3, (int)3);
        PdVector[] pdVectorArray2 = PdVector.realloc(null, (int)3, (int)3);
        PdVector[] pdVectorArray3 = PdVector.realloc(null, (int)3, (int)3);
        int n = this.m_surface.getNumElements();
        for (int i = 0; i < n; ++i) {
            int n2;
            int n3;
            int n4;
            for (n4 = 0; n4 < 3; ++n4) {
                n3 = 3 * piVectorArray[i].getEntry(n4);
                pdVectorArray[n4].set(pdVector.m_data[n3++], pdVector.m_data[n3++], pdVector.m_data[n3++]);
            }
            PuVectorGeom.ctg((double[])dArray, (PdVector)pdVectorArray[0], (PdVector)pdVectorArray[1], (PdVector)pdVectorArray[2]);
            if (!bl && pdVector3.maxAbs() > 10000.0) {
                bl = true;
                PsDebug.warning((String)("ctg out of range, first in elem = " + i));
            }
            for (n4 = 0; n4 < 3; ++n4) {
                pdVectorArray3[n4].sub(pdVectorArray[(n4 + 2) % 3], pdVectorArray[(n4 + 1) % 3]);
            }
            for (n4 = 0; n4 < 3; ++n4) {
                int n5;
                n2 = piVectorArray2[i].getEntry(n4);
                if (n2 != -1) {
                    n5 = this.m_surface.getOppVertexLocInd(i, n4);
                    pdVectorArray2[n4].copyArray(this.m_Jc[n2][n5]);
                    continue;
                }
                if (this.m_bndList != null && this.m_bndList.length > 0 && !this.m_surface.isConforming()) {
                    n5 = piVectorArray[i].getEntry(n4);
                    int n6 = this.m_bndCompOfVertex.getEntry(n5);
                    pdVectorArray2[n4].leftMultMatrix(this.m_rotMat[n6], this.m_Jc[i][n4]);
                    continue;
                }
                pdVectorArray2[n4].setConstant(0.0);
            }
            pdVector11.cross(pdVectorArray3[2], pdVectorArray3[1]);
            pdVector11.normalize();
            pdMatrix.adjoint(pdVector11);
            pdMatrix3.adjoint(pdVectorArray3[1], pdVectorArray3[2]);
            pdMatrix2.adjoint(pdVectorArray3[2], pdVectorArray3[1]);
            pdMatrix2.sub(pdMatrix2, pdMatrix3);
            pdMatrix2.multScalar((dArray[1] + dArray[2]) / pdVectorArray3[0].sqrLength());
            for (n4 = 0; n4 < 3; ++n4) {
                n2 = piVectorArray2[i].getEntry(n4);
                if (n2 != -1) {
                    pdVector6.leftMultMatrix(pdMatrix, pdVectorArray2[n4]);
                    pdVector6.multScalar(dArray[(n4 + 1) % 3] + dArray[(n4 + 2) % 3]);
                } else {
                    pdVector6.setConstant(0.0);
                }
                pdVector4.copyArray(pdVector6);
                pdVector5.copyArray(pdVectorArray3[(n4 + 1) % 3]);
                pdVector7.leftMultMatrix(pdMatrix2, pdVectorArray2[(n4 + 1) % 3]);
                pdVector5.sub(pdVector7);
                pdVector8.leftMultMatrix(pdMatrix, pdVectorArray2[(n4 + 1) % 3]);
                pdVector8.multScalar(dArray[(n4 + 2) % 3]);
                pdVector5.sub(pdVector8);
                pdVector4.add(pdVector5);
                pdVector5.setConstant(0.0);
                pdVector5.sub(pdVectorArray3[(n4 + 2) % 3]);
                pdVector9.leftMultMatrix(pdMatrix2, pdVectorArray2[(n4 + 2) % 3]);
                pdVector5.add(pdVector9);
                pdVector10.leftMultMatrix(pdMatrix, pdVectorArray2[(n4 + 2) % 3]);
                pdVector10.multScalar(dArray[(n4 + 1) % 3]);
                pdVector5.sub(pdVector10);
                pdVector4.add(pdVector5);
                n3 = 3 * piVectorArray[i].getEntry(n4);
                for (int j = 0; j < 3; ++j) {
                    int n7 = n3++;
                    pdVector2.m_data[n7] = pdVector2.m_data[n7] + 2.0 * pdVector4.m_data[j];
                }
            }
        }
        return this.constrainGradient(pdVector, pdVector2);
    }

    protected double evalInteriorEnergy(PdVector pdVector) {
        int n = this.m_surface.getNumElements();
        PdVector pdVector2 = new PdVector(this.m_dim);
        PiVector[] piVectorArray = this.m_surface.getNeighbours();
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < 3; ++j) {
                int n2 = piVectorArray[i].getEntry(j);
                if (n2 < i) continue;
                int n3 = piVectorArray[n2].getIndexOf(i);
                pdVector2.add(this.m_Jc[i][j], this.m_Jc[n2][n3]);
                d += pdVector2.sqrLength();
            }
        }
        return d;
    }

    protected double evalBoundaryEnergy(PdVector pdVector) {
        if (this.m_bndList == null || this.m_bndList.length == 0) {
            return 0.0;
        }
        double d = 0.0;
        for (int i = 0; i < this.m_bndList.length; ++i) {
            PgBndConstraint pgBndConstraint;
            if (this.m_bndList[i].hasTag(2) || (pgBndConstraint = this.m_bndList[i].getBndConstraint()) == null) continue;
            int n = this.m_bndList[i].getNumElements();
            int[] nArray = this.m_bndList[i].getElementInd().m_data;
            int[] nArray2 = this.m_bndList[i].getVertexInd().m_data;
            PiVector[] piVectorArray = this.m_surface.getElements();
            PdVector pdVector2 = new PdVector(3);
            if (!pgBndConstraint.hasShape(4)) continue;
            for (int j = 0; j < n; ++j) {
                int n2 = nArray[j];
                int n3 = piVectorArray[n2].getIndexOf(nArray2[j]);
                PdVector pdVector3 = this.m_Jc[n2][n3];
                pdVector2.leftMultMatrix(this.m_rotMat[i], pdVector3);
                pdVector2.add(pdVector3);
                d += pdVector2.sqrLength() / 2.0;
            }
        }
        return d;
    }

    private static PdMatrix[] computeBndReflections(PdMatrix[] pdMatrixArray, PgBndPolygon[] pgBndPolygonArray) {
        if (pgBndPolygonArray == null || pgBndPolygonArray.length == 0) {
            return null;
        }
        pdMatrixArray = PdMatrix.realloc((PdMatrix[])pdMatrixArray, (int)pgBndPolygonArray.length, (int)3, (int)3);
        for (int i = 0; i < pgBndPolygonArray.length; ++i) {
            if (pgBndPolygonArray[i].hasTag(2)) continue;
            PgBndConstraint pgBndConstraint = pgBndPolygonArray[i].getBndConstraint();
            if (pgBndConstraint == null) {
                pdMatrixArray[i].setConstant(0.0);
                continue;
            }
            if (pgBndConstraint.hasShape(4)) {
                PdVector pdVector = pgBndConstraint.m_dir;
                PuReflect.makeRotation((PdMatrix)pdMatrixArray[i], (PdVector)pdVector, (double)Math.PI);
                continue;
            }
            pdMatrixArray[i].setConstant(0.0);
        }
        return pdMatrixArray;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

