/*
 * Decompiled with CFR 0.152.
 */
package jvx.loader;

import java.io.DataOutputStream;
import jv.object.PsConfig;
import jvx.loader.PsU3dBlock;

class PsU3dHeaderBlock
extends PsU3dBlock {
    private static boolean m_bWriteMetaData = true;
    public int m_version = 0;
    public int m_profileIdentifier = 0;
    public int m_declarationSize = 0;
    public long m_fileSize = 0L;
    public int m_characterEncoding = 106;
    public double m_unitsScalingFactor = 1.0;
    String cbKey = "cb";
    String cb = "Created by JavaView (version " + PsConfig.getVersion() + "). Authors: " + PsConfig.getAuthors() + " (www.javaview.de).";

    public PsU3dHeaderBlock() {
        this.m_blockType = 0x443355;
    }

    public void computeSize() {
        this.m_dataSize = 24;
        if ((8 & this.m_profileIdentifier) == 8) {
            this.m_dataSize += 8;
        }
        this.m_metaDataSize = m_bWriteMetaData ? 8 + this.cbKey.length() + 2 + this.cb.length() + 2 : 0;
    }

    public void write(DataOutputStream dataOutputStream) {
        super.write(dataOutputStream);
        this.writeUInt32(dataOutputStream, this.m_version);
        this.writeUInt32(dataOutputStream, this.m_profileIdentifier);
        this.writeUInt32(dataOutputStream, this.m_declarationSize);
        this.writeUInt64(dataOutputStream, this.m_fileSize);
        this.writeUInt32(dataOutputStream, this.m_characterEncoding);
        if ((8 & this.m_profileIdentifier) == 8) {
            this.writeFloat64(dataOutputStream, this.m_unitsScalingFactor);
        }
        if (m_bWriteMetaData) {
            this.writeUInt32(dataOutputStream, 1);
            this.writeUInt32(dataOutputStream, 0);
            int n = this.writeString(dataOutputStream, this.cbKey);
            n += this.writeString(dataOutputStream, this.cb);
            this.writePaddingBytes(dataOutputStream, n %= 4);
        }
    }
}

