/*
 * Decompiled with CFR 0.152.
 */
package jvx.loader;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.Writer;
import java.util.Vector;
import jv.loader.PgAbstractLoader;
import jv.number.PuDouble;
import jv.number.PuString;
import jv.object.PsDebug;
import jv.project.PgJvxSrc;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jvx.util.PuAVLTree;
import jvx.util.PuComparePdVectorsLexi;

public final class PgStlbLoader
extends PgAbstractLoader {
    protected int m_numVertices = 0;
    protected int m_numElements = 0;
    protected int m_numElementNormals = 0;
    protected Vector m_vVertex;
    protected int m_dimOfElements = -1;
    protected Vector m_vElement;
    protected Vector m_vElementNormal;
    protected String m_name;

    public PgStlbLoader() {
        this.m_bIsEnabledOptimization = true;
    }

    public PgJvxSrc[] read(BufferedReader bufferedReader) {
        Object[] objectArray;
        if (bufferedReader == null) {
            PsDebug.warning((String)"missing reader");
            return null;
        }
        boolean bl = this.parse(bufferedReader);
        if (!bl) {
            PsDebug.warning((String)"error during parsing of reader");
            return null;
        }
        PgJvxSrc pgJvxSrc = new PgJvxSrc();
        pgJvxSrc.setEnabledInstanceSharing(true);
        if (!PuString.isEmpty((String)this.m_name)) {
            pgJvxSrc.setName(this.m_name);
        }
        pgJvxSrc.setType(33);
        if (this.m_numVertices > 0) {
            objectArray = (Object[])this.m_vVertex.elementAt(0);
            pgJvxSrc.setDimOfVertices(objectArray.getSize());
            pgJvxSrc.setNumVertices(this.m_numVertices);
            Object[] objectArray2 = new PdVector[this.m_numVertices];
            this.m_vVertex.copyInto(objectArray2);
            pgJvxSrc.setVertices((PdVector[])objectArray2);
            this.m_vVertex = null;
        }
        if (this.m_numElements > 0) {
            pgJvxSrc.setDimOfElements(this.m_dimOfElements);
            pgJvxSrc.setNumElements(this.m_numElements);
            objectArray = new PiVector[this.m_numElements];
            this.m_vElement.copyInto(objectArray);
            pgJvxSrc.setElements((PiVector[])objectArray);
            this.m_vElement = null;
        }
        if (this.m_numElements > 0 && this.m_numElementNormals == this.m_numElements) {
            objectArray = new PdVector[this.m_numElements];
            this.m_vElementNormal.copyInto(objectArray);
            pgJvxSrc.setElementNormals((PdVector[])objectArray);
            this.m_vElementNormal = null;
        }
        pgJvxSrc.showEdges(true);
        pgJvxSrc.showElements(true);
        pgJvxSrc.setEnabledInstanceSharing(false);
        return new PgJvxSrc[]{pgJvxSrc};
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean parse(BufferedReader var1_1) {
        var2_2 = 200;
        var3_3 = new int[var2_2];
        this.m_vVertex = new Vector<E>();
        this.m_vElement = new Vector<E>();
        this.m_vElementNormal = new Vector<E>();
        var4_4 = new StreamTokenizer(var1_1);
        var4_4.eolIsSignificant(true);
        var4_4.ordinaryChars(47, 47);
        var4_4.ordinaryChars(95, 95);
        var4_4.ordinaryChar(45);
        var4_4.ordinaryChar(43);
        var4_4.ordinaryChar(46);
        var4_4.ordinaryChars(48, 48);
        var4_4.ordinaryChars(49, 57);
        var4_4.wordChars(94, 94);
        var4_4.wordChars(38, 38);
        var4_4.wordChars(36, 36);
        var4_4.wordChars(40, 40);
        var4_4.wordChars(41, 41);
        var4_4.wordChars(126, 126);
        var4_4.wordChars(64, 64);
        var4_4.wordChars(45, 45);
        var4_4.wordChars(43, 43);
        var4_4.wordChars(42, 42);
        var4_4.wordChars(48, 48);
        var4_4.wordChars(49, 57);
        var4_4.wordChars(46, 46);
        var4_4.wordChars(44, 44);
        var4_4.wordChars(59, 59);
        var4_4.wordChars(95, 95);
        var4_4.wordChars(58, 58);
        var4_4.wordChars(95, 95);
        var4_4.commentChar(35);
        this.m_numVertices = 0;
        this.m_numElementNormals = 0;
        this.m_numElements = 0;
        var5_5 = false;
        var6_6 = false;
        var7_7 = 0;
        try {
            block7: while (true) {
                block26: {
                    switch (var4_4.nextToken()) {
                        default: {
                            throw new IOException("unknown token type = " + var4_4.ttype);
                        }
                        case -1: {
                            PsDebug.notify((String)("eof token = " + var4_4.sval));
                            ** break;
                        }
                        case 10: {
                            continue block7;
                        }
                        case -3: 
                    }
                    if (var6_6 && "vertex".equals(var4_4.sval)) {
                        var8_8 = new PdVector(3);
                        for (var9_15 = 0; var9_15 < 3; ++var9_15) {
                            var4_4.nextToken();
                            var8_8.m_data[var9_15] = PuDouble.parseDouble((String)var4_4.sval);
                        }
                        this.m_vVertex.addElement(var8_8);
                        var3_3[var7_7++] = this.m_numVertices++;
                        continue;
                    }
                    if (var5_5 && "normal".equals(var4_4.sval)) {
                        var8_9 = new PdVector(3);
                        for (var9_15 = 0; var9_15 < 3; ++var9_15) {
                            var4_4.nextToken();
                            var8_9.m_data[var9_15] = PuDouble.parseDouble((String)var4_4.sval);
                        }
                        var8_9.normalize();
                        this.m_vElementNormal.addElement(var8_9);
                        ++this.m_numElementNormals;
                        continue;
                    }
                    if (!var5_5 && "facet".equals(var4_4.sval)) {
                        var5_5 = true;
                        continue;
                    }
                    if (var5_5 && "endfacet".equals(var4_4.sval)) {
                        var5_5 = false;
                        if (var7_7 <= 0) {
                            throw new IOException("face with no vertex");
                        }
                        ++this.m_numElements;
                        var8_10 = new PiVector(var7_7);
                        var8_10.copy(var3_3, var7_7);
                        var7_7 = 0;
                        this.m_vElement.addElement(var8_10);
                        continue;
                    }
                    if (var5_5 && "outer".equals(var4_4.sval)) {
                        var6_6 = true;
                        continue;
                    }
                    if (var5_5 && "loop".equals(var4_4.sval)) {
                        var6_6 = true;
                        continue;
                    }
                    if (var5_5 && "endloop".equals(var4_4.sval)) {
                        var6_6 = false;
                        continue;
                    }
                    if ("solid".equals(var4_4.sval)) {
                        this.m_name = "";
                        var8_11 = var4_4.nextToken();
                        if (var8_11 == 10) continue;
                        break block26;
                    } else {
                        if ("endsolid".equals(var4_4.sval)) {
                            var8_12 = var4_4.nextToken();
                            while (true) {
                                if (var8_12 == 10 || var8_12 == -1) continue block7;
                                var8_12 = var4_4.nextToken();
                            }
                        }
                        if (!"end".equals(var4_4.sval)) {
                            throw new IOException("Unknown token = " + var4_4.sval);
                        }
                        PsDebug.warning((String)"Found stl file with trailing 'end solid', still continue parsing.");
                        var8_13 = var4_4.nextToken();
                        while (true) {
                            if (var8_13 == 10 || var8_13 == -1) continue block7;
                            var8_13 = var4_4.nextToken();
                        }
                    }
lbl114:
                    // 1 sources

                    PsDebug.notify((String)"... finished");
                    return true;
                }
                var4_4.ordinaryChar(32);
                var4_4.wordChars(32, 32);
                do {
                    if (var4_4.sval != null) {
                        this.m_name = this.m_name + var4_4.sval;
                        continue;
                    }
                    if (var4_4.ttype != 92) continue;
                    this.m_name = this.m_name + "\\";
                } while ((var8_11 = var4_4.nextToken()) != 10 && var8_11 != -1);
                var4_4.whitespaceChars(32, 32);
            }
        }
        catch (IOException var8_14) {
            PsDebug.warning((String)("Exception thrown = " + var8_14.toString() + "\n\tparsing broke abnormally in line=" + var4_4.lineno() + ",\n\treading st.sval=" + var4_4.sval + ",\n\tst.ttype=" + var4_4.ttype));
            return false;
        }
    }

    public static boolean isAscii(BufferedReader bufferedReader) throws IOException {
        char[] cArray = new char[5];
        bufferedReader.mark(5);
        bufferedReader.read(cArray);
        bufferedReader.reset();
        String string = new String(cArray);
        return string.equalsIgnoreCase("solid");
    }

    public PgJvxSrc[] read(DataInputStream dataInputStream) {
        PgJvxSrc[] pgJvxSrcArray = null;
        try {
            int n;
            Object object;
            DataInputStream dataInputStream2 = dataInputStream;
            byte[] byArray = new byte[80];
            dataInputStream2.read(byArray);
            pgJvxSrcArray = new PgJvxSrc[]{new PgJvxSrc()};
            PgJvxSrc pgJvxSrc = pgJvxSrcArray[0];
            pgJvxSrc.setType(33);
            boolean bl = true;
            bl &= byArray[0] == 67;
            bl &= byArray[1] == 79;
            bl &= byArray[2] == 76;
            bl &= byArray[3] == 79;
            bl &= byArray[4] == 82;
            if (bl &= byArray[5] == 61) {
                object = new Color((byArray[6] + 256) % 256, (byArray[7] + 256) % 256, (byArray[8] + 256) % 256);
                pgJvxSrc.setGlobalElementColor((Color)object);
            }
            object = new int[4];
            for (n = 0; n < 4; ++n) {
                object[3 - n] = dataInputStream2.read();
            }
            n = (object[0] << 24) + (object[1] << 16) + (object[2] << 8) + object[3];
            byArray = new byte[50];
            PuAVLTree puAVLTree = new PuAVLTree(new PuComparePdVectorsLexi());
            puAVLTree.setAvoidDuplicates(true);
            int n2 = n / 2 + 100;
            pgJvxSrc.setNumVertices(n2);
            pgJvxSrc.setNumElements(n);
            pgJvxSrc.assureElementNormals();
            PdVector[] pdVectorArray = pgJvxSrc.getVertices();
            PiVector[] piVectorArray = pgJvxSrc.getElements();
            PdVector[] pdVectorArray2 = pgJvxSrc.getElementNormals();
            int n3 = 0;
            PdVector pdVector = new PdVector(3);
            for (int i = 0; i < n; ++i) {
                int n4;
                dataInputStream2.read(byArray);
                for (n4 = 0; n4 < 3; ++n4) {
                    pdVectorArray2[i].m_data[n4] = PgStlbLoader.arr2float(byArray, n4 * 4);
                }
                piVectorArray[i] = new PiVector(3);
                for (n4 = 0; n4 < 3; ++n4) {
                    int n5;
                    for (n5 = 0; n5 < 3; ++n5) {
                        pdVector.m_data[n5] = PgStlbLoader.arr2float(byArray, (n4 + 1) * 12 + n5 * 4);
                    }
                    piVectorArray[i].m_data[n4] = n5 = puAVLTree.insert(pdVector);
                    if (n5 < n3) continue;
                    if (n5 >= n2) {
                        pgJvxSrc.setNumVertices(n2 += (n - i) * 3);
                        pdVectorArray = pgJvxSrc.getVertices();
                    }
                    pdVectorArray[n5] = pdVector;
                    ++n3;
                    pdVector = new PdVector(3);
                }
            }
            pgJvxSrc.setNumVertices(n3);
            if (n > 0) {
                pgJvxSrc.setDimOfVertices(pgJvxSrc.getVertex(0).getSize());
            } else {
                pgJvxSrc.setDimOfVertices(3);
            }
            pgJvxSrc.setVisible(true);
            pgJvxSrc.setElementNormals(pdVectorArray2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            PsDebug.warning((String)"Error while reading file.");
        }
        return pgJvxSrcArray;
    }

    private static float arr2float(byte[] byArray, int n) {
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < 32; i += 8) {
            n3 = (int)((long)n3 | (long)(byArray[n + n2] & 0xFF) << i);
            ++n2;
        }
        return Float.intBitsToFloat(n3);
    }

    private static void float2arr(float f, byte[] byArray, int n) {
        if (byArray.length <= n + 3) {
            return;
        }
        int n2 = Float.floatToIntBits(f);
        for (int i = 0; i < 4; ++i) {
            byArray[n + i] = new Integer(n2 % 256).byteValue();
            n2 >>= 8;
        }
    }

    public boolean write(Writer writer, PgJvxSrc[] pgJvxSrcArray) throws IOException {
        if (pgJvxSrcArray == null || pgJvxSrcArray.length == 0 || pgJvxSrcArray[0] == null) {
            PsDebug.warning((String)"missing geometry");
            return false;
        }
        int n = 0;
        PgJvxSrc pgJvxSrc = null;
        while ((pgJvxSrc = pgJvxSrcArray[n]).getType() != 33 || pgJvxSrc.getDimOfVertices() != 3) {
            if (++n != pgJvxSrcArray.length) continue;
            PsDebug.warning((String)"geometry array did not contain a 3D element set, STL export failed.");
            return false;
        }
        writer.write("solid " + pgJvxSrc.getName() + "\n");
        PdVector[] pdVectorArray = pgJvxSrc.getVertices();
        PiVector[] piVectorArray = pgJvxSrc.getElements();
        PdVector[] pdVectorArray2 = pgJvxSrc.getElementNormals();
        String string = "\t";
        String string2 = "\t\t";
        String string3 = "\t\t\t";
        int n2 = pgJvxSrc.getNumElements();
        for (int i = 0; i < n2; ++i) {
            writer.write(string + "facet");
            if (pdVectorArray2 != null && pdVectorArray2[i] != null) {
                String string4 = PuString.toString((double[])pdVectorArray2[i].m_data, (boolean)true, (boolean)false);
                writer.write(" normal " + string4);
            }
            writer.write("\n");
            writer.write(string2 + "outer loop\n");
            int n3 = piVectorArray[i].getSize();
            for (int j = 0; j < n3; ++j) {
                String string5 = PuString.toString((double[])pdVectorArray[piVectorArray[i].m_data[j]].m_data, (boolean)true, (boolean)false);
                writer.write(string3 + "vertex " + string5 + "\n");
            }
            writer.write(string2 + "endloop\n");
            writer.write(string + "endfacet\n");
        }
        writer.write("endsolid " + pgJvxSrc.getName());
        return true;
    }
}

