/*
 * Decompiled with CFR 0.152.
 */
package jvx.loader;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Writer;
import java.util.Vector;
import jv.loader.PgAbstractLoader;
import jv.number.PuDouble;
import jv.number.PuString;
import jv.object.PsDebug;
import jv.project.PgJvxSrc;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;

public class PgPlyLoader
extends PgAbstractLoader {
    protected int m_indexFirstVertex = 0;

    public PgJvxSrc[] read(BufferedReader bufferedReader) {
        if (bufferedReader == null) {
            PsDebug.warning((String)"missing reader");
            return null;
        }
        PgJvxSrc pgJvxSrc = new PgJvxSrc();
        if (!this.parse(bufferedReader, pgJvxSrc)) {
            PsDebug.warning((String)"error during parsing of reader");
            return null;
        }
        if (pgJvxSrc.getNumElements() == 0) {
            pgJvxSrc.setType(30);
            pgJvxSrc.showVertices(true);
            pgJvxSrc.setGlobalVertexSize(1.0);
        } else {
            pgJvxSrc.setType(33);
            pgJvxSrc.assureNeighbours();
            pgJvxSrc.showEdges(true);
            pgJvxSrc.showElements(true);
        }
        this.m_geomArr = new PgJvxSrc[]{pgJvxSrc};
        return this.m_geomArr;
    }

    protected boolean parse(BufferedReader bufferedReader, PgJvxSrc pgJvxSrc) {
        if (bufferedReader == null) {
            return false;
        }
        try {
            PdVector[] pdVectorArray;
            int n = 0;
            int n2 = 0;
            if (!bufferedReader.ready()) {
                return false;
            }
            String string = bufferedReader.readLine();
            if (string == null || string.equalsIgnoreCase("")) {
                return false;
            }
            String[] stringArray = PuString.splitString((String)string, (char)' ');
            Vector<String> vector = new Vector<String>();
            while (!string.startsWith("end_header")) {
                if (stringArray.length == 3 && stringArray[0].equalsIgnoreCase("format") && !stringArray[1].equalsIgnoreCase("ascii")) {
                    PsDebug.warning((String)("Ply-file-encoding " + stringArray[1] + " not supported yet!"));
                    return false;
                }
                if (string.startsWith("element") && stringArray.length == 3) {
                    if (stringArray[1].equalsIgnoreCase("vertex")) {
                        n = Integer.parseInt(stringArray[2]);
                        pgJvxSrc.setNumVertices(n);
                    } else if (stringArray[1].equalsIgnoreCase("face")) {
                        n2 = Integer.parseInt(stringArray[2]);
                        pgJvxSrc.setNumElements(n2);
                    }
                }
                if (string.startsWith("property") && (stringArray[1].equalsIgnoreCase("float") || stringArray[1].equalsIgnoreCase("float64") || stringArray[1].equalsIgnoreCase("float32"))) {
                    vector.addElement(stringArray[2]);
                }
                if ((string = bufferedReader.readLine()) == null) continue;
                stringArray = PuString.splitString((String)string, (char)' ');
            }
            string = bufferedReader.readLine();
            stringArray = PuString.splitString((String)string, (char)' ');
            int n3 = 0;
            boolean bl = false;
            int[] nArray = new int[3];
            int[] nArray2 = new int[3];
            for (int i = 0; i < vector.size(); ++i) {
                pdVectorArray = ((String)vector.elementAt(i)).toLowerCase();
                if (pdVectorArray.equals("x")) {
                    nArray[0] = i;
                }
                if (pdVectorArray.equals("y")) {
                    nArray[1] = i;
                }
                if (pdVectorArray.equals("z")) {
                    nArray[2] = i;
                }
                if (pdVectorArray.equalsIgnoreCase("nx")) {
                    nArray2[0] = i;
                    bl = true;
                }
                if (bl && pdVectorArray.equals("ny")) {
                    nArray2[1] = i;
                }
                if (!bl || !pdVectorArray.equals("nz")) continue;
                nArray2[2] = i;
            }
            PdVector[] pdVectorArray2 = pgJvxSrc.getVertices();
            pdVectorArray = null;
            if (bl) {
                pgJvxSrc.assureVertexNormals();
                pdVectorArray = pgJvxSrc.getVertexNormals();
            }
            while (n3 < n) {
                for (int i = 0; i < 3; ++i) {
                    pdVectorArray2[n3].m_data[i] = PuDouble.parseDouble((String)stringArray[nArray[i]]);
                    if (!bl) continue;
                    pdVectorArray[n3].m_data[i] = PuDouble.parseDouble((String)stringArray[nArray2[i]]);
                }
                ++n3;
                string = bufferedReader.readLine();
                if (string == null) continue;
                stringArray = PuString.splitString((String)string, (char)' ');
            }
            PiVector[] piVectorArray = pgJvxSrc.getElements();
            for (n3 = 0; n3 < n2 && string != null; ++n3) {
                stringArray = PuString.splitString((String)string, (char)' ');
                int n4 = Integer.parseInt(stringArray[0]);
                piVectorArray[n3] = new PiVector(n4);
                for (int i = 0; i < n4; ++i) {
                    if (stringArray.length > i + 1) {
                        piVectorArray[n3].m_data[i] = Integer.parseInt(stringArray[i + 1]);
                        continue;
                    }
                    PsDebug.warning((String)("Error parsing ply-file while reading element number " + n3));
                }
                string = bufferedReader.readLine();
            }
        }
        catch (IOException iOException) {
            PsDebug.warning((String)("Exception thrown = " + iOException.toString()));
            return false;
        }
        return true;
    }

    public boolean write(Writer writer, PgJvxSrc[] pgJvxSrcArray) throws IOException {
        if (pgJvxSrcArray == null || pgJvxSrcArray.length == 0 || pgJvxSrcArray[0] == null) {
            PsDebug.warning((String)"missing geometry");
            return false;
        }
        PgJvxSrc pgJvxSrc = pgJvxSrcArray[0];
        writer.write("ply\n");
        writer.write("format ascii 1.0\n");
        writer.write("comment created by JavaView\n");
        int n = pgJvxSrc.getNumVertices();
        writer.write("element vertex " + n + "\n");
        writer.write("property float64 x\n");
        writer.write("property float64 y\n");
        writer.write("property float64 z\n");
        int n2 = pgJvxSrc.getNumElements();
        writer.write("element face " + n2 + "\n");
        writer.write("property list uint8 int32 vertex_indices\n");
        writer.write("end_header\n");
        PdVector[] pdVectorArray = pgJvxSrc.getVertices();
        for (int i = 0; i < n; ++i) {
            writer.write(PuString.toString((double[])pdVectorArray[i].m_data) + "\n");
        }
        PiVector[] piVectorArray = pgJvxSrc.getElements();
        for (int i = 0; i < n2; ++i) {
            int n3 = piVectorArray[i].m_data.length;
            if (n3 == 0) {
                PsDebug.warning((String)("Missing vertex references in element[" + i + "]"));
                return false;
            }
            String string = String.valueOf(Integer.toString(n3) + " " + (piVectorArray[i].m_data[0] + this.m_indexFirstVertex));
            for (int j = 1; j < n3; ++j) {
                string = string + " " + String.valueOf(piVectorArray[i].m_data[j] + this.m_indexFirstVertex);
            }
            writer.write(string + "\n");
        }
        return true;
    }

    public boolean write(Writer writer, PgJvxSrc[] pgJvxSrcArray, PdVector[] pdVectorArray, PdVector[] pdVectorArray2, PdVector[][] pdVectorArray3) throws IOException {
        return this.write(writer, pgJvxSrcArray);
    }

    public int getFirstVertexIndex() {
        return this.m_indexFirstVertex;
    }

    public void setFirstVertexIndex(int n) {
        this.m_indexFirstVertex = n;
    }
}

