/*
 * Decompiled with CFR 0.152.
 */
package jvx.loader;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Writer;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.GregorianCalendar;
import java.util.Locale;
import jv.loader.PgAbstractLoader;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.project.PgJvxSrc;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jv.vecmath.PuVectorGeom;
import jvx.loader.PgU3dLoader;
import jvx.loader.PgU3dSrc;
import jvx.loader.PsPdfConfig;

public final class PgPdfLoader
extends PgAbstractLoader {
    private static final boolean m_bPdfView = true;
    private double[] m_mediaBox = new double[]{0.0, 0.0, 595.276, 841.89};
    public static final int FORMAT_A4_PORTRAIT = 0;
    public static final int FORMAT_A4_LANDSCAPE = 1;
    public static final int FORMAT_A3_PORTRAIT = 2;
    public static final int FORMAT_A3_LANDSCAPE = 3;
    private String m_header = "";
    private String m_contents = "";
    private double[] m_headerPosition = new double[]{200.0, 800.0};
    private double[] m_contentsPosition = new double[]{100.0, 700.0};

    public void setMediaBox(double d, double d2, double d3, double d4) {
        this.m_mediaBox[0] = d;
        this.m_mediaBox[0] = d2;
        this.m_mediaBox[0] = d3;
        this.m_mediaBox[0] = d4;
    }

    public void setMediaBox(int n) {
        this.m_mediaBox[0] = 0.0;
        this.m_mediaBox[1] = 0.0;
        switch (n) {
            case 0: {
                this.m_mediaBox[2] = 595.276;
                this.m_mediaBox[3] = 841.89;
                break;
            }
            case 1: {
                this.m_mediaBox[2] = 841.89;
                this.m_mediaBox[3] = 595.276;
                break;
            }
            case 2: {
                this.m_mediaBox[2] = 841.89;
                this.m_mediaBox[3] = 1190.552;
                break;
            }
            case 3: {
                this.m_mediaBox[2] = 1190.552;
                this.m_mediaBox[3] = 841.89;
                break;
            }
        }
    }

    public void setHeader(String string) {
        this.m_header = string;
    }

    public void setContents(String string) {
        this.m_contents = string;
    }

    public PgJvxSrc[] read(String string) {
        return null;
    }

    public PgJvxSrc[] read(BufferedReader bufferedReader) {
        return null;
    }

    protected boolean parse(BufferedReader bufferedReader) {
        return true;
    }

    public boolean write(Writer writer, PgJvxSrc[] pgJvxSrcArray) throws IOException {
        return false;
    }

    private int writeLine(DataOutputStream dataOutputStream, String string) {
        try {
            dataOutputStream.writeBytes(string);
            dataOutputStream.write(13);
            dataOutputStream.write(10);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return string.length() + 2;
    }

    public boolean write(DataOutputStream dataOutputStream, PgJvxSrc[] pgJvxSrcArray) {
        int n;
        if (dataOutputStream == null) {
            PsDebug.warning((String)"missing data output stream writer");
            return false;
        }
        PgU3dSrc pgU3dSrc = new PgU3dSrc();
        PsPdfConfig psPdfConfig = new PsPdfConfig(this.m_displayOption);
        this.m_mediaBox[0] = 0.0;
        this.m_mediaBox[1] = 0.0;
        this.m_mediaBox[2] = psPdfConfig.m_mediumSizeX;
        this.m_mediaBox[3] = psPdfConfig.m_mediumSizeY;
        float f = (float)psPdfConfig.m_displayLLX;
        float f2 = (float)psPdfConfig.m_displayURX;
        float f3 = (float)psPdfConfig.m_displayLLY;
        float f4 = (float)psPdfConfig.m_displayURY;
        float f5 = f2 - f;
        float f6 = f4 - f3;
        this.m_header = psPdfConfig.m_headLine;
        this.m_headerPosition = psPdfConfig.m_headLinePosition;
        int n2 = psPdfConfig.m_headerFontSize;
        int n3 = 12;
        for (n = 0; n < pgJvxSrcArray.length; ++n) {
            if (pgJvxSrcArray[n].getType() != 33) continue;
            PgU3dLoader.addElementSet(pgU3dSrc, pgJvxSrcArray[n], n);
        }
        try {
            int n4;
            int n5;
            String string;
            String string2;
            String string3;
            Object object;
            n = 0;
            int n6 = 1;
            boolean bl = false;
            boolean bl2 = true;
            if (this.m_header == null || this.m_header.equals("")) {
                bl2 = false;
            }
            boolean bl3 = true;
            if (this.m_contents == null || this.m_contents.equals("")) {
                bl3 = false;
            }
            boolean bl4 = true;
            boolean bl5 = true;
            boolean bl6 = true;
            boolean bl7 = true;
            boolean bl8 = true;
            boolean bl9 = true;
            int n7 = n6++;
            int n8 = n6++;
            int n9 = -1;
            if (bl) {
                n9 = n6++;
            }
            int n10 = n6++;
            int n11 = -1;
            if (bl3 || bl2) {
                n11 = n6++;
            }
            int n12 = -1;
            if (bl4) {
                n12 = n6++;
            }
            int n13 = n6++;
            int n14 = n6++;
            int n15 = -1;
            if (bl5) {
                n15 = n6++;
            }
            int n16 = -1;
            if (bl6) {
                n16 = n6++;
            }
            int n17 = -1;
            if (bl7) {
                n17 = n6++;
            }
            int n18 = -1;
            if (bl8) {
                n18 = n6++;
            }
            int n19 = -1;
            if (bl9) {
                n19 = n6++;
            }
            int n20 = n6++;
            int n21 = n6++;
            long[] lArray = new long[n6];
            lArray[n7] = n += this.writeLine(dataOutputStream, "%PDF-1.6");
            n += this.writeLine(dataOutputStream, "" + n7 + " 0 obj <<");
            n += this.writeLine(dataOutputStream, "/Type /Catalog");
            if (bl) {
                n += this.writeLine(dataOutputStream, "/Outlines " + n9 + " 0 R");
            }
            n += this.writeLine(dataOutputStream, "/Pages " + n8 + " 0 R");
            n += this.writeLine(dataOutputStream, ">>");
            n += this.writeLine(dataOutputStream, "endobj");
            if (bl) {
                lArray[n9] = n;
                n += this.writeLine(dataOutputStream, "" + n9 + " 0 obj <<");
                n += this.writeLine(dataOutputStream, "/Type /Outlines");
                n += this.writeLine(dataOutputStream, "/Count 0");
                n += this.writeLine(dataOutputStream, ">>");
                n += this.writeLine(dataOutputStream, "endobj");
            }
            lArray[n8] = n;
            n += this.writeLine(dataOutputStream, "" + n8 + " 0 obj <<");
            n += this.writeLine(dataOutputStream, "/Type /Pages");
            n += this.writeLine(dataOutputStream, "/Kids [" + n10 + " 0 R]");
            n += this.writeLine(dataOutputStream, "/Count 1");
            n += this.writeLine(dataOutputStream, ">>");
            lArray[n10] = n += this.writeLine(dataOutputStream, "endobj");
            n += this.writeLine(dataOutputStream, "" + n10 + " 0 obj <<");
            n += this.writeLine(dataOutputStream, "/Type /Page");
            n += this.writeLine(dataOutputStream, "/Parent " + n8 + " 0 R");
            n += this.writeLine(dataOutputStream, "/MediaBox [" + this.m_mediaBox[0] + " " + this.m_mediaBox[1] + " " + this.m_mediaBox[2] + " " + this.m_mediaBox[3] + "]");
            if (bl3 || bl2) {
                n += this.writeLine(dataOutputStream, "/Contents " + n11 + " 0 R");
            }
            n += this.writeLine(dataOutputStream, "/Annots [" + n13 + " 0 R]");
            n += this.writeLine(dataOutputStream, "/Resources << /ProcSet [/PDF /Text]");
            if (bl4) {
                n += this.writeLine(dataOutputStream, "/Font << /F1 " + n12 + " 0 R >>");
            }
            n += this.writeLine(dataOutputStream, ">>");
            n += this.writeLine(dataOutputStream, ">>");
            n += this.writeLine(dataOutputStream, "endobj");
            if (bl3 || bl2) {
                lArray[n11] = n;
                n += this.writeLine(dataOutputStream, "" + n11 + " 0 obj <<");
                int n22 = 0;
                object = "" + this.m_contentsPosition[0] + " " + this.m_contentsPosition[1];
                string3 = "" + this.m_headerPosition[0] + " " + this.m_headerPosition[1];
                string2 = n3 > 0 ? "" + n3 : "12";
                if (bl3) {
                    n22 += 29 + this.m_contents.length() + ((String)object).length() + string2.length();
                }
                string = n2 > 0 ? "" + n2 : "24";
                if (bl2) {
                    n22 += 29 + this.m_header.length() + string3.length() + string.length();
                }
                n += this.writeLine(dataOutputStream, "/Length " + n22 + " >>");
                n += this.writeLine(dataOutputStream, "stream");
                if (bl3) {
                    n += this.writeLine(dataOutputStream, "BT");
                    n += this.writeLine(dataOutputStream, "/F1 " + string2 + " Tf");
                    n += this.writeLine(dataOutputStream, (String)object + " Td");
                    n += this.writeLine(dataOutputStream, "(" + this.m_contents + ") Tj");
                    n += this.writeLine(dataOutputStream, "ET");
                }
                if (bl2) {
                    n += this.writeLine(dataOutputStream, "BT");
                    n += this.writeLine(dataOutputStream, "/F1 " + string + " Tf");
                    n += this.writeLine(dataOutputStream, string3 + " Td");
                    n += this.writeLine(dataOutputStream, "(" + this.m_header + ") Tj");
                    n += this.writeLine(dataOutputStream, "ET");
                }
                n += this.writeLine(dataOutputStream, "endstream");
                n += this.writeLine(dataOutputStream, "endobj");
            }
            if (bl4) {
                lArray[n12] = n;
                n += this.writeLine(dataOutputStream, "" + n12 + " 0 obj <<");
                n += this.writeLine(dataOutputStream, "/Type /Font");
                n += this.writeLine(dataOutputStream, "/Subtype /Type1");
                n += this.writeLine(dataOutputStream, "/Name /F1");
                n += this.writeLine(dataOutputStream, "/BaseFont /Helvetica");
                n += this.writeLine(dataOutputStream, ">>");
                n += this.writeLine(dataOutputStream, "endobj");
            }
            lArray[n13] = n;
            n += this.writeLine(dataOutputStream, "" + n13 + " 0 obj <<");
            n += this.writeLine(dataOutputStream, "/Type /Annot");
            n += this.writeLine(dataOutputStream, "/Subtype /3D");
            n += this.writeLine(dataOutputStream, "/Rect [" + f + " " + f3 + " " + f2 + " " + f4 + "]");
            n += this.writeLine(dataOutputStream, "/3DB [0 0 " + f5 + " " + f6 + "]");
            n += this.writeLine(dataOutputStream, "/F 4");
            n += this.writeLine(dataOutputStream, "/Contents (3D Object (model/u3d))");
            n += this.writeLine(dataOutputStream, "/P " + n10 + " 0 R");
            n += this.writeLine(dataOutputStream, "/AP << /N " + n20 + " 0 R >>");
            n += this.writeLine(dataOutputStream, "/3DA <<");
            n += this.writeLine(dataOutputStream, "/A/PV");
            n += this.writeLine(dataOutputStream, "/D/PI");
            n += this.writeLine(dataOutputStream, "/DIS/U");
            n += this.writeLine(dataOutputStream, ">>");
            n += this.writeLine(dataOutputStream, "/3DI true");
            n += this.writeLine(dataOutputStream, "/3DD " + n14 + " 0 R");
            n += this.writeLine(dataOutputStream, ">>");
            lArray[n14] = n += this.writeLine(dataOutputStream, "endobj");
            n += this.writeLine(dataOutputStream, "" + n14 + " 0 obj <<");
            n += this.writeLine(dataOutputStream, "/Type /3D");
            if (bl5) {
                n += this.writeLine(dataOutputStream, "/VA [" + n15 + " 0 R]");
                n += this.writeLine(dataOutputStream, "/DV /F");
            }
            n += this.writeLine(dataOutputStream, "/Subtype /U3D");
            pgU3dSrc.computeFileSize();
            String string4 = Long.toString(pgU3dSrc.m_header.m_fileSize);
            n += this.writeLine(dataOutputStream, "/Length " + string4);
            n += this.writeLine(dataOutputStream, ">>");
            n += this.writeLine(dataOutputStream, "stream");
            pgU3dSrc.write(dataOutputStream);
            n += this.writeLine(dataOutputStream, "endstream");
            n += this.writeLine(dataOutputStream, "endobj");
            if (bl5) {
                lArray[n15] = n;
                n += this.writeLine(dataOutputStream, "" + n15 + " 0 obj <<");
                if (bl6) {
                    n += this.writeLine(dataOutputStream, "/BG " + n16 + " 0 R");
                }
                if (bl7) {
                    n += this.writeLine(dataOutputStream, "/P " + n17 + " 0 R");
                }
                if (this.m_displayOption != null) {
                    object = new DecimalFormat("0.######", new DecimalFormatSymbols(Locale.ENGLISH));
                    string3 = "/C2W[";
                    string2 = this.m_displayOption.getCameraInterest(0);
                    string = this.m_displayOption.getCameraPosition(0);
                    PdVector pdVector = PdVector.subNew((PdVector)string2, (PdVector)string);
                    pdVector.normalize();
                    PdVector pdVector2 = new PdVector(0.0, 0.0, 1.0);
                    PdVector pdVector3 = new PdVector(3);
                    PdVector pdVector4 = pdVector2.orthogonalPart(null, pdVector);
                    if (!pdVector4.normalize()) {
                        PsDebug.notify((String)"upVector parallel to line of view, modify 1");
                        pdVector2.m_data[1] = pdVector2.m_data[1] + 1.0;
                        pdVector4 = pdVector2.orthogonalPart(null, pdVector);
                        if (!pdVector4.normalize()) {
                            PsDebug.notify((String)"upVector parallel to line of view, modify 2");
                            pdVector2.m_data[2] = pdVector2.m_data[2] + 1.0;
                            pdVector4 = pdVector2.orthogonalPart(null, pdVector);
                            if (!pdVector4.normalize()) {
                                PsDebug.notify((String)"upVector parallel to line of view, modify 3");
                                pdVector2.m_data[2] = pdVector2.m_data[2] + 1.0;
                                pdVector4 = pdVector2.orthogonalPart(null, pdVector);
                            }
                        }
                    }
                    pdVector2.copy(pdVector4);
                    PuVectorGeom.rotatePointAroundVector((PdVector)pdVector4, (PdVector)pdVector2, (PdVector)pdVector, (double)(-this.m_displayOption.getCameraRoll(0) * Math.PI / 180.0));
                    pdVector3.cross(pdVector, pdVector4);
                    PdMatrix pdMatrix = new PdMatrix(4);
                    for (int i = 0; i < 3; ++i) {
                        pdMatrix.m_data[0][i] = pdVector3.m_data[i];
                        pdMatrix.m_data[1][i] = pdVector4.m_data[i];
                        pdMatrix.m_data[2][i] = pdVector.m_data[i];
                        pdMatrix.m_data[3][i] = ((PdVector)string).m_data[i];
                    }
                    double d = PdVector.dist((PdVector)string, (PdVector)string2);
                    pdMatrix.m_data[3][3] = 1.0;
                    for (n5 = 0; n5 < 4; ++n5) {
                        for (n4 = 0; n4 < 3; ++n4) {
                            string3 = string3 + ((NumberFormat)object).format(pdMatrix.m_data[n5][n4]);
                            if (n5 == 3 && n4 == 2) continue;
                            string3 = string3 + " ";
                        }
                    }
                    string3 = string3 + "]";
                    n += this.writeLine(dataOutputStream, string3);
                    n += this.writeLine(dataOutputStream, "/CO " + d);
                }
                if (bl8) {
                    n += this.writeLine(dataOutputStream, "/RM " + n18 + " 0 R");
                }
                n += this.writeLine(dataOutputStream, "/XN(Default View)");
                if (bl9) {
                    n += this.writeLine(dataOutputStream, "/LS " + n19 + " 0 R");
                }
                n += this.writeLine(dataOutputStream, "/Type/3DView");
                n += this.writeLine(dataOutputStream, "/MS/M");
                n += this.writeLine(dataOutputStream, ">>");
                n += this.writeLine(dataOutputStream, "endobj");
            }
            if (bl6) {
                lArray[n16] = n;
                n += this.writeLine(dataOutputStream, "" + n16 + " 0 obj <<");
                n += this.writeLine(dataOutputStream, "/Subtype/SC");
                n += this.writeLine(dataOutputStream, "/C[1.0 1.0 1.0]");
                n += this.writeLine(dataOutputStream, ">>");
                n += this.writeLine(dataOutputStream, "endobj");
            }
            if (bl7) {
                lArray[n17] = n;
                n += this.writeLine(dataOutputStream, "" + n17 + " 0 obj <<");
                n += this.writeLine(dataOutputStream, "/Subtype/P");
                n += this.writeLine(dataOutputStream, "/CS /ANF");
                double d = 35.0;
                if (this.m_displayOption != null) {
                    d = 114.59155902616465 * Math.atan(0.5 * this.m_displayOption.getCameraFieldOfView(0));
                }
                n += this.writeLine(dataOutputStream, "/FOV " + (d *= 2.0));
                n += this.writeLine(dataOutputStream, "/PS /Min");
                n += this.writeLine(dataOutputStream, ">>");
                n += this.writeLine(dataOutputStream, "endobj");
            }
            if (bl8) {
                lArray[n18] = n;
                n += this.writeLine(dataOutputStream, "" + n18 + " 0 obj <<");
                n += this.writeLine(dataOutputStream, "/Subtype/Solid");
                n += this.writeLine(dataOutputStream, "/Type/3DRenderMode");
                n += this.writeLine(dataOutputStream, ">>");
                n += this.writeLine(dataOutputStream, "endobj");
            }
            if (bl9) {
                lArray[n19] = n;
                n += this.writeLine(dataOutputStream, "" + n19 + " 0 obj <<");
                n += this.writeLine(dataOutputStream, "/Subtype/White");
                n += this.writeLine(dataOutputStream, "/Type/3DLightingScheme");
                n += this.writeLine(dataOutputStream, ">>");
                n += this.writeLine(dataOutputStream, "endobj");
            }
            lArray[n20] = n;
            n += this.writeLine(dataOutputStream, "" + n20 + " 0 obj <<");
            n += this.writeLine(dataOutputStream, "/Subtype/Form");
            n += this.writeLine(dataOutputStream, "/FormType 1");
            n += this.writeLine(dataOutputStream, "/BBox [0 0 1000 1000]");
            n += this.writeLine(dataOutputStream, "/Matrix [1 0 0 1 0 0]");
            n += this.writeLine(dataOutputStream, "/Resources << /ProcSet [/PDF] >>");
            n += this.writeLine(dataOutputStream, "/Length 51");
            n += this.writeLine(dataOutputStream, ">>");
            n += this.writeLine(dataOutputStream, "stream");
            n += this.writeLine(dataOutputStream, "0.8 sc");
            n += this.writeLine(dataOutputStream, "0 0 m");
            n += this.writeLine(dataOutputStream, "0 1000 l");
            n += this.writeLine(dataOutputStream, "1000 1000 l");
            n += this.writeLine(dataOutputStream, "1000 0 l");
            n += this.writeLine(dataOutputStream, "f");
            n += this.writeLine(dataOutputStream, "endstream");
            n += this.writeLine(dataOutputStream, ">>");
            lArray[n21] = n += this.writeLine(dataOutputStream, "endobj");
            n += this.writeLine(dataOutputStream, "" + n21 + " 0 obj <<");
            n += this.writeLine(dataOutputStream, "/Creator (" + PsConfig.getProgramAndVersion() + ")");
            n += this.writeLine(dataOutputStream, "/Producer (" + PsConfig.getProgramAndVersion() + ")");
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            string3 = "";
            int n23 = gregorianCalendar.get(1);
            string3 = n23 > 999 && n23 < 10000 ? string3 + "" + n23 : string3 + "1980";
            int n24 = gregorianCalendar.get(2) + 1;
            if (n24 > 0 && n24 < 13) {
                if (n24 < 10) {
                    string3 = string3 + "0";
                }
                string3 = string3 + "" + n24;
            } else {
                string3 = string3 + "01";
            }
            int n25 = gregorianCalendar.get(5);
            if (n25 > 0 && n25 < 32) {
                if (n25 < 10) {
                    string3 = string3 + "0";
                }
                string3 = string3 + "" + n25;
            } else {
                string3 = string3 + "01";
            }
            int n26 = gregorianCalendar.get(11);
            if (n26 > -1 && n26 < 24) {
                if (n26 < 10) {
                    string3 = string3 + "0";
                }
                string3 = string3 + "" + n26;
            } else {
                string3 = string3 + "00";
            }
            int n27 = gregorianCalendar.get(12);
            if (n27 > -1 && n27 < 60) {
                if (n27 < 10) {
                    string3 = string3 + "0";
                }
                string3 = string3 + "" + n27;
            } else {
                string3 = string3 + "00";
            }
            int n28 = gregorianCalendar.get(13);
            if (n28 > -1 && n28 < 60) {
                if (n28 < 10) {
                    string3 = string3 + "0";
                }
                string3 = string3 + "" + n28;
            } else {
                string3 = string3 + "00";
            }
            string3 = string3 + "+";
            int n29 = gregorianCalendar.get(15) / 3600000;
            if (n29 > -1 && n29 < 24) {
                if (n29 < 10) {
                    string3 = string3 + "0";
                }
                string3 = string3 + "" + n29 + "'";
            } else {
                string3 = string3 + "00'";
            }
            int n30 = (gregorianCalendar.get(15) - 3600000 * n29) / 60000;
            if (n30 > -1 && n30 < 60) {
                if (n30 < 10) {
                    string3 = string3 + "0";
                }
                string3 = string3 + "" + n30 + "'";
            } else {
                string3 = string3 + "00'";
            }
            n += this.writeLine(dataOutputStream, "/CreationDate(D:" + string3 + ")");
            n += this.writeLine(dataOutputStream, "/ModDate(D:" + string3 + ")");
            n += this.writeLine(dataOutputStream, "/Title (" + this.m_header + ")");
            n += this.writeLine(dataOutputStream, ">>");
            lArray[0] = n += this.writeLine(dataOutputStream, "endobj");
            this.writeLine(dataOutputStream, "xref");
            this.writeLine(dataOutputStream, "0 " + n6);
            this.writeLine(dataOutputStream, "0000000000 65535 f");
            byte[] byArray = new byte[10];
            for (n5 = 1; n5 < n6; ++n5) {
                for (n4 = 0; n4 < 10; ++n4) {
                    byArray[9 - n4] = lArray[n5] % 10L == 0L ? 48 : (lArray[n5] % 10L == 1L ? 49 : (lArray[n5] % 10L == 2L ? 50 : (lArray[n5] % 10L == 3L ? 51 : (lArray[n5] % 10L == 4L ? 52 : (lArray[n5] % 10L == 5L ? 53 : (lArray[n5] % 10L == 6L ? 54 : (lArray[n5] % 10L == 7L ? 55 : (lArray[n5] % 10L == 8L ? 56 : 57))))))));
                    int n31 = n5;
                    lArray[n31] = lArray[n31] / 10L;
                }
                dataOutputStream.write(byArray);
                dataOutputStream.writeBytes(" 00000 n");
                dataOutputStream.write(13);
                dataOutputStream.write(10);
            }
            this.writeLine(dataOutputStream, "trailer <<");
            this.writeLine(dataOutputStream, "/Size " + n6);
            this.writeLine(dataOutputStream, "/Root " + n7 + " 0 R");
            this.writeLine(dataOutputStream, "/Info " + n21 + " 0 R");
            this.writeLine(dataOutputStream, ">>");
            this.writeLine(dataOutputStream, "startxref");
            this.writeLine(dataOutputStream, Long.toString(lArray[0]));
            dataOutputStream.writeBytes("%%EOF");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }
}

