/*
 * Decompiled with CFR 0.152.
 */
package jvx.imageDisplay;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import jv.number.PuDouble;
import jv.object.PsObject;
import jv.object.PsUpdateIf;
import jv.project.PvCameraEvent;
import jv.project.PvCameraIf;
import jv.project.PvCameraListenerIf;
import jv.project.PvDisplayIf;
import jv.vecmath.PdVector;
import jv.viewer.PvCamera;
import jvx.imageDisplay.PiImageSource;

public class PvImageDisplay
extends PsObject
implements ComponentListener,
PvCameraListenerIf {
    protected PvDisplayIf m_display;
    protected PiImageSource m_imageSource;
    protected PuDouble m_distance;
    protected PuDouble m_imageSize;
    static /* synthetic */ Class class$jvx$imageDisplay$PvImageDisplay;

    public PvImageDisplay() {
        this.setName("Image Display");
        this.m_distance = new PuDouble("Distance", (PsUpdateIf)this);
        this.m_imageSize = new PuDouble("Image Size", (PsUpdateIf)this);
        if (this.getClass() == (class$jvx$imageDisplay$PvImageDisplay == null ? (class$jvx$imageDisplay$PvImageDisplay = PvImageDisplay.class$("jvx.imageDisplay.PvImageDisplay")) : class$jvx$imageDisplay$PvImageDisplay)) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.m_distance.setDefBounds(0.001, 10.0, 0.1, 1.0);
        this.m_distance.setDefValue(3.0);
        this.m_distance.init();
        this.m_imageSize.setDefBounds(0.1, 1.0, 0.01, 0.1);
        this.m_imageSize.setDefValue(1.0);
        this.m_imageSize.init();
        this.setDistance(this.m_distance.getValue());
        if (this.m_imageSource != null) {
            this.m_imageSource.init();
        }
    }

    public void start() {
        if (this.m_display == null) {
            return;
        }
        if (!this.m_display.hasCameraListener((PvCameraListenerIf)this)) {
            this.m_display.addCameraListener((PvCameraListenerIf)this);
            ((Component)this.m_display).addComponentListener(this);
        }
        if (this.m_imageSource != null && this.resizeImage(this.m_display)) {
            this.changeViewport(this.m_display);
            this.m_imageSource.compute();
            this.update((Object)this.m_imageSource);
        }
        this.m_display.showBackgroundImage(true);
        this.m_display.update(null);
    }

    public void reset() {
        if (this.m_display != null) {
            this.m_display.removeCameraListener((PvCameraListenerIf)this);
            ((Component)this.m_display).removeComponentListener(this);
        }
        this.init();
    }

    public boolean update(Object object) {
        if (object == this || object == null) {
            return super.update(object);
        }
        if (this.m_display == null) {
            return true;
        }
        if (object == this.m_imageSource) {
            this.m_display.setBackgroundImage(this.m_imageSource.m_image);
            this.m_display.update(null);
            return super.update((Object)this);
        }
        if (object == this.m_distance) {
            PvCameraIf pvCameraIf = this.m_display.getCamera(1);
            pvCameraIf.setDist(this.m_distance.getValue());
            ((PvCamera)pvCameraIf).updatePanels((Object)pvCameraIf);
            this.changeViewport(this.m_display);
            if (this.m_imageSource != null) {
                this.m_imageSource.compute();
            }
            this.update((Object)this.m_imageSource);
            return super.update((Object)this);
        }
        if (object == this.m_imageSize) {
            this.resizeImage(this.m_display);
            if (this.m_imageSource != null) {
                this.m_imageSource.compute();
            }
            return this.update((Object)this.m_imageSource);
        }
        return super.update(object);
    }

    public PvDisplayIf getImageDisplay() {
        return this.m_display;
    }

    public void setImageDisplay(PvDisplayIf pvDisplayIf) {
        this.m_display = pvDisplayIf;
        if (this.m_display != null) {
            this.m_display.setBackgroundColor(new Color(255, 255, 150));
            this.m_display.selectCamera(1);
            this.m_display.setBackgroundImageFit(1);
            this.m_display.setMajorMode(6);
            this.m_display.showScenegraph(false);
            this.resizeImage(this.m_display);
            this.update(this.m_distance);
        }
    }

    public PiImageSource getImageSource() {
        return this.m_imageSource;
    }

    public void setImageSource(PiImageSource piImageSource) {
        this.m_imageSource = piImageSource;
        this.m_imageSource.setParent((PsUpdateIf)this);
    }

    public PdVector getInterest() {
        if (this.m_display == null) {
            return null;
        }
        PvCameraIf pvCameraIf = this.m_display.getCamera(1);
        return pvCameraIf.getInterest();
    }

    public void setInterest(PdVector pdVector) {
        if (this.m_display == null) {
            return;
        }
        PvCameraIf pvCameraIf = this.m_display.getCamera(1);
        pvCameraIf.setInterest(pdVector);
        this.update(this.m_distance);
    }

    public double getDistance() {
        return this.m_distance.getValue();
    }

    public void setDistance(double d) {
        this.m_distance.setValue(d);
        this.update(this.m_distance);
    }

    public double getImageSize() {
        return this.m_imageSize.getValue();
    }

    public void setImageSize(double d) {
        this.m_imageSize.setValue(d);
        this.update(this.m_imageSize);
    }

    protected boolean resizeImage(PvDisplayIf pvDisplayIf) {
        if (pvDisplayIf == null || this.m_imageSource == null) {
            return false;
        }
        Dimension dimension = pvDisplayIf.getSize();
        int n = (int)(this.m_imageSize.getValue() * (double)dimension.width);
        int n2 = (int)(this.m_imageSize.getValue() * (double)dimension.height);
        this.m_imageSource.createImage((Component)pvDisplayIf, n, n2);
        return true;
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentResized(ComponentEvent componentEvent) {
        if (this.m_display == null) {
            return;
        }
        Object object = componentEvent.getSource();
        if (object == this.m_display && this.m_imageSource != null && this.resizeImage(this.m_display)) {
            this.changeViewport(this.m_display);
            this.m_imageSource.compute();
            this.update((Object)this.m_imageSource);
        }
    }

    public void dragCamera(PvCameraEvent pvCameraEvent) {
        this.pickCamera(pvCameraEvent);
    }

    public void pickCamera(PvCameraEvent pvCameraEvent) {
        if (this.m_display == null) {
            return;
        }
        PvDisplayIf pvDisplayIf = pvCameraEvent.getSource();
        if (pvDisplayIf != this.m_display) {
            return;
        }
        PvCameraIf pvCameraIf = pvDisplayIf.getCamera();
        double d = pvCameraIf.getDist();
        this.m_distance.setValue(d);
        if (this.m_imageSource == null) {
            return;
        }
        this.changeViewport(pvDisplayIf);
        Dimension dimension = pvDisplayIf.getSize();
        double d2 = dimension.width;
        double d3 = dimension.height;
        Point point = pvCameraEvent.getLocation();
        this.m_imageSource.m_currentPosition.set((double)point.x / d2, (double)point.y / d3);
        this.m_imageSource.compute();
        this.update((Object)this.m_imageSource);
    }

    private void changeViewport(PvDisplayIf pvDisplayIf) {
        if (pvDisplayIf == null || this.m_imageSource == null) {
            return;
        }
        PvCameraIf pvCameraIf = pvDisplayIf.getCamera();
        double d = pvCameraIf.getDist();
        Dimension dimension = pvDisplayIf.getSize();
        PdVector pdVector = pvCameraIf.getInterest();
        PdVector pdVector2 = PvImageDisplay.computeDomainBounds(dimension, pdVector, d);
        this.m_imageSource.setDomainBounds(pdVector2);
    }

    public static PdVector computeDomainBounds(Dimension dimension, PdVector pdVector, double d) {
        double d2;
        double d3;
        double d4 = dimension.width;
        double d5 = dimension.height;
        double d6 = d4 / d5;
        if (d6 > 1.0) {
            d3 = d * d6;
            d2 = d;
        } else {
            d3 = d;
            d2 = d / d6;
        }
        double d7 = -d3 / 2.0 + pdVector.getEntry(0);
        double d8 = d3 / 2.0 + pdVector.getEntry(0);
        double d9 = -d2 / 2.0 + pdVector.getEntry(1);
        double d10 = d2 / 2.0 + pdVector.getEntry(1);
        return new PdVector(d7, d9, d8, d10);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

