/*
 * Decompiled with CFR 0.152.
 */
package jvx.gui;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.io.Serializable;
import jv.object.PsConfig;

public class PuNameBar
extends Canvas {
    private static final int FONT_SIZE = 11;
    protected String m_name;
    private int m_stringWidth;
    private boolean m_bShowLines;

    public PuNameBar() {
        PsConfig.setFont((int)-1, (int)4, null, (int)-1, (int)11);
        this.m_stringWidth = -1;
        this.m_bShowLines = true;
    }

    public PuNameBar(String string) {
        this();
        this.setName(string);
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String string) {
        this.m_name = string;
        this.m_stringWidth = -1;
    }

    public boolean isEnabledLines() {
        return this.m_bShowLines;
    }

    public void setEnabledLines(boolean bl) {
        this.m_bShowLines = bl;
    }

    public Dimension getPreferredSize() {
        return new Dimension(10, 15);
    }

    public void paint(Graphics graphics) {
        Serializable serializable;
        super.paint(graphics);
        Font font = PsConfig.getFont((int)4);
        if (this.m_stringWidth == -1) {
            serializable = Toolkit.getDefaultToolkit().getFontMetrics(font);
            this.m_stringWidth = ((FontMetrics)serializable).stringWidth(this.m_name);
        }
        serializable = this.getSize();
        int n = ((Dimension)serializable).width;
        int n2 = ((Dimension)serializable).height;
        int n3 = (n - this.m_stringWidth) / 2;
        int n4 = (n + this.m_stringWidth) / 2;
        graphics.setFont(font);
        graphics.setColor(Color.black);
        graphics.drawString(this.m_name, n3, n2 - 3);
        if (this.m_bShowLines) {
            graphics.setColor(Color.gray.brighter());
            int n5 = 5;
            int n6 = -2;
            int n7 = n6 + n2 - 5;
            graphics.drawLine(n5, n7 - 1, n3 - 2 - n5, n7 - 1);
            graphics.drawLine(n5, n7 + 1, n3 - 2 - n5, n7 + 1);
            graphics.drawLine(n4 + n5, n7 - 1, n - 1 - n5, n7 - 1);
            graphics.drawLine(n4 + n5, n7 + 1, n - 1 - n5, n7 + 1);
        }
    }
}

