/*
 * Decompiled with CFR 0.152.
 */
package jvx.gui;

import java.awt.Color;
import java.awt.Font;
import jv.number.PuInteger;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.object.PsUpdateIf;
import jv.vecmath.PdVector;

public final class PuHistogram
extends PsObject {
    public static final int NUMBINS_USER = 0;
    public static final int NUMBINS_STURGES = 1;
    public static final int NUMBINS_SCOTT = 2;
    public static final int NUMBINS_FD = 3;
    public static final int COUNT_ABSOLUTE = 0;
    public static final int COUNT_RELATIVE = 1;
    protected Color m_backgroundColor;
    protected Color m_backgroundColorDef;
    protected boolean m_enabled = true;
    public static Color DEFAULT_FILL_COLOR = new Color(50, 50, 200);
    protected static Font DEFAULT_FONT_LABELS;
    protected static Font DEFAULT_FONT_TITLE;
    protected PdVector m_samples;
    protected double m_sampleMin;
    protected double m_sampleMax;
    protected boolean m_bUseSampleBnd;
    protected PdVector m_sampleBnd;
    protected double m_countMin;
    protected double m_countMax;
    protected boolean m_bUseCountBnd;
    protected PdVector m_countBnd;
    protected PuInteger m_numBins;
    protected double[] m_binBounds;
    protected double[] m_binCount;
    protected double[] m_binCumulative;
    protected boolean m_bShowBorder;
    protected boolean m_bShowCounts;
    protected boolean m_bShowZeroCounts;
    protected boolean m_bShowAxisLabels;
    protected boolean m_bShowAxisTicks;
    protected boolean m_bShowTitle;
    protected String m_title;
    protected String m_xLabel;
    protected String m_yLabel;
    protected int m_classType;
    protected int m_countType;
    protected int[] m_margins;
    protected Color m_fillColor;
    static /* synthetic */ Class class$jvx$gui$PuHistogram;

    public PuHistogram(String string, PsUpdateIf psUpdateIf) {
        this.setTag(4);
        this.setParent(psUpdateIf);
        this.setName(string);
        DEFAULT_FONT_LABELS = PsConfig.getFont((int)0);
        DEFAULT_FONT_TITLE = PsConfig.getFont((int)0);
        this.m_margins = new int[]{10, 10, 20, 10};
        this.m_bShowTitle = false;
        this.m_bShowAxisLabels = false;
        this.m_bShowAxisTicks = false;
        this.m_bShowCounts = false;
        this.m_samples = new PdVector();
        this.m_numBins = new PuInteger("Number of Bins", (PsUpdateIf)this);
        if (((Object)((Object)this)).getClass() == (class$jvx$gui$PuHistogram == null ? (class$jvx$gui$PuHistogram = PuHistogram.class$("jvx.gui.PuHistogram")) : class$jvx$gui$PuHistogram)) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.m_sampleMin = 0.0;
        this.m_sampleMax = 1.0;
        this.setEnabledSampleBnd(false);
        this.m_sampleBnd = new PdVector(0.0, 1.0);
        this.m_bUseCountBnd = false;
        this.m_countBnd = new PdVector(0.0, 1.0);
        this.setBackground(Color.white);
        this.m_fillColor = DEFAULT_FILL_COLOR;
        this.setClassType(0);
        this.setCountType(0);
        this.setYAxisLabel("Abs Freq");
        this.m_bShowBorder = true;
        this.setEnabledShowCounts(true);
        this.m_bShowZeroCounts = false;
        this.m_numBins.setDefBounds(1, 100, 1, 5);
        this.m_numBins.setDefValue(5);
        this.m_numBins.init();
    }

    public void reset() {
        this.init();
        this.updatePanels((Object)this);
    }

    public boolean update(Object object) {
        if (object == this) {
            this.computeHistogram();
            return super.update((Object)this);
        }
        if (object == this.m_numBins) {
            return this.update((Object)this);
        }
        return super.update(object);
    }

    private void computeHistogram() {
        int n;
        double d;
        int n2;
        if (this.m_bUseSampleBnd) {
            this.m_sampleMin = this.m_sampleBnd.getEntry(0);
            this.m_sampleMax = this.m_sampleBnd.getEntry(1);
        } else {
            this.m_sampleMin = this.m_samples.min();
            this.m_sampleMax = this.m_samples.max();
        }
        int n3 = this.m_samples.getSize();
        int n4 = 0;
        for (n2 = 0; n2 < n3; ++n2) {
            d = this.m_samples.getEntry(n2);
            if (!(this.m_sampleMin <= d) || !(d <= this.m_sampleMax)) continue;
            ++n4;
        }
        if (n4 < 1) {
            return;
        }
        n2 = this.m_numBins.getValue();
        switch (this.m_classType) {
            case 1: {
                n2 = (int)Math.ceil(1.0 + Math.log(n3) / Math.log(2.0));
                break;
            }
            case 0: {
                break;
            }
            default: {
                n2 = (int)Math.ceil(1.0 + Math.log(n3) / Math.log(2.0));
            }
        }
        if (this.m_classType != 0 && this.m_numBins.getValue() != n2) {
            this.m_numBins.setValue(n2);
        }
        this.m_binBounds = new double[n2 + 1];
        this.m_binCumulative = new double[n2 + 1];
        this.m_binCount = new double[n2];
        d = (this.m_sampleMax - this.m_sampleMin) / (double)n2;
        for (n = 0; n <= n2; ++n) {
            this.m_binBounds[n] = this.m_sampleMin + d * (double)n;
        }
        this.m_binCumulative[0] = 0.0;
        for (n = 1; n <= n2; ++n) {
            this.m_binCumulative[n] = 0.0;
            for (int i = 0; i < n3; ++i) {
                double d2 = this.m_samples.getEntry(i);
                if (d2 < this.m_sampleMin || this.m_sampleMax < d2 || !(d2 <= this.m_binBounds[n])) continue;
                int n5 = n;
                this.m_binCumulative[n5] = this.m_binCumulative[n5] + 1.0;
            }
        }
        for (n = 0; n < n2; ++n) {
            this.m_binCount[n] = this.m_countType == 1 ? (this.m_binCumulative[n + 1] - this.m_binCumulative[n]) / (double)n4 : this.m_binCumulative[n + 1] - this.m_binCumulative[n];
            if (n == 0) {
                this.m_countMin = this.m_binCount[0];
                this.m_countMax = this.m_binCount[0];
                continue;
            }
            if (this.m_binCount[n] < this.m_countMin) {
                this.m_countMin = this.m_binCount[n];
                continue;
            }
            if (!(this.m_binCount[n] > this.m_countMax)) continue;
            this.m_countMax = this.m_binCount[n];
        }
    }

    public boolean isEnabled() {
        return this.m_enabled;
    }

    public void setEnabled(boolean bl) {
        PsDebug.notify((String)("setEnabled(" + bl + ")"));
        if (this.m_enabled == bl) {
            return;
        }
        this.m_enabled = bl;
        this.updatePanels((Object)this);
    }

    public Color getBackground() {
        return this.m_backgroundColor;
    }

    public void setBackground(Color color) {
        this.m_backgroundColorDef = color;
        this.m_backgroundColor = color;
    }

    public void setSamples(PdVector pdVector) {
        if (pdVector == null) {
            PsDebug.warning((String)"missing input data");
            this.m_samples.setSize(0);
            return;
        }
        this.m_samples.setSize(pdVector.getSize());
        this.m_samples.copy(pdVector);
    }

    public PdVector getSampleBnd() {
        return this.m_sampleBnd;
    }

    public void setSampleBnd(double d, double d2) {
        this.m_sampleBnd.set(d, d2);
    }

    public int getClassType() {
        return this.m_classType;
    }

    public void setClassType(int n) {
        this.m_classType = n;
        this.m_numBins.setEnabled(n == 0);
    }

    public int getCountType() {
        return this.m_countType;
    }

    public void setCountType(int n) {
        this.m_countType = n;
        if (n == 1) {
            this.setYAxisLabel("Rel Freq");
        } else {
            this.setYAxisLabel("Abs Freq");
        }
    }

    public void setXAxisLabel(String string) {
        this.m_xLabel = string;
    }

    public void setYAxisLabel(String string) {
        this.m_yLabel = string;
    }

    public void setTitle(String string) {
        this.m_title = string;
    }

    public int getNumBins() {
        return this.m_numBins.getValue();
    }

    public void setNumBins(int n) {
        this.m_numBins.setValue(n);
    }

    public boolean isEnabledShowCounts() {
        return this.m_bShowCounts;
    }

    public void setEnabledShowCounts(boolean bl) {
        this.m_bShowCounts = bl;
    }

    public boolean isEnabledShowAxisTicks() {
        return this.m_bShowAxisTicks;
    }

    public void setEnabledShowAxisTicks(boolean bl) {
        if (!bl) {
            if (this.m_bShowAxisTicks) {
                this.m_margins[0] = this.m_margins[0] - 15;
                this.m_margins[1] = this.m_margins[1] - 25;
                this.m_margins[3] = this.m_margins[3] - 10;
            }
        } else if (!this.m_bShowAxisTicks) {
            this.m_margins[0] = this.m_margins[0] + 15;
            this.m_margins[1] = this.m_margins[1] + 25;
            this.m_margins[3] = this.m_margins[3] + 10;
        }
        this.m_bShowAxisTicks = bl;
    }

    public boolean isEnabledShowAxisLabels() {
        return this.m_bShowAxisLabels;
    }

    public void setEnabledShowAxisLabels(boolean bl) {
        if (!bl) {
            if (this.m_bShowAxisLabels) {
                this.m_margins[0] = this.m_margins[0] - 12;
                this.m_margins[1] = this.m_margins[1] - 12;
            }
        } else if (!this.m_bShowAxisLabels) {
            this.m_margins[0] = this.m_margins[0] + 12;
            this.m_margins[1] = this.m_margins[1] + 12;
        }
        this.m_bShowAxisLabels = bl;
    }

    public boolean isEnabledSampleBnd() {
        return this.m_bUseSampleBnd;
    }

    public void setEnabledSampleBnd(boolean bl) {
        this.m_bUseSampleBnd = bl;
    }

    public boolean isEnabledShowTitle() {
        return this.m_bShowTitle;
    }

    public void setEnabledShowTitle(boolean bl) {
        if (!bl) {
            if (this.m_bShowTitle) {
                this.m_margins[2] = this.m_margins[2] - 20;
            }
        } else if (!this.m_bShowTitle) {
            this.m_margins[2] = this.m_margins[2] + 20;
        }
        this.m_bShowTitle = bl;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

