/*
 * Decompiled with CFR 0.152.
 */
package jvx.geom;

import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsPanel;
import jv.object.PsUpdateIf;
import jvx.geom.PwSymmetry;
import jvx.project.PjWorkshop_IP;

public class PwSymmetry_IP
extends PjWorkshop_IP
implements ItemListener,
ActionListener {
    public static final long serialVersionUID = 0L;
    protected PwSymmetry m_workshop;
    protected PsPanel m_epsilon_slider;
    protected PsPanel m_maxdep_slider;
    protected PsPanel m_angle_slider;
    protected PsPanel m_element_slider;
    protected Button m_bReflect;
    protected Button m_bMergeVis;
    protected Button m_bRefSel;
    protected Button m_bReset;
    protected Checkbox m_cIdentGeom;
    protected Checkbox m_cShowBound;
    protected Checkbox m_cPrevOverl;
    protected boolean m_refSelMode;
    protected Color m_refSelColor;
    static /* synthetic */ Class class$jvx$geom$PwSymmetry_IP;

    public PwSymmetry_IP() {
        if (this.getClass() == (class$jvx$geom$PwSymmetry_IP == null ? (class$jvx$geom$PwSymmetry_IP = PwSymmetry_IP.class$("jvx.geom.PwSymmetry_IP")) : class$jvx$geom$PwSymmetry_IP)) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.setTitle(PsConfig.getMessage((boolean)true, (int)54000, (String)"Automatic Reflection"));
        this.addSubTitle("Tolerance and Limits");
        this.m_epsilon_slider = new PsPanel();
        ((Container)((Object)this)).add((Component)this.m_epsilon_slider);
        this.m_angle_slider = new PsPanel();
        ((Container)((Object)this)).add((Component)this.m_angle_slider);
        this.m_maxdep_slider = new PsPanel();
        ((Container)((Object)this)).add((Component)this.m_maxdep_slider);
        this.m_element_slider = new PsPanel();
        ((Container)((Object)this)).add((Component)this.m_element_slider);
        PsPanel psPanel = new PsPanel((LayoutManager)new GridLayout(2, 2));
        psPanel.addSubTitle("Options");
        this.m_cShowBound = new Checkbox("Show boundaries", false);
        this.m_cShowBound.addItemListener(this);
        psPanel.add(this.m_cShowBound);
        this.m_cIdentGeom = new Checkbox("Identify geometries", false);
        this.m_cIdentGeom.addItemListener(this);
        psPanel.add(this.m_cIdentGeom);
        this.m_cPrevOverl = new Checkbox("Prevent overlap", false);
        this.m_cPrevOverl.addItemListener(this);
        psPanel.add(this.m_cPrevOverl);
        ((Container)((Object)this)).add((Component)psPanel);
        PsPanel psPanel2 = new PsPanel((LayoutManager)new GridLayout(2, 2));
        psPanel2.addSubTitle("Actions");
        this.m_bReflect = new Button("Reflect all");
        this.m_bReflect.addActionListener(this);
        psPanel2.add(this.m_bReflect);
        this.m_bRefSel = new Button("Select visible geometries");
        this.m_bRefSel.addActionListener(this);
        psPanel2.add(this.m_bRefSel);
        this.m_bMergeVis = new Button("Merge visible Geometries");
        this.m_bMergeVis.addActionListener(this);
        psPanel2.add(this.m_bMergeVis);
        ((Container)((Object)this)).add((Component)psPanel2);
        PsPanel psPanel3 = new PsPanel((LayoutManager)new FlowLayout(1));
        this.m_bReset = new Button(PsConfig.getMessage((int)54015));
        this.m_bReset.addActionListener(this);
        psPanel3.add(this.m_bReset);
        ((Container)((Object)this)).add((Component)psPanel3);
    }

    public String getNotice() {
        return PsConfig.getMessage((boolean)true, (int)54000, (String)"Generates mirrored objects using planar and straight line symmetries defined by the boundaries of the current geometry. Splitting angle and tolerance determine symmetry segments. ");
    }

    protected int getDialogButtons() {
        return super.getDialogButtons() | 8;
    }

    public Dimension getDialogSize() {
        return new Dimension(400, 650);
    }

    public void setParent(PsUpdateIf psUpdateIf) {
        super.setParent(psUpdateIf);
        this.m_workshop = (PwSymmetry)psUpdateIf;
        this.m_workshop.m_symmIP = this;
        this.m_epsilon_slider.add((Component)this.m_workshop.m_epsilon.assureInspector("Info", "_IP"));
        this.m_maxdep_slider.add((Component)this.m_workshop.m_maxdep.assureInspector("Info", "_IP"));
        this.m_angle_slider.add((Component)this.m_workshop.m_angle.assureInspector("Info", "_IP"));
        this.m_element_slider.add((Component)this.m_workshop.m_elementNum.assureInspector("Info", "_IP"));
    }

    public boolean update(Object object) {
        if (object == this.m_workshop) {
            PsPanel.setState((Checkbox)this.m_cShowBound, (boolean)this.m_workshop.m_cShowBnd);
            PsPanel.setState((Checkbox)this.m_cIdentGeom, (boolean)this.m_workshop.m_cIdGeom);
            PsPanel.setState((Checkbox)this.m_cPrevOverl, (boolean)this.m_workshop.m_checkGeomOverlap);
            return true;
        }
        return super.update(object);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        PsDebug.notify((String)"entered");
        Object object = itemEvent.getSource();
        if (object == this.m_cShowBound) {
            if (this.m_cShowBound.getState() != this.m_workshop.m_cShowBnd) {
                this.m_workshop.m_cShowBnd = this.m_cShowBound.getState();
                this.m_workshop.showBoundaries(this.m_workshop.m_cShowBnd);
                this.m_workshop.update(this);
            }
        } else if (object == this.m_cIdentGeom) {
            if (this.m_cIdentGeom.getState() != this.m_workshop.m_cIdGeom) {
                this.m_workshop.colorGeoms(this.m_cIdentGeom.getState());
                this.m_workshop.update(this);
            }
        } else if (object == this.m_cPrevOverl && this.m_cPrevOverl.getState() != this.m_workshop.m_checkGeomOverlap) {
            this.m_workshop.setCheckGeometricOverlap(this.m_cPrevOverl.getState());
            this.m_workshop.update(this);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.m_workshop == null) {
            return;
        }
        Object object = actionEvent.getSource();
        if (object == this.m_bReflect) {
            this.m_workshop.getSymmAndGeom();
        } else if (object == this.m_bMergeVis) {
            this.m_workshop.mergeVis();
        } else if (object == this.m_bRefSel) {
            if (this.m_refSelMode) {
                this.m_refSelMode = false;
                this.m_bRefSel.setBackground(this.m_refSelColor);
                this.m_bRefSel.setLabel("Select all visible geometries");
                this.m_workshop.mirrorAlongSelected();
            } else {
                this.m_refSelMode = true;
                this.m_refSelColor = this.m_bRefSel.getBackground();
                this.m_bRefSel.setBackground(Color.red);
                this.m_bRefSel.setLabel("Reflect selected");
                this.m_workshop.partialMerge();
            }
        } else if (object == this.m_bReset) {
            this.m_workshop.reset();
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

