/*
 * Decompiled with CFR 0.152.
 */
package jvx.geom;

import java.awt.Color;
import java.util.Vector;
import jv.geom.PgBndPolygon;
import jv.geom.PgElementSet;
import jv.geom.PgVectorField;
import jv.number.PdColor;
import jv.number.PuDouble;
import jv.number.PuInteger;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.object.PsUpdateIf;
import jv.project.PgGeometry;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jv.vecmath.PuMath;
import jvx.geom.PgVertexStar;
import jvx.geom.PwCurvature;
import jvx.geom.PwLocalButterfly_IP;
import jvx.project.PjWorkshop;

public class PwLocalButterfly
extends PjWorkshop {
    protected PgElementSet m_elementSet;
    private int m_noe;
    private int m_nov;
    private int m_novAll;
    private int m_origNoe;
    private Vector m_vertex;
    private Vector m_vertexInsert;
    private Vector m_vertexCOG;
    private Vector m_vertexInfo;
    private static int INDEX = 0;
    private static int REFINEMENT_GRADE = 1;
    private static int SUBDIVISION_GRADE = 2;
    private static int PARENT_EDGE_0 = 3;
    private static int PARENT_EDGE_1 = 4;
    private static int POSITION = 5;
    private static int BOUNDARY = 0;
    private static int INTERIOR = 1;
    private static int NN_START = 6;
    private int m_subdivisionScheme = BUTTERFLY;
    public static int PLANAR = 0;
    public static int BUTTERFLY = 1;
    public static int LOOP = 2;
    boolean m_bVertexNameByLevel = false;
    private Vector m_triangleInfo;
    private static int TRIANGLE_TYPE = 0;
    private static int START = 0;
    private static int RIGHT = 1;
    private static int LEFT = 2;
    private static int R_RIGHT = 3;
    private static int L_LEFT = 4;
    private boolean m_bHasBoundary;
    private PiVector[] m_boundary;
    private boolean m_bHasElementTexture;
    private Vector m_elementTexture;
    private boolean m_bHasElementColors;
    private Vector m_elementColor;
    private boolean m_bHasElementBackColors;
    private Vector m_elementBackColor;
    private boolean m_bHasElementNormals;
    private Vector m_elementNormal;
    private int m_numVectorFields;
    private Vector[] m_vectorField;
    private int[] m_vectorFieldIsBasedOn;
    private boolean m_bHasVertexTexture;
    private Vector m_vertexTexture;
    private boolean m_bHasVertexColors;
    private Vector m_vertexColor;
    private boolean m_bHasVertexNormals;
    private Vector m_vertexNormal;
    public PuDouble m_tolerance;
    public PuInteger m_maxNumSteps;
    public PuDouble m_percentage;
    public static final int HAND = 0;
    public static final int CURVATURE = 1;
    public static final int AREA = 2;
    public int m_markBy = 0;
    protected PwLocalButterfly_IP m_ip;

    public PwLocalButterfly() {
        super(PsConfig.getMessage((int)54433));
        this.m_vertex = new Vector();
        this.m_vertexInsert = new Vector();
        this.m_vertexCOG = new Vector();
        this.m_vertexInfo = new Vector();
        this.m_triangleInfo = new Vector();
        this.m_elementTexture = new Vector();
        this.m_elementColor = new Vector();
        this.m_elementBackColor = new Vector();
        this.m_elementNormal = new Vector();
        this.m_vertexTexture = new Vector();
        this.m_vertexColor = new Vector();
        this.m_vertexNormal = new Vector();
        this.m_tolerance = new PuDouble(PsConfig.getMessage((int)54434), (PsUpdateIf)this);
        this.m_tolerance.setDefBounds(0.0, 1.0, 0.01, 0.1);
        this.m_tolerance.init();
        this.m_tolerance.setValue(0.1);
        this.m_maxNumSteps = new PuInteger(PsConfig.getMessage((int)54435), (PsUpdateIf)this);
        this.m_maxNumSteps.setDefBounds(1, 20, 1, 5);
        this.m_maxNumSteps.init();
        this.m_maxNumSteps.setValue(5);
        this.m_percentage = new PuDouble(PsConfig.getMessage((int)54436), (PsUpdateIf)this);
        this.m_percentage.setDefBounds(0.0, 100.0, 1.0, 10.0);
        this.m_percentage.init();
        this.m_percentage.setValue(10.0);
    }

    public void setGeometry(PgElementSet pgElementSet) {
        super.setGeometry((PgGeometry)pgElementSet);
        this.m_elementSet = pgElementSet;
        this.init();
    }

    public void setScheme(int n) {
        this.m_subdivisionScheme = n;
        this.init();
    }

    public void init() {
        Object object;
        int n;
        int n2;
        Object object2;
        super.init();
        if (this.m_elementSet.getDimOfElements() != 3) {
            PgElementSet.triangulate((PgElementSet)this.m_elementSet);
        }
        if (!this.m_elementSet.checkNeighbour(false)) {
            PsDebug.warning((String)"Neighbourhood information not correct.");
            this.m_elementSet.makeNeighbour();
        }
        this.m_bHasBoundary = this.m_elementSet.hasBoundary();
        if (this.m_bHasBoundary) {
            object2 = this.m_elementSet.getBoundaries();
            int n3 = ((PgBndPolygon[])object2).length;
            this.m_boundary = new PiVector[n3];
            for (n2 = 0; n2 < n3; ++n2) {
                this.m_boundary[n2] = PiVector.copyNew((PiVector)object2[n2].getVertexInd());
                this.m_boundary[n2].setSize(object2[n2].getNumVertices());
            }
        }
        this.m_origNoe = this.m_noe = this.m_elementSet.getNumElements();
        this.m_novAll = this.m_nov = this.m_elementSet.getNumVertices();
        this.m_vertex.removeAllElements();
        this.m_vertexInsert.removeAllElements();
        this.m_vertexCOG.removeAllElements();
        this.m_vertexInfo.removeAllElements();
        this.m_triangleInfo.removeAllElements();
        object2 = new PgVertexStar();
        boolean[] blArray = new boolean[this.m_nov];
        for (n2 = 0; n2 < this.m_nov; ++n2) {
            blArray[n2] = false;
        }
        int[] nArray = new int[this.m_nov];
        for (n2 = 0; n2 < this.m_noe; ++n2) {
            PiVector piVector = this.m_elementSet.getElement(n2);
            for (n = 0; n < 3; ++n) {
                if (blArray[piVector.m_data[n]]) continue;
                blArray[piVector.m_data[n]] = true;
                nArray[piVector.m_data[n]] = n2;
            }
            PiVector piVector2 = this.m_elementSet.getNeighbour(n2);
            object = new int[7];
            object[PwLocalButterfly.TRIANGLE_TYPE] = START;
            object[1] = piVector.m_data[0];
            object[2] = piVector.m_data[1];
            object[3] = piVector.m_data[2];
            object[4] = piVector2.m_data[0];
            object[5] = piVector2.m_data[1];
            object[6] = piVector2.m_data[2];
            this.m_triangleInfo.addElement(object);
        }
        this.m_bHasElementTexture = this.m_elementSet.hasElementTextures();
        this.m_elementTexture.removeAllElements();
        if (this.m_bHasElementTexture) {
            for (n2 = 0; n2 < this.m_noe; ++n2) {
                this.m_elementTexture.addElement(this.m_elementSet.getElementTexture(n2));
            }
        }
        this.m_bHasElementColors = this.m_elementSet.hasElementColors();
        this.m_elementColor.removeAllElements();
        this.m_bHasElementBackColors = this.m_elementSet.hasElementBackColors();
        this.m_elementBackColor.removeAllElements();
        if (this.m_bHasElementColors) {
            for (n2 = 0; n2 < this.m_noe; ++n2) {
                this.m_elementColor.addElement(this.m_elementSet.getElementColor(n2));
            }
        }
        if (this.m_bHasElementBackColors) {
            for (n2 = 0; n2 < this.m_noe; ++n2) {
                this.m_elementBackColor.addElement(this.m_elementSet.getElementBackColor(n2));
            }
        }
        this.m_bHasElementNormals = this.m_elementSet.hasElementNormals();
        this.m_elementNormal.removeAllElements();
        if (this.m_bHasElementNormals) {
            for (n2 = 0; n2 < this.m_noe; ++n2) {
                this.m_elementNormal.addElement(this.m_elementSet.getElementNormal(n2));
            }
        }
        this.m_numVectorFields = this.m_elementSet.getNumVectorFields();
        this.m_vectorField = new Vector[this.m_numVectorFields];
        this.m_vectorFieldIsBasedOn = new int[this.m_numVectorFields];
        for (n2 = 0; n2 < this.m_numVectorFields; ++n2) {
            object = this.m_elementSet.getVectorField(n2);
            this.m_vectorFieldIsBasedOn[n2] = object.getBasedOn();
            this.m_vectorField[n2] = new Vector();
            if (this.m_vectorFieldIsBasedOn[n2] == 1) {
                for (n = 0; n < this.m_noe; ++n) {
                    this.m_vectorField[n2].addElement(object.getVector(n));
                }
                continue;
            }
            for (n = 0; n < this.m_nov; ++n) {
                this.m_vectorField[n2].addElement(object.getVector(n));
            }
        }
        for (n2 = 0; n2 < this.m_nov; ++n2) {
            ((PgVertexStar)((Object)object2)).makeVertexStar(this.m_elementSet, n2, nArray[n2]);
            PiVector piVector = ((PgVertexStar)((Object)object2)).getLink();
            int n4 = piVector.getSize();
            object = new int[NN_START + n4];
            object[PwLocalButterfly.INDEX] = n2;
            object[PwLocalButterfly.REFINEMENT_GRADE] = 0;
            object[PwLocalButterfly.SUBDIVISION_GRADE] = 0;
            object[PwLocalButterfly.PARENT_EDGE_0] = -1;
            object[PwLocalButterfly.PARENT_EDGE_1] = -1;
            object[PwLocalButterfly.POSITION] = ((PgVertexStar)((Object)object2)).isClosed() ? INTERIOR : BOUNDARY;
            for (n = 0; n < n4; ++n) {
                object[PwLocalButterfly.NN_START + n] = piVector.m_data[n];
            }
            this.m_vertexInfo.addElement(object);
            if (this.m_subdivisionScheme != LOOP) {
                this.m_vertex.addElement(this.m_elementSet.getVertex(n2));
            }
            if (this.m_subdivisionScheme != LOOP) continue;
            this.m_vertexInsert.addElement(PdVector.copyNew((PdVector)this.m_elementSet.getVertex(n2)));
            PdVector pdVector = new PdVector(this.m_elementSet.getDimOfVertices());
            pdVector.setConstant(0.0);
            if (object[POSITION] == INTERIOR) {
                for (n = 0; n < n4; ++n) {
                    pdVector.add(this.m_elementSet.getVertex(piVector.m_data[n]));
                }
                pdVector.multScalar(1.0 / (double)n4);
            } else {
                pdVector = PdVector.blendNew((double)0.5, (PdVector)this.m_elementSet.getVertex(piVector.m_data[0]), (double)0.5, (PdVector)this.m_elementSet.getVertex(piVector.m_data[piVector.getSize() - 1]));
            }
            this.m_vertexCOG.addElement(pdVector);
        }
        this.m_bHasVertexTexture = this.m_elementSet.hasVertexTextures();
        this.m_vertexTexture.removeAllElements();
        if (this.m_bHasVertexTexture) {
            for (n2 = 0; n2 < this.m_nov; ++n2) {
                this.m_vertexTexture.addElement(this.m_elementSet.getVertexTexture(n2));
            }
        }
        this.m_bHasVertexColors = this.m_elementSet.hasVertexColors();
        this.m_vertexColor.removeAllElements();
        if (this.m_bHasVertexColors) {
            for (n2 = 0; n2 < this.m_nov; ++n2) {
                this.m_vertexColor.addElement(this.m_elementSet.getVertexColor(n2));
            }
        }
        this.m_bHasVertexNormals = this.m_elementSet.hasVertexNormals();
        this.m_vertexNormal.removeAllElements();
        if (this.m_bHasVertexNormals) {
            for (n2 = 0; n2 < this.m_nov; ++n2) {
                this.m_vertexNormal.addElement(this.m_elementSet.getVertexNormal(n2));
            }
        }
    }

    public void markBySize() {
        int n;
        int n2 = (int)(this.m_percentage.getValue() * (double)this.m_noe) / 100;
        if (n2 > this.m_noe) {
            n2 = this.m_noe;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        double[] dArray = new double[this.m_noe];
        for (n = 0; n < this.m_noe; ++n) {
            dArray[n] = this.m_elementSet.getAreaOfElement(n);
        }
        int[] nArray = new int[this.m_noe];
        PuMath.heapsort((int)this.m_noe, (double[])dArray, (int[])nArray);
        for (n = this.m_noe - 1; n >= this.m_noe - n2; --n) {
            this.m_elementSet.setTagElement(nArray[n], 1);
        }
        for (n = this.m_noe - n2 - 1; n >= 0; --n) {
            this.m_elementSet.clearTagElement(nArray[n], 1);
        }
    }

    public boolean update(Object object) {
        if (object == this.m_percentage) {
            this.markBySize();
            return this.m_elementSet.update((Object)this.m_elementSet);
        }
        if (object == this.m_tolerance) {
            this.markByCurvature();
            return this.m_elementSet.update((Object)this.m_elementSet);
        }
        if (object == this.m_maxNumSteps) {
            return true;
        }
        return super.update(object);
    }

    public void unselectAllElements() {
        for (int i = 0; i < this.m_noe; ++i) {
            this.m_elementSet.clearTagElement(i, 1);
        }
    }

    public void refineByCurvature() {
        int n = 1;
        int n2 = this.m_maxNumSteps.getValue();
        for (int i = 0; n > 0 && i < n2; ++i) {
            this.refine();
            n = this.markByCurvature();
        }
    }

    private int markByCurvature() {
        int n;
        int n2;
        double d = this.m_tolerance.getValue();
        PdVector pdVector = new PdVector(this.m_nov);
        PwCurvature.getGaussCurvature(this.m_elementSet, pdVector);
        this.m_elementSet.markBoundary();
        for (n2 = 0; n2 < this.m_nov; ++n2) {
            if (!this.m_elementSet.hasTagVertex(n2, 14)) continue;
            int n3 = n2;
            pdVector.m_data[n3] = pdVector.m_data[n3] * 2.0;
        }
        if (this.m_bHasBoundary) {
            n = this.m_boundary.length;
            for (n2 = 0; n2 < n; ++n2) {
                int n4 = this.m_boundary[n2].getSize();
                pdVector.m_data[this.m_boundary[n2].m_data[0]] = 0.0;
                pdVector.m_data[this.m_boundary[n2].m_data[n4 - 1]] = 0.0;
            }
        }
        for (n2 = 0; n2 < this.m_noe; ++n2) {
            this.m_elementSet.clearTagElement(n2, 1);
        }
        n = 0;
        for (n2 = 0; n2 < this.m_noe; ++n2) {
            if (!(Math.abs(pdVector.m_data[this.m_elementSet.getElement((int)n2).m_data[0]]) > d) && !(Math.abs(pdVector.m_data[this.m_elementSet.getElement((int)n2).m_data[1]]) > d) && !(Math.abs(pdVector.m_data[this.m_elementSet.getElement((int)n2).m_data[2]]) > d)) continue;
            this.m_elementSet.setTagElement(n2, 1);
            ++n;
        }
        return n;
    }

    public void refine() {
        int n;
        int n2;
        int[] nArray;
        int n3;
        for (n3 = 0; n3 < this.m_origNoe; ++n3) {
            if (!this.m_elementSet.hasTagElement(n3, 1)) continue;
            this.refineTriangle(n3);
        }
        this.m_elementSet.setNumElements(this.m_noe);
        PiVector[] piVectorArray = new PiVector[this.m_noe];
        PiVector[] piVectorArray2 = new PiVector[this.m_noe];
        for (n3 = 0; n3 < this.m_noe; ++n3) {
            nArray = (int[])this.m_triangleInfo.elementAt(n3);
            piVectorArray[n3] = new PiVector(((int[])this.m_vertexInfo.elementAt(nArray[1]))[INDEX], ((int[])this.m_vertexInfo.elementAt(nArray[2]))[INDEX], ((int[])this.m_vertexInfo.elementAt(nArray[3]))[INDEX]);
            piVectorArray2[n3] = new PiVector(nArray[4], nArray[5], nArray[6]);
            if (this.m_subdivisionScheme != LOOP) continue;
            n2 = 0;
            for (n = 0; n < 3; ++n) {
                if (((int[])this.m_vertexInfo.elementAt(piVectorArray[n3].m_data[n]))[REFINEMENT_GRADE] <= n2) continue;
                n2 = ((int[])this.m_vertexInfo.elementAt(piVectorArray[n3].m_data[n]))[REFINEMENT_GRADE];
            }
            for (n = 0; n < 3; ++n) {
                if (((int[])this.m_vertexInfo.elementAt(piVectorArray[n3].m_data[n]))[SUBDIVISION_GRADE] >= n2) continue;
                ((int[])this.m_vertexInfo.elementAt((int)piVectorArray[n3].m_data[n]))[PwLocalButterfly.SUBDIVISION_GRADE] = n2;
            }
        }
        this.m_elementSet.setElements(piVectorArray);
        this.m_elementSet.setNeighbours(piVectorArray2);
        this.m_elementSet.setNumVertices(this.m_nov);
        if (this.m_subdivisionScheme == LOOP) {
            this.m_vertex.removeAllElements();
        }
        for (n3 = 0; n3 < this.m_novAll; ++n3) {
            nArray = (int[])this.m_vertexInfo.elementAt(n3);
            if (this.m_subdivisionScheme == LOOP) {
                this.m_vertex.addElement(this.positionForLevel(n3, nArray[SUBDIVISION_GRADE]));
            }
            if (this.m_bVertexNameByLevel) {
                ((PdVector)this.m_vertex.elementAt(n3)).setName("" + nArray[REFINEMENT_GRADE] + "/" + nArray[SUBDIVISION_GRADE]);
            }
            if (nArray[INDEX] == -1) continue;
            this.m_elementSet.setVertex(nArray[INDEX], (PdVector)this.m_vertex.elementAt(n3));
        }
        if (this.m_bHasBoundary) {
            n2 = this.m_boundary.length;
            PgBndPolygon[] pgBndPolygonArray = this.m_elementSet.getBoundaries();
            for (n3 = 0; n3 < n2; ++n3) {
                int n4 = this.m_boundary[n3].getSize();
                int n5 = 0;
                for (n = 0; n < n4; ++n) {
                    if (((int[])this.m_vertexInfo.elementAt(this.m_boundary[n3].m_data[n]))[INDEX] <= -1) continue;
                    ++n5;
                }
                pgBndPolygonArray[n3].setNumVertices(n5);
                PiVector piVector = pgBndPolygonArray[n3].getVertexInd();
                n5 = 0;
                for (n = 0; n < n4; ++n) {
                    if (((int[])this.m_vertexInfo.elementAt(this.m_boundary[n3].m_data[n]))[INDEX] <= -1) continue;
                    piVector.m_data[n5] = ((int[])this.m_vertexInfo.elementAt(this.m_boundary[n3].m_data[n]))[INDEX];
                    ++n5;
                }
                pgBndPolygonArray[n3].assignVertices();
                pgBndPolygonArray[n3].makeElementInd();
            }
        }
        if (this.m_bHasElementTexture) {
            for (n3 = 0; n3 < this.m_noe; ++n3) {
                this.m_elementSet.setElementTexture(n3, (PdVector[])this.m_elementTexture.elementAt(n3));
            }
        }
        if (this.m_bHasElementColors) {
            this.m_elementSet.assureElementColors();
            for (n3 = 0; n3 < this.m_noe; ++n3) {
                this.m_elementSet.setElementColor(n3, (Color)this.m_elementColor.elementAt(n3));
            }
        }
        if (this.m_bHasElementBackColors) {
            this.m_elementSet.assureElementBackColors();
            for (n3 = 0; n3 < this.m_noe; ++n3) {
                this.m_elementSet.setElementBackColor(n3, (Color)this.m_elementBackColor.elementAt(n3));
            }
        }
        if (this.m_bHasElementNormals) {
            this.m_elementSet.makeElementNormals();
        }
        for (n3 = 0; n3 < this.m_numVectorFields; ++n3) {
            PgVectorField pgVectorField = this.m_elementSet.getVectorField(n3);
            if (this.m_vectorFieldIsBasedOn[n3] == 1) {
                pgVectorField.setNumVectors(this.m_noe);
                for (n = 0; n < this.m_noe; ++n) {
                    pgVectorField.setVector(n, (PdVector)this.m_vectorField[n3].elementAt(n));
                }
                continue;
            }
            pgVectorField.setNumVectors(this.m_nov);
            for (n = 0; n < this.m_novAll; ++n) {
                nArray = (int[])this.m_vertexInfo.elementAt(n);
                if (nArray[INDEX] == -1) continue;
                pgVectorField.setVector(nArray[INDEX], (PdVector)this.m_vectorField[n3].elementAt(n));
            }
        }
        if (this.m_bHasVertexTexture) {
            this.m_elementSet.assureVertexTextures();
            for (n3 = 0; n3 < this.m_novAll; ++n3) {
                nArray = (int[])this.m_vertexInfo.elementAt(n3);
                if (nArray[INDEX] == -1) continue;
                this.m_elementSet.setVertexTexture(nArray[INDEX], (PdVector)this.m_vertexTexture.elementAt(n3));
            }
        }
        if (this.m_bHasVertexColors) {
            this.m_elementSet.assureVertexColors();
            for (n3 = 0; n3 < this.m_novAll; ++n3) {
                nArray = (int[])this.m_vertexInfo.elementAt(n3);
                if (nArray[INDEX] == -1) continue;
                this.m_elementSet.setVertexColor(nArray[INDEX], (Color)this.m_vertexColor.elementAt(n3));
            }
        }
        if (this.m_bHasVertexNormals) {
            this.m_elementSet.makeVertexNormals();
        }
        this.m_elementSet.update((Object)this.m_elementSet);
        this.m_origNoe = this.m_noe;
    }

    private void refineTriangle(int n) {
        PdVector[] pdVectorArray;
        Object[] objectArray;
        int n2;
        int[] nArray;
        int n3;
        int[] nArray2;
        int[] nArray3;
        int n4;
        if (n < this.m_origNoe) {
            this.m_elementSet.clearTagElement(n, 1);
        }
        if ((n4 = (nArray3 = (int[])this.m_triangleInfo.elementAt(n))[4]) != -1) {
            nArray2 = (int[])this.m_triangleInfo.elementAt(n4);
            if (nArray3[TRIANGLE_TYPE] == R_RIGHT && nArray2[TRIANGLE_TYPE] != L_LEFT || nArray3[TRIANGLE_TYPE] == L_LEFT && nArray2[TRIANGLE_TYPE] != R_RIGHT) {
                this.refineTriangle(n4);
                n4 = nArray3[4];
                nArray2 = (int[])this.m_triangleInfo.elementAt(n4);
            }
        }
        if (nArray3[TRIANGLE_TYPE] == R_RIGHT || nArray3[TRIANGLE_TYPE] == L_LEFT) {
            nArray2 = (int[])this.m_triangleInfo.elementAt(n4);
            n3 = this.refineEdge(nArray3[1], nArray2[1]);
        } else {
            n3 = this.refineEdge(nArray3[2], nArray3[3]);
        }
        ((int[])this.m_vertexInfo.elementAt((int)n3))[PwLocalButterfly.INDEX] = this.m_nov++;
        int n5 = n;
        int n6 = this.m_noe;
        Object[] objectArray2 = new int[7];
        if (nArray3[TRIANGLE_TYPE] == START) {
            nArray3[PwLocalButterfly.TRIANGLE_TYPE] = RIGHT;
            objectArray2[PwLocalButterfly.TRIANGLE_TYPE] = LEFT;
        } else if (nArray3[TRIANGLE_TYPE] == LEFT) {
            nArray3[PwLocalButterfly.TRIANGLE_TYPE] = START;
            objectArray2[PwLocalButterfly.TRIANGLE_TYPE] = L_LEFT;
        } else if (nArray3[TRIANGLE_TYPE] == RIGHT) {
            nArray3[PwLocalButterfly.TRIANGLE_TYPE] = R_RIGHT;
            objectArray2[PwLocalButterfly.TRIANGLE_TYPE] = START;
        } else if (nArray3[TRIANGLE_TYPE] == L_LEFT || nArray3[TRIANGLE_TYPE] == R_RIGHT) {
            nArray3[PwLocalButterfly.TRIANGLE_TYPE] = LEFT;
            objectArray2[PwLocalButterfly.TRIANGLE_TYPE] = RIGHT;
        }
        objectArray2[1] = n3;
        objectArray2[2] = nArray3[1];
        objectArray2[3] = nArray3[2];
        nArray3[2] = nArray3[3];
        nArray3[3] = nArray3[1];
        nArray3[1] = n3;
        if (nArray3[6] != -1) {
            nArray = (int[])this.m_triangleInfo.elementAt(nArray3[6]);
            for (n2 = 4; n2 < 7; ++n2) {
                if (nArray[n2] != n5) continue;
                nArray[n2] = n6;
                break;
            }
        }
        objectArray2[4] = nArray3[6];
        nArray3[4] = nArray3[5];
        objectArray2[6] = n5;
        nArray3[5] = n6;
        this.m_triangleInfo.addElement(objectArray2);
        ++this.m_noe;
        if (this.m_bHasElementTexture) {
            objectArray = (PdVector[])this.m_elementTexture.elementAt(n);
            pdVectorArray = new PdVector[]{PdVector.blendNew((double)0.5, (PdVector)objectArray[1], (double)0.5, (PdVector)objectArray[2]), PdVector.copyNew((PdVector)objectArray[0]), objectArray[1]};
            objectArray[1] = objectArray[2];
            objectArray[2] = objectArray[0];
            objectArray[0] = PdVector.copyNew((PdVector)pdVectorArray[0]);
            this.m_elementTexture.addElement(pdVectorArray);
        }
        if (this.m_bHasElementColors) {
            this.m_elementColor.addElement(this.m_elementColor.elementAt(n));
        }
        if (this.m_bHasElementBackColors) {
            this.m_elementBackColor.addElement(this.m_elementBackColor.elementAt(n));
        }
        if (this.m_bHasElementNormals) {
            this.m_elementNormal.addElement(PdVector.copyNew((PdVector)((PdVector)this.m_elementNormal.elementAt(n))));
        }
        for (n2 = 0; n2 < this.m_numVectorFields; ++n2) {
            if (this.m_vectorFieldIsBasedOn[n2] != 1) continue;
            this.m_vectorField[n2].addElement(PdVector.copyNew((PdVector)((PdVector)this.m_vectorField[n2].elementAt(n))));
        }
        while (true) {
            PdVector[] pdVectorArray2;
            PdVector[] pdVectorArray3;
            int n7;
            int n8;
            PdVector[] pdVectorArray4;
            int n9;
            int n10;
            int n11;
            if (n4 == -1) {
                if (nArray3[1] == n3) {
                    nArray3[6] = -1;
                } else {
                    nArray3[4] = -1;
                }
                if (objectArray2[1] == n3) {
                    objectArray2[5] = -1;
                    break;
                }
                objectArray2[4] = -1;
                break;
            }
            if (n4 < this.m_origNoe && this.m_elementSet.hasTagElement(n4, 1)) {
                this.m_elementSet.clearTagElement(n4, 1);
            }
            if ((n11 = (nArray2 = (int[])this.m_triangleInfo.elementAt(n4))[4]) == n5) {
                n10 = n4;
                n9 = this.m_noe;
                objectArray = new int[7];
                if (nArray2[TRIANGLE_TYPE] == START) {
                    nArray2[PwLocalButterfly.TRIANGLE_TYPE] = RIGHT;
                    objectArray[PwLocalButterfly.TRIANGLE_TYPE] = (PdVector)LEFT;
                } else if (nArray2[TRIANGLE_TYPE] == LEFT) {
                    nArray2[PwLocalButterfly.TRIANGLE_TYPE] = START;
                    objectArray[PwLocalButterfly.TRIANGLE_TYPE] = (PdVector)L_LEFT;
                } else if (nArray2[TRIANGLE_TYPE] == RIGHT) {
                    nArray2[PwLocalButterfly.TRIANGLE_TYPE] = R_RIGHT;
                    objectArray[PwLocalButterfly.TRIANGLE_TYPE] = (PdVector)START;
                } else if (nArray2[TRIANGLE_TYPE] == L_LEFT || nArray2[TRIANGLE_TYPE] == R_RIGHT) {
                    nArray2[PwLocalButterfly.TRIANGLE_TYPE] = LEFT;
                    objectArray[PwLocalButterfly.TRIANGLE_TYPE] = (PdVector)RIGHT;
                }
                objectArray[1] = (PdVector)n3;
                objectArray[2] = (PdVector)nArray2[1];
                objectArray[3] = (PdVector)nArray2[2];
                nArray2[2] = nArray2[3];
                nArray2[3] = nArray2[1];
                nArray2[1] = n3;
                if (nArray2[6] != -1) {
                    nArray = (int[])this.m_triangleInfo.elementAt(nArray2[6]);
                    for (n2 = 4; n2 < 7; ++n2) {
                        if (nArray[n2] != n4) continue;
                        nArray[n2] = n9;
                        break;
                    }
                }
                objectArray[4] = (PdVector)nArray2[6];
                nArray2[4] = nArray2[5];
                objectArray[6] = (PdVector)n10;
                nArray2[5] = n9;
                if (nArray3[2] == nArray2[2] || nArray3[3] == nArray2[2]) {
                    if (nArray3[1] == n3) {
                        nArray3[6] = n10;
                    } else {
                        nArray3[4] = n10;
                    }
                    if (objectArray2[1] == n3) {
                        objectArray2[5] = n9;
                    } else {
                        objectArray2[4] = n9;
                    }
                    nArray2[6] = n5;
                    objectArray[5] = (PdVector)n6;
                } else {
                    if (nArray3[1] == n3) {
                        nArray3[6] = n9;
                    } else {
                        nArray3[4] = n9;
                    }
                    if (objectArray2[1] == n3) {
                        objectArray2[5] = n10;
                    } else {
                        objectArray2[4] = n10;
                    }
                    nArray2[6] = n6;
                    objectArray[5] = (PdVector)n5;
                }
                this.m_triangleInfo.addElement(objectArray);
                ++this.m_noe;
                if (this.m_bHasElementTexture) {
                    pdVectorArray = (PdVector[])this.m_elementTexture.elementAt(n4);
                    pdVectorArray4 = new PdVector[]{PdVector.blendNew((double)0.5, (PdVector)pdVectorArray[1], (double)0.5, (PdVector)pdVectorArray[2]), PdVector.copyNew((PdVector)pdVectorArray[0]), pdVectorArray[1]};
                    pdVectorArray[1] = pdVectorArray[2];
                    pdVectorArray[2] = pdVectorArray[0];
                    pdVectorArray[0] = PdVector.copyNew((PdVector)pdVectorArray4[0]);
                    this.m_elementTexture.addElement(pdVectorArray4);
                }
                if (this.m_bHasElementColors) {
                    this.m_elementColor.addElement(this.m_elementColor.elementAt(n4));
                }
                if (this.m_bHasElementBackColors) {
                    this.m_elementBackColor.addElement(this.m_elementBackColor.elementAt(n4));
                }
                if (this.m_bHasElementNormals) {
                    this.m_elementNormal.addElement(PdVector.copyNew((PdVector)((PdVector)this.m_elementNormal.elementAt(n4))));
                }
                for (n2 = 0; n2 < this.m_numVectorFields; ++n2) {
                    if (this.m_vectorFieldIsBasedOn[n2] != 1) continue;
                    this.m_vectorField[n2].addElement(PdVector.copyNew((PdVector)((PdVector)this.m_vectorField[n2].elementAt(n4))));
                }
                break;
            }
            if (nArray2[TRIANGLE_TYPE] == R_RIGHT || nArray2[TRIANGLE_TYPE] == L_LEFT) {
                objectArray = (int[])this.m_triangleInfo.elementAt(n11);
                Object object = objectArray[TRIANGLE_TYPE] != L_LEFT && objectArray[TRIANGLE_TYPE] != R_RIGHT ? (Object)this.refineEdge((int)objectArray[2], (int)objectArray[3]) : objectArray[1];
                n8 = this.refineEdge(nArray2[1], (int)object);
            } else {
                n8 = this.refineEdge(nArray2[2], nArray2[3]);
            }
            ((int[])this.m_vertexInfo.elementAt((int)n8))[PwLocalButterfly.INDEX] = this.m_nov++;
            if (nArray2[6] == n5) {
                n10 = n4;
                n9 = this.m_noe;
                n7 = this.m_noe + 1;
                objectArray = new int[7];
                int[] nArray4 = new int[7];
                if (nArray2[TRIANGLE_TYPE] == START) {
                    nArray2[PwLocalButterfly.TRIANGLE_TYPE] = RIGHT;
                    objectArray[PwLocalButterfly.TRIANGLE_TYPE] = (PdVector)START;
                    nArray4[PwLocalButterfly.TRIANGLE_TYPE] = L_LEFT;
                } else if (nArray2[TRIANGLE_TYPE] == LEFT) {
                    nArray2[PwLocalButterfly.TRIANGLE_TYPE] = START;
                    objectArray[PwLocalButterfly.TRIANGLE_TYPE] = (PdVector)LEFT;
                    nArray4[PwLocalButterfly.TRIANGLE_TYPE] = RIGHT;
                } else if (nArray2[TRIANGLE_TYPE] == RIGHT) {
                    nArray2[PwLocalButterfly.TRIANGLE_TYPE] = R_RIGHT;
                    objectArray[PwLocalButterfly.TRIANGLE_TYPE] = (PdVector)RIGHT;
                    nArray4[PwLocalButterfly.TRIANGLE_TYPE] = LEFT;
                } else if (nArray2[TRIANGLE_TYPE] == L_LEFT || nArray2[TRIANGLE_TYPE] == R_RIGHT) {
                    nArray2[PwLocalButterfly.TRIANGLE_TYPE] = LEFT;
                    objectArray[PwLocalButterfly.TRIANGLE_TYPE] = (PdVector)R_RIGHT;
                    nArray4[PwLocalButterfly.TRIANGLE_TYPE] = START;
                }
                objectArray[1] = (PdVector)n3;
                objectArray[2] = (PdVector)nArray2[2];
                objectArray[3] = (PdVector)n8;
                nArray4[1] = n3;
                nArray4[2] = n8;
                nArray4[3] = nArray2[1];
                nArray2[2] = nArray2[3];
                nArray2[3] = nArray2[1];
                nArray2[1] = n8;
                nArray4[4] = n10;
                nArray2[4] = nArray2[5];
                objectArray[5] = (PdVector)n7;
                nArray4[6] = n9;
                nArray2[5] = n7;
                if (nArray3[2] == nArray2[3] || nArray3[3] == nArray2[3]) {
                    if (nArray3[1] == n3) {
                        nArray3[6] = n7;
                    } else {
                        nArray3[4] = n7;
                    }
                    if (objectArray2[1] == n3) {
                        objectArray2[5] = n9;
                    } else {
                        objectArray2[4] = n9;
                    }
                    nArray4[5] = n5;
                    objectArray[6] = (PdVector)n6;
                } else {
                    if (nArray3[1] == n3) {
                        nArray3[6] = n9;
                    } else {
                        nArray3[4] = n9;
                    }
                    if (objectArray2[1] == n3) {
                        objectArray2[5] = n7;
                    } else {
                        objectArray2[4] = n7;
                    }
                    nArray4[5] = n6;
                    objectArray[6] = (PdVector)n5;
                }
                this.m_triangleInfo.addElement(objectArray);
                this.m_triangleInfo.addElement(nArray4);
                this.m_noe += 2;
                if (this.m_bHasElementTexture) {
                    pdVectorArray4 = (PdVector[])this.m_elementTexture.elementAt(n4);
                    pdVectorArray3 = new PdVector[3];
                    pdVectorArray2 = new PdVector[3];
                    pdVectorArray3[0] = PdVector.blendNew((double)0.5, (PdVector)pdVectorArray4[0], (double)0.5, (PdVector)pdVectorArray4[1]);
                    pdVectorArray3[1] = pdVectorArray4[1];
                    pdVectorArray3[2] = PdVector.blendNew((double)0.5, (PdVector)pdVectorArray4[1], (double)0.5, (PdVector)pdVectorArray4[2]);
                    pdVectorArray2[0] = PdVector.copyNew((PdVector)pdVectorArray3[0]);
                    pdVectorArray2[1] = PdVector.copyNew((PdVector)pdVectorArray3[2]);
                    pdVectorArray2[2] = PdVector.copyNew((PdVector)pdVectorArray4[0]);
                    pdVectorArray4[1] = pdVectorArray4[2];
                    pdVectorArray4[2] = pdVectorArray4[0];
                    pdVectorArray4[0] = PdVector.copyNew((PdVector)pdVectorArray3[2]);
                    this.m_elementTexture.addElement(pdVectorArray3);
                    this.m_elementTexture.addElement(pdVectorArray2);
                }
                if (this.m_bHasElementColors) {
                    this.m_elementColor.addElement(this.m_elementColor.elementAt(n4));
                    this.m_elementColor.addElement(this.m_elementColor.elementAt(n4));
                }
                if (this.m_bHasElementBackColors) {
                    this.m_elementBackColor.addElement(this.m_elementBackColor.elementAt(n4));
                    this.m_elementBackColor.addElement(this.m_elementBackColor.elementAt(n4));
                }
                if (this.m_bHasElementNormals) {
                    this.m_elementNormal.addElement(PdVector.copyNew((PdVector)((PdVector)this.m_elementNormal.elementAt(n4))));
                    this.m_elementNormal.addElement(PdVector.copyNew((PdVector)((PdVector)this.m_elementNormal.elementAt(n4))));
                }
                for (n2 = 0; n2 < this.m_numVectorFields; ++n2) {
                    if (this.m_vectorFieldIsBasedOn[n2] != 1) continue;
                    this.m_vectorField[n2].addElement(PdVector.copyNew((PdVector)((PdVector)this.m_vectorField[n2].elementAt(n4))));
                    this.m_vectorField[n2].addElement(PdVector.copyNew((PdVector)((PdVector)this.m_vectorField[n2].elementAt(n4))));
                }
                n5 = n10;
                n6 = n9;
                nArray3 = nArray2;
                objectArray2 = objectArray;
            } else if (nArray2[5] == n5) {
                n10 = n4;
                n9 = this.m_noe;
                n7 = this.m_noe + 1;
                objectArray = new int[7];
                int[] nArray5 = new int[7];
                if (nArray2[TRIANGLE_TYPE] == START) {
                    nArray2[PwLocalButterfly.TRIANGLE_TYPE] = START;
                    objectArray[PwLocalButterfly.TRIANGLE_TYPE] = (PdVector)LEFT;
                    nArray5[PwLocalButterfly.TRIANGLE_TYPE] = R_RIGHT;
                } else if (nArray2[TRIANGLE_TYPE] == LEFT) {
                    nArray2[PwLocalButterfly.TRIANGLE_TYPE] = LEFT;
                    objectArray[PwLocalButterfly.TRIANGLE_TYPE] = (PdVector)L_LEFT;
                    nArray5[PwLocalButterfly.TRIANGLE_TYPE] = RIGHT;
                } else if (nArray2[TRIANGLE_TYPE] == RIGHT) {
                    nArray2[PwLocalButterfly.TRIANGLE_TYPE] = RIGHT;
                    objectArray[PwLocalButterfly.TRIANGLE_TYPE] = (PdVector)START;
                    nArray5[PwLocalButterfly.TRIANGLE_TYPE] = LEFT;
                } else if (nArray2[TRIANGLE_TYPE] == L_LEFT || nArray2[TRIANGLE_TYPE] == R_RIGHT) {
                    nArray2[PwLocalButterfly.TRIANGLE_TYPE] = L_LEFT;
                    objectArray[PwLocalButterfly.TRIANGLE_TYPE] = (PdVector)RIGHT;
                    nArray5[PwLocalButterfly.TRIANGLE_TYPE] = START;
                }
                objectArray[1] = (PdVector)n8;
                objectArray[2] = (PdVector)nArray2[1];
                objectArray[3] = (PdVector)nArray2[2];
                nArray5[1] = n3;
                nArray5[2] = nArray2[1];
                nArray5[3] = n8;
                nArray2[2] = n8;
                nArray2[1] = n3;
                nArray5[4] = n9;
                if (nArray2[6] != -1) {
                    nArray = (int[])this.m_triangleInfo.elementAt(nArray2[6]);
                    for (n2 = 4; n2 < 7; ++n2) {
                        if (nArray[n2] != n4) continue;
                        nArray[n2] = n9;
                        break;
                    }
                }
                objectArray[4] = (PdVector)nArray2[6];
                nArray2[6] = n7;
                objectArray[6] = (PdVector)n7;
                nArray5[5] = n10;
                if (nArray3[2] == nArray2[3] || nArray3[3] == nArray2[3]) {
                    if (nArray3[1] == n3) {
                        nArray3[6] = n10;
                    } else {
                        nArray3[4] = n10;
                    }
                    if (objectArray2[1] == n3) {
                        objectArray2[5] = n7;
                    } else {
                        objectArray2[4] = n7;
                    }
                    nArray5[6] = n6;
                    nArray2[5] = n5;
                } else {
                    if (nArray3[1] == n3) {
                        nArray3[6] = n7;
                    } else {
                        nArray3[4] = n7;
                    }
                    if (objectArray2[1] == n3) {
                        objectArray2[5] = n10;
                    } else {
                        objectArray2[4] = n10;
                    }
                    nArray5[6] = n5;
                    nArray2[5] = n6;
                }
                this.m_triangleInfo.addElement(objectArray);
                this.m_triangleInfo.addElement(nArray5);
                this.m_noe += 2;
                if (this.m_bHasElementTexture) {
                    pdVectorArray4 = (PdVector[])this.m_elementTexture.elementAt(n4);
                    pdVectorArray3 = new PdVector[3];
                    pdVectorArray2 = new PdVector[3];
                    pdVectorArray3[0] = PdVector.blendNew((double)0.5, (PdVector)pdVectorArray4[1], (double)0.5, (PdVector)pdVectorArray4[2]);
                    pdVectorArray3[1] = PdVector.copyNew((PdVector)pdVectorArray4[0]);
                    pdVectorArray3[2] = pdVectorArray4[1];
                    pdVectorArray2[0] = PdVector.blendNew((double)0.5, (PdVector)pdVectorArray4[0], (double)0.5, (PdVector)pdVectorArray4[2]);
                    pdVectorArray2[1] = pdVectorArray4[0];
                    pdVectorArray2[2] = PdVector.copyNew((PdVector)pdVectorArray3[0]);
                    pdVectorArray4[0] = PdVector.copyNew((PdVector)pdVectorArray2[0]);
                    pdVectorArray4[1] = PdVector.copyNew((PdVector)pdVectorArray2[2]);
                    this.m_elementTexture.addElement(pdVectorArray3);
                    this.m_elementTexture.addElement(pdVectorArray2);
                }
                if (this.m_bHasElementColors) {
                    this.m_elementColor.addElement(this.m_elementColor.elementAt(n4));
                    this.m_elementColor.addElement(this.m_elementColor.elementAt(n4));
                }
                if (this.m_bHasElementBackColors) {
                    this.m_elementBackColor.addElement(this.m_elementBackColor.elementAt(n4));
                    this.m_elementBackColor.addElement(this.m_elementBackColor.elementAt(n4));
                }
                if (this.m_bHasElementNormals) {
                    this.m_elementNormal.addElement(PdVector.copyNew((PdVector)((PdVector)this.m_elementNormal.elementAt(n4))));
                    this.m_elementNormal.addElement(PdVector.copyNew((PdVector)((PdVector)this.m_elementNormal.elementAt(n4))));
                }
                for (n2 = 0; n2 < this.m_numVectorFields; ++n2) {
                    if (this.m_vectorFieldIsBasedOn[n2] != 1) continue;
                    this.m_vectorField[n2].addElement(PdVector.copyNew((PdVector)((PdVector)this.m_vectorField[n2].elementAt(n4))));
                    this.m_vectorField[n2].addElement(PdVector.copyNew((PdVector)((PdVector)this.m_vectorField[n2].elementAt(n4))));
                }
                n5 = n10;
                n6 = n9;
                nArray3 = nArray2;
                objectArray2 = objectArray;
            }
            n3 = n8;
            n4 = n11;
        }
    }

    private int refineEdge(int n, int n2) {
        int n3;
        int[] nArray;
        int n4;
        int[] nArray2 = new int[]{n, n2};
        int[][] nArrayArray = new int[2][];
        int[] nArray3 = new int[2];
        for (n4 = 0; n4 < 2; ++n4) {
            nArrayArray[n4] = (int[])this.m_vertexInfo.elementAt(nArray2[n4]);
            nArray3[n4] = nArrayArray[n4].length;
        }
        boolean bl = true;
        for (n4 = NN_START; n4 < nArray3[0]; ++n4) {
            if (nArrayArray[0][n4] != nArray2[1]) continue;
            bl = false;
            break;
        }
        int n5 = Math.max(nArrayArray[0][REFINEMENT_GRADE], nArrayArray[1][REFINEMENT_GRADE]) + 1;
        if (bl) {
            for (n4 = NN_START; n4 < nArray3[0]; ++n4) {
                int n6 = nArrayArray[0][n4];
                if (n6 == -1) continue;
                int[] nArray4 = (int[])this.m_vertexInfo.elementAt(n6);
                while (nArray4[REFINEMENT_GRADE] > n5) {
                    n6 = ((int[])this.m_vertexInfo.elementAt(nArray4[PARENT_EDGE_0]))[REFINEMENT_GRADE] > ((int[])this.m_vertexInfo.elementAt(nArray4[PARENT_EDGE_1]))[REFINEMENT_GRADE] ? nArray4[PARENT_EDGE_0] : nArray4[PARENT_EDGE_1];
                    nArray4 = (int[])this.m_vertexInfo.elementAt(n6);
                }
                if ((nArray4[PARENT_EDGE_0] != nArray2[0] || nArray4[PARENT_EDGE_1] != nArray2[1]) && (nArray4[PARENT_EDGE_0] != nArray2[1] || nArray4[PARENT_EDGE_1] != nArray2[0])) continue;
                return n6;
            }
            PsDebug.warning((String)"Index of existing vertex not found.");
            return 0;
        }
        if (this.edgeIsBoundary(nArrayArray[0], nArray2[1])) {
            nArray = new int[NN_START + 4];
        } else {
            nArray = new int[NN_START + 6];
            nArray[PwLocalButterfly.POSITION] = INTERIOR;
        }
        nArray[PwLocalButterfly.INDEX] = -1;
        nArray[PwLocalButterfly.REFINEMENT_GRADE] = n5;
        nArray[PwLocalButterfly.SUBDIVISION_GRADE] = n5;
        nArray[PwLocalButterfly.PARENT_EDGE_0] = nArray2[0];
        nArray[PwLocalButterfly.PARENT_EDGE_1] = nArray2[1];
        nArray[PwLocalButterfly.NN_START + 0] = nArray2[0];
        nArray[PwLocalButterfly.NN_START + 3] = nArray2[1];
        int[] nArray5 = new int[2];
        block4: for (n4 = 0; n4 < 2; ++n4) {
            nArray5[n4] = -1;
            for (n3 = NN_START; n3 < nArray3[n4]; ++n3) {
                if (nArrayArray[n4][n3] != nArray2[1 - n4]) continue;
                nArray5[n4] = n3;
                continue block4;
            }
        }
        int[][] nArray6 = nArray[POSITION] == INTERIOR ? this.getButterflyVertices(nArray2, nArray5, nArrayArray, true) : this.getButterflyVertices(nArray2, nArray5, nArrayArray, false);
        for (n4 = 0; n4 < 2; ++n4) {
            nArrayArray[n4][nArray5[n4]] = this.m_novAll;
        }
        if (nArray[POSITION] == BOUNDARY && this.m_bHasBoundary) {
            int n7 = this.m_boundary.length;
            boolean bl2 = false;
            for (n4 = 0; n4 < n7; ++n4) {
                int n8 = this.m_boundary[n4].getSize();
                for (n3 = 0; n3 < n8 - 1; ++n3) {
                    if ((this.m_boundary[n4].m_data[n3] != nArray2[0] || this.m_boundary[n4].m_data[n3 + 1] != nArray2[1]) && (this.m_boundary[n4].m_data[n3] != nArray2[1] || this.m_boundary[n4].m_data[n3 + 1] != nArray2[0])) continue;
                    this.m_boundary[n4].setSize(n8 + 1);
                    for (int i = n8; i > n3 + 1; --i) {
                        this.m_boundary[n4].m_data[i] = this.m_boundary[n4].m_data[i - 1];
                    }
                    this.m_boundary[n4].m_data[n3 + 1] = this.m_novAll;
                    bl2 = true;
                    break;
                }
                if (bl2) break;
            }
        }
        int[][] nArray7 = new int[2][2];
        for (n4 = 0; n4 < 2; ++n4) {
            nArray7[n4][1] = nArray5[n4] == nArray3[n4] - 1 ? (nArray[POSITION] == INTERIOR ? NN_START : -1) : nArray5[n4] + 1;
            if (nArray5[n4] == NN_START) {
                if (nArray[POSITION] == INTERIOR) {
                    nArray7[n4][0] = nArray3[n4] - 1;
                    continue;
                }
                nArray7[n4][0] = -1;
                continue;
            }
            nArray7[n4][0] = nArray5[n4] - 1;
        }
        for (n4 = 0; n4 < 2; ++n4) {
            for (n3 = 0; n3 < 2; ++n3) {
                if (nArray7[n4][n3] == -1) continue;
                nArray7[n4][n3] = nArrayArray[n4][nArray7[n4][n3]];
            }
        }
        int[][] nArray8 = new int[2][2];
        for (n4 = 0; n4 < 2; ++n4) {
            for (n3 = 0; n3 < 2; ++n3) {
                if (nArray7[n4][n3] != -1) {
                    int[] nArray9 = (int[])this.m_vertexInfo.elementAt(nArray7[n4][n3]);
                    while (nArray9[REFINEMENT_GRADE] > n5) {
                        nArray7[n4][n3] = nArray9[PARENT_EDGE_0] == nArray2[n4] ? nArray9[PARENT_EDGE_1] : nArray9[PARENT_EDGE_0];
                        nArray9 = (int[])this.m_vertexInfo.elementAt(nArray7[n4][n3]);
                    }
                    if (nArray9[REFINEMENT_GRADE] == n5) {
                        if (nArray9[PARENT_EDGE_0] == nArray2[n4]) {
                            nArray8[n4][n3] = nArray9[PARENT_EDGE_1];
                            continue;
                        }
                        nArray8[n4][n3] = nArray9[PARENT_EDGE_0];
                        continue;
                    }
                    nArray8[n4][n3] = nArray7[n4][n3];
                    nArray7[n4][n3] = -1;
                    continue;
                }
                nArray8[n4][n3] = -1;
            }
        }
        int[][] nArray10 = new int[2][2];
        for (n4 = 0; n4 < 2; ++n4) {
            for (n3 = 0; n3 < 2; ++n3) {
                nArray10[n4][n3] = -1;
            }
        }
        boolean bl3 = false;
        for (n4 = 0; n4 < 2; ++n4) {
            for (n3 = 0; n3 < 2; ++n3) {
                if (nArray8[0][n4] != nArray8[1][n3] || nArray8[0][n4] == -1) continue;
                if (bl3) {
                    nArray10[0][1] = nArray7[0][n4];
                    nArray10[1][1] = nArray7[1][n3];
                    continue;
                }
                bl3 = true;
                nArray10[0][0] = nArray7[0][n4];
                nArray10[1][0] = nArray7[1][n3];
            }
        }
        nArray[PwLocalButterfly.NN_START + 1] = nArray10[0][0];
        nArray[PwLocalButterfly.NN_START + 2] = nArray10[1][0];
        if (nArray[POSITION] == INTERIOR) {
            nArray[PwLocalButterfly.NN_START + 4] = nArray10[1][1];
            nArray[PwLocalButterfly.NN_START + 5] = nArray10[0][1];
        }
        for (n4 = 0; n4 < 2; ++n4) {
            for (n3 = 0; n3 < 2; ++n3) {
                if (n3 != 0 && nArray[POSITION] != INTERIOR || nArray10[n4][n3] == -1) continue;
                int[] nArray11 = (int[])this.m_vertexInfo.elementAt(nArray10[n4][n3]);
                if (nArray10[1 - n4][n3] == -1) {
                    if (nArray11[NN_START + 1] == -1 && nArray11[NN_START + 2] == -1) {
                        if (nArray11[PARENT_EDGE_0] == nArray2[n4]) {
                            nArray11[PwLocalButterfly.NN_START + 1] = this.m_novAll;
                            continue;
                        }
                        nArray11[PwLocalButterfly.NN_START + 2] = this.m_novAll;
                        continue;
                    }
                    if (nArray11[PARENT_EDGE_1] == nArray2[n4]) {
                        nArray11[PwLocalButterfly.NN_START + 4] = this.m_novAll;
                        continue;
                    }
                    nArray11[PwLocalButterfly.NN_START + 5] = this.m_novAll;
                    continue;
                }
                if (nArray11[PARENT_EDGE_0] == nArray2[n4]) {
                    if (nArray11[NN_START + 2] == nArray10[1 - n4][n3]) {
                        nArray11[PwLocalButterfly.NN_START + 1] = this.m_novAll;
                        continue;
                    }
                    nArray11[PwLocalButterfly.NN_START + 5] = this.m_novAll;
                    continue;
                }
                if (nArray11[NN_START + 1] == nArray10[1 - n4][n3]) {
                    nArray11[PwLocalButterfly.NN_START + 2] = this.m_novAll;
                    continue;
                }
                nArray11[PwLocalButterfly.NN_START + 4] = this.m_novAll;
            }
        }
        int n9 = this.m_novAll++;
        this.m_vertexInfo.addElement(nArray);
        if (nArray[POSITION] == INTERIOR) {
            this.computeVertex(nArray6, true, nArray[REFINEMENT_GRADE]);
        } else {
            this.computeVertex(nArray6, false, nArray[REFINEMENT_GRADE]);
        }
        return n9;
    }

    private int[][] getButterflyVertices(int[] nArray, int[] nArray2, int[][] nArray3, boolean bl) {
        int n;
        int n2;
        int[] nArray4;
        int[] nArray5;
        int n3;
        int n4;
        int n5;
        int[] nArray6 = new int[2];
        for (n5 = 0; n5 < 2; ++n5) {
            nArray6[n5] = nArray3[n5].length;
        }
        int[][] nArray7 = new int[2][4];
        for (n5 = 0; n5 < 2; ++n5) {
            if (nArray2[n5] == NN_START) {
                if (bl) {
                    nArray7[n5][0] = nArray3[n5][nArray6[n5] - 2];
                    nArray7[n5][1] = nArray3[n5][nArray6[n5] - 1];
                } else {
                    nArray7[n5][0] = -2;
                    nArray7[n5][1] = -2;
                }
            } else if (nArray2[n5] == NN_START + 1) {
                nArray7[n5][1] = nArray3[n5][NN_START + 0];
                nArray7[n5][0] = this.edgeIsBoundary(nArray3[n5], nArray7[n5][1]) ? -2 : nArray3[n5][nArray6[n5] - 1];
            } else {
                nArray7[n5][0] = nArray3[n5][nArray2[n5] - 2];
                nArray7[n5][1] = nArray3[n5][nArray2[n5] - 1];
            }
            if (nArray2[n5] == nArray6[n5] - 1) {
                if (bl) {
                    nArray7[n5][3] = nArray3[n5][NN_START + 1];
                    nArray7[n5][2] = nArray3[n5][NN_START + 0];
                    continue;
                }
                nArray7[n5][3] = -2;
                nArray7[n5][2] = -2;
                continue;
            }
            if (nArray2[n5] == nArray6[n5] - 2) {
                nArray7[n5][2] = nArray3[n5][nArray6[n5] - 1];
                if (this.edgeIsBoundary(nArray3[n5], nArray7[n5][2])) {
                    nArray7[n5][3] = -2;
                    continue;
                }
                nArray7[n5][3] = nArray3[n5][NN_START];
                continue;
            }
            nArray7[n5][3] = nArray3[n5][nArray2[n5] + 2];
            nArray7[n5][2] = nArray3[n5][nArray2[n5] + 1];
        }
        if (nArray3[0][REFINEMENT_GRADE] == nArray3[1][REFINEMENT_GRADE]) {
            for (n5 = 0; n5 < 4; ++n5) {
                for (n4 = 0; n4 < 2; ++n4) {
                    if (nArray7[n4][n5] <= -1) continue;
                    n3 = nArray7[n4][n5];
                    nArray5 = (int[])this.m_vertexInfo.elementAt(n3);
                    while (nArray5[REFINEMENT_GRADE] > nArray3[0][REFINEMENT_GRADE]) {
                        n3 = nArray5[PARENT_EDGE_0] == nArray[n4] ? nArray5[PARENT_EDGE_1] : nArray5[PARENT_EDGE_0];
                        nArray5 = (int[])this.m_vertexInfo.elementAt(n3);
                    }
                    nArray7[n4][n5] = n3;
                }
            }
            if (nArray3[0][REFINEMENT_GRADE] != 0) {
                if (nArray7[0][1] == nArray7[1][1] && nArray7[0][1] == -1) {
                    nArray7[0][1] = this.refineEdge(nArray7[0][0], nArray7[1][0]);
                    nArray7[1][1] = nArray7[0][1];
                } else if (nArray7[0][1] == nArray7[1][2] && nArray7[0][1] == -1) {
                    nArray7[0][1] = this.refineEdge(nArray7[0][0], nArray7[1][3]);
                    nArray7[1][2] = nArray7[0][1];
                }
                if (nArray7[0][2] == nArray7[1][2] && nArray7[0][2] == -1) {
                    nArray7[0][2] = this.refineEdge(nArray7[0][3], nArray7[1][3]);
                    nArray7[1][2] = nArray7[0][2];
                } else if (nArray7[0][2] == nArray7[1][1] && nArray7[0][2] == -1) {
                    nArray7[0][2] = this.refineEdge(nArray7[0][3], nArray7[1][0]);
                    nArray7[1][1] = nArray7[0][2];
                }
                for (n4 = 0; n4 < 2; ++n4) {
                    for (int i = 0; i < 2; ++i) {
                        if (nArray7[n4][i * 3] != -1) continue;
                        int n6 = -1;
                        nArray5 = (int[])this.m_vertexInfo.elementAt(nArray7[n4][1 + i]);
                        int n7 = nArray5.length;
                        if (n4 == 1 && n7 == NN_START + 3 && nArray5[POSITION] == INTERIOR) {
                            if (nArray7[n4][1 + i] == nArray7[(n4 + 1) % 2][1]) {
                                nArray7[n4][i * 3] = nArray7[(n4 + 1) % 2][0];
                                continue;
                            }
                            nArray7[n4][i * 3] = nArray7[(n4 + 1) % 2][3];
                            continue;
                        }
                        for (n5 = NN_START; n5 < n7; ++n5) {
                            n3 = nArray5[n5];
                            if (nArray5[n5] != -1) {
                                nArray4 = (int[])this.m_vertexInfo.elementAt(n3);
                                while (nArray4[REFINEMENT_GRADE] > nArray3[0][REFINEMENT_GRADE]) {
                                    n3 = nArray4[PARENT_EDGE_0] == nArray7[n4][1 + i] ? nArray4[PARENT_EDGE_1] : nArray4[PARENT_EDGE_0];
                                    nArray4 = (int[])this.m_vertexInfo.elementAt(n3);
                                }
                            }
                            if (n3 != nArray[n4]) continue;
                            n6 = n5;
                            break;
                        }
                        n6 = n6 == NN_START ? ((nArray4 = (int[])this.m_vertexInfo.elementAt(nArray5[NN_START + 1]))[REFINEMENT_GRADE] < nArray3[0][REFINEMENT_GRADE] ? NN_START + 1 : n7 - 1) : ((nArray4 = (int[])this.m_vertexInfo.elementAt(nArray5[n6 - 1]))[REFINEMENT_GRADE] < nArray3[0][REFINEMENT_GRADE] ? --n6 : (n6 == n7 - 1 ? NN_START + 0 : ++n6));
                        n6 = this.refineEdge(nArray7[n4][1 + i], nArray5[n6]);
                        nArray5 = (int[])this.m_vertexInfo.elementAt(n6);
                        while (nArray5[REFINEMENT_GRADE] > nArray3[0][REFINEMENT_GRADE]) {
                            n6 = this.refineEdge(nArray7[n4][1 + i], n6);
                            nArray5 = (int[])this.m_vertexInfo.elementAt(n6);
                        }
                        nArray7[n4][i * 3] = n6;
                    }
                }
            }
        } else {
            int n8;
            if (nArray3[0][REFINEMENT_GRADE] < nArray3[1][REFINEMENT_GRADE]) {
                n2 = 0;
                n8 = 1;
            } else {
                n2 = 1;
                n8 = 0;
            }
            for (n5 = 0; n5 < 4; ++n5) {
                if (nArray7[n2][n5] == -2) continue;
                n3 = nArray7[n2][n5];
                nArray5 = (int[])this.m_vertexInfo.elementAt(n3);
                while (nArray5[REFINEMENT_GRADE] > nArray3[n8][REFINEMENT_GRADE]) {
                    n3 = nArray5[PARENT_EDGE_0] == nArray[n2] ? nArray5[PARENT_EDGE_1] : nArray5[PARENT_EDGE_0];
                    nArray5 = (int[])this.m_vertexInfo.elementAt(n3);
                }
                if (nArray5[REFINEMENT_GRADE] < nArray3[n8][REFINEMENT_GRADE]) {
                    n3 = this.refineEdge(n3, nArray[n2]);
                }
                nArray7[n2][n5] = n3;
            }
            for (n5 = 0; n5 < 2; ++n5) {
                if (nArray7[n8][n5 * 3] <= -1) continue;
                n3 = nArray7[n8][n5 * 3];
                nArray5 = (int[])this.m_vertexInfo.elementAt(n3);
                while (nArray5[REFINEMENT_GRADE] > nArray3[n8][REFINEMENT_GRADE]) {
                    n3 = nArray5[PARENT_EDGE_0] == nArray[n8] ? nArray5[PARENT_EDGE_1] : nArray5[PARENT_EDGE_0];
                    nArray5 = (int[])this.m_vertexInfo.elementAt(n3);
                }
                nArray7[n8][n5 * 3] = n3;
            }
            if (nArray7[n8][0] == -1 || nArray7[n8][3] == -1) {
                nArray5 = (int[])this.m_vertexInfo.elementAt(nArray[n8]);
                int n9 = nArray5[PARENT_EDGE_0] == nArray[n2] ? nArray5[PARENT_EDGE_1] : nArray5[PARENT_EDGE_0];
                n = nArray7[n2][1] != -2 ? ((nArray5 = (int[])this.m_vertexInfo.elementAt(nArray7[n2][1]))[PARENT_EDGE_0] == nArray[n2] ? nArray5[PARENT_EDGE_1] : nArray5[PARENT_EDGE_0]) : -1;
                int n10 = nArray7[n2][2] != -2 ? ((nArray5 = (int[])this.m_vertexInfo.elementAt(nArray7[n2][2]))[PARENT_EDGE_0] == nArray[n2] ? nArray5[PARENT_EDGE_1] : nArray5[PARENT_EDGE_0]) : -1;
                if (nArray7[n8][0] > -1) {
                    nArray5 = (int[])this.m_vertexInfo.elementAt(nArray7[n8][0]);
                    nArray7[n8][3] = nArray5[PARENT_EDGE_0] == n || nArray5[PARENT_EDGE_1] == n ? this.refineEdge(n9, n10) : this.refineEdge(n9, n);
                } else if (nArray7[n8][3] > -1) {
                    nArray5 = (int[])this.m_vertexInfo.elementAt(nArray7[n8][3]);
                    nArray7[n8][0] = nArray5[PARENT_EDGE_0] == n || nArray5[PARENT_EDGE_1] == n ? this.refineEdge(n9, n10) : this.refineEdge(n9, n);
                } else {
                    if (nArray7[n8][3] != -2) {
                        nArray7[n8][3] = n10 != -1 ? this.refineEdge(n9, n10) : this.refineEdge(n9, n);
                    }
                    if (nArray7[n8][0] != -2) {
                        nArray7[n8][0] = n != -1 ? this.refineEdge(n9, n) : this.refineEdge(n9, n10);
                    }
                }
            }
            if (nArray7[n8][0] != -2) {
                nArray5 = (int[])this.m_vertexInfo.elementAt(nArray7[n8][0]);
                if (nArray7[n2][1] != -2) {
                    nArray4 = (int[])this.m_vertexInfo.elementAt(nArray7[n2][1]);
                    if (nArray5[PARENT_EDGE_0] == nArray4[PARENT_EDGE_0] || nArray5[PARENT_EDGE_1] == nArray4[PARENT_EDGE_0] || nArray5[PARENT_EDGE_0] == nArray4[PARENT_EDGE_1] || nArray5[PARENT_EDGE_1] == nArray4[PARENT_EDGE_1]) {
                        nArray7[n8][1] = nArray7[n2][1];
                        nArray7[n8][2] = nArray7[n2][2];
                    } else {
                        nArray7[n8][1] = nArray7[n2][2];
                        nArray7[n8][2] = nArray7[n2][1];
                    }
                } else {
                    nArray4 = (int[])this.m_vertexInfo.elementAt(nArray7[n2][2]);
                    if (nArray5[PARENT_EDGE_0] == nArray4[PARENT_EDGE_0] || nArray5[PARENT_EDGE_1] == nArray4[PARENT_EDGE_0] || nArray5[PARENT_EDGE_0] == nArray4[PARENT_EDGE_1] || nArray5[PARENT_EDGE_1] == nArray4[PARENT_EDGE_1]) {
                        nArray7[n8][1] = nArray7[n2][2];
                        nArray7[n8][2] = nArray7[n2][1];
                    } else {
                        nArray7[n8][1] = nArray7[n2][1];
                        nArray7[n8][2] = nArray7[n2][2];
                    }
                }
            } else if (nArray7[n8][3] != -2) {
                nArray5 = (int[])this.m_vertexInfo.elementAt(nArray7[n8][3]);
                if (nArray7[n2][1] != -2) {
                    nArray4 = (int[])this.m_vertexInfo.elementAt(nArray7[n2][1]);
                    if (nArray5[PARENT_EDGE_0] == nArray4[PARENT_EDGE_0] || nArray5[PARENT_EDGE_1] == nArray4[PARENT_EDGE_0] || nArray5[PARENT_EDGE_0] == nArray4[PARENT_EDGE_1] || nArray5[PARENT_EDGE_1] == nArray4[PARENT_EDGE_1]) {
                        nArray7[n8][1] = nArray7[n2][2];
                        nArray7[n8][2] = nArray7[n2][1];
                    } else {
                        nArray7[n8][1] = nArray7[n2][1];
                        nArray7[n8][2] = nArray7[n2][2];
                    }
                } else {
                    nArray4 = (int[])this.m_vertexInfo.elementAt(nArray7[n2][2]);
                    if (nArray5[PARENT_EDGE_0] == nArray4[PARENT_EDGE_0] || nArray5[PARENT_EDGE_1] == nArray4[PARENT_EDGE_0] || nArray5[PARENT_EDGE_0] == nArray4[PARENT_EDGE_1] || nArray5[PARENT_EDGE_1] == nArray4[PARENT_EDGE_1]) {
                        nArray7[n8][1] = nArray7[n2][1];
                        nArray7[n8][2] = nArray7[n2][2];
                    } else {
                        nArray7[n8][1] = nArray7[n2][2];
                        nArray7[n8][2] = nArray7[n2][1];
                    }
                }
            } else {
                nArray7[n8][1] = nArray7[n2][1];
                nArray7[n8][2] = nArray7[n2][2];
            }
        }
        int[][] nArrayArray = new int[2][];
        if (bl) {
            for (n5 = 0; n5 < 2; ++n5) {
                if (nArray3[n5][REFINEMENT_GRADE] == 0 && nArray3[n5][POSITION] == INTERIOR) {
                    if (nArray3[n5].length == NN_START + 3) {
                        nArrayArray[n5] = new int[3];
                        nArrayArray[n5][0] = nArray[(n5 + 1) % 2];
                        nArrayArray[n5][1] = nArray7[n5][1];
                        nArrayArray[n5][2] = nArray7[n5][2];
                        continue;
                    }
                    if (nArray3[n5].length == NN_START + 4) {
                        nArrayArray[n5] = new int[4];
                        nArrayArray[n5][0] = nArray[(n5 + 1) % 2];
                        nArrayArray[n5][1] = nArray7[n5][1];
                        nArrayArray[n5][2] = nArray7[n5][0];
                        nArrayArray[n5][3] = nArray7[n5][2];
                        continue;
                    }
                    if (nArray3[n5].length == NN_START + 5) {
                        nArrayArray[n5] = new int[5];
                        nArrayArray[n5][0] = nArray[(n5 + 1) % 2];
                        nArrayArray[n5][1] = nArray7[n5][2];
                        nArrayArray[n5][2] = nArray7[n5][3];
                        nArrayArray[n5][3] = nArray7[n5][0];
                        nArrayArray[n5][4] = nArray7[n5][1];
                        continue;
                    }
                    n2 = nArray3[n5].length - NN_START;
                    nArrayArray[n5] = new int[n2];
                    nArrayArray[n5][0] = nArray[(n5 + 1) % 2];
                    nArrayArray[n5][1] = nArray7[n5][2];
                    nArrayArray[n5][2] = nArray7[n5][3];
                    nArrayArray[n5][n2 - 2] = nArray7[n5][0];
                    nArrayArray[n5][n2 - 1] = nArray7[n5][1];
                    for (n4 = 3; n4 < n2 - 2; ++n4) {
                        nArrayArray[n5][n4] = nArray3[n5][NN_START + (nArray2[n5] - NN_START + n4) % n2];
                        nArray4 = (int[])this.m_vertexInfo.elementAt(nArrayArray[n5][n4]);
                        while (nArray4[REFINEMENT_GRADE] > nArray3[(n5 + 1) % 2][REFINEMENT_GRADE]) {
                            nArrayArray[n5][n4] = nArray4[PARENT_EDGE_0] == nArray[n5] ? nArray4[PARENT_EDGE_1] : nArray4[PARENT_EDGE_0];
                            nArray4 = (int[])this.m_vertexInfo.elementAt(nArrayArray[n5][n4]);
                        }
                        while (nArray4[REFINEMENT_GRADE] < nArray3[(n5 + 1) % 2][REFINEMENT_GRADE]) {
                            nArrayArray[n5][n4] = this.refineEdge(nArrayArray[n5][n4], nArray[n5]);
                            nArray4 = (int[])this.m_vertexInfo.elementAt(nArrayArray[n5][n4]);
                        }
                    }
                    continue;
                }
                nArrayArray[n5] = new int[5];
                nArrayArray[n5][0] = nArray[(n5 + 1) % 2];
                nArrayArray[n5][1] = nArray7[n5][2];
                nArrayArray[n5][2] = nArray7[n5][3];
                nArrayArray[n5][3] = nArray7[n5][0];
                nArrayArray[n5][4] = nArray7[n5][1];
            }
        } else {
            for (n5 = 0; n5 < 2; ++n5) {
                nArrayArray[n5] = new int[2];
                nArrayArray[n5][0] = nArray[(n5 + 1) % 2];
                nArray4 = (int[])this.m_vertexInfo.elementAt(nArray[n5]);
                nArrayArray[n5][1] = nArray4[NN_START] == nArray[(n5 + 1) % 2] ? nArray4[nArray4.length - 1] : nArray4[NN_START];
                nArray5 = (int[])this.m_vertexInfo.elementAt(nArrayArray[n5][0]);
                if (nArray5[REFINEMENT_GRADE] < nArray4[REFINEMENT_GRADE]) {
                    n2 = 0;
                    n = nArray4[REFINEMENT_GRADE] - 1;
                } else {
                    n = n2 = nArray5[REFINEMENT_GRADE];
                }
                nArray5 = (int[])this.m_vertexInfo.elementAt(nArrayArray[n5][1]);
                while (nArray5[REFINEMENT_GRADE] > n) {
                    nArrayArray[n5][1] = nArray5[PARENT_EDGE_0] == nArray[n5] ? nArray5[PARENT_EDGE_1] : nArray5[PARENT_EDGE_0];
                    nArray5 = (int[])this.m_vertexInfo.elementAt(nArrayArray[n5][1]);
                }
                while (nArray5[REFINEMENT_GRADE] < n2) {
                    nArrayArray[n5][1] = this.refineEdge(nArrayArray[n5][1], nArray[n5]);
                    nArray5 = (int[])this.m_vertexInfo.elementAt(nArrayArray[n5][1]);
                }
            }
        }
        return nArrayArray;
    }

    private void computeVertex(int[][] nArray, boolean bl, int n) {
        double[][] dArrayArray = new double[2][];
        PdVector pdVector = null;
        if (this.m_subdivisionScheme == BUTTERFLY) {
            int n2;
            int n3;
            int n4;
            boolean[] blArray = new boolean[2];
            if (bl) {
                for (n4 = 0; n4 < 2; ++n4) {
                    dArrayArray[n4] = new double[nArray[n4].length];
                    int[] nArray2 = (int[])this.m_vertexInfo.elementAt(nArray[(n4 + 1) % 2][0]);
                    if (nArray2[REFINEMENT_GRADE] == 0 && nArray2[POSITION] == INTERIOR) {
                        if (nArray[n4].length == 3) {
                            blArray[n4] = false;
                            dArrayArray[n4][0] = 0.4166666666666667;
                            dArrayArray[n4][1] = -0.08333333333333333;
                            dArrayArray[n4][2] = -0.08333333333333333;
                            continue;
                        }
                        if (nArray[n4].length == 4) {
                            blArray[n4] = false;
                            dArrayArray[n4][0] = 0.375;
                            dArrayArray[n4][1] = 0.0;
                            dArrayArray[n4][2] = -0.125;
                            dArrayArray[n4][3] = 0.0;
                            continue;
                        }
                        if (nArray[n4].length == 6) {
                            blArray[n4] = true;
                            dArrayArray[n4][0] = 0.5;
                            dArrayArray[n4][1] = 0.0625;
                            dArrayArray[n4][2] = -0.0625;
                            dArrayArray[n4][3] = 0.0;
                            dArrayArray[n4][4] = -0.0625;
                            dArrayArray[n4][5] = 0.0625;
                            continue;
                        }
                        n3 = nArray[n4].length;
                        blArray[n4] = false;
                        for (n2 = 0; n2 < n3; ++n2) {
                            dArrayArray[n4][n2] = (0.25 + Math.cos(Math.PI * 2 * (double)n2 / (double)n3) + Math.cos(Math.PI * 4 * (double)n2 / (double)n3) / 2.0) / (double)n3;
                        }
                        continue;
                    }
                    blArray[n4] = true;
                    dArrayArray[n4][0] = 0.5;
                    dArrayArray[n4][1] = 0.0625;
                    dArrayArray[n4][2] = -0.0625;
                    dArrayArray[n4][3] = -0.0625;
                    dArrayArray[n4][4] = 0.0625;
                    if (nArray[n4][2] < 0) {
                        double[] dArray = dArrayArray[n4];
                        dArray[1] = dArray[1] + dArrayArray[n4][2];
                    }
                    if (nArray[n4][3] < 0) {
                        double[] dArray = dArrayArray[n4];
                        dArray[4] = dArray[4] + dArrayArray[n4][3];
                    }
                    if (nArray[n4][1] < 0) {
                        double[] dArray = dArrayArray[n4];
                        dArray[4] = dArray[4] + dArrayArray[n4][1];
                    }
                    if (nArray[n4][4] >= 0) continue;
                    double[] dArray = dArrayArray[n4];
                    dArray[1] = dArray[1] + dArrayArray[n4][4];
                }
                for (n4 = 0; n4 < 2; ++n4) {
                    if (!blArray[n4] || blArray[(n4 + 1) % 2]) continue;
                    dArrayArray[n4][0] = 0.75;
                    for (n2 = 1; n2 < dArrayArray[n4].length; ++n2) {
                        dArrayArray[n4][n2] = 0.0;
                    }
                }
                if (!blArray[0] && !blArray[1]) {
                    double[] dArray = dArrayArray[0];
                    dArray[0] = dArray[0] + 0.75;
                    double[] dArray2 = dArrayArray[1];
                    dArray2[0] = dArray2[0] + 0.75;
                    for (n4 = 0; n4 < 2; ++n4) {
                        n2 = 0;
                        while (n2 < dArrayArray[n4].length) {
                            double[] dArray3 = dArrayArray[n4];
                            int n5 = n2++;
                            dArray3[n5] = dArray3[n5] / 2.0;
                        }
                    }
                }
            } else {
                for (n4 = 0; n4 < 2; ++n4) {
                    dArrayArray[n4] = new double[2];
                    dArrayArray[n4][0] = 0.5625;
                    dArrayArray[n4][1] = -0.0625;
                }
                if (this.m_bHasBoundary) {
                    n3 = this.m_boundary.length;
                    for (n4 = 0; n4 < 2; ++n4) {
                        for (n2 = 0; n2 < n3; ++n2) {
                            int n6 = this.m_boundary[n2].getSize();
                            if (this.m_boundary[n2].m_data[0] != nArray[n4][0] && this.m_boundary[n2].m_data[n6 - 1] != nArray[n4][0]) continue;
                            double[] dArray = dArrayArray[n4];
                            dArray[0] = dArray[0] + dArrayArray[(n4 + 1) % 2][1];
                            dArrayArray[(n4 + 1) % 2][1] = 0.0;
                        }
                    }
                }
            }
            pdVector = PdVector.blendNew((double)dArrayArray[0][0], (PdVector)((PdVector)this.m_vertex.elementAt(nArray[0][0])), (double)dArrayArray[1][0], (PdVector)((PdVector)this.m_vertex.elementAt(nArray[1][0])));
            for (n4 = 0; n4 < 2; ++n4) {
                for (n2 = 1; n2 < nArray[n4].length; ++n2) {
                    if (nArray[n4][n2] <= -1) continue;
                    pdVector.blendBase(pdVector, dArrayArray[n4][n2], (PdVector)this.m_vertex.elementAt(nArray[n4][n2]));
                }
            }
            for (n3 = 0; n3 < this.m_numVectorFields; ++n3) {
                if (this.m_vectorFieldIsBasedOn[n3] != 0) continue;
                PdVector pdVector2 = PdVector.blendNew((double)dArrayArray[0][0], (PdVector)((PdVector)this.m_vectorField[n3].elementAt(nArray[0][0])), (double)dArrayArray[1][0], (PdVector)((PdVector)this.m_vectorField[n3].elementAt(nArray[1][0])));
                for (n4 = 0; n4 < 2; ++n4) {
                    for (n2 = 1; n2 < nArray[n4].length; ++n2) {
                        if (nArray[n4][n2] <= -1) continue;
                        pdVector2.blendBase(pdVector2, dArrayArray[n4][n2], (PdVector)this.m_vectorField[n3].elementAt(nArray[n4][n2]));
                    }
                }
                this.m_vectorField[n3].addElement(pdVector2);
            }
            if (this.m_bHasVertexTexture) {
                PdVector pdVector3 = PdVector.blendNew((double)dArrayArray[0][0], (PdVector)((PdVector)this.m_vertexTexture.elementAt(nArray[0][0])), (double)dArrayArray[1][0], (PdVector)((PdVector)this.m_vertexTexture.elementAt(nArray[1][0])));
                for (n4 = 0; n4 < 2; ++n4) {
                    for (n2 = 1; n2 < nArray[n4].length; ++n2) {
                        if (nArray[n4][n2] <= -1) continue;
                        pdVector3.blendBase(pdVector3, dArrayArray[n4][n2], (PdVector)this.m_vertexTexture.elementAt(nArray[n4][n2]));
                    }
                }
                this.m_vertexTexture.addElement(pdVector3);
            }
            if (this.m_bHasVertexColors) {
                Color color = PdColor.blend((double)dArrayArray[0][0], (Color)((Color)this.m_vertexColor.elementAt(nArray[0][0])), (double)dArrayArray[1][0], (Color)((Color)this.m_vertexColor.elementAt(nArray[1][0])));
                for (n4 = 0; n4 < 2; ++n4) {
                    for (n2 = 1; n2 < nArray[n4].length; ++n2) {
                        if (nArray[n4][n2] <= -1) continue;
                        color = PdColor.blend((double)1.0, (Color)color, (double)dArrayArray[n4][n2], (Color)((Color)this.m_vertexColor.elementAt(nArray[n4][n2])));
                    }
                }
                this.m_vertexColor.addElement(color);
            }
            if (this.m_bHasVertexNormals) {
                PdVector pdVector4 = PdVector.blendNew((double)dArrayArray[0][0], (PdVector)((PdVector)this.m_vertexNormal.elementAt(nArray[0][0])), (double)dArrayArray[1][0], (PdVector)((PdVector)this.m_vertexNormal.elementAt(nArray[1][0])));
                for (n4 = 0; n4 < 2; ++n4) {
                    for (n2 = 1; n2 < nArray[n4].length; ++n2) {
                        if (nArray[n4][n2] <= -1) continue;
                        pdVector4.blendBase(pdVector4, dArrayArray[n4][n2], (PdVector)this.m_vertexNormal.elementAt(nArray[n4][n2]));
                    }
                }
                pdVector4.normalize();
                this.m_vertexNormal.addElement(pdVector4);
            }
        } else if (this.m_subdivisionScheme == LOOP) {
            int n7;
            int n8;
            PdVector pdVector5 = null;
            double[][] dArray = new double[2][3];
            if (bl) {
                dArray[0][0] = 0.375;
                dArray[1][0] = 0.375;
                dArray[0][1] = 0.0625;
                dArray[1][1] = 0.0625;
                dArray[0][2] = 0.0625;
                dArray[1][2] = 0.0625;
            } else {
                dArray[0][0] = 0.5;
                dArray[1][0] = 0.5;
                dArray[0][1] = 0.0;
                dArray[1][1] = 0.0;
                dArray[0][2] = 0.0;
                dArray[1][2] = 0.0;
            }
            pdVector5 = PdVector.blendNew((double)dArray[0][0], (PdVector)this.positionForLevel(nArray[0][0], n - 1), (double)dArray[1][0], (PdVector)this.positionForLevel(nArray[1][0], n - 1));
            for (n8 = 0; n8 < 2; ++n8) {
                if (nArray[n8][1] > -1) {
                    pdVector5.blendBase(pdVector5, dArray[n8][1], this.positionForLevel(nArray[n8][1], n - 1));
                }
                if (nArray[n8][nArray[n8].length - 1] <= -1) continue;
                pdVector5.blendBase(pdVector5, dArray[n8][2], this.positionForLevel(nArray[n8][nArray[n8].length - 1], n - 1));
            }
            this.m_vertexInsert.addElement(pdVector5);
            double[][] dArray4 = new double[2][5];
            double[][] dArray5 = new double[2][5];
            PdVector pdVector6 = null;
            if (bl) {
                dArray5[0][0] = 0.16666666666666666;
                dArray5[1][0] = 0.16666666666666666;
                for (n8 = 0; n8 < 2; ++n8) {
                    for (n7 = 1; n7 < 5; ++n7) {
                        dArray5[n8][n7] = 0.0;
                    }
                }
                if (this.edgeIsBoundary((int[])this.m_vertexInfo.elementAt(nArray[0][0]), nArray[1][1])) {
                    double[] dArray6 = dArray5[0];
                    dArray6[0] = dArray6[0] + 0.05555555555555555;
                    double[] dArray7 = dArray5[1];
                    dArray7[1] = dArray7[1] + 0.05555555555555555;
                    double[] dArray8 = dArray4[0];
                    dArray8[0] = dArray8[0] + 0.027777777777777776;
                    double[] dArray9 = dArray4[1];
                    dArray9[1] = dArray9[1] + 0.027777777777777776;
                } else {
                    double[] dArray10 = dArray4[0];
                    dArray10[0] = dArray10[0] + 0.0625;
                    double[] dArray11 = dArray4[1];
                    dArray11[1] = dArray11[1] + 0.0625;
                    double[] dArray12 = dArray4[1];
                    dArray12[0] = dArray12[0] + 0.020833333333333332;
                    double[] dArray13 = dArray4[1];
                    dArray13[3] = dArray13[3] + 0.020833333333333332;
                }
                if (this.edgeIsBoundary((int[])this.m_vertexInfo.elementAt(nArray[0][0]), nArray[1][nArray[1].length - 1])) {
                    double[] dArray14 = dArray5[0];
                    dArray14[0] = dArray14[0] + 0.05555555555555555;
                    double[] dArray15 = dArray5[1];
                    dArray15[2] = dArray15[2] + 0.05555555555555555;
                    double[] dArray16 = dArray4[0];
                    dArray16[0] = dArray16[0] + 0.027777777777777776;
                    double[] dArray17 = dArray4[1];
                    dArray17[2] = dArray17[2] + 0.027777777777777776;
                } else {
                    double[] dArray18 = dArray4[0];
                    dArray18[0] = dArray18[0] + 0.0625;
                    double[] dArray19 = dArray4[1];
                    dArray19[2] = dArray19[2] + 0.0625;
                    double[] dArray20 = dArray4[1];
                    dArray20[0] = dArray20[0] + 0.020833333333333332;
                    double[] dArray21 = dArray4[1];
                    dArray21[4] = dArray21[4] + 0.020833333333333332;
                }
                if (this.edgeIsBoundary((int[])this.m_vertexInfo.elementAt(nArray[1][0]), nArray[0][1])) {
                    double[] dArray22 = dArray5[1];
                    dArray22[0] = dArray22[0] + 0.05555555555555555;
                    double[] dArray23 = dArray5[0];
                    dArray23[1] = dArray23[1] + 0.05555555555555555;
                    double[] dArray24 = dArray4[1];
                    dArray24[0] = dArray24[0] + 0.027777777777777776;
                    double[] dArray25 = dArray4[0];
                    dArray25[1] = dArray25[1] + 0.027777777777777776;
                } else {
                    double[] dArray26 = dArray4[1];
                    dArray26[0] = dArray26[0] + 0.0625;
                    double[] dArray27 = dArray4[0];
                    dArray27[1] = dArray27[1] + 0.0625;
                    double[] dArray28 = dArray4[0];
                    dArray28[0] = dArray28[0] + 0.020833333333333332;
                    double[] dArray29 = dArray4[0];
                    dArray29[3] = dArray29[3] + 0.020833333333333332;
                }
                if (this.edgeIsBoundary((int[])this.m_vertexInfo.elementAt(nArray[1][0]), nArray[0][nArray[0].length - 1])) {
                    double[] dArray30 = dArray5[1];
                    dArray30[0] = dArray30[0] + 0.05555555555555555;
                    double[] dArray31 = dArray5[0];
                    dArray31[2] = dArray31[2] + 0.05555555555555555;
                    double[] dArray32 = dArray4[1];
                    dArray32[0] = dArray32[0] + 0.027777777777777776;
                    double[] dArray33 = dArray4[0];
                    dArray33[2] = dArray33[2] + 0.027777777777777776;
                } else {
                    double[] dArray34 = dArray4[1];
                    dArray34[0] = dArray34[0] + 0.0625;
                    double[] dArray35 = dArray4[0];
                    dArray35[2] = dArray35[2] + 0.0625;
                    double[] dArray36 = dArray4[0];
                    dArray36[0] = dArray36[0] + 0.020833333333333332;
                    double[] dArray37 = dArray4[0];
                    dArray37[4] = dArray37[4] + 0.020833333333333332;
                }
            } else {
                dArray5[0][0] = 0.3333333333333333;
                dArray5[1][0] = 0.3333333333333333;
                for (n8 = 0; n8 < 2; ++n8) {
                    for (n7 = 1; n7 < 5; ++n7) {
                        dArray5[n8][n7] = 0.0;
                    }
                }
                dArray4[0][0] = 0.16666666666666666;
                dArray4[1][0] = 0.16666666666666666;
                for (n8 = 0; n8 < 2; ++n8) {
                    for (n7 = 1; n7 < 5; ++n7) {
                        dArray4[n8][n7] = 0.0;
                    }
                }
            }
            pdVector6 = PdVector.blendNew((double)dArray5[0][0], (PdVector)this.positionForLevel(nArray[0][0], n), (double)dArray5[1][0], (PdVector)this.positionForLevel(nArray[1][0], n));
            pdVector6.blendBase(pdVector6, dArray4[0][0], this.positionForLevel(nArray[0][0], n - 1));
            pdVector6.blendBase(pdVector6, dArray4[1][0], this.positionForLevel(nArray[1][0], n - 1));
            if (bl) {
                for (n8 = 0; n8 < 2; ++n8) {
                    if (nArray[n8][1] > -1) {
                        pdVector6.blendBase(pdVector6, dArray4[n8][1], this.positionForLevel(nArray[n8][1], n - 1));
                        pdVector6.blendBase(pdVector6, dArray5[n8][1], this.positionForLevel(nArray[n8][1], n));
                    }
                    if (nArray[n8][nArray[n8].length - 1] > -1) {
                        pdVector6.blendBase(pdVector6, dArray4[n8][2], this.positionForLevel(nArray[n8][nArray[n8].length - 1], n - 1));
                        pdVector6.blendBase(pdVector6, dArray5[n8][2], this.positionForLevel(nArray[n8][nArray[n8].length - 1], n));
                    }
                    if (nArray[n8][2] > -1) {
                        pdVector6.blendBase(pdVector6, dArray4[n8][3], this.positionForLevel(nArray[n8][2], n - 1));
                        pdVector6.blendBase(pdVector6, dArray5[n8][3], this.positionForLevel(nArray[n8][2], n));
                    }
                    if (nArray[n8][nArray[n8].length - 2] <= -1) continue;
                    pdVector6.blendBase(pdVector6, dArray4[n8][4], this.positionForLevel(nArray[n8][nArray[n8].length - 2], n - 1));
                    pdVector6.blendBase(pdVector6, dArray5[n8][4], this.positionForLevel(nArray[n8][nArray[n8].length - 2], n));
                }
            }
            this.m_vertexCOG.addElement(pdVector6);
            for (int i = 0; i < this.m_numVectorFields; ++i) {
                if (this.m_vectorFieldIsBasedOn[i] != 0) continue;
                PdVector pdVector7 = PdVector.blendNew((double)0.5, (PdVector)((PdVector)this.m_vectorField[i].elementAt(nArray[0][0])), (double)0.5, (PdVector)((PdVector)this.m_vectorField[i].elementAt(nArray[1][0])));
                this.m_vectorField[i].addElement(pdVector7);
            }
            if (this.m_bHasVertexTexture) {
                PdVector pdVector8 = PdVector.blendNew((double)0.5, (PdVector)((PdVector)this.m_vertexTexture.elementAt(nArray[0][0])), (double)0.5, (PdVector)((PdVector)this.m_vertexTexture.elementAt(nArray[1][0])));
                this.m_vertexTexture.addElement(pdVector8);
            }
            if (this.m_bHasVertexColors) {
                Color color = PdColor.blend((double)0.5, (Color)((Color)this.m_vertexColor.elementAt(nArray[0][0])), (double)0.5, (Color)((Color)this.m_vertexColor.elementAt(nArray[1][0])));
                this.m_vertexColor.addElement(color);
            }
            if (this.m_bHasVertexNormals) {
                PdVector pdVector9 = PdVector.blendNew((double)0.5, (PdVector)((PdVector)this.m_vertexNormal.elementAt(nArray[0][0])), (double)0.5, (PdVector)((PdVector)this.m_vertexNormal.elementAt(nArray[1][0])));
                pdVector9.normalize();
                this.m_vertexNormal.addElement(pdVector9);
            }
        } else {
            pdVector = PdVector.blendNew((double)0.5, (PdVector)((PdVector)this.m_vertex.elementAt(nArray[0][0])), (double)0.5, (PdVector)((PdVector)this.m_vertex.elementAt(nArray[1][0])));
            for (int i = 0; i < this.m_numVectorFields; ++i) {
                if (this.m_vectorFieldIsBasedOn[i] != 0) continue;
                PdVector pdVector10 = PdVector.blendNew((double)0.5, (PdVector)((PdVector)this.m_vectorField[i].elementAt(nArray[0][0])), (double)0.5, (PdVector)((PdVector)this.m_vectorField[i].elementAt(nArray[1][0])));
                this.m_vectorField[i].addElement(pdVector10);
            }
            if (this.m_bHasVertexTexture) {
                PdVector pdVector11 = PdVector.blendNew((double)0.5, (PdVector)((PdVector)this.m_vertexTexture.elementAt(nArray[0][0])), (double)0.5, (PdVector)((PdVector)this.m_vertexTexture.elementAt(nArray[1][0])));
                this.m_vertexTexture.addElement(pdVector11);
            }
            if (this.m_bHasVertexColors) {
                Color color = PdColor.blend((double)0.5, (Color)((Color)this.m_vertexColor.elementAt(nArray[0][0])), (double)0.5, (Color)((Color)this.m_vertexColor.elementAt(nArray[1][0])));
                this.m_vertexColor.addElement(color);
            }
            if (this.m_bHasVertexNormals) {
                PdVector pdVector12 = PdVector.blendNew((double)0.5, (PdVector)((PdVector)this.m_vertexNormal.elementAt(nArray[0][0])), (double)0.5, (PdVector)((PdVector)this.m_vertexNormal.elementAt(nArray[1][0])));
                pdVector12.normalize();
                this.m_vertexNormal.addElement(pdVector12);
            }
        }
        if (this.m_subdivisionScheme != LOOP) {
            this.m_vertex.addElement(pdVector);
        }
    }

    private boolean edgeIsBoundary(int[] nArray, int n) {
        return nArray[POSITION] == BOUNDARY && (nArray[NN_START] == n || nArray[REFINEMENT_GRADE] == 0 && nArray[nArray.length - 1] == n || nArray[REFINEMENT_GRADE] > 0 && nArray[NN_START + 3] == n);
    }

    private PdVector positionForLevel(int n, int n2) {
        int[] nArray = (int[])this.m_vertexInfo.elementAt(n);
        int n3 = n2 - nArray[REFINEMENT_GRADE];
        if (n3 == 0) {
            return PdVector.copyNew((PdVector)((PdVector)this.m_vertexInsert.elementAt(n)));
        }
        if (nArray[POSITION] == INTERIOR) {
            int n4 = nArray.length - NN_START;
            double d = 0.625 - (0.375 + 0.25 * Math.cos(Math.PI * 2 / (double)n4)) * (0.375 + 0.25 * Math.cos(Math.PI * 2 / (double)n4));
            double d2 = -0.625 + d;
            for (int i = 1; i < n3; ++i) {
                d2 *= 0.625 - d;
            }
            d2 += 1.0;
            d2 /= 0.375 + d;
            return PdVector.blendNew((double)(1.0 - (d2 *= d)), (PdVector)((PdVector)this.m_vertexInsert.elementAt(n)), (double)d2, (PdVector)((PdVector)this.m_vertexCOG.elementAt(n)));
        }
        double d = 4.0;
        for (int i = 1; i < n3; ++i) {
            d *= 4.0;
        }
        d = (d - 1.0) / (3.0 * d);
        return PdVector.blendNew((double)(1.0 - d), (PdVector)((PdVector)this.m_vertexInsert.elementAt(n)), (double)d, (PdVector)((PdVector)this.m_vertexCOG.elementAt(n)));
    }

    public void reset() {
        if (this.m_geom == null) {
            return;
        }
        if (this.m_ip != null) {
            this.m_ip.enableCheckboxes();
        }
        this.m_geom.copy((PsObject)this.m_geomSave);
        this.init();
        if (this.m_markBy == 1) {
            this.update(this.m_tolerance);
        } else if (this.m_markBy == 2) {
            this.update(this.m_percentage);
        }
    }

    public void ok() {
        int n = this.m_elementSet.getNumElements();
        for (int i = 0; i < n; ++i) {
            this.m_elementSet.clearTagElement(i, 1);
        }
        super.ok();
        this.m_elementSet.update((Object)this.m_elementSet);
    }

    public void cancel() {
        int n = this.m_elementSet.getNumElements();
        for (int i = 0; i < n; ++i) {
            this.m_elementSet.clearTagElement(i, 1);
        }
        super.cancel();
    }
}

