/*
 * Decompiled with CFR 0.152.
 */
package jvx.geom;

import jv.geom.PgElementSet;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.vecmath.PiVector;

public class PgVertexStar
extends PsObject {
    protected PiVector m_element = new PiVector();
    protected PiVector m_link = new PiVector();
    protected PiVector m_vertexLocInd = new PiVector();
    protected boolean m_bClosed;
    protected int m_firstElemInd;
    static /* synthetic */ Class class$jvx$geom$PgVertexStar;

    public PgVertexStar() {
        if (((Object)((Object)this)).getClass() == (class$jvx$geom$PgVertexStar == null ? (class$jvx$geom$PgVertexStar = PgVertexStar.class$("jvx.geom.PgVertexStar")) : class$jvx$geom$PgVertexStar)) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.m_element.setSize(0);
        this.m_link.setSize(0);
        this.m_vertexLocInd.setSize(0);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append(super.toString());
        stringBuffer.append("\t ******* PgVertexStar ***********\n");
        stringBuffer.append("\t " + PsConfig.getMessage((int)63003) + " = " + this.m_element.toShortString());
        stringBuffer.append("\t " + PsConfig.getMessage((int)63004) + "\t= " + this.m_link.toShortString());
        stringBuffer.append("\t " + PsConfig.getMessage((int)63005) + " = " + this.m_vertexLocInd.toShortString());
        stringBuffer.append("\t " + PsConfig.getMessage((int)63001) + " = " + this.m_bClosed + "\n");
        stringBuffer.append("\t " + PsConfig.getMessage((int)63002) + " = " + this.m_firstElemInd + "\n");
        return stringBuffer.toString();
    }

    public void copy(PsObject psObject) {
        super.copy(psObject);
        if (!(psObject instanceof PgVertexStar)) {
            return;
        }
        PgVertexStar pgVertexStar = (PgVertexStar)psObject;
        this.m_element.copy(pgVertexStar.getElement());
        this.m_link.copy(pgVertexStar.getLink());
        this.m_vertexLocInd.copy(pgVertexStar.getVertexLocInd());
        this.m_bClosed = pgVertexStar.isClosed();
        this.m_firstElemInd = pgVertexStar.getFirstElemInd();
    }

    public PiVector getElement() {
        return this.m_element;
    }

    public PiVector getLink() {
        return this.m_link;
    }

    public PiVector getVertexLocInd() {
        return this.m_vertexLocInd;
    }

    public boolean isClosed() {
        return this.m_bClosed;
    }

    public int getFirstElemInd() {
        return this.m_firstElemInd;
    }

    public int getSize() {
        return this.m_element.getSize();
    }

    public void setSize(int n, boolean bl) {
        this.m_element.setSize(n);
        this.m_vertexLocInd.setSize(n);
        this.m_bClosed = bl;
        if (!this.m_bClosed) {
            ++n;
        }
        this.m_link.setSize(n);
    }

    public static PiVector getElementPerVertex(PgElementSet pgElementSet) {
        if (pgElementSet == null) {
            return null;
        }
        PiVector[] piVectorArray = pgElementSet.getNeighbours();
        int n = pgElementSet.getNumElements();
        boolean[] blArray = new boolean[pgElementSet.getNumVertices()];
        PiVector piVector = new PiVector(pgElementSet.getNumVertices());
        piVector.setConstant(-1);
        for (int i = 0; i < n; ++i) {
            PiVector piVector2 = pgElementSet.getElement(i);
            int n2 = piVector2.getSize();
            for (int j = 0; j < n2; ++j) {
                int n3 = piVector2.m_data[j];
                if (n3 < 0 || blArray[n3]) continue;
                piVector.m_data[n3] = i;
                blArray[n3] = piVectorArray != null && (piVectorArray[i].m_data[(n2 + j - 1) % n2] == -1 || piVectorArray[i].m_data[(n2 + j - 2) % n2] == -1);
            }
        }
        return piVector;
    }

    public static PiVector[] makeVertexNeighbours(PgElementSet pgElementSet) {
        int n;
        int n2 = pgElementSet.getNumVertices();
        int[] nArray = new int[n2];
        PiVector piVector = PgElementSet.getVertexValence((PgElementSet)pgElementSet);
        PiVector[] piVectorArray = PiVector.realloc(null, (int)n2);
        for (n = 0; n < n2; ++n) {
            piVectorArray[n].setSize(piVector.m_data[n]);
        }
        n = pgElementSet.getNumElements();
        for (int i = 0; i < n; ++i) {
            PiVector piVector2 = pgElementSet.getNeighbour(i);
            PiVector piVector3 = pgElementSet.getElement(i);
            int n3 = piVector3.getSize();
            for (int j = 0; j < n3; ++j) {
                int n4 = piVector2.m_data[j];
                if (n4 > i) continue;
                int n5 = piVector3.m_data[(j + 1) % n3];
                int n6 = piVector3.m_data[(j + 2) % n3];
                int n7 = n5;
                int n8 = nArray[n7];
                nArray[n7] = n8 + 1;
                piVectorArray[n5].setEntry(n8, n6);
                int n9 = n6;
                int n10 = nArray[n9];
                nArray[n9] = n10 + 1;
                piVectorArray[n6].setEntry(n10, n5);
            }
        }
        return piVectorArray;
    }

    public PiVector findEdges(PgElementSet pgElementSet, PiVector piVector) {
        if (this.getSize() <= 0) {
            PsDebug.warning((String)"Vertex star is not initialized!");
        }
        if (pgElementSet.getElementEdges() == null) {
            PsDebug.warning((String)"Edges of elemSet not initialized.");
            return null;
        }
        int n = this.getSize();
        if (piVector == null) {
            piVector = new PiVector(n);
        } else {
            piVector.setSize(n);
        }
        for (int i = 0; i < n; ++i) {
            piVector.m_data[i] = this.findEdge(pgElementSet, i);
        }
        return piVector;
    }

    public int findEdge(PgElementSet pgElementSet, int n) {
        if (this.getSize() <= 0) {
            PsDebug.warning((String)"Vertex star is not initialized!");
            return -1;
        }
        if (pgElementSet.getElementEdges() == null) {
            PsDebug.warning((String)"Edges of elemSet not initialized.");
            return -1;
        }
        if (n < 0 || n >= this.m_link.getSize()) {
            PsDebug.warning((String)"Local index out of range.");
            return -1;
        }
        int n2 = this.m_element.getSize();
        if (this.isClosed() || n < n2) {
            int n3 = this.m_element.m_data[n];
            int n4 = this.m_vertexLocInd.m_data[n];
            int n5 = pgElementSet.getDimOfElement(n3);
            boolean bl = this.getElementOrientation(pgElementSet, n);
            int n6 = bl ? (n5 + n4 - 1) % n5 : (n5 + n4 - 2) % n5;
            return pgElementSet.getElementEdge(n3, n6);
        }
        int n7 = this.m_element.m_data[n2 - 1];
        int n8 = this.m_vertexLocInd.m_data[n2 - 1];
        int n9 = pgElementSet.getDimOfElement(n7);
        boolean bl = this.getElementOrientation(pgElementSet, n2 - 1);
        int n10 = bl ? (n8 + 1) % n9 : (n8 + 2) % n9;
        return pgElementSet.getElementEdge(n7, n10);
    }

    public boolean getElementOrientation(PgElementSet pgElementSet, int n) {
        int n2 = this.m_vertexLocInd.m_data[n];
        PiVector piVector = pgElementSet.getElement(this.m_element.m_data[n]);
        int n3 = piVector.getSize();
        return this.m_link.m_data[n] == piVector.m_data[(n2 + 1) % n3];
    }

    public void makeVertexStar(PgElementSet pgElementSet, int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        PiVector[] piVectorArray = pgElementSet.getNeighbours();
        if (piVectorArray == null || piVectorArray.length == 0) {
            PsDebug.warning((String)("missing neighbour array in elementSet=" + pgElementSet.getName()));
            return;
        }
        int n7 = 0;
        int n8 = 0;
        int n9 = pgElementSet.getNumElements();
        PiVector[] piVectorArray2 = pgElementSet.getElements();
        boolean bl = true;
        if (n2 == -1) {
            bl = false;
            for (n6 = 0; n6 < n9; ++n6) {
                n5 = piVectorArray2[n6].getIndexOf(n);
                if (n5 == -1) continue;
                n2 = n6;
                break;
            }
            if (n2 == -1) {
                PsDebug.warning((String)("vertexInd=" + n + " not referenced in elementSet"));
                return;
            }
        }
        n6 = piVectorArray2[n2].getIndexOf(n);
        int n10 = 1;
        int n11 = n2;
        int n12 = piVectorArray2[n11].getSize();
        n5 = n6;
        int n13 = (n5 - 1 + n12) % n12;
        int n14 = piVectorArray[n11].m_data[n13];
        boolean bl2 = false;
        while (n14 != -1 && n14 != n2) {
            ++n10;
            n4 = piVectorArray2[n14].getSize();
            n3 = pgElementSet.getOppVertexLocInd(n11, n13);
            if (n3 == -2) {
                PsDebug.warning((String)("opposite element does not reference this element, elem = " + n11));
                return;
            }
            if (piVectorArray2[n11].m_data[(n13 + 1) % n12] == piVectorArray2[n14].m_data[(n3 + 1) % n4]) {
                boolean bl3 = bl2 = !bl2;
            }
            if (bl2) {
                n5 = (n3 + 1) % n4;
                n13 = (n5 - 2 + n4) % n4;
            } else {
                n5 = (n3 + 2) % n4;
                n13 = (n5 - 1 + n4) % n4;
            }
            n11 = n14;
            n12 = n4;
            n14 = piVectorArray[n11].m_data[n13];
        }
        this.m_bClosed = n14 == n2;
        this.m_firstElemInd = this.m_bClosed || !bl ? 0 : n10 - 1;
        if (!this.m_bClosed) {
            n7 = n11;
            n8 = n5;
            n11 = n2;
            n12 = piVectorArray2[n11].getSize();
            n5 = n6;
            n13 = (n5 - 2 + n12) % n12;
            n14 = piVectorArray[n11].m_data[n13];
            bl2 = false;
            while (n14 != -1 && n14 != n2) {
                ++n10;
                n4 = piVectorArray2[n14].getSize();
                n3 = pgElementSet.getOppVertexLocInd(n11, n13);
                if (n3 == -2) {
                    PsDebug.warning((String)("opposite element does not reference this element, elem = " + n11));
                    return;
                }
                if (piVectorArray2[n11].m_data[(n13 + 1) % n12] == piVectorArray2[n14].m_data[(n3 + 1) % n4]) {
                    boolean bl4 = bl2 = !bl2;
                }
                if (bl2) {
                    n5 = (n3 + 2) % n4;
                    n13 = (n5 - 1 + n4) % n4;
                } else {
                    n5 = (n3 + 1) % n4;
                    n13 = (n5 - 2 + n4) % n4;
                }
                n11 = n14;
                n12 = n4;
                n14 = piVectorArray[n11].m_data[n13];
            }
        }
        this.setSize(n10, this.m_bClosed);
        if (!this.m_bClosed && n7 != n2) {
            n11 = n7;
            n5 = n8;
        } else {
            n11 = n2;
            n5 = n6;
        }
        n12 = piVectorArray2[n11].getSize();
        n13 = (n5 - 2 + n12) % n12;
        n14 = piVectorArray[n11].m_data[n13];
        bl2 = false;
        if (n14 == -1 && piVectorArray[n11].m_data[(n5 - 1 + n12) % n12] != -1) {
            bl2 = true;
            n13 = (n5 - 1 + n12) % n12;
            n14 = piVectorArray[n11].m_data[n13];
        }
        for (n4 = 0; n4 < n10; ++n4) {
            this.m_element.setEntry(n4, n11);
            this.m_vertexLocInd.setEntry(n4, n5);
            if (bl2) {
                this.m_link.setEntry(n4, piVectorArray2[n11].m_data[(n5 - 1 + n12) % n12]);
            } else {
                this.m_link.setEntry(n4, piVectorArray2[n11].m_data[(n5 + 1 + n12) % n12]);
            }
            if (n4 == n10 - 1 && !this.m_bClosed) {
                if (bl2) {
                    this.m_link.setEntry(n10, piVectorArray2[n11].m_data[(n5 + 1 + n12) % n12]);
                    continue;
                }
                this.m_link.setEntry(n10, piVectorArray2[n11].m_data[(n5 - 1 + n12) % n12]);
                continue;
            }
            n12 = piVectorArray2[n14].getSize();
            if (piVectorArray2[n11].m_data[(n13 + 1) % piVectorArray2[n11].getSize()] == piVectorArray2[n14].m_data[(pgElementSet.getOppVertexLocInd(n11, n13) + 1) % n12]) {
                boolean bl5 = bl2 = !bl2;
            }
            if (bl2) {
                n5 = (pgElementSet.getOppVertexLocInd(n11, n13) + 2) % n12;
                n13 = (n5 - 1 + n12) % n12;
            } else {
                n5 = (pgElementSet.getOppVertexLocInd(n11, n13) + 1) % n12;
                n13 = (n5 - 2 + n12) % n12;
            }
            n11 = n14;
            n14 = piVectorArray[n11].m_data[n13];
        }
    }

    public void reverse() {
        this.m_element.invert();
        if (this.isClosed()) {
            this.m_element.shift(-1);
        }
        this.m_link.invert();
        this.m_vertexLocInd.invert();
        if (this.m_element.getSize() >= 0) {
            this.m_firstElemInd = this.m_element.m_data[0];
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

