/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.tool.mutex;

import org.neodatis.odb.ODBRuntimeException;
import org.neodatis.odb.core.NeoDatisError;
import org.neodatis.tool.DLogger;
import org.neodatis.tool.wrappers.OdbThread;

public class Mutex {
    private String name;
    protected boolean inUse;
    protected int nbOwners;
    private boolean debug;

    protected Mutex(String name) {
        this.name = name;
        this.inUse = false;
        this.nbOwners = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Mutex acquire(String who) throws InterruptedException {
        if (this.debug) {
            DLogger.info("Thread " + OdbThread.getCurrentThreadName() + " - " + who + " : Trying to acquire mutex " + this.name);
        }
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        Mutex mutex = this;
        synchronized (mutex) {
            try {
                while (this.inUse) {
                    this.wait();
                }
                if (this.nbOwners != 0) {
                    throw new InterruptedException("nb owners != 0 - " + this.nbOwners);
                }
                this.inUse = true;
                ++this.nbOwners;
            }
            catch (InterruptedException ex) {
                this.notify();
                throw ex;
            }
        }
        if (this.debug) {
            DLogger.info("Thread " + OdbThread.getCurrentThreadName() + " - " + who + " : Mutex " + this.name + " acquired!");
        }
        return this;
    }

    public synchronized void release(String who) {
        if (this.debug) {
            DLogger.info("Thread " + OdbThread.getCurrentThreadName() + " - " + who + " : Releasing mutex " + this.name);
        }
        this.inUse = false;
        --this.nbOwners;
        if (this.nbOwners < 0) {
            throw new ODBRuntimeException(NeoDatisError.INTERNAL_ERROR.addParameter("Nb owner is negative in release(" + who + ")"));
        }
        this.notify();
    }

    /*
     * Exception decompiling
     */
    public boolean attempt(long msecs) throws InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[TRYBLOCK]], but top level block is 12[DOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public String getName() {
        return this.name;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public boolean isInUse() {
        return this.inUse;
    }

    public int getNbOwners() {
        return this.nbOwners;
    }
}

