/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.impl.core.transaction;

import org.neodatis.odb.ODBRuntimeException;
import org.neodatis.odb.OdbConfiguration;
import org.neodatis.odb.core.NeoDatisError;
import org.neodatis.odb.core.layers.layer2.meta.ODBType;
import org.neodatis.odb.core.layers.layer3.engine.IByteArrayConverter;
import org.neodatis.odb.core.layers.layer3.engine.IFileSystemInterface;
import org.neodatis.odb.core.transaction.IWriteAction;
import org.neodatis.tool.DLogger;
import org.neodatis.tool.DisplayUtility;
import org.neodatis.tool.wrappers.list.IOdbList;
import org.neodatis.tool.wrappers.list.OdbArrayList;

public class DefaultWriteAction
implements IWriteAction {
    public static int count = 0;
    public static final int UNKNOWN_WRITE_ACTION = 0;
    public static final int DATA_WRITE_ACTION = 1;
    public static final int POINTER_WRITE_ACTION = 2;
    public static final int DIRECT_WRITE_ACTION = 3;
    public static final String LOG_ID = "WriteAction";
    private static String UNKNOWN_LABEL = "?";
    private long position;
    private IByteArrayConverter byteArrayConverter = OdbConfiguration.getCoreProvider().getByteArrayConverter();
    private IOdbList<byte[]> listOfBytes;
    private int size;

    public DefaultWriteAction(long position) {
        this(position, null);
    }

    public DefaultWriteAction(long position, byte[] bytes) {
        this(position, bytes, null);
    }

    public DefaultWriteAction(long position, byte[] bytes, String label) {
        this.position = position;
        this.listOfBytes = new OdbArrayList<byte[]>(20);
        if (bytes != null) {
            this.listOfBytes.add(bytes);
            this.size = bytes.length;
        }
    }

    @Override
    public long getPosition() {
        return this.position;
    }

    public void setPosition(long position) {
        this.position = position;
    }

    @Override
    public byte[] getBytes(int index) {
        return this.listOfBytes.get(index);
    }

    @Override
    public void addBytes(byte[] bytes) {
        this.listOfBytes.add(bytes);
        this.size += bytes.length;
    }

    @Override
    public void persist(IFileSystemInterface fsi, int index) {
        int i;
        long currentPosition = fsi.getPosition();
        if (OdbConfiguration.isDebugEnabled(LOG_ID)) {
            // empty if block
        }
        int sizeOfLong = ODBType.LONG.getSize();
        int sizeOfInt = ODBType.INTEGER.getSize();
        byte[] bytes = new byte[sizeOfLong + sizeOfInt + this.size];
        byte[] bytesOfPosition = this.byteArrayConverter.longToByteArray(this.position);
        byte[] bytesOfSize = this.byteArrayConverter.intToByteArray(this.size);
        for (int i2 = 0; i2 < sizeOfLong; ++i2) {
            bytes[i2] = bytesOfPosition[i2];
        }
        int offset = sizeOfLong;
        for (i = 0; i < sizeOfInt; ++i) {
            bytes[offset] = bytesOfSize[i];
            ++offset;
        }
        for (i = 0; i < this.listOfBytes.size(); ++i) {
            byte[] tmp = this.listOfBytes.get(i);
            System.arraycopy(tmp, 0, bytes, offset, tmp.length);
            offset += tmp.length;
        }
        fsi.writeBytes(bytes, false, "Transaction");
        int fixedSize = sizeOfLong + sizeOfInt;
        long positionAfterWrite = fsi.getPosition();
        long writeSize = positionAfterWrite - currentPosition;
        if (writeSize != (long)(this.size + fixedSize)) {
            throw new ODBRuntimeException(NeoDatisError.DIFFERENT_SIZE_IN_WRITE_ACTION.addParameter(this.size).addParameter(writeSize));
        }
    }

    public static DefaultWriteAction read(IFileSystemInterface fsi, int index) {
        try {
            long position = fsi.readLong();
            int size = fsi.readInt();
            byte[] bytes = fsi.readBytes(size);
            DefaultWriteAction writeAction = new DefaultWriteAction(position, bytes);
            if (OdbConfiguration.isDebugEnabled(LOG_ID)) {
                DLogger.debug("Loading Write Action # " + index + " at " + fsi.getPosition() + " => " + writeAction.toString());
            }
            return writeAction;
        }
        catch (ODBRuntimeException e) {
            DLogger.error("error reading write action " + index + " at position " + fsi.getPosition());
            throw e;
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("position=").append(this.position);
        StringBuffer bytes = new StringBuffer();
        if (this.listOfBytes != null) {
            for (int i = 0; i < this.listOfBytes.size(); ++i) {
                bytes.append(DisplayUtility.byteArrayToString(this.getBytes(i)));
            }
            buffer.append(" | bytes=[").append(bytes).append("] & size=" + this.size);
        } else {
            buffer.append(" | bytes=null & size=").append(this.size);
        }
        return buffer.toString();
    }

    @Override
    public void applyTo(IFileSystemInterface fsi, int index) {
        if (OdbConfiguration.isDebugEnabled(LOG_ID)) {
            DLogger.debug("Applying WriteAction #" + index + " : " + this.toString());
        }
        fsi.setWritePosition(this.position, false);
        for (int i = 0; i < this.listOfBytes.size(); ++i) {
            fsi.writeBytes(this.getBytes(i), false, LOG_ID);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.listOfBytes == null || this.listOfBytes.isEmpty();
    }

    public void clear() {
        this.listOfBytes.clear();
        this.listOfBytes = null;
        --count;
    }
}

