/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.impl.core.layers.layer3.engine;

import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.neodatis.btree.IBTree;
import org.neodatis.odb.CorruptedDatabaseException;
import org.neodatis.odb.DatabaseId;
import org.neodatis.odb.ODBAuthenticationRuntimeException;
import org.neodatis.odb.ODBRuntimeException;
import org.neodatis.odb.OID;
import org.neodatis.odb.Objects;
import org.neodatis.odb.OdbConfiguration;
import org.neodatis.odb.TransactionId;
import org.neodatis.odb.Values;
import org.neodatis.odb.core.NeoDatisError;
import org.neodatis.odb.core.layers.layer2.instance.IClassPool;
import org.neodatis.odb.core.layers.layer2.instance.IInstanceBuilder;
import org.neodatis.odb.core.layers.layer2.meta.AbstractObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.ArrayObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.AtomicNativeObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.AttributeValuesMap;
import org.neodatis.odb.core.layers.layer2.meta.ClassAttributeInfo;
import org.neodatis.odb.core.layers.layer2.meta.ClassInfo;
import org.neodatis.odb.core.layers.layer2.meta.ClassInfoIndex;
import org.neodatis.odb.core.layers.layer2.meta.CollectionObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.EnumNativeObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.MapObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.MetaModel;
import org.neodatis.odb.core.layers.layer2.meta.NativeAttributeHeader;
import org.neodatis.odb.core.layers.layer2.meta.NonNativeDeletedObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.NonNativeNullObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.NonNativeObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.NullNativeObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.ODBType;
import org.neodatis.odb.core.layers.layer2.meta.ObjectInfoHeader;
import org.neodatis.odb.core.layers.layer3.IObjectReader;
import org.neodatis.odb.core.layers.layer3.IStorageEngine;
import org.neodatis.odb.core.layers.layer3.engine.IByteArrayConverter;
import org.neodatis.odb.core.layers.layer3.engine.IFileSystemInterface;
import org.neodatis.odb.core.oid.OIDFactory;
import org.neodatis.odb.core.query.IQuery;
import org.neodatis.odb.core.query.IValuesQuery;
import org.neodatis.odb.core.query.QueryManager;
import org.neodatis.odb.core.query.criteria.Where;
import org.neodatis.odb.core.query.execution.IMatchingObjectAction;
import org.neodatis.odb.core.query.execution.IQueryExecutor;
import org.neodatis.odb.core.transaction.ICache;
import org.neodatis.odb.core.transaction.ISession;
import org.neodatis.odb.core.transaction.ITmpCache;
import org.neodatis.odb.core.trigger.ITriggerManager;
import org.neodatis.odb.impl.core.btree.LazyODBBTreePersister;
import org.neodatis.odb.impl.core.layers.layer3.block.BlockTypes;
import org.neodatis.odb.impl.core.layers.layer3.engine.PendingReading;
import org.neodatis.odb.impl.core.layers.layer3.engine.StorageEngineConstant;
import org.neodatis.odb.impl.core.layers.layer3.oid.FullIDInfo;
import org.neodatis.odb.impl.core.layers.layer3.oid.IDStatus;
import org.neodatis.odb.impl.core.oid.DatabaseIdImpl;
import org.neodatis.odb.impl.core.oid.TransactionIdImpl;
import org.neodatis.odb.impl.core.query.criteria.CollectionQueryResultAction;
import org.neodatis.odb.impl.core.query.criteria.CriteriaQuery;
import org.neodatis.odb.impl.core.query.values.GroupByValuesQueryResultAction;
import org.neodatis.odb.impl.core.query.values.ValuesQueryResultAction;
import org.neodatis.odb.impl.tool.Cryptographer;
import org.neodatis.tool.DLogger;
import org.neodatis.tool.wrappers.OdbArray;
import org.neodatis.tool.wrappers.OdbString;
import org.neodatis.tool.wrappers.list.IOdbList;
import org.neodatis.tool.wrappers.list.OdbArrayList;
import org.neodatis.tool.wrappers.map.OdbHashMap;

public class ObjectReader
implements IObjectReader {
    public static long timeToGetObjectFromId = 0L;
    public static long calls = 0L;
    public static final String LOG_ID = "ObjectReader";
    private static final String LOG_ID_DEBUG = "ObjectReader.debug";
    public IStorageEngine storageEngine;
    private Map<Long, Long> blockPositions;
    private IFileSystemInterface fsi;
    private int currentDepth;
    private IInstanceBuilder instanceBuilder;
    private IClassPool classPool;
    protected IByteArrayConverter byteArrayConverter;
    protected ITriggerManager triggerManager;

    public String depthToSpaces() {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < this.currentDepth; ++i) {
            buffer.append("  ");
        }
        return buffer.toString();
    }

    public ObjectReader(IStorageEngine engine) {
        this.storageEngine = engine;
        this.fsi = engine.getObjectWriter().getFsi();
        this.blockPositions = new OdbHashMap<Long, Long>();
        this.instanceBuilder = this.buildInstanceBuilder();
        this.classPool = OdbConfiguration.getCoreProvider().getClassPool();
        this.byteArrayConverter = OdbConfiguration.getCoreProvider().getByteArrayConverter();
        this.triggerManager = this.storageEngine.getTriggerManager();
    }

    protected IInstanceBuilder buildInstanceBuilder() {
        return OdbConfiguration.getCoreProvider().getLocalInstanceBuilder(this.storageEngine);
    }

    protected int readVersion() {
        this.fsi.setReadPosition(StorageEngineConstant.DATABASE_HEADER_VERSION_POSITION);
        return this.fsi.readInt();
    }

    protected boolean readEncryptionFlag() {
        this.fsi.setReadPosition(0L);
        byte b = this.fsi.readByte();
        return b == 1;
    }

    protected boolean readReplicationFlag() {
        this.fsi.setReadPosition(StorageEngineConstant.DATABASE_HEADER_USE_REPLICATION_POSITION);
        byte b = this.fsi.readByte();
        return b == 1;
    }

    protected TransactionId readLastTransactionId(DatabaseId databaseId) {
        this.fsi.setReadPosition(StorageEngineConstant.DATABASE_HEADER_LAST_TRANSACTION_ID);
        long[] id = new long[]{this.fsi.readLong(), this.fsi.readLong()};
        return new TransactionIdImpl(databaseId, id[0], id[1]);
    }

    protected long readNumberOfClasses() {
        this.fsi.setReadPosition(StorageEngineConstant.DATABASE_HEADER_NUMBER_OF_CLASSES_POSITION);
        return this.fsi.readLong();
    }

    protected long readFirstClassOid() {
        this.fsi.setReadPosition(StorageEngineConstant.DATABASE_HEADER_FIRST_CLASS_OID);
        return this.fsi.readLong();
    }

    protected boolean readLastODBCloseStatus() {
        this.fsi.setReadPosition(StorageEngineConstant.DATABASE_HEADER_LAST_CLOSE_STATUS_POSITION);
        return this.fsi.readBoolean("last odb status");
    }

    protected String readDatabaseCharacterEncoding() {
        this.fsi.setReadPosition(StorageEngineConstant.DATABASE_HEADER_DATABASE_CHARACTER_ENCODING_POSITION);
        return this.fsi.readString(false);
    }

    @Override
    public void readDatabaseHeader(String user, String password) {
        boolean versionIsCompatible;
        boolean useEncryption = this.readEncryptionFlag();
        int version = this.readVersion();
        boolean bl = versionIsCompatible = version == 9;
        if (!versionIsCompatible) {
            throw new ODBRuntimeException(NeoDatisError.RUNTIME_INCOMPATIBLE_VERSION.addParameter(version).addParameter(9));
        }
        long[] databaseIdsArray = new long[]{this.fsi.readLong(), this.fsi.readLong(), this.fsi.readLong(), this.fsi.readLong()};
        DatabaseIdImpl databaseId = new DatabaseIdImpl(databaseIdsArray);
        boolean isReplicated = this.readReplicationFlag();
        TransactionId lastTransactionId = this.readLastTransactionId(databaseId);
        lastTransactionId = lastTransactionId.next();
        long nbClasses = this.readNumberOfClasses();
        long firstClassPosition = this.readFirstClassOid();
        if (nbClasses < 0L) {
            throw new CorruptedDatabaseException(NeoDatisError.NEGATIVE_CLASS_NUMBER_IN_HEADER.addParameter(nbClasses).addParameter(firstClassPosition));
        }
        boolean lastCloseStatus = this.readLastODBCloseStatus();
        String databaseCharacterEncoding = this.readDatabaseCharacterEncoding();
        this.fsi.setDatabaseCharacterEncoding(databaseCharacterEncoding);
        boolean hasUserAndPassword = this.fsi.readBoolean("has user&password?");
        String userRead = this.fsi.readString(true);
        String passwordRead = this.fsi.readString(true);
        if (hasUserAndPassword) {
            String encryptedPassword = Cryptographer.encrypt(password);
            if (!userRead.equals(user) || !passwordRead.equals(encryptedPassword)) {
                throw new ODBAuthenticationRuntimeException();
            }
        } else if (user != null) {
            throw new ODBAuthenticationRuntimeException();
        }
        long currentBlockPosition = this.fsi.readLong("current block position");
        this.fsi.setReadPosition(currentBlockPosition + StorageEngineConstant.BLOCK_ID_OFFSET_FOR_BLOCK_NUMBER);
        int currentBlockNumber = this.fsi.readInt("current block id number");
        OID maxId = OIDFactory.buildObjectOID(this.fsi.readLong("Block max id"));
        this.storageEngine.setVersion(version);
        this.storageEngine.setDatabaseId(databaseId);
        this.storageEngine.setNbClasses(nbClasses);
        this.storageEngine.setLastODBCloseStatus(lastCloseStatus);
        this.storageEngine.setCurrentIdBlockInfos(currentBlockPosition, currentBlockNumber, maxId);
        this.storageEngine.setCurrentTransactionId(lastTransactionId);
    }

    @Override
    public MetaModel readMetaModel(MetaModel metaModel, boolean full) {
        OID classOID = null;
        ClassInfo classInfo2 = null;
        long nbClasses = this.readNumberOfClasses();
        if (nbClasses == 0L) {
            return metaModel;
        }
        this.fsi.setReadPosition(StorageEngineConstant.DATABASE_HEADER_FIRST_CLASS_OID);
        classOID = OIDFactory.buildClassOID(this.readFirstClassOid());
        int i = 0;
        while ((long)i < nbClasses) {
            classInfo2 = this.readClassInfoHeader(classOID);
            if (OdbConfiguration.isDebugEnabled(LOG_ID)) {
                DLogger.debug(this.depthToSpaces() + "Reading class header for " + classInfo2.getFullClassName() + " - oid = " + classOID + " prevOid=" + classInfo2.getPreviousClassOID() + " - nextOid=" + classInfo2.getNextClassOID());
            }
            metaModel.addClass(classInfo2);
            classOID = classInfo2.getNextClassOID();
            ++i;
        }
        if (!full) {
            return metaModel;
        }
        IOdbList<ClassInfo> allClasses = metaModel.getAllClasses();
        Iterator iterator = allClasses.iterator();
        ClassInfo tempCi = null;
        while (iterator.hasNext()) {
            tempCi = (ClassInfo)iterator.next();
            try {
                classInfo2 = this.readClassInfoBody(tempCi);
            }
            catch (ODBRuntimeException e) {
                e.addMessageHeader("Error while reading the class info body of " + tempCi);
                throw e;
            }
            if (!OdbConfiguration.isDebugEnabled(LOG_ID)) continue;
            DLogger.debug(this.depthToSpaces() + "Reading class body for " + classInfo2.getFullClassName());
        }
        for (ClassInfo classInfo2 : allClasses) {
            if (OdbConfiguration.isDebugEnabled(LOG_ID)) {
                DLogger.debug(this.depthToSpaces() + "Reading class info last instance " + classInfo2.getFullClassName());
            }
            if (!classInfo2.getCommitedZoneInfo().hasObjects()) continue;
            try {
                OID oid = classInfo2.getCommitedZoneInfo().last;
                classInfo2.setLastObjectInfoHeader(this.readObjectInfoHeaderFromOid(oid, true));
            }
            catch (ODBRuntimeException e) {
                throw new ODBRuntimeException(NeoDatisError.METAMODEL_READING_LAST_OBJECT.addParameter(classInfo2.getFullClassName()).addParameter(classInfo2.getCommitedZoneInfo().last), (Throwable)e);
            }
        }
        OdbArrayList<ClassInfoIndex> indexes = null;
        LazyODBBTreePersister persister = null;
        ClassInfoIndex cii = null;
        CriteriaQuery queryClassInfo = null;
        IBTree btree = null;
        this.storageEngine.resetCommitListeners();
        for (ClassInfo classInfo2 : allClasses) {
            indexes = new OdbArrayList<ClassInfoIndex>();
            queryClassInfo = new CriteriaQuery(ClassInfoIndex.class, Where.equal("classInfoId", classInfo2.getId()));
            Objects classIndexes = this.getObjects(queryClassInfo, true, -1, -1);
            indexes.addAll(classIndexes);
            for (int j = 0; j < indexes.size(); ++j) {
                cii = (ClassInfoIndex)indexes.get(j);
                persister = new LazyODBBTreePersister(this.storageEngine);
                btree = cii.getBTree();
                btree.setPersister(persister);
                btree.getRoot().setBTree(btree);
            }
            if (OdbConfiguration.isDebugEnabled(LOG_ID)) {
                DLogger.debug(this.depthToSpaces() + "Reading indexes for " + classInfo2.getFullClassName() + " : " + indexes.size() + " indexes");
            }
            classInfo2.setIndexes(indexes);
        }
        if (OdbConfiguration.isDebugEnabled(LOG_ID)) {
            DLogger.debug(this.depthToSpaces() + "Current Meta Model is :" + metaModel);
        }
        return metaModel;
    }

    protected ClassInfo readClassInfoHeader(OID classInfoOid) {
        if (OdbConfiguration.isDebugEnabled(LOG_ID)) {
            DLogger.debug(this.depthToSpaces() + "Reading new Class info Header with oid " + classInfoOid);
        }
        long classInfoPosition = this.getObjectPositionFromItsOid(classInfoOid, true, true);
        this.fsi.setReadPosition(classInfoPosition);
        int blockSize = this.fsi.readInt("class info block size");
        byte blockType = this.fsi.readByte("class info block type");
        if (!BlockTypes.isClassHeader(blockType)) {
            throw new ODBRuntimeException(NeoDatisError.WRONG_TYPE_FOR_BLOCK_TYPE.addParameter("Class Header").addParameter(blockType).addParameter(classInfoPosition));
        }
        byte classInfoCategory = this.fsi.readByte("class info category");
        ClassInfo classInfo = new ClassInfo();
        classInfo.setClassCategory(classInfoCategory);
        classInfo.setPosition(classInfoPosition);
        classInfo.setId(OIDFactory.buildClassOID(this.fsi.readLong()));
        classInfo.setBlockSize(blockSize);
        classInfo.setPreviousClassOID(this.readOid("prev class oid"));
        classInfo.setNextClassOID(this.readOid("next class oid"));
        classInfo.getOriginalZoneInfo().setNbObjects(this.fsi.readLong());
        classInfo.getOriginalZoneInfo().first = this.readOid("ci first object oid");
        classInfo.getOriginalZoneInfo().last = this.readOid("ci last object oid");
        classInfo.getCommitedZoneInfo().set(classInfo.getOriginalZoneInfo());
        classInfo.setFullClassName(this.fsi.readString(false));
        classInfo.setExtraInfo("");
        classInfo.setMaxAttributeId(this.fsi.readInt());
        classInfo.setAttributesDefinitionPosition(this.fsi.readLong());
        int realBlockSize = (int)(this.fsi.getPosition() - classInfoPosition);
        if (blockSize != realBlockSize) {
            throw new ODBRuntimeException(NeoDatisError.WRONG_BLOCK_SIZE.addParameter(blockSize).addParameter(realBlockSize).addParameter(classInfoPosition));
        }
        return classInfo;
    }

    private OID decodeOid(byte[] bytes, int offset) {
        long oid = this.byteArrayConverter.byteArrayToLong(bytes, offset);
        if (oid == -1L) {
            return null;
        }
        return OIDFactory.buildObjectOID(oid);
    }

    private OID readOid(String label) {
        long oid = this.fsi.readLong(label);
        if (oid == -1L) {
            return null;
        }
        return OIDFactory.buildObjectOID(oid);
    }

    protected ClassInfo readClassInfoBody(ClassInfo classInfo) {
        if (OdbConfiguration.isDebugEnabled(LOG_ID)) {
            DLogger.debug(this.depthToSpaces() + "Reading new Class info Body at " + classInfo.getAttributesDefinitionPosition());
        }
        this.fsi.setReadPosition(classInfo.getAttributesDefinitionPosition());
        int blockSize = this.fsi.readInt();
        byte blockType = this.fsi.readByte();
        if (!BlockTypes.isClassBody(blockType)) {
            throw new ODBRuntimeException(NeoDatisError.WRONG_TYPE_FOR_BLOCK_TYPE.addParameter("Class Body").addParameter(blockType).addParameter(classInfo.getAttributesDefinitionPosition()));
        }
        long nbAttributes = this.fsi.readLong();
        OdbArrayList<ClassAttributeInfo> attributes = new OdbArrayList<ClassAttributeInfo>((int)nbAttributes);
        int i = 0;
        while ((long)i < nbAttributes) {
            attributes.add(this.readClassAttributeInfo());
            ++i;
        }
        classInfo.setAttributes(attributes);
        int realBlockSize = (int)(this.fsi.getPosition() - classInfo.getAttributesDefinitionPosition());
        if (blockSize != realBlockSize) {
            throw new ODBRuntimeException(NeoDatisError.WRONG_BLOCK_SIZE.addParameter(blockSize).addParameter(realBlockSize).addParameter(classInfo.getAttributesDefinitionPosition()));
        }
        return classInfo;
    }

    @Override
    public IOdbList<ClassInfoIndex> readClassInfoIndexesAt(long position, ClassInfo classInfo) {
        OdbArrayList<ClassInfoIndex> indexes = new OdbArrayList<ClassInfoIndex>();
        this.fsi.setReadPosition(position);
        ClassInfoIndex cii = null;
        long previousIndexPosition = -1L;
        long nextIndexPosition = position;
        byte blockType = 0;
        int blockSize = -1;
        int nbAttributes = -1;
        int[] attributeIds = null;
        do {
            cii = new ClassInfoIndex();
            this.fsi.setReadPosition(nextIndexPosition);
            blockSize = this.fsi.readInt("block size");
            blockType = this.fsi.readByte("block type");
            if (!BlockTypes.isIndex(blockType)) {
                throw new ODBRuntimeException(NeoDatisError.WRONG_TYPE_FOR_BLOCK_TYPE.addParameter((byte)21).addParameter(blockType).addParameter(position).addParameter("while reading indexes for " + classInfo.getFullClassName()));
            }
            previousIndexPosition = this.fsi.readLong("prev index pos");
            nextIndexPosition = this.fsi.readLong("next index pos");
            cii.setName(this.fsi.readString(false, "Index name"));
            cii.setUnique(this.fsi.readBoolean("index is unique"));
            cii.setStatus(this.fsi.readByte("index status"));
            cii.setCreationDate(this.fsi.readLong("creation date"));
            cii.setLastRebuild(this.fsi.readLong("last rebuild"));
            nbAttributes = this.fsi.readInt("number of fields");
            attributeIds = new int[nbAttributes];
            for (int j = 0; j < nbAttributes; ++j) {
                attributeIds[j] = this.fsi.readInt("attr id");
            }
            cii.setAttributeIds(attributeIds);
            indexes.add(cii);
        } while (nextIndexPosition != -1L);
        return indexes;
    }

    private ClassAttributeInfo readClassAttributeInfo() {
        ClassAttributeInfo cai = new ClassAttributeInfo();
        int attributeId = this.fsi.readInt();
        boolean isNative = this.fsi.readBoolean();
        if (isNative) {
            int attributeTypeId = this.fsi.readInt();
            ODBType type = ODBType.getFromId(attributeTypeId);
            if (type.isArray()) {
                type = type.copy();
                int subTypeId = this.fsi.readInt();
                ODBType subType = ODBType.getFromId(subTypeId);
                if (subType.isNonNative()) {
                    subType = subType.copy();
                    subType.setName(this.storageEngine.getSession(true).getMetaModel().getClassInfoFromId(OIDFactory.buildClassOID(this.fsi.readLong())).getFullClassName());
                }
                type.setSubType(subType);
            }
            cai.setAttributeType(type);
            if (type.isEnum()) {
                long classInfoId = this.fsi.readLong();
                MetaModel metaModel = this.storageEngine.getSession(true).getMetaModel();
                cai.setFullClassName(metaModel.getClassInfoFromId(OIDFactory.buildClassOID(classInfoId)).getFullClassName());
                type = type.copy();
                type.setName(cai.getFullClassname());
                cai.setAttributeType(type);
            } else {
                cai.setFullClassName(cai.getAttributeType().getName());
            }
        } else {
            MetaModel metaModel = this.storageEngine.getSession(true).getMetaModel();
            long typeId = this.fsi.readLong();
            cai.setFullClassName(metaModel.getClassInfoFromId(OIDFactory.buildClassOID(typeId)).getFullClassName());
            cai.setClassInfo(metaModel.getClassInfo(cai.getFullClassname(), true));
            cai.setAttributeType(ODBType.getFromName(cai.getFullClassname()));
        }
        cai.setName(this.fsi.readString(false));
        cai.setIndex(this.fsi.readBoolean());
        cai.setId(attributeId);
        return cai;
    }

    public Object readNonNativeObjectAtPosition(long position, boolean useCache, boolean returnInstance) {
        NonNativeObjectInfo nnoi = this.readNonNativeObjectInfoFromPosition(null, null, position, useCache, returnInstance);
        if (nnoi.isDeletedObject()) {
            throw new ODBRuntimeException(NeoDatisError.OBJECT_IS_MARKED_AS_DELETED_FOR_POSITION.addParameter(position));
        }
        if (!returnInstance) {
            return nnoi;
        }
        Object o = this.instanceBuilder.buildOneInstance(nnoi);
        return o;
    }

    public AbstractObjectInfo readObjectInfo(long objectIdentification, boolean useCache, boolean returnObjects) {
        if (objectIdentification < 0L) {
            OID oid = OIDFactory.buildObjectOID(-objectIdentification);
            return this.readNonNativeObjectInfoFromOid(null, oid, useCache, returnObjects);
        }
        return this.readObjectInfoFromPosition(null, objectIdentification, useCache, returnObjects);
    }

    @Override
    public ObjectInfoHeader readObjectInfoHeaderFromOid(OID oid, boolean useCache) {
        ObjectInfoHeader oih = null;
        if (useCache && (oih = this.getSession().getCache().getObjectInfoHeaderFromOid(oid, false)) != null) {
            return oih;
        }
        long position = this.getObjectPositionFromItsOid(oid, useCache, true);
        return this.readObjectInfoHeaderFromPosition(oid, position, useCache);
    }

    public ObjectInfoHeader readObjectInfoHeaderFromPosition(OID oid, long position, boolean useCache) {
        OID classInfoId = null;
        if (position > this.fsi.getLength()) {
            throw new CorruptedDatabaseException(NeoDatisError.INSTANCE_POSITION_OUT_OF_FILE.addParameter(position).addParameter(this.fsi.getLength()));
        }
        if (position < 0L) {
            throw new CorruptedDatabaseException(NeoDatisError.INSTANCE_POSITION_IS_NEGATIVE.addParameter(position).addParameter(String.valueOf(oid)));
        }
        this.fsi.setReadPosition(position + (long)ODBType.INTEGER.getSize());
        byte blockType = this.fsi.readByte("object block type");
        if (BlockTypes.isNonNative(blockType)) {
            int tsize = 7 * ODBType.SIZE_OF_LONG + 2 * ODBType.SIZE_OF_INT + 1 * ODBType.SIZE_OF_BOOL;
            byte[] abytes = this.fsi.readBytes(tsize);
            OID readOid = this.decodeOid(abytes, 0);
            if (oid != null && readOid.compareTo(oid) != 0) {
                throw new CorruptedDatabaseException(NeoDatisError.WRONG_OID_AT_POSITION.addParameter(oid).addParameter(position).addParameter(readOid));
            }
            if (oid == null) {
                oid = readOid;
            }
            classInfoId = OIDFactory.buildClassOID(this.byteArrayConverter.byteArrayToLong(abytes, 8));
            OID prevObjectOID = this.decodeOid(abytes, 16);
            OID nextObjectOID = this.decodeOid(abytes, 24);
            long creationDate = this.byteArrayConverter.byteArrayToLong(abytes, 32);
            long updateDate = this.byteArrayConverter.byteArrayToLong(abytes, 40);
            int objectVersion = this.byteArrayConverter.byteArrayToInt(abytes, 48);
            long objectReferencePointer = this.byteArrayConverter.byteArrayToLong(abytes, 52);
            boolean isSynchronized = this.byteArrayConverter.byteArrayToBoolean(abytes, 60);
            int nbAttributesRead = this.byteArrayConverter.byteArrayToInt(abytes, 61);
            long[] attributesIdentification = new long[nbAttributesRead];
            int[] attributeIds = new int[nbAttributesRead];
            int atsize = ODBType.SIZE_OF_INT + ODBType.SIZE_OF_LONG;
            byte[] bytes = this.fsi.readBytes(nbAttributesRead * atsize);
            for (int i = 0; i < nbAttributesRead; ++i) {
                attributeIds[i] = this.byteArrayConverter.byteArrayToInt(bytes, i * atsize);
                attributesIdentification[i] = this.byteArrayConverter.byteArrayToLong(bytes, i * atsize + ODBType.SIZE_OF_INT);
            }
            ObjectInfoHeader oip = new ObjectInfoHeader(position, prevObjectOID, nextObjectOID, classInfoId, attributesIdentification, attributeIds);
            oip.setObjectVersion(objectVersion);
            oip.setCreationDate(creationDate);
            oip.setUpdateDate(updateDate);
            oip.setOid(oid);
            oip.setClassInfoId(classInfoId);
            if (useCache) {
                this.storageEngine.getSession(true).getCache().addObjectInfo(oip);
            }
            return oip;
        }
        if (BlockTypes.isPointer(blockType)) {
            throw new CorruptedDatabaseException(NeoDatisError.FOUND_POINTER.addParameter(oid).addParameter(position));
        }
        throw new CorruptedDatabaseException(NeoDatisError.WRONG_TYPE_FOR_BLOCK_TYPE.addParameter((byte)4).addParameter(blockType).addParameter(position + "/oid=" + oid));
    }

    public AbstractObjectInfo readObjectInfoFromPosition(ClassInfo classInfo, long objectPosition, boolean useCache, boolean returnObjects) {
        ++this.currentDepth;
        try {
            if (objectPosition > this.fsi.getLength()) {
                throw new ODBRuntimeException(NeoDatisError.INSTANCE_POSITION_OUT_OF_FILE.addParameter(objectPosition).addParameter(this.fsi.getLength()));
            }
            if (objectPosition == 0L || objectPosition == 0L) {
                NonNativeDeletedObjectInfo nonNativeDeletedObjectInfo = new NonNativeDeletedObjectInfo(objectPosition, null);
                return nonNativeDeletedObjectInfo;
            }
            ICache cache = this.storageEngine.getSession(true).getCache();
            this.fsi.setReadPosition(objectPosition);
            int blockSize = this.fsi.readInt("object block size");
            byte blockType = this.fsi.readByte("object block type");
            if (BlockTypes.isNullNonNativeObject(blockType)) {
                NonNativeNullObjectInfo nonNativeNullObjectInfo = new NonNativeNullObjectInfo(classInfo);
                return nonNativeNullObjectInfo;
            }
            if (BlockTypes.isNullNativeObject(blockType)) {
                NullNativeObjectInfo nullNativeObjectInfo = NullNativeObjectInfo.getInstance();
                return nullNativeObjectInfo;
            }
            if (BlockTypes.isDeletedObject(blockType)) {
                NonNativeDeletedObjectInfo nonNativeDeletedObjectInfo = new NonNativeDeletedObjectInfo(objectPosition, null);
                return nonNativeDeletedObjectInfo;
            }
            if (BlockTypes.isPointer(blockType)) {
                throw new CorruptedDatabaseException(NeoDatisError.FOUND_POINTER.addParameter(objectPosition));
            }
            if (BlockTypes.isNative(blockType)) {
                int odbTypeId = this.fsi.readInt();
                boolean isNull = this.fsi.readBoolean("Native object is null ?");
                if (isNull) {
                    NullNativeObjectInfo nullNativeObjectInfo = new NullNativeObjectInfo(odbTypeId);
                    return nullNativeObjectInfo;
                }
                AbstractObjectInfo abstractObjectInfo = this.readNativeObjectInfo(odbTypeId, objectPosition, useCache, returnObjects, false);
                return abstractObjectInfo;
            }
            if (BlockTypes.isNonNative(blockType)) {
                throw new ODBRuntimeException(NeoDatisError.OBJECT_READER_DIRECT_CALL);
            }
            throw new ODBRuntimeException(NeoDatisError.UNKNOWN_BLOCK_TYPE.addParameter(blockType).addParameter(this.fsi.getPosition() - 1L));
        }
        finally {
            --this.currentDepth;
        }
    }

    @Override
    public NonNativeObjectInfo readNonNativeObjectInfoFromOid(ClassInfo classInfo, OID oid, boolean useCache, boolean returnObjects) {
        long position = this.getObjectPositionFromItsOid(oid, useCache, false);
        if (position == 0L) {
            return new NonNativeDeletedObjectInfo(position, oid);
        }
        if (position == -2L) {
            throw new ODBRuntimeException(NeoDatisError.OBJECT_WITH_OID_DOES_NOT_EXIST.addParameter(oid));
        }
        NonNativeObjectInfo nnoi = this.readNonNativeObjectInfoFromPosition(classInfo, oid, position, useCache, returnObjects);
        if (!this.storageEngine.isLocal()) {
            String fullClassName;
            if (this.triggerManager == null) {
                this.triggerManager = this.storageEngine.getTriggerManager();
            }
            if (this.triggerManager.hasSelectTriggersFor(fullClassName = nnoi.getClassInfo().getFullClassName())) {
                this.triggerManager.manageSelectTriggerAfter(fullClassName, nnoi, oid);
            }
        }
        return nnoi;
    }

    @Override
    public NonNativeObjectInfo readNonNativeObjectInfoFromPosition(ClassInfo classInfo, OID oid, long position, boolean useCache, boolean returnInstance) {
        ISession lsession = this.storageEngine.getSession(true);
        ICache cache = lsession.getCache();
        ITmpCache tmpCache = lsession.getTmpCache();
        NonNativeObjectInfo objectInfo = null;
        if (OdbConfiguration.isDebugEnabled(LOG_ID)) {
            DLogger.debug(this.depthToSpaces() + "Reading Non Native Object info with oid " + oid);
        }
        if (tmpCache.isReadingObjectInfoWithOid(oid)) {
            return tmpCache.getReadingObjectInfoFromOid(oid);
        }
        ObjectInfoHeader objectInfoHeader = this.getObjectInfoHeader(oid, position, useCache, cache);
        if (classInfo == null) {
            classInfo = this.storageEngine.getSession(true).getMetaModel().getClassInfoFromId(objectInfoHeader.getClassInfoId());
        }
        oid = objectInfoHeader.getOid();
        if (!classInfo.getId().equals(objectInfoHeader.getClassInfoId())) {
            classInfo = this.storageEngine.getSession(true).getMetaModel().getClassInfoFromId(objectInfoHeader.getClassInfoId());
        }
        if (OdbConfiguration.isDebugEnabled(LOG_ID)) {
            DLogger.debug(this.depthToSpaces() + "Reading Non Native Object info of " + (classInfo == null ? "?" : classInfo.getFullClassName()) + " at " + objectInfoHeader.getPosition() + " with id " + oid);
            DLogger.debug(this.depthToSpaces() + "  Object Header is " + objectInfoHeader);
        }
        objectInfo = new NonNativeObjectInfo(objectInfoHeader, classInfo);
        objectInfo.setOid(oid);
        objectInfo.setClassInfo(classInfo);
        objectInfo.setPosition(objectInfoHeader.getPosition());
        tmpCache.startReadingObjectInfoWithOid(objectInfo.getOid(), objectInfo);
        ClassAttributeInfo cai = null;
        AbstractObjectInfo aoi = null;
        long attributeIdentification = -1L;
        OdbArrayList<PendingReading> pendingReadings = new OdbArrayList<PendingReading>();
        for (int id = 1; id <= classInfo.getMaxAttributeId(); ++id) {
            cai = objectInfo.getClassInfo().getAttributeInfoFromId(id);
            if (cai == null) continue;
            attributeIdentification = objectInfoHeader.getAttributeIdentificationFromId(id);
            if (attributeIdentification == 0L || attributeIdentification == 0L) {
                aoi = cai.isNative() ? NullNativeObjectInfo.getInstance() : new NonNativeNullObjectInfo();
                objectInfo.setAttributeValue(id, aoi);
                continue;
            }
            if (attributeIdentification < 0L) {
                OID attributeOid = OIDFactory.buildObjectOID(-attributeIdentification);
                pendingReadings.add(new PendingReading(id, null, attributeOid));
                continue;
            }
            aoi = this.readObjectInfo(attributeIdentification, useCache, returnInstance);
            objectInfo.setAttributeValue(id, aoi);
        }
        PendingReading pr = null;
        for (int i = 0; i < pendingReadings.size(); ++i) {
            pr = (PendingReading)pendingReadings.get(i);
            boolean useCacheForAttribute = useCache || !cache.objectWithIdIsInCommitedZone(pr.getAttributeOID());
            aoi = this.readNonNativeObjectInfoFromOid(pr.getCi(), pr.getAttributeOID(), useCacheForAttribute, returnInstance);
            objectInfo.setAttributeValue(pr.getId(), aoi);
        }
        if (returnInstance) {
            // empty if block
        }
        return objectInfo;
    }

    @Override
    public AttributeValuesMap readObjectInfoValuesFromOID(ClassInfo classInfo, OID oid, boolean useCache, IOdbList<String> attributeNames, IOdbList<String> relationAttributeNames, int recursionLevel, String[] orderByFields, boolean useOidForObject) {
        long position = this.getObjectPositionFromItsOid(oid, useCache, true);
        return this.readObjectInfoValuesFromPosition(classInfo, oid, position, useCache, attributeNames, relationAttributeNames, recursionLevel, orderByFields, useOidForObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AttributeValuesMap readObjectInfoValuesFromPosition(ClassInfo classInfo, OID oid, long position, boolean useCache, IOdbList<String> attributeNames, IOdbList<String> relationAttributeNames, int recursionLevel, String[] orderByFields, boolean useOidForObject) {
        ++this.currentDepth;
        AttributeValuesMap map = new AttributeValuesMap();
        if (position > this.fsi.getLength()) {
            throw new ODBRuntimeException(NeoDatisError.INSTANCE_POSITION_OUT_OF_FILE.addParameter(position).addParameter(this.fsi.getLength()));
        }
        ICache cache = this.storageEngine.getSession(true).getCache();
        this.fsi.setReadPosition(position);
        int blockSize = this.fsi.readInt();
        byte blockType = this.fsi.readByte();
        if (BlockTypes.isNull(blockType) || BlockTypes.isDeletedObject(blockType)) {
            return map;
        }
        if (BlockTypes.isPointer(blockType)) {
            throw new CorruptedDatabaseException(NeoDatisError.FOUND_POINTER.addParameter(oid).addParameter(position));
        }
        try {
            ObjectInfoHeader objectInfoHeader = this.getObjectInfoHeader(oid, position, true, cache);
            oid = objectInfoHeader.getOid();
            if (classInfo == null) {
                classInfo = this.storageEngine.getSession(true).getMetaModel().getClassInfoFromId(objectInfoHeader.getClassInfoId());
            }
            if (recursionLevel == 0) {
                map.setObjectInfoHeader(objectInfoHeader);
            }
            if (BlockTypes.isNative(blockType)) {
                AttributeValuesMap attributeValuesMap = map;
                return attributeValuesMap;
            }
            ClassAttributeInfo cai = null;
            int nbAttributes = attributeNames.size();
            String attributeNameToSearch = null;
            String relationNameToSearch = null;
            String singleAttributeName = null;
            boolean mustNavigate = false;
            for (int attributeIndex = 0; attributeIndex < nbAttributes; ++attributeIndex) {
                attributeNameToSearch = attributeNames.get(attributeIndex);
                relationNameToSearch = relationAttributeNames.get(attributeIndex);
                mustNavigate = attributeNameToSearch.indexOf(".") != -1;
                long attributeIdentification = -1L;
                long attributePosition = -1L;
                OID attributeOid = null;
                if (mustNavigate) {
                    int firstDotIndex = attributeNameToSearch.indexOf(".");
                    String relationAttributeName = OdbString.substring(attributeNameToSearch, firstDotIndex + 1);
                    singleAttributeName = OdbString.substring(attributeNameToSearch, 0, firstDotIndex);
                    int attributeId = classInfo.getAttributeId(singleAttributeName);
                    if (attributeId == -1) {
                        throw new ODBRuntimeException(NeoDatisError.CRITERIA_QUERY_UNKNOWN_ATTRIBUTE.addParameter(attributeNameToSearch).addParameter(classInfo.getFullClassName()));
                    }
                    cai = classInfo.getAttributeInfoFromId(attributeId);
                    attributeIdentification = objectInfoHeader.getAttributeIdentificationFromId(cai.getId());
                    if (!cai.isNative()) {
                        if (attributeIdentification == 0L) {
                            map.put(relationNameToSearch, null);
                            continue;
                        }
                        attributeOid = OIDFactory.buildObjectOID(-attributeIdentification);
                        attributePosition = this.getObjectPositionFromItsOid(attributeOid, useCache, false);
                        OdbArrayList<String> list1 = new OdbArrayList<String>(1);
                        list1.add(relationAttributeName);
                        OdbArrayList<String> list2 = new OdbArrayList<String>(1);
                        list2.add(relationNameToSearch);
                        map.putAll(this.readObjectInfoValuesFromPosition(cai.getClassInfo(), attributeOid, attributePosition, useCache, list1, list2, recursionLevel + 1, orderByFields, useOidForObject));
                        continue;
                    }
                    throw new ODBRuntimeException(NeoDatisError.CRITERIA_QUERY_UNKNOWN_ATTRIBUTE.addParameter(attributeNameToSearch).addParameter(classInfo.getFullClassName()));
                }
                int attributeId = classInfo.getAttributeId(attributeNameToSearch);
                if (attributeId == -1) {
                    throw new ODBRuntimeException(NeoDatisError.CRITERIA_QUERY_UNKNOWN_ATTRIBUTE.addParameter(attributeNameToSearch).addParameter(classInfo.getFullClassName()));
                }
                cai = classInfo.getAttributeInfoFromId(attributeId);
                attributeIdentification = objectInfoHeader.getAttributeIdentificationFromId(cai.getId());
                if (cai.isNonNative()) {
                    attributeOid = OIDFactory.buildObjectOID(-attributeIdentification);
                }
                if ((attributePosition = cai.isNonNative() && attributeIdentification < 0L ? this.getObjectPositionFromItsOid(attributeOid, useCache, false) : attributeIdentification) == 0L || attributePosition == 0L || attributePosition == -1L) continue;
                this.fsi.setReadPosition(attributePosition);
                AbstractObjectInfo aoi = null;
                Object object = null;
                if (cai.isNative()) {
                    aoi = this.readNativeObjectInfo(cai.getAttributeType().getId(), attributePosition, useCache, true, true);
                    object = aoi.getObject();
                    map.put(relationNameToSearch, object);
                    continue;
                }
                NonNativeObjectInfo nnoi = this.readNonNativeObjectInfoFromOid(cai.getClassInfo(), attributeOid, true, false);
                if (useOidForObject) {
                    map.put(relationNameToSearch, nnoi.getOid());
                    continue;
                }
                object = nnoi.getObject();
                if (object == null) {
                    object = this.instanceBuilder.buildOneInstance(nnoi);
                }
                map.put(relationNameToSearch, object);
            }
            AttributeValuesMap attributeValuesMap = map;
            return attributeValuesMap;
        }
        finally {
            --this.currentDepth;
        }
    }

    public ObjectInfoHeader getObjectInfoHeader(OID oid, long position, boolean useCache, ICache cache) {
        ObjectInfoHeader objectInfoHeader = null;
        if (useCache && oid != null) {
            objectInfoHeader = cache.getObjectInfoHeaderFromOid(oid, false);
        }
        if (objectInfoHeader == null) {
            objectInfoHeader = this.readObjectInfoHeaderFromPosition(oid, position, false);
            boolean oidWasNull = oid == null;
            oid = objectInfoHeader.getOid();
            if (useCache) {
                ObjectInfoHeader cachedOih;
                boolean needToUpdateCache = true;
                if (oidWasNull && (cachedOih = cache.getObjectInfoHeaderFromOid(oid, false)) != null) {
                    objectInfoHeader = cachedOih;
                    needToUpdateCache = false;
                }
                if (needToUpdateCache) {
                    cache.addObjectInfo(objectInfoHeader);
                }
            }
        }
        return objectInfoHeader;
    }

    protected NativeAttributeHeader readNativeAttributeHeader() {
        NativeAttributeHeader nah = new NativeAttributeHeader();
        int size = ODBType.INTEGER.getSize() + ODBType.BYTE.getSize() + ODBType.INTEGER.getSize() + ODBType.BOOLEAN.getSize();
        byte[] bytes = this.fsi.readBytes(size);
        int blockSize = this.byteArrayConverter.byteArrayToInt(bytes, 0);
        byte blockType = bytes[4];
        int odbTypeId = this.byteArrayConverter.byteArrayToInt(bytes, 5);
        boolean isNull = this.byteArrayConverter.byteArrayToBoolean(bytes, 9);
        nah.setBlockSize(blockSize);
        nah.setBlockType(blockType);
        nah.setOdbTypeId(odbTypeId);
        nah.setNull(isNull);
        return nah;
    }

    private AbstractObjectInfo readNativeObjectInfo(int odbDeclaredTypeId, long position, boolean useCache, boolean returnObject, boolean readHeader) {
        if (OdbConfiguration.isDebugEnabled(LOG_ID)) {
            DLogger.debug(this.depthToSpaces() + "Reading native object of type " + ODBType.getNameFromId(odbDeclaredTypeId) + " at position " + position);
        }
        int realTypeId = odbDeclaredTypeId;
        if (readHeader) {
            NativeAttributeHeader nah = this.readNativeAttributeHeader();
            if (nah.isNull()) {
                return new NullNativeObjectInfo(odbDeclaredTypeId);
            }
            realTypeId = nah.getOdbTypeId();
        }
        if (ODBType.isAtomicNative(realTypeId)) {
            return this.readAtomicNativeObjectInfo(position, realTypeId);
        }
        if (ODBType.isNull(realTypeId)) {
            return new NullNativeObjectInfo(realTypeId);
        }
        if (ODBType.isCollection(realTypeId)) {
            return this.readCollection(position, useCache, returnObject);
        }
        if (ODBType.isArray(realTypeId)) {
            return this.readArray(position, useCache, returnObject);
        }
        if (ODBType.isMap(realTypeId)) {
            return this.readMap(position, useCache, returnObject);
        }
        if (ODBType.isEnum(realTypeId)) {
            return this.readEnumObjectInfo(position, realTypeId);
        }
        throw new ODBRuntimeException(NeoDatisError.NATIVE_TYPE_NOT_SUPPORTED.addParameter(realTypeId));
    }

    @Override
    public Object readAtomicNativeObjectInfoAsObject(long position, int odbTypeId) {
        Object o = null;
        switch (odbTypeId) {
            case 20: 
            case 90: {
                o = new Byte(this.fsi.readByte("atomic"));
                break;
            }
            case 10: 
            case 160: {
                boolean b = this.fsi.readBoolean("atomic");
                if (b) {
                    o = Boolean.TRUE;
                    break;
                }
                o = Boolean.FALSE;
                break;
            }
            case 30: 
            case 150: {
                o = new Character(this.fsi.readChar("atomic"));
                break;
            }
            case 70: 
            case 130: {
                o = new Float(this.fsi.readFloat("atomic"));
                break;
            }
            case 80: 
            case 140: {
                o = new Double(this.fsi.readDouble("atomic"));
                break;
            }
            case 50: 
            case 110: {
                o = new Integer(this.fsi.readInt("atomic"));
                break;
            }
            case 60: 
            case 120: {
                o = new Long(this.fsi.readLong("atomic"));
                break;
            }
            case 40: 
            case 100: {
                o = new Short(this.fsi.readShort("atomic"));
                break;
            }
            case 200: {
                o = this.fsi.readBigDecimal("atomic");
                break;
            }
            case 190: {
                o = this.fsi.readBigInteger("atomic");
                break;
            }
            case 170: {
                o = this.fsi.readDate("atomic");
                break;
            }
            case 171: {
                o = new Date(this.fsi.readDate("atomic").getTime());
                break;
            }
            case 172: {
                o = new Timestamp(this.fsi.readDate("atomic").getTime());
                break;
            }
            case 173: 
            case 174: {
                Calendar c = Calendar.getInstance();
                c.setTime(this.fsi.readDate("atomic"));
                o = c;
                break;
            }
            case 181: {
                long oid = this.fsi.readLong("oid");
                o = OIDFactory.buildObjectOID(oid);
                break;
            }
            case 182: {
                long cid = this.fsi.readLong("oid");
                o = OIDFactory.buildClassOID(cid);
                break;
            }
            case 210: {
                o = this.fsi.readString(true);
                break;
            }
            case 211: {
                o = this.fsi.readString(false);
            }
        }
        if (o == null) {
            throw new ODBRuntimeException(NeoDatisError.NATIVE_TYPE_NOT_SUPPORTED.addParameter(odbTypeId).addParameter(ODBType.getNameFromId(odbTypeId)));
        }
        return o;
    }

    @Override
    public AtomicNativeObjectInfo readAtomicNativeObjectInfo(long position, int odbTypeId) {
        Object object = this.readAtomicNativeObjectInfoAsObject(position, odbTypeId);
        return new AtomicNativeObjectInfo(object, odbTypeId);
    }

    public EnumNativeObjectInfo readEnumObjectInfo(long position, int odbTypeId) {
        long enumClassInfoId = this.fsi.readLong("EnumClassInfoId");
        String enumValue = this.fsi.readString(true);
        ClassInfo enumCi = this.getSession().getMetaModel().getClassInfoFromId(OIDFactory.buildClassOID(enumClassInfoId));
        return new EnumNativeObjectInfo(enumCi, enumValue);
    }

    private CollectionObjectInfo readCollection(long position, boolean useCache, boolean returnObjects) {
        int i;
        AbstractObjectInfo aoi = null;
        String realCollectionClassName = this.fsi.readString(false, "Real collection class name");
        int collectionSize = this.fsi.readInt("Collection size");
        Object clazz = null;
        ArrayList<AbstractObjectInfo> c = new ArrayList<AbstractObjectInfo>(collectionSize);
        long[] objectIdentifications = new long[collectionSize];
        for (i = 0; i < collectionSize; ++i) {
            objectIdentifications[i] = this.fsi.readLong("position of element " + (i + 1));
        }
        for (i = 0; i < collectionSize; ++i) {
            try {
                aoi = this.readObjectInfo(objectIdentifications[i], useCache, returnObjects);
                if (aoi instanceof NonNativeDeletedObjectInfo) continue;
                c.add(aoi);
                continue;
            }
            catch (Exception e) {
                throw new ODBRuntimeException(NeoDatisError.INTERNAL_ERROR.addParameter("in ObjectReader.readCollection - at position " + position), (Throwable)e);
            }
        }
        CollectionObjectInfo coi = new CollectionObjectInfo(c);
        coi.setRealCollectionClassName(realCollectionClassName);
        return coi;
    }

    private ArrayObjectInfo readArray(long position, boolean useCache, boolean returnObjects) {
        int i;
        long[] objectIdentifications = null;
        boolean arrayComponentHasFixedSize = true;
        String realArrayComponentClassName = this.fsi.readString(false, "real array class name");
        ODBType subTypeId = ODBType.getFromName(realArrayComponentClassName);
        boolean componentIsNative = subTypeId.isNative();
        int arraySize = this.fsi.readInt();
        if (OdbConfiguration.isDebugEnabled(LOG_ID)) {
            DLogger.debug(this.depthToSpaces() + "reading an array of " + realArrayComponentClassName + " with " + arraySize + " elements");
        }
        Object[] array = new Object[arraySize];
        objectIdentifications = new long[arraySize];
        for (i = 0; i < arraySize; ++i) {
            objectIdentifications[i] = this.fsi.readLong();
        }
        for (i = 0; i < arraySize; ++i) {
            try {
                if (objectIdentifications[i] != 0L) {
                    AbstractObjectInfo o = this.readObjectInfo(objectIdentifications[i], useCache, returnObjects);
                    if (o instanceof NonNativeDeletedObjectInfo) continue;
                    OdbArray.setValue(array, i, o);
                    continue;
                }
                if (componentIsNative) {
                    OdbArray.setValue(array, i, NullNativeObjectInfo.getInstance());
                    continue;
                }
                OdbArray.setValue(array, i, new NonNativeNullObjectInfo());
                continue;
            }
            catch (Exception e) {
                throw new ODBRuntimeException(NeoDatisError.INTERNAL_ERROR.addParameter("in ObjectReader.readArray - at position " + position), (Throwable)e);
            }
        }
        ArrayObjectInfo aoi = new ArrayObjectInfo(array);
        aoi.setRealArrayComponentClassName(realArrayComponentClassName);
        aoi.setComponentTypeId(subTypeId.getId());
        return aoi;
    }

    private MapObjectInfo readMap(long position, boolean useCache, boolean returnObjects) {
        int i;
        AbstractObjectInfo aoiKey = null;
        AbstractObjectInfo aoiValue = null;
        String realMapClassName = this.fsi.readString(false);
        int mapSize = this.fsi.readInt();
        Class<HashMap> clazz = null;
        try {
            clazz = this.classPool.getClass(realMapClassName);
        }
        catch (ODBRuntimeException e) {
            clazz = HashMap.class;
        }
        clazz = HashMap.class;
        Map map = null;
        try {
            map = (Map)clazz.newInstance();
        }
        catch (Exception e1) {
            throw new ODBRuntimeException(NeoDatisError.MAP_INSTANCIATION_ERROR.addParameter(realMapClassName));
        }
        long[] objectIdentifications = new long[mapSize * 2];
        for (i = 0; i < mapSize * 2; ++i) {
            objectIdentifications[i] = this.fsi.readLong();
        }
        for (i = 0; i < mapSize; ++i) {
            try {
                aoiKey = this.readObjectInfo(objectIdentifications[2 * i], useCache, returnObjects);
                aoiValue = this.readObjectInfo(objectIdentifications[2 * i + 1], useCache, returnObjects);
                if (aoiKey.isDeletedObject() || aoiValue.isDeletedObject()) continue;
                map.put(aoiKey, aoiValue);
                continue;
            }
            catch (Exception e) {
                throw new ODBRuntimeException(NeoDatisError.INTERNAL_ERROR.addParameter("in ObjectReader.readMap - at position " + position), (Throwable)e);
            }
        }
        return new MapObjectInfo(map, realMapClassName);
    }

    @Override
    public OID getNextObjectOID(OID oid) {
        long position = this.storageEngine.getObjectWriter().getIdManager().getObjectPositionWithOid(oid, true);
        this.fsi.setReadPosition(position + StorageEngineConstant.OBJECT_OFFSET_NEXT_OBJECT_OID);
        return OIDFactory.buildObjectOID(this.fsi.readLong());
    }

    @Override
    public long readOidPosition(OID oid) {
        if (OdbConfiguration.isDebugEnabled(LOG_ID)) {
            DLogger.debug("  Start of readOidPosition for oid " + oid);
        }
        long blockNumber = this.getIdBlockNumberOfOid(oid);
        long blockPosition = -1L;
        blockPosition = this.getIdBlockPositionFromNumber(blockNumber);
        if (OdbConfiguration.isDebugEnabled(LOG_ID)) {
            DLogger.debug("  Block number of oid " + oid + " is " + blockNumber + " / block position = " + blockPosition);
        }
        long position = blockPosition + StorageEngineConstant.BLOCK_ID_OFFSET_FOR_START_OF_REPETITION + (oid.getObjectId() - 1L) % (long)OdbConfiguration.getNB_IDS_PER_BLOCK() * (long)OdbConfiguration.getID_BLOCK_REPETITION_SIZE();
        if (OdbConfiguration.isDebugEnabled(LOG_ID)) {
            DLogger.debug("  End of readOidPosition for oid " + oid + " returning position " + position);
        }
        return position;
    }

    @Override
    public Object getObjectFromOid(OID oid, boolean returnInstance, boolean useCache) {
        long position = this.getObjectPositionFromItsOid(oid, useCache, true);
        Object o = this.readNonNativeObjectAtPosition(position, useCache, returnInstance);
        this.getSession().getTmpCache().clearObjectInfos();
        return o;
    }

    public String getObjectTypeFromPosition(long objectPosition) {
        long blockPosition = objectPosition + StorageEngineConstant.OBJECT_OFFSET_BLOCK_TYPE;
        this.fsi.setReadPosition(blockPosition);
        byte blockType = this.fsi.readByte();
        if (BlockTypes.isNull(blockType)) {
            OID classIdForNullObject = OIDFactory.buildClassOID(this.fsi.readLong("class id of object"));
            return "null " + this.storageEngine.getSession(true).getMetaModel().getClassInfoFromId(classIdForNullObject).getFullClassName();
        }
        long classIdPosition = objectPosition + StorageEngineConstant.OBJECT_OFFSET_CLASS_INFO_ID;
        this.fsi.setReadPosition(classIdPosition);
        OID classId = OIDFactory.buildClassOID(this.fsi.readLong("class id of object"));
        return this.storageEngine.getSession(true).getMetaModel().getClassInfoFromId(classId).getFullClassName();
    }

    @Override
    public long getObjectPositionFromItsOid(OID oid, boolean useCache, boolean throwException) {
        if (OdbConfiguration.isDebugEnabled(LOG_ID)) {
            DLogger.debug("  getObjectPositionFromItsId for oid " + oid);
        }
        long position = -1L;
        if (useCache) {
            position = this.storageEngine.getSession(true).getCache().getObjectPositionByOid(oid);
        }
        if (position == 0L) {
            if (throwException) {
                throw new CorruptedDatabaseException(NeoDatisError.OBJECT_IS_MARKED_AS_DELETED_FOR_OID.addParameter(oid));
            }
            return 0L;
        }
        if (position != -1L && position != 0L) {
            return position;
        }
        position = this.readOidPosition(oid);
        this.fsi.setReadPosition(position += StorageEngineConstant.BLOCK_ID_REPETITION_ID_STATUS);
        byte idStatus = this.fsi.readByte();
        long objectPosition = this.fsi.readLong();
        if (!IDStatus.isActive(idStatus)) {
            if (throwException) {
                if (objectPosition == 0L) {
                    throw new CorruptedDatabaseException(NeoDatisError.OBJECT_WITH_OID_DOES_NOT_EXIST.addParameter(oid));
                }
                throw new CorruptedDatabaseException(NeoDatisError.OBJECT_IS_MARKED_AS_DELETED_FOR_OID.addParameter(oid));
            }
            if (objectPosition == 0L) {
                return -2L;
            }
            return 0L;
        }
        if (OdbConfiguration.isDebugEnabled(LOG_ID)) {
            DLogger.debug("  object position of object with oid " + oid + " is " + objectPosition);
        }
        return objectPosition;
    }

    private long getIdBlockPositionFromNumber(long blockNumberToFind) {
        Long lposition = this.blockPositions.get(blockNumberToFind);
        if (lposition != null) {
            return lposition;
        }
        long nextBlockPosition = 0L;
        long currentBlockPosition = StorageEngineConstant.DATABASE_HEADER_FIRST_ID_BLOCK_POSITION;
        int blockNumber = -1;
        while (currentBlockPosition != -1L) {
            this.fsi.setReadPosition(currentBlockPosition + StorageEngineConstant.BLOCK_ID_OFFSET_FOR_NEXT_BLOCK);
            nextBlockPosition = this.fsi.readLong();
            blockNumber = this.fsi.readInt();
            if ((long)blockNumber == blockNumberToFind) {
                this.blockPositions.put(blockNumberToFind, currentBlockPosition);
                return currentBlockPosition;
            }
            currentBlockPosition = nextBlockPosition;
        }
        throw new CorruptedDatabaseException(NeoDatisError.BLOCK_NUMBER_DOES_EXIST.addParameter(blockNumberToFind));
    }

    private long getIdBlockNumberOfOid(OID oid) {
        long number = -1L;
        long objectId = oid.getObjectId();
        number = objectId % (long)OdbConfiguration.getNB_IDS_PER_BLOCK() == 0L ? objectId / (long)OdbConfiguration.getNB_IDS_PER_BLOCK() : objectId / (long)OdbConfiguration.getNB_IDS_PER_BLOCK() + 1L;
        return number;
    }

    @Override
    public List<Long> getAllIds(byte idType) {
        long blockMaxId = 0L;
        long currentId = 0L;
        byte idTypeRead = 0;
        byte idStatus = 0;
        long nextRepetitionPosition = 0L;
        ArrayList<Long> ids = new ArrayList<Long>(5000);
        long nextBlockPosition = 0L;
        long currentBlockPosition = StorageEngineConstant.DATABASE_HEADER_FIRST_ID_BLOCK_POSITION;
        while (currentBlockPosition != -1L) {
            this.fsi.setReadPosition(currentBlockPosition + StorageEngineConstant.BLOCK_ID_OFFSET_FOR_NEXT_BLOCK);
            nextBlockPosition = this.fsi.readLong();
            this.fsi.setReadPosition(currentBlockPosition + StorageEngineConstant.BLOCK_ID_OFFSET_FOR_MAX_ID);
            blockMaxId = this.fsi.readLong();
            do {
                nextRepetitionPosition = this.fsi.getPosition() + (long)OdbConfiguration.getID_BLOCK_REPETITION_SIZE();
                idTypeRead = this.fsi.readByte();
                currentId = this.fsi.readLong();
                idStatus = this.fsi.readByte();
                if (idType == idTypeRead && IDStatus.isActive(idStatus)) {
                    ids.add(new Long(currentId));
                }
                this.fsi.setReadPosition(nextRepetitionPosition);
            } while (currentId != blockMaxId);
            currentBlockPosition = nextBlockPosition;
        }
        return ids;
    }

    @Override
    public List<FullIDInfo> getAllIdInfos(String objectTypeToDisplay, byte idType, boolean displayObject) {
        long blockId = 0L;
        long blockMaxId = 0L;
        long currentId = 0L;
        byte idTypeRead = 0;
        byte idStatus = 0;
        long objectPosition = 0L;
        long nextRepetitionPosition = 0L;
        String objectType = null;
        ArrayList<FullIDInfo> idInfos = new ArrayList<FullIDInfo>(5000);
        long nextBlockPosition = 0L;
        OID prevObjectOID = null;
        OID nextObjectOID = null;
        long currentBlockPosition = StorageEngineConstant.DATABASE_HEADER_FIRST_ID_BLOCK_POSITION;
        FullIDInfo info = null;
        String objectToString = "empty";
        while (currentBlockPosition != -1L) {
            DLogger.debug("Current block position = " + currentBlockPosition);
            this.fsi.setReadPosition(currentBlockPosition + StorageEngineConstant.BLOCK_ID_OFFSET_FOR_BLOCK_NUMBER);
            this.fsi.setReadPosition(currentBlockPosition + StorageEngineConstant.BLOCK_ID_OFFSET_FOR_NEXT_BLOCK);
            nextBlockPosition = this.fsi.readLong();
            blockId = this.fsi.readInt();
            blockMaxId = this.fsi.readLong();
            do {
                nextRepetitionPosition = this.fsi.getPosition() + (long)OdbConfiguration.getID_BLOCK_REPETITION_SIZE();
                idTypeRead = this.fsi.readByte();
                currentId = this.fsi.readLong();
                idStatus = this.fsi.readByte();
                objectPosition = this.fsi.readLong();
                if (idType == idTypeRead) {
                    long currentPosition = this.fsi.getPosition();
                    if (displayObject) {
                        NonNativeObjectInfo aoi = null;
                        try {
                            aoi = this.readNonNativeObjectInfoFromPosition(null, null, objectPosition, false, false);
                            if (!(aoi instanceof NonNativeDeletedObjectInfo)) {
                                objectToString = ((Object)aoi).toString();
                                NonNativeObjectInfo nnoi = aoi;
                                prevObjectOID = nnoi.getPreviousObjectOID();
                                nextObjectOID = nnoi.getNextObjectOID();
                            } else {
                                objectToString = " deleted";
                                prevObjectOID = null;
                                nextObjectOID = null;
                            }
                        }
                        catch (Exception e) {
                            objectToString = "?";
                            prevObjectOID = null;
                            nextObjectOID = null;
                        }
                    }
                    try {
                        objectType = this.getObjectTypeFromPosition(objectPosition);
                    }
                    catch (Exception e) {
                        objectType = "(error?)";
                    }
                    if (objectTypeToDisplay == null || objectTypeToDisplay.equals(objectType)) {
                        this.fsi.setReadPosition(currentPosition);
                        info = new FullIDInfo(currentId, objectPosition, idStatus, blockId, objectType, objectToString, prevObjectOID, nextObjectOID);
                        idInfos.add(info);
                    }
                } else {
                    try {
                        ClassInfo ci = this.readClassInfoHeader(OIDFactory.buildClassOID(currentId));
                        objectType = "Class def. of " + ci.getFullClassName();
                        objectToString = ci.toString();
                        prevObjectOID = ci.getPreviousClassOID();
                        nextObjectOID = ci.getNextClassOID();
                        info = new FullIDInfo(currentId, objectPosition, idStatus, blockId, objectType, objectToString, prevObjectOID, nextObjectOID);
                        idInfos.add(info);
                    }
                    catch (Exception e) {
                        info = new FullIDInfo(currentId, objectPosition, idStatus, blockId, "unknow", "Error", null, null);
                        idInfos.add(info);
                    }
                }
                this.fsi.setReadPosition(nextRepetitionPosition);
            } while (currentId != blockMaxId);
            currentBlockPosition = nextBlockPosition;
        }
        return idInfos;
    }

    @Override
    public OID getIdOfObjectAt(long position, boolean includeDeleted) {
        this.fsi.setReadPosition(position + (long)ODBType.INTEGER.getSize());
        byte blockType = this.fsi.readByte("object block type");
        if (BlockTypes.isPointer(blockType)) {
            return this.getIdOfObjectAt(this.fsi.readLong("new position"), includeDeleted);
        }
        if (BlockTypes.isNonNative(blockType)) {
            return OIDFactory.buildObjectOID(this.fsi.readLong("oid"));
        }
        if (includeDeleted && BlockTypes.isDeletedObject(blockType)) {
            return OIDFactory.buildObjectOID(this.fsi.readLong("oid"));
        }
        throw new CorruptedDatabaseException(NeoDatisError.WRONG_TYPE_FOR_BLOCK_TYPE.addParameter((byte)4).addParameter(blockType).addParameter(position));
    }

    @Override
    public void close() {
        this.storageEngine = null;
        this.blockPositions.clear();
        this.blockPositions = null;
    }

    @Override
    public Object buildOneInstance(NonNativeObjectInfo objectInfo) {
        return this.instanceBuilder.buildOneInstance(objectInfo);
    }

    public <T> Objects<T> getObjects(Class clazz, boolean inMemory, int startIndex, int endIndex) {
        return this.getObjects(new CriteriaQuery(clazz), inMemory, startIndex, endIndex);
    }

    public <T> Objects<T> getObjects(String fullClassName, boolean inMemory, int startIndex, int endIndex) {
        return this.getObjects(new CriteriaQuery(fullClassName), inMemory, startIndex, endIndex);
    }

    @Override
    public <T> Objects<T> getObjects(IQuery query, boolean inMemory, int startIndex, int endIndex) {
        CollectionQueryResultAction queryResultAction = new CollectionQueryResultAction(query, inMemory, this.storageEngine, true, this.instanceBuilder);
        return QueryManager.getQueryExecutor(query, this.storageEngine, this.instanceBuilder).execute(inMemory, startIndex, endIndex, false, queryResultAction);
    }

    @Override
    public Values getValues(IValuesQuery valuesQuery, int startIndex, int endIndex) {
        IMatchingObjectAction queryResultAction = null;
        queryResultAction = valuesQuery.hasGroupBy() ? new GroupByValuesQueryResultAction(valuesQuery, this.storageEngine, this.instanceBuilder) : new ValuesQueryResultAction(valuesQuery, this.storageEngine, this.instanceBuilder);
        Objects objects = this.getObjectInfos(valuesQuery, true, startIndex, endIndex, false, queryResultAction);
        return (Values)objects;
    }

    public ISession getSession() {
        return this.storageEngine.getSession(true);
    }

    @Override
    public <T> Objects<T> getObjectInfos(IQuery query, boolean inMemory, int startIndex, int endIndex, boolean returnObjects, IMatchingObjectAction queryResultAction) {
        IQueryExecutor executor = QueryManager.getQueryExecutor(query, this.storageEngine, this.instanceBuilder);
        return executor.execute(inMemory, startIndex, endIndex, returnObjects, queryResultAction);
    }

    public <T> Objects<T> getObjectInfos(String fullClassName, boolean inMemory, int startIndex, int endIndex, boolean returnOjects) {
        CriteriaQuery query = new CriteriaQuery(fullClassName);
        CollectionQueryResultAction queryResultAction = new CollectionQueryResultAction(query, inMemory, this.storageEngine, returnOjects, this.instanceBuilder);
        return this.getObjectInfos(query, inMemory, startIndex, endIndex, returnOjects, queryResultAction);
    }

    @Override
    public String getBaseIdentification() {
        return this.storageEngine.getBaseIdentification().getIdentification();
    }

    public IOdbList<ObjectInfoHeader> getObjectInfoHeaderList(ClassInfo classInfo) {
        if (classInfo.getNumberOfObjects() == 0L) {
            return new OdbArrayList<ObjectInfoHeader>();
        }
        OdbArrayList<ObjectInfoHeader> list = new OdbArrayList<ObjectInfoHeader>((int)classInfo.getNumberOfObjects());
        ObjectInfoHeader oih = null;
        OID oid = classInfo.getCommitedZoneInfo().first;
        if (oid == null) {
            oid = classInfo.getUncommittedZoneInfo().first;
        }
        while (oid != null) {
            oih = this.readObjectInfoHeaderFromOid(oid, true);
            list.add(oih);
            oid = oih.getNextObjectOID();
        }
        return list;
    }

    public String getClassInfoFullObjectChaining(ClassInfo ci) {
        IOdbList<ObjectInfoHeader> oihs = this.getObjectInfoHeaderList(ci);
        StringBuilder builder = new StringBuilder();
        for (ObjectInfoHeader oih : oihs) {
            builder.append(oih.oidsToString());
        }
        if (oihs.isEmpty()) {
            builder.append(" No Object!");
        }
        return builder.toString();
    }

    @Override
    public IInstanceBuilder getInstanceBuilder() {
        return this.instanceBuilder;
    }
}

