/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.impl.core.layers.layer2.meta.compare;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.neodatis.odb.core.layers.layer2.meta.AbstractObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.ArrayObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.CollectionObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.EnumNativeObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.MapObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.NativeObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.NonNativeObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.ODBType;
import org.neodatis.odb.core.layers.layer2.meta.ObjectReference;
import org.neodatis.odb.core.layers.layer2.meta.compare.ArrayModifyElement;
import org.neodatis.odb.core.layers.layer2.meta.compare.ChangedAttribute;
import org.neodatis.odb.core.layers.layer2.meta.compare.ChangedNativeAttributeAction;
import org.neodatis.odb.core.layers.layer2.meta.compare.ChangedObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.compare.ChangedObjectReferenceAttributeAction;
import org.neodatis.odb.core.layers.layer2.meta.compare.IObjectInfoComparator;
import org.neodatis.odb.core.layers.layer2.meta.compare.NewNonNativeObjectAction;
import org.neodatis.odb.core.layers.layer2.meta.compare.SetAttributeToNullAction;
import org.neodatis.odb.core.server.layers.layer2.meta.ClientNonNativeObjectInfo;
import org.neodatis.tool.DLogger;
import org.neodatis.tool.wrappers.map.OdbHashMap;

public class ObjectInfoComparator
implements IObjectInfoComparator {
    private static final int SIZE = 5;
    public List<NonNativeObjectInfo> changedObjectMetaRepresentations = new ArrayList<NonNativeObjectInfo>(5);
    private List<SetAttributeToNullAction> attributeToSetToNull = new ArrayList<SetAttributeToNullAction>(5);
    public List<ChangedAttribute> changedAttributeActions;
    private Map<NonNativeObjectInfo, Integer> alreadyCheckingObjects = new OdbHashMap<NonNativeObjectInfo, Integer>(5);
    public List<Object> newObjects = new ArrayList<Object>(5);
    public List<NewNonNativeObjectAction> newObjectMetaRepresentations = new ArrayList<NewNonNativeObjectAction>(5);
    public List<ChangedObjectInfo> changes = new ArrayList<ChangedObjectInfo>(5);
    private List<ArrayModifyElement> arrayChanges;
    public int maxObjectRecursionLevel = 0;
    private int nbChanges;
    private boolean supportInPlaceUpdate = false;

    public ObjectInfoComparator() {
        this.changedAttributeActions = new ArrayList<ChangedAttribute>(5);
        this.arrayChanges = new ArrayList<ArrayModifyElement>();
    }

    @Override
    public boolean hasChanged(AbstractObjectInfo aoi1, AbstractObjectInfo aoi2) {
        return this.hasChanged(aoi1, aoi2, -1);
    }

    private boolean hasChanged(AbstractObjectInfo aoi1, AbstractObjectInfo aoi2, int objectRecursionLevel) {
        if (aoi1.isNull() != aoi2.isNull()) {
            return true;
        }
        if (aoi1.isNonNativeObject() && aoi2.isNonNativeObject()) {
            return this.hasChanged((NonNativeObjectInfo)aoi1, (NonNativeObjectInfo)aoi2, objectRecursionLevel + 1);
        }
        if (aoi1.isNative() && aoi2.isNative()) {
            return this.hasChanged((NativeObjectInfo)aoi1, (NativeObjectInfo)aoi2, 0);
        }
        return false;
    }

    private boolean hasChanged(NativeObjectInfo aoi1, NativeObjectInfo aoi2, int objectRecursionLevel) {
        if (aoi1.getObject() == null && aoi2.getObject() == null) {
            return false;
        }
        if (aoi1.getObject() == null || aoi2.getObject() == null) {
            return true;
        }
        return !aoi1.getObject().equals(aoi2.getObject());
    }

    private boolean hasChanged(NonNativeObjectInfo nnoi1, NonNativeObjectInfo nnoi2, int objectRecursionLevel) {
        AbstractObjectInfo value1 = null;
        AbstractObjectInfo value2 = null;
        boolean hasChanged = false;
        if (this.alreadyCheckingObjects.get(nnoi2) != null) {
            return false;
        }
        this.alreadyCheckingObjects.put(nnoi1, new Integer(1));
        this.alreadyCheckingObjects.put(nnoi2, new Integer(1));
        if (!(nnoi1.isNull() || nnoi2.isNull() || nnoi1.getClassInfo().getFullClassName().equals(nnoi2.getClassInfo().getFullClassName()))) {
            return true;
        }
        for (int id = 1; id <= nnoi1.getMaxNbattributes(); ++id) {
            value1 = nnoi1.getAttributeValueFromId(id);
            value2 = nnoi2.getAttributeValueFromId(id);
            if (value2 == null) {
                this.storeChangedObject(nnoi1, nnoi2, id, objectRecursionLevel);
                hasChanged = true;
                continue;
            }
            if (value1 == null) {
                this.supportInPlaceUpdate = false;
                continue;
            }
            if (value1.isNull() && value2.isNull()) continue;
            if (value1.isNull() || value2.isNull()) {
                this.supportInPlaceUpdate = false;
                hasChanged = true;
                this.storeActionSetAttributetoNull(nnoi1, id, objectRecursionLevel);
                continue;
            }
            if (!this.classAreCompatible(value1, value2)) {
                if (value2 instanceof NativeObjectInfo) {
                    this.storeChangedObject(nnoi1, nnoi2, id, objectRecursionLevel);
                    this.storeChangedAttributeAction(new ChangedNativeAttributeAction(nnoi1, nnoi2, nnoi1.getHeader().getAttributeIdentificationFromId(id), (NativeObjectInfo)value2, objectRecursionLevel, false, nnoi1.getClassInfo().getAttributeInfoFromId(id).getName()));
                }
                if (value2 instanceof ObjectReference && value1 instanceof NonNativeObjectInfo) {
                    NonNativeObjectInfo nnoi = (NonNativeObjectInfo)value1;
                    ObjectReference oref = (ObjectReference)value2;
                    if (nnoi.getOid().equals(oref.getOid())) continue;
                    this.storeChangedObject(nnoi1, nnoi2, id, objectRecursionLevel);
                    int attributeIdThatHasChanged = id;
                    long attributeDefinitionPosition = nnoi2.getAttributeDefinitionPosition(attributeIdThatHasChanged);
                    this.storeChangedAttributeAction(new ChangedObjectReferenceAttributeAction(attributeDefinitionPosition, (ObjectReference)value2, objectRecursionLevel));
                }
                hasChanged = true;
                continue;
            }
            if (value1.isAtomicNativeObject()) {
                if (value1.equals(value2)) continue;
                this.storeChangedAttributeAction(new ChangedNativeAttributeAction(nnoi1, nnoi2, nnoi1.getHeader().getAttributeIdentificationFromId(id), (NativeObjectInfo)value2, objectRecursionLevel, false, nnoi1.getClassInfo().getAttributeInfoFromId(id).getName()));
                hasChanged = true;
                continue;
            }
            if (value1.isCollectionObject()) {
                CollectionObjectInfo coi1 = (CollectionObjectInfo)value1;
                CollectionObjectInfo coi2 = (CollectionObjectInfo)value2;
                boolean collectionHasChanged = this.manageCollectionChanges(nnoi1, nnoi2, id, coi1, coi2, objectRecursionLevel);
                hasChanged = hasChanged || collectionHasChanged;
                continue;
            }
            if (value1.isArrayObject()) {
                ArrayObjectInfo aoi1 = (ArrayObjectInfo)value1;
                ArrayObjectInfo aoi2 = (ArrayObjectInfo)value2;
                boolean arrayHasChanged = this.manageArrayChanges(nnoi1, nnoi2, id, aoi1, aoi2, objectRecursionLevel);
                hasChanged = hasChanged || arrayHasChanged;
                continue;
            }
            if (value1.isMapObject()) {
                MapObjectInfo moi1 = (MapObjectInfo)value1;
                MapObjectInfo moi2 = (MapObjectInfo)value2;
                boolean mapHasChanged = this.manageMapChanges(nnoi1, nnoi2, id, moi1, moi2, objectRecursionLevel);
                hasChanged = hasChanged || mapHasChanged;
                continue;
            }
            if (value1.isEnumObject()) {
                EnumNativeObjectInfo enoi1 = (EnumNativeObjectInfo)value1;
                EnumNativeObjectInfo enoi2 = (EnumNativeObjectInfo)value2;
                boolean enumHasChanged = !enoi1.getEnumClassInfo().getId().equals(enoi2.getEnumClassInfo().getId()) || !enoi1.getEnumName().equals(enoi2.getEnumName());
                hasChanged = hasChanged || enumHasChanged;
                continue;
            }
            if (!value1.isNonNativeObject()) continue;
            NonNativeObjectInfo oi1 = (NonNativeObjectInfo)value1;
            NonNativeObjectInfo oi2 = (NonNativeObjectInfo)value2;
            if (oi1.getOid() != null && oi1.getOid().equals(oi2.getOid())) {
                hasChanged = this.hasChanged(value1, value2, objectRecursionLevel + 1) || hasChanged;
                continue;
            }
            hasChanged = true;
            long positionToUpdateReference = nnoi1.getAttributeDefinitionPosition(id);
            this.storeNewObjectReference(positionToUpdateReference, oi2, objectRecursionLevel, nnoi1.getClassInfo().getAttributeInfoFromId(id).getName());
            ++objectRecursionLevel;
            this.addPendingVerification(value2);
        }
        Integer i1 = this.alreadyCheckingObjects.get(nnoi1);
        Integer i2 = this.alreadyCheckingObjects.get(nnoi2);
        if (i1 != null) {
            i1 = new Integer(i1 - 1);
        }
        if (i2 != null) {
            i2 = new Integer(i2 - 1);
        }
        if (i1 != null && i1 == 0) {
            this.alreadyCheckingObjects.remove(nnoi1);
        } else {
            this.alreadyCheckingObjects.put(nnoi1, i1);
        }
        if (i2 != null && i2 == 0) {
            this.alreadyCheckingObjects.remove(nnoi2);
        } else {
            this.alreadyCheckingObjects.put(nnoi2, i2);
        }
        return hasChanged;
    }

    private void addPendingVerification(AbstractObjectInfo value) {
        this.supportInPlaceUpdate = false;
    }

    private void storeNewObjectReference(long positionToUpdateReference, NonNativeObjectInfo oi2, int objectRecursionLevel, String attributeName) {
        NewNonNativeObjectAction nnnoa = new NewNonNativeObjectAction(positionToUpdateReference, oi2, objectRecursionLevel, attributeName);
        this.newObjectMetaRepresentations.add(nnnoa);
        ++this.nbChanges;
    }

    private void storeActionSetAttributetoNull(NonNativeObjectInfo nnoi, int id, int objectRecursionLevel) {
        ++this.nbChanges;
        SetAttributeToNullAction action = new SetAttributeToNullAction(nnoi, id);
        this.attributeToSetToNull.add(action);
    }

    private void storeArrayChange(NonNativeObjectInfo nnoi, int arrayAttributeId, int arrayIndex, AbstractObjectInfo value, boolean supportInPlaceUpdate) {
        ++this.nbChanges;
        ArrayModifyElement ame = new ArrayModifyElement(nnoi, arrayAttributeId, arrayIndex, value, supportInPlaceUpdate);
        this.arrayChanges.add(ame);
    }

    private boolean classAreCompatible(AbstractObjectInfo value1, AbstractObjectInfo value2) {
        Class<?> clazz2;
        Class<?> clazz1 = value1.getClass();
        if (clazz1 == (clazz2 = value2.getClass())) {
            return true;
        }
        return clazz1 == NonNativeObjectInfo.class && clazz2 == ClientNonNativeObjectInfo.class;
    }

    private void storeChangedObject(NonNativeObjectInfo aoi1, NonNativeObjectInfo aoi2, int fieldId, AbstractObjectInfo oldValue, AbstractObjectInfo newValue, String message, int objectRecursionLevel) {
        if (aoi1 != null && aoi2 != null) {
            if (aoi1.getOid() != null && aoi1.getOid().equals(aoi2.getOid())) {
                this.changedObjectMetaRepresentations.add(aoi2);
                this.changes.add(new ChangedObjectInfo(aoi1.getClassInfo(), aoi2.getClassInfo(), fieldId, oldValue, newValue, message, objectRecursionLevel));
                if (objectRecursionLevel > this.maxObjectRecursionLevel) {
                    this.maxObjectRecursionLevel = objectRecursionLevel;
                }
                ++this.nbChanges;
            } else {
                this.newObjects.add(aoi2.getObject());
                String fieldName = aoi1.getClassInfo().getAttributeInfoFromId(fieldId).getName();
                long positionToUpdateReference = aoi1.getAttributeDefinitionPosition(fieldId);
                this.storeNewObjectReference(positionToUpdateReference, aoi2, objectRecursionLevel, fieldName);
            }
        } else {
            DLogger.info("Non native object with null object");
        }
    }

    private void storeChangedObject(NonNativeObjectInfo aoi1, NonNativeObjectInfo aoi2, int fieldId, int objectRecursionLevel) {
        ++this.nbChanges;
        if (aoi1 != null && aoi2 != null) {
            this.changes.add(new ChangedObjectInfo(aoi1.getClassInfo(), aoi2.getClassInfo(), fieldId, aoi1.getAttributeValueFromId(fieldId), aoi2.getAttributeValueFromId(fieldId), objectRecursionLevel));
            if (objectRecursionLevel > this.maxObjectRecursionLevel) {
                this.maxObjectRecursionLevel = objectRecursionLevel;
            }
        } else {
            DLogger.info("Non native object with null object");
        }
    }

    private boolean manageCollectionChanges(NonNativeObjectInfo nnoi1, NonNativeObjectInfo nnoi2, int fieldId, CollectionObjectInfo coi1, CollectionObjectInfo coi2, int objectRecursionLevel) {
        Collection<AbstractObjectInfo> collection1 = coi1.getCollection();
        Collection<AbstractObjectInfo> collection2 = coi2.getCollection();
        if (collection1.size() != collection2.size()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("Collection size has changed oldsize=").append(collection1.size()).append("/newsize=").append(collection2.size());
            this.storeChangedObject(nnoi1, nnoi2, fieldId, coi1, coi2, buffer.toString(), objectRecursionLevel);
            return true;
        }
        Iterator<AbstractObjectInfo> iterator1 = collection1.iterator();
        Iterator<AbstractObjectInfo> iterator2 = collection2.iterator();
        AbstractObjectInfo value1 = null;
        AbstractObjectInfo value2 = null;
        int index = 0;
        while (iterator1.hasNext()) {
            value1 = iterator1.next();
            boolean hasChanged = this.hasChanged(value1, value2 = iterator2.next(), objectRecursionLevel);
            if (hasChanged) {
                if (value1.isNonNativeObject() && value2.isNonNativeObject()) {
                    NonNativeObjectInfo nnoia = (NonNativeObjectInfo)value1;
                    NonNativeObjectInfo nnoib = (NonNativeObjectInfo)value2;
                    if (nnoia.getOid() != null && !nnoia.getOid().equals(nnoi2.getOid())) {
                        this.storeChangedObject(nnoi1, nnoi2, fieldId, value1, value2, "List element index " + index + " has changed", objectRecursionLevel);
                    }
                } else {
                    this.supportInPlaceUpdate = false;
                    ++this.nbChanges;
                }
                return true;
            }
            ++index;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean manageArrayChanges(NonNativeObjectInfo nnoi1, NonNativeObjectInfo nnoi2, int fieldId, ArrayObjectInfo aoi1, ArrayObjectInfo aoi2, int objectRecursionLevel) {
        Object[] array2;
        Object[] array1 = aoi1.getArray();
        if (array1.length != (array2 = aoi2.getArray()).length) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("Array size has changed oldsize=").append(array1.length).append("/newsize=").append(array2.length);
            this.storeChangedObject(nnoi1, nnoi2, fieldId, aoi1, aoi2, buffer.toString(), objectRecursionLevel);
            this.supportInPlaceUpdate = false;
            return true;
        }
        AbstractObjectInfo value1 = null;
        AbstractObjectInfo value2 = null;
        boolean localSupportInPlaceUpdate = ODBType.hasFixSize(aoi2.getComponentTypeId());
        int index = 0;
        boolean hasChanged = false;
        try {
            for (int i = 0; i < array1.length; ++i) {
                value1 = (AbstractObjectInfo)array1[i];
                value2 = (AbstractObjectInfo)array2[i];
                boolean localHasChanged = this.hasChanged(value1, value2, objectRecursionLevel);
                if (localHasChanged) {
                    this.storeArrayChange(nnoi1, fieldId, i, value2, localSupportInPlaceUpdate);
                    if (localSupportInPlaceUpdate) {
                        hasChanged = true;
                    } else {
                        boolean bl = hasChanged = true;
                        return bl;
                    }
                }
                ++index;
            }
        }
        finally {
            if (hasChanged && !localSupportInPlaceUpdate) {
                this.supportInPlaceUpdate = false;
            }
        }
        return hasChanged;
    }

    private boolean manageMapChanges(NonNativeObjectInfo nnoi1, NonNativeObjectInfo nnoi2, int fieldId, MapObjectInfo moi1, MapObjectInfo moi2, int objectRecursionLevel) {
        Map<AbstractObjectInfo, AbstractObjectInfo> map1 = moi1.getMap();
        Map<AbstractObjectInfo, AbstractObjectInfo> map2 = moi2.getMap();
        if (map1.size() != map2.size()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("Map size has changed oldsize=").append(map1.size()).append("/newsize=").append(map2.size());
            this.storeChangedObject(nnoi1, nnoi2, fieldId, moi1, moi2, buffer.toString(), objectRecursionLevel);
            return true;
        }
        Iterator<AbstractObjectInfo> keys1 = map1.keySet().iterator();
        Iterator<AbstractObjectInfo> keys2 = map2.keySet().iterator();
        AbstractObjectInfo key1 = null;
        AbstractObjectInfo key2 = null;
        AbstractObjectInfo value1 = null;
        AbstractObjectInfo value2 = null;
        int index = 0;
        while (keys1.hasNext()) {
            key1 = keys1.next();
            boolean keysHaveChanged = this.hasChanged(key1, key2 = keys2.next(), objectRecursionLevel);
            if (keysHaveChanged) {
                this.storeChangedObject(nnoi1, nnoi2, fieldId, key1, key2, "Map key index " + index + " has changed", objectRecursionLevel);
                return true;
            }
            value1 = map1.get(key1);
            boolean valuesHaveChanged = this.hasChanged(value1, value2 = map2.get(key2), objectRecursionLevel);
            if (valuesHaveChanged) {
                this.storeChangedObject(nnoi1, nnoi2, fieldId, value1, value2, "Map value index " + index + " has changed", objectRecursionLevel);
                return true;
            }
            ++index;
        }
        return false;
    }

    protected void storeChangedAttributeAction(ChangedNativeAttributeAction caa) {
        ++this.nbChanges;
        this.changedAttributeActions.add(caa);
    }

    protected void storeChangedAttributeAction(ChangedObjectReferenceAttributeAction caa) {
        ++this.nbChanges;
        this.changedAttributeActions.add(caa);
    }

    @Override
    public AbstractObjectInfo getChangedObjectMetaRepresentation(int i) {
        return this.changedObjectMetaRepresentations.get(i);
    }

    @Override
    public List<ChangedObjectInfo> getChanges() {
        return this.changes;
    }

    @Override
    public List<NewNonNativeObjectAction> getNewObjectMetaRepresentations() {
        return this.newObjectMetaRepresentations;
    }

    @Override
    public NewNonNativeObjectAction getNewObjectMetaRepresentation(int i) {
        return this.newObjectMetaRepresentations.get(i);
    }

    @Override
    public List<Object> getNewObjects() {
        return this.newObjects;
    }

    @Override
    public int getMaxObjectRecursionLevel() {
        return this.maxObjectRecursionLevel;
    }

    @Override
    public List<ChangedAttribute> getChangedAttributeActions() {
        return this.changedAttributeActions;
    }

    public void setChangedAttributeActions(List<ChangedAttribute> changedAttributeActions) {
        this.changedAttributeActions = changedAttributeActions;
    }

    @Override
    public List<SetAttributeToNullAction> getAttributeToSetToNull() {
        return this.attributeToSetToNull;
    }

    @Override
    public void clear() {
        this.changedObjectMetaRepresentations.clear();
        this.attributeToSetToNull.clear();
        this.alreadyCheckingObjects.clear();
        this.newObjects.clear();
        this.newObjectMetaRepresentations.clear();
        this.changes.clear();
        this.changedAttributeActions.clear();
        this.arrayChanges.clear();
        this.maxObjectRecursionLevel = 0;
        this.nbChanges = 0;
        this.supportInPlaceUpdate = false;
    }

    @Override
    public int getNbChanges() {
        return this.nbChanges;
    }

    public String toString() {
        return this.nbChanges + " changes";
    }

    @Override
    public List<ArrayModifyElement> getArrayChanges() {
        return this.arrayChanges;
    }

    @Override
    public boolean supportInPlaceUpdate() {
        return this.supportInPlaceUpdate;
    }
}

