/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.gui.xml;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.neodatis.odb.core.layers.layer3.IStorageEngine;
import org.neodatis.odb.gui.LoggerPanel;
import org.neodatis.odb.gui.Messages;
import org.neodatis.odb.gui.component.GUITool;
import org.neodatis.odb.xml.XMLExporter;
import org.neodatis.tool.ILogger;
import org.neodatis.tool.wrappers.OdbTime;

public class XmlExportPanel2
extends JPanel
implements ActionListener,
Runnable {
    private IStorageEngine storageEngine = null;
    private JButton btExport;
    private JButton btCancel;
    private JTextField tfFile;
    private JButton btBrowse;
    private ILogger logger;
    private LoggerPanel loggerPanel;

    public XmlExportPanel2(ILogger logger) {
        this.logger = logger;
        this.init();
    }

    private void init() {
        JLabel label1 = new JLabel(Messages.getString("Xml File name to export to"));
        this.tfFile = new JTextField(20);
        this.btBrowse = new JButton(Messages.getString("..."));
        this.btExport = new JButton(Messages.getString("Export to XML"));
        this.btCancel = new JButton(Messages.getString("Cancel"));
        this.btBrowse.setActionCommand("browse");
        this.btExport.setActionCommand("export");
        this.btCancel.setActionCommand("cancel");
        this.btBrowse.addActionListener(this);
        this.btExport.addActionListener(this);
        this.btCancel.addActionListener(this);
        this.loggerPanel = new LoggerPanel();
        JPanel fpanel = new JPanel(new FlowLayout(0));
        fpanel.add(label1);
        fpanel.add(this.tfFile);
        fpanel.add(this.btBrowse);
        JPanel cpanel = new JPanel(new BorderLayout(4, 4));
        cpanel.add((Component)fpanel, "North");
        cpanel.add((Component)new JScrollPane(this.loggerPanel), "Center");
        JPanel bpanel = new JPanel();
        bpanel.add(this.btCancel);
        bpanel.add(this.btExport);
        this.setLayout(new BorderLayout(4, 4));
        this.add((Component)cpanel, "Center");
        this.add((Component)bpanel, "South");
        this.add((Component)GUITool.buildHeaderPanel("Export to XML Wizard"), "North");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String action = e.getActionCommand();
        if ("browse".equals(action)) {
            this.browse();
        }
        if ("cancel".equals(action)) {
            this.cancel();
        }
        if ("export".equals(action)) {
            try {
                this.storageEngine.close();
                Thread t = new Thread(this);
                t.start();
            }
            catch (Exception e1) {
                this.logger.error("Error while export to XML : ", e1);
            }
        }
    }

    private void export() throws Exception {
        int r;
        File file = new File(this.tfFile.getText());
        if (file.exists() && (r = JOptionPane.showConfirmDialog(this, Messages.getString("File already exist, do you want to overwrite?"), "File already exist", 0)) != 0) {
            return;
        }
        long start = OdbTime.getCurrentTimeInMs();
        this.setCursor(Cursor.getPredefinedCursor(3));
        XMLExporter exporter = new XMLExporter(this.storageEngine);
        exporter.setExternalLogger(this.loggerPanel);
        exporter.export(file.getParent(), file.getName());
        this.disableFields();
        this.setCursor(Cursor.getPredefinedCursor(0));
        long end = OdbTime.getCurrentTimeInMs();
        this.loggerPanel.info(end - start + " ms");
    }

    private void cancel() {
        this.disableFields();
    }

    private void disableFields() {
        this.tfFile.setEnabled(false);
        this.btExport.setEnabled(false);
        this.btCancel.setEnabled(false);
        this.btBrowse.setEnabled(false);
    }

    private void browse() {
        JFileChooser fc = new JFileChooser(System.getProperty("user.dir"));
        fc.setDialogTitle(Messages.getString("Choose the name of the xml file to export to"));
        int returnVal = fc.showOpenDialog(this);
        if (returnVal == 0) {
            this.tfFile.setText(fc.getSelectedFile().getPath());
        }
    }

    @Override
    public void run() {
        try {
            this.export();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error(e);
            this.loggerPanel.error(e);
        }
    }
}

