/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.gui.objectbrowser.hierarchy;

import org.neodatis.odb.core.layers.layer2.meta.AbstractObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.NonNativeDeletedObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.NonNativeNullObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.NonNativeObjectInfo;
import org.neodatis.odb.gui.objectbrowser.hierarchy.Wrapper;

public class NonNativeObjectInfoWrapper
implements Wrapper {
    private NonNativeObjectInfo nnoi;
    private String name;
    private boolean isDeleted;
    private boolean isUpdated;

    public NonNativeObjectInfoWrapper(String name, NonNativeObjectInfo nnai) {
        this.nnoi = nnai;
        this.name = name;
        this.isDeleted = false;
        this.isUpdated = false;
    }

    public NonNativeObjectInfoWrapper(NonNativeObjectInfo nnai) {
        this.nnoi = nnai;
    }

    public String toString() {
        if (this.nnoi instanceof NonNativeNullObjectInfo) {
            return this.name == null ? "?" : this.name + "=null";
        }
        if (this.isDeleted) {
            return this.name == null ? "<>" : this.name + "(deleted)";
        }
        if (this.isUpdated) {
            return this.name == null ? "<>" : this.name + "(updated)";
        }
        if (this.name == null) {
            return "<>";
        }
        if (this.name.indexOf("oid") != -1) {
            return this.name;
        }
        if (this.nnoi.isDeletedObject()) {
            NonNativeDeletedObjectInfo nd = (NonNativeDeletedObjectInfo)this.nnoi;
            return String.format("%s (oid=%s) - deleted object", this.name, this.nnoi.getOid().toString());
        }
        return String.format("%s (oid=%s)", this.name, this.nnoi.getOid().toString());
    }

    public NonNativeObjectInfo getNnoi() {
        return this.nnoi;
    }

    public void setDeleted(boolean isDeleted) {
        this.isDeleted = isDeleted;
    }

    public void setUpdated(boolean isUpdated) {
        this.isUpdated = isUpdated;
    }

    public boolean isDeleted() {
        return this.isDeleted;
    }

    public boolean isUpdated() {
        return this.isUpdated;
    }

    @Override
    public AbstractObjectInfo getObject() {
        return this.nnoi;
    }
}

