/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.gui.connect;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import org.neodatis.odb.ODB;
import org.neodatis.odb.ODBFactory;
import org.neodatis.odb.Objects;
import org.neodatis.odb.core.query.criteria.ICriterion;
import org.neodatis.odb.core.query.criteria.Where;
import org.neodatis.odb.gui.LoggerPanel;
import org.neodatis.odb.gui.Messages;
import org.neodatis.odb.gui.connect.Connection;
import org.neodatis.odb.gui.connect.ConnectionPanel;
import org.neodatis.odb.gui.connect.RemoteConnection;
import org.neodatis.odb.impl.core.query.criteria.CriteriaQuery;
import org.neodatis.tool.ILogger;

public class RemoteConnectionPanel
extends ConnectionPanel
implements ActionListener {
    private JTextField tfHost;
    private JTextField tfPort;
    private JTextField tfBase;
    private JTextField tfUserName;
    private JPasswordField tfPassword;
    private JComboBox cbConnections;
    private ILogger logger;

    public RemoteConnectionPanel(ILogger logger) {
        this.logger = logger;
        this.initGUI();
    }

    private void initGUI() {
        this.logger.info("local connection");
        this.tfHost = new JTextField(20);
        this.tfPort = new JTextField(10);
        this.tfUserName = new JTextField(20);
        this.tfPassword = new JPasswordField(20);
        this.tfBase = new JTextField(20);
        Vector<RemoteConnection> v = null;
        try {
            v = new Vector<RemoteConnection>(this.getRecentRemoteConnections());
        }
        catch (Exception e) {
            String error = "Error while loading recent conections";
            this.logger.error(error);
        }
        this.cbConnections = new JComboBox<RemoteConnection>(v);
        this.cbConnections.setActionCommand("choose-recent");
        this.cbConnections.addActionListener(this);
        this.cbConnections.setPreferredSize(new Dimension((int)this.cbConnections.getPreferredSize().getWidth(), (int)this.tfHost.getPreferredSize().getHeight()));
        JButton btChoose = new JButton(Messages.getString("Choose"));
        btChoose.setActionCommand("choose");
        btChoose.addActionListener(this);
        JPanel fieldsPanel = new JPanel(new BorderLayout(5, 5));
        JPanel labelsPanel = new JPanel(new GridLayout(5, 1));
        labelsPanel.add(new JLabel(Messages.getString("Recent")));
        labelsPanel.add(new JLabel(Messages.getString("Host")));
        labelsPanel.add(new JLabel(Messages.getString("Base")));
        labelsPanel.add(new JLabel(Messages.getString("User")));
        labelsPanel.add(new JLabel(Messages.getString("Password")));
        JPanel panel0 = new JPanel(new FlowLayout(0));
        panel0.add(this.cbConnections);
        JPanel panel1 = new JPanel(new FlowLayout(0));
        panel1.add(this.tfHost);
        panel1.add(new JLabel(Messages.getString("Port")));
        panel1.add(this.tfPort);
        JPanel panel12 = new JPanel(new FlowLayout(0));
        panel12.add(this.tfBase);
        JPanel panel2 = new JPanel(new FlowLayout(0));
        panel2.add(this.tfUserName);
        JPanel panel3 = new JPanel(new FlowLayout(0));
        panel3.add(this.tfPassword);
        JPanel inputPanel = new JPanel(new GridLayout(5, 1));
        inputPanel.add(panel0);
        inputPanel.add(panel1);
        inputPanel.add(panel12);
        inputPanel.add(panel2);
        inputPanel.add(panel3);
        fieldsPanel.add((Component)labelsPanel, "West");
        fieldsPanel.add((Component)inputPanel, "Center");
        this.setLayout(new BorderLayout(5, 5));
        this.add((Component)fieldsPanel, "Center");
    }

    private Collection<RemoteConnection> getRecentRemoteConnections() throws Exception {
        try (ODB odb = null;){
            odb = ODBFactory.open("connect-history.neodatis");
            Objects<RemoteConnection> objects = odb.getObjects(RemoteConnection.class, true);
            return objects;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean existConnection(String host, int port, String user) throws Exception {
        try (ODB odb = null;){
            odb = ODBFactory.open("connect-history.neodatis");
            CriteriaQuery query = new CriteriaQuery(RemoteConnection.class, (ICriterion)Where.and().add(Where.equal("host", host)).add(Where.equal("port", port)).add(Where.equal("user", user)));
            boolean bl = !odb.getObjects(query).isEmpty();
            return bl;
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if ("choose-recent".equals(command)) {
            this.chooseRecent();
        }
    }

    private void chooseRecent() {
        RemoteConnection rc = (RemoteConnection)this.cbConnections.getSelectedItem();
        this.tfHost.setText(rc.getHost());
        this.tfPort.setText(String.valueOf(rc.getPort()));
        if (rc.getUser() != null) {
            this.tfUserName.setText(rc.getUser());
        }
        this.tfBase.setText(rc.getBaseIdentifier());
    }

    @Override
    public boolean validateData() {
        if (this.tfHost.getText().length() == 0) {
            this.logger.error("Please inform the Host name");
            this.tfHost.requestFocus();
            return false;
        }
        if (this.tfPort.getText().length() == 0) {
            this.logger.error("Please inform the Port");
            this.tfPort.requestFocus();
            return false;
        }
        if (this.tfBase.getText().length() == 0) {
            this.logger.error("Please inform the Base");
            this.tfBase.requestFocus();
            return false;
        }
        return true;
    }

    @Override
    public Connection getConnection() throws Exception {
        RemoteConnection rc = new RemoteConnection();
        rc.setHost(this.tfHost.getText());
        rc.setPort(Integer.parseInt(this.tfPort.getText()));
        rc.setBaseIdentifier(this.tfBase.getText());
        if (this.tfUserName.getText().length() > 0) {
            rc.setUser(this.tfUserName.getText());
            rc.setPassword(this.tfPassword.getText());
        }
        if (!this.existConnection(rc.getHost(), rc.getPort(), rc.getUser())) {
            this.saveConnection(rc);
        }
        this.logger.info("connecting to " + rc);
        return rc;
    }

    private void saveConnection(Connection connection) throws Exception {
        try (ODB odb = null;){
            odb = ODBFactory.open("connect-history.neodatis");
            odb.store(connection);
        }
    }

    public static void main(String[] args) {
        LoggerPanel loggerPanel = new LoggerPanel();
        RemoteConnectionPanel lcp = new RemoteConnectionPanel(loggerPanel);
        JFrame f = new JFrame("Test RemoteConnectionPanel");
        f.getContentPane().add(lcp);
        f.setDefaultCloseOperation(3);
        f.pack();
        f.setVisible(true);
        JFrame f2 = new JFrame("Test RemoteConnectionPanel");
        f2.getContentPane().add(loggerPanel);
        f2.setDefaultCloseOperation(3);
        f2.pack();
        f2.setVisible(true);
    }
}

