/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyVetoException;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDesktopPane;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;
import org.neodatis.odb.OdbConfiguration;
import org.neodatis.odb.core.layers.layer3.IBaseIdentification;
import org.neodatis.odb.core.layers.layer3.IOFileParameter;
import org.neodatis.odb.core.layers.layer3.IOSocketParameter;
import org.neodatis.odb.gui.AboutDialog;
import org.neodatis.odb.gui.LoggerPanel;
import org.neodatis.odb.gui.Messages;
import org.neodatis.odb.gui.ODBExplorerPanel;
import org.neodatis.odb.gui.ODBInternalFrame;
import org.neodatis.odb.gui.connect.Connection;
import org.neodatis.odb.gui.connect.LocalConnection;
import org.neodatis.odb.gui.connect.MainConnectPanel;
import org.neodatis.odb.gui.connect.RemoteConnection;
import org.neodatis.odb.gui.tool.GuiUtil;
import org.neodatis.odb.gui.xml.XmlExportPanel;
import org.neodatis.odb.gui.xml.XmlImportPanel;
import org.neodatis.tool.DLogger;
import org.neodatis.tool.ILogger;
import org.neodatis.tool.wrappers.OdbThread;

public class ODBExplorerFrame
extends JFrame
implements ActionListener,
ItemListener {
    private JDesktopPane desktop;
    private final JFileChooser fc = new JFileChooser(System.getProperty("user.dir"));
    private final LoggerPanel logger;
    private String nextThreadAction;

    public ODBExplorerFrame() {
        super("NeoDatis Object Explorer");
        int inset = 5;
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds(inset, inset, screenSize.width - inset * 2, screenSize.height - inset * 5 - 50);
        this.desktop = new JDesktopPane();
        this.desktop.setBackground(Color.WHITE);
        this.logger = new LoggerPanel();
        DLogger.register(this.logger);
        JSplitPane pane = new JSplitPane(0, this.desktop, this.logger);
        pane.setOneTouchExpandable(true);
        pane.setDividerLocation(550);
        this.setContentPane(pane);
        this.setJMenuBar(this.createMenuBar());
        this.desktop.setDragMode(1);
    }

    protected JMenuBar createMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        JMenu menu = new JMenu("NeoDatis ODB");
        menu.setMnemonic(75);
        menuBar.add(menu);
        JMenuItem menuItem = new JMenuItem("Open DataBase");
        menuItem.setMnemonic(79);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(79, 8));
        menuItem.setActionCommand("open");
        menuItem.addActionListener(this);
        menu.add(menuItem);
        menuItem = new JMenuItem("Export to XML");
        menuItem.setMnemonic(69);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(69, 8));
        menuItem.setActionCommand("export");
        menuItem.addActionListener(this);
        menu.add(menuItem);
        menuItem = new JMenuItem("Import from XML");
        menuItem.setMnemonic(73);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(73, 8));
        menuItem.setActionCommand("import");
        menuItem.addActionListener(this);
        menu.add(menuItem);
        menuItem = new JMenuItem("Quit");
        menuItem.setMnemonic(81);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(81, 8));
        menuItem.setActionCommand("quit");
        menuItem.addActionListener(this);
        menu.add(menuItem);
        menu = new JMenu("Options");
        menu.setMnemonic(79);
        menuBar.add(menu);
        JCheckBoxMenuItem cbmi = new JCheckBoxMenuItem("Tolerate inconsistency", false);
        cbmi.setMnemonic(84);
        cbmi.setAccelerator(KeyStroke.getKeyStroke(84, 8));
        cbmi.setActionCommand("tolerate-inconsistency");
        cbmi.addItemListener(this);
        menu.add(cbmi);
        menu = new JMenu("Help");
        menu.setMnemonic(72);
        menuBar.add(menu);
        JMenuItem cbAbout = new JMenuItem("About");
        cbAbout.setMnemonic(65);
        cbAbout.setAccelerator(KeyStroke.getKeyStroke(65, 8));
        cbAbout.setActionCommand("about");
        cbAbout.addActionListener(this);
        menu.add(cbAbout);
        return menuBar;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if ("new".equals(e.getActionCommand())) {
            return;
        }
        if ("about".equals(e.getActionCommand())) {
            this.displayAbout();
        }
        if ("open".equals(e.getActionCommand())) {
            try {
                this.openODBBase();
            }
            catch (Exception e1) {
                this.logger.error("Error while opening base", e1);
            }
            return;
        }
        if ("export".equals(e.getActionCommand())) {
            try {
                this.exportToXml();
            }
            catch (Exception e1) {
                this.logger.error("Error while exporting base", e1);
            }
            return;
        }
        if ("import".equals(e.getActionCommand())) {
            try {
                this.importFromXml();
            }
            catch (Exception e1) {
                this.logger.error("Error while importing base", e1);
            }
            return;
        }
        if ("quit".equals(e.getActionCommand())) {
            this.quit();
        }
    }

    private void displayAbout() {
        JInternalFrame iframe = new JInternalFrame("About NeoDatis ODB");
        iframe.setContentPane(new AboutDialog());
        iframe.pack();
        iframe.setVisible(true);
        iframe.setClosable(true);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int inset = 100;
        iframe.setLocation(screenSize.width / 2 - inset, screenSize.height / 2 - inset);
        this.desktop.add(iframe);
        try {
            iframe.setSelected(true);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    private void tolerateInconsistency(boolean tolerate) {
        OdbConfiguration.setThrowExceptionWhenInconsistencyFound(!tolerate);
    }

    public void openODBBase() throws Exception {
        Object engine = null;
        MainConnectPanel mcp = null;
        Connection connection = null;
        mcp = new MainConnectPanel((Frame)this, this.logger);
        mcp.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int w = (int)screenSize.getWidth();
        int h = (int)screenSize.getHeight();
        int wdialog = (int)mcp.getBounds().getWidth();
        int hdialog = (int)mcp.getBounds().getHeight();
        int rw = w / 2 - wdialog / 2;
        int rh = h / 2 - hdialog / 2;
        mcp.setLocation(new Point(rw, rh));
        mcp.setVisible(true);
        connection = mcp.getConnection();
        if (connection == null) {
            return;
        }
        IBaseIdentification baseIdentification = null;
        if (connection instanceof LocalConnection) {
            LocalConnection lc = (LocalConnection)connection;
            baseIdentification = new IOFileParameter(lc.getFileName(), true, lc.getUser(), lc.getUser() == null ? null : lc.getPassword());
        } else {
            RemoteConnection rc = (RemoteConnection)connection;
            baseIdentification = new IOSocketParameter(rc.getHost(), rc.getPort(), rc.getBaseIdentifier(), 1, rc.getUser(), rc.getPassword());
        }
        JInternalFrame iframe = this.createInternalFrame(connection.toString(), this.logger);
        ODBExplorerPanel oep = new ODBExplorerPanel(iframe, baseIdentification, connection.toString(), this.logger);
        iframe.setContentPane(oep);
        iframe.pack();
        iframe.setVisible(true);
        iframe.setLocation(15, 15);
        this.desktop.add(iframe);
        try {
            iframe.setSelected(true);
        }
        catch (PropertyVetoException e) {
            this.logger.error("Error while opening base", e);
        }
        mcp.dispose();
    }

    private JInternalFrame createInternalFrame(String title, ILogger logger) {
        ODBInternalFrame iframe = new ODBInternalFrame(title, logger);
        return iframe;
    }

    protected void quit() {
        System.exit(0);
    }

    public void run() {
        this.logger.info("Iniciando da thread " + OdbThread.getCurrentThreadName());
        if ("open".equals(this.nextThreadAction)) {
            try {
                this.openODBBase();
            }
            catch (Exception e) {
                this.logger.error(e.getMessage());
            }
        }
        if ("import".equals(this.nextThreadAction)) {
            try {
                this.importFromXml();
            }
            catch (Exception e) {
                this.logger.error(e.getMessage());
            }
        }
        this.logger.info("Saindo da thread " + OdbThread.getCurrentThreadName());
    }

    private void exportToXml() {
        XmlExportPanel panel = new XmlExportPanel(this.logger);
        final JDialog dialog = new JDialog();
        dialog.setTitle(Messages.getString("XML Exportation"));
        dialog.getContentPane().add(panel);
        JButton btClose = new JButton(Messages.getString("Close"));
        btClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                dialog.dispose();
            }
        });
        dialog.getContentPane().add((Component)btClose, "South");
        dialog.setModal(true);
        dialog.pack();
        GuiUtil.centerScreen(dialog);
    }

    private void importFromXml() {
        XmlImportPanel panel = new XmlImportPanel(this.logger);
        final JDialog dialog = new JDialog();
        dialog.setTitle(Messages.getString("XML importation"));
        dialog.getContentPane().add(panel);
        JButton btClose = new JButton(Messages.getString("Close"));
        btClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                dialog.dispose();
            }
        });
        dialog.getContentPane().add((Component)btClose, "South");
        dialog.setModal(true);
        dialog.pack();
        GuiUtil.centerScreen(dialog);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.tolerateInconsistency(e.getStateChange() == 1);
    }
}

