/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.core.layers.layer3;

import org.neodatis.odb.core.layers.layer3.IBaseIdentification;
import org.neodatis.tool.wrappers.net.NeoDatisIpAddress;

public class IOSocketParameter
implements IBaseIdentification {
    public static final int TYPE_DATABASE = 1;
    public static final int TYPE_TRANSACTION = 2;
    private String destinationHost;
    private int port;
    private String baseIdentifier;
    private int type;
    private String user;
    private transient String password;
    private long dateTimeCreation;
    protected boolean clientAndServerRunInSameVM;

    public IOSocketParameter(String host, int port, String identifier, int type, String user, String password) {
        this(host, port, identifier, type, -1L, user, password, false);
    }

    public IOSocketParameter(String host, int port, String identifier, int type, long dtCreation, String user, String password) {
        this(host, port, identifier, type, dtCreation, user, password, false);
    }

    public IOSocketParameter(String host, int port, String identifier, int type, long dtCreation, String user, String password, boolean clientAndServerRunOnSameVm) {
        this.destinationHost = host;
        if (this.destinationHost.indexOf(".") == -1) {
            this.destinationHost = NeoDatisIpAddress.get(this.destinationHost);
        }
        this.port = port;
        this.baseIdentifier = identifier;
        this.type = type;
        this.dateTimeCreation = dtCreation;
        this.user = user;
        this.password = password;
        this.clientAndServerRunInSameVM = clientAndServerRunOnSameVm;
    }

    public String getDestinationHost() {
        return this.destinationHost;
    }

    public int getPort() {
        return this.port;
    }

    public String getBaseIdentifier() {
        return this.baseIdentifier;
    }

    @Override
    public boolean canWrite() {
        return true;
    }

    public int getType() {
        return this.type;
    }

    public boolean isDatabase() {
        return this.type == 1;
    }

    public boolean isTransaction() {
        return this.type == 2;
    }

    public long getDateTimeCreation() {
        return this.dateTimeCreation;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    public String getUserName() {
        return this.user;
    }

    public void setUserName(String user) {
        this.user = user;
    }

    public String toString() {
        return this.baseIdentifier + "@" + this.destinationHost + ":" + this.port;
    }

    @Override
    public String getIdentification() {
        return this.toString();
    }

    @Override
    public boolean isNew() {
        return false;
    }

    @Override
    public boolean isLocal() {
        return false;
    }

    public boolean clientAndServerRunInSameVM() {
        return this.clientAndServerRunInSameVM;
    }

    @Override
    public String getDirectory() {
        return "";
    }
}

