/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.btree.impl.singlevalue;

import org.neodatis.btree.IBTree;
import org.neodatis.btree.IBTreeNode;
import org.neodatis.btree.exception.BTreeException;
import org.neodatis.btree.impl.singlevalue.BTreeNodeSingleValuePerKey;

public class InMemoryBTreeNodeSingleValuePerkey
extends BTreeNodeSingleValuePerKey {
    protected static int nextId = 1;
    protected Integer id = new Integer(nextId++);
    protected IBTreeNode[] children;
    protected IBTreeNode parent;

    public InMemoryBTreeNodeSingleValuePerkey(IBTree btree) {
        super(btree);
    }

    @Override
    public IBTreeNode getChildAt(int index, boolean throwExceptionIfNotExist) {
        if (this.children[index] == null && throwExceptionIfNotExist) {
            throw new BTreeException("Trying to load null child node at index " + index);
        }
        return this.children[index];
    }

    @Override
    public IBTreeNode getParent() {
        return this.parent;
    }

    @Override
    public void setChildAt(IBTreeNode child, int index) {
        this.children[index] = child;
        if (child != null) {
            child.setParent(this);
        }
    }

    @Override
    public void setChildAt(IBTreeNode node, int childIndex, int index, boolean throwExceptionIfDoesNotExist) {
        IBTreeNode child;
        this.children[index] = child = node.getChildAt(childIndex, throwExceptionIfDoesNotExist);
        if (child != null) {
            child.setParent(this);
        }
    }

    @Override
    public void setParent(IBTreeNode node) {
        this.parent = node;
    }

    @Override
    public boolean hasParent() {
        return this.parent != null;
    }

    @Override
    protected void init() {
        this.children = new IBTreeNode[this.maxNbChildren];
    }

    @Override
    public Object getId() {
        return this.id;
    }

    @Override
    public void setId(Object id) {
        this.id = (Integer)id;
    }

    @Override
    public void deleteChildAt(int index) {
        this.children[index] = null;
        --this.nbChildren;
    }

    @Override
    public void moveChildFromTo(int sourceIndex, int destinationIndex, boolean throwExceptionIfDoesNotExist) {
        if (this.children[sourceIndex] == null && throwExceptionIfDoesNotExist) {
            throw new BTreeException("Trying to move null child node at index " + sourceIndex);
        }
        this.children[destinationIndex] = this.children[sourceIndex];
    }

    @Override
    public void setNullChildAt(int childIndex) {
        this.children[childIndex] = null;
    }

    @Override
    public Object getChildIdAt(int childIndex, boolean throwExceptionIfDoesNotExist) {
        if (this.children[childIndex] == null && throwExceptionIfDoesNotExist) {
            throw new BTreeException("Trying to move null child node at index " + childIndex);
        }
        return this.children[childIndex].getId();
    }

    @Override
    public Object getParentId() {
        return this.id;
    }

    @Override
    public Object getValueAsObjectAt(int index) {
        return this.getValueAt(index);
    }
}

