/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.btree.impl;

import org.neodatis.btree.IBTree;
import org.neodatis.btree.IBTreeNode;
import org.neodatis.btree.IBTreePersister;
import org.neodatis.btree.IKeyAndValue;
import org.neodatis.btree.exception.BTreeNodeValidationException;
import org.neodatis.btree.impl.KeyAndValue;
import org.neodatis.btree.tool.BTreeValidator;

public abstract class AbstractBTree
implements IBTree {
    private String name;
    private int degree;
    private long size;
    private int height;
    private IBTreeNode root;
    protected transient IBTreePersister persister;
    protected int controlNumber;

    @Override
    public abstract IBTreeNode buildNode();

    public AbstractBTree() {
        this.degree = 0;
        this.size = 0L;
        this.height = 1;
        this.persister = null;
        this.root = null;
    }

    public AbstractBTree(String name, int degree, IBTreePersister persister) {
        this.name = name;
        this.degree = degree;
        this.size = 0L;
        this.height = 1;
        this.persister = persister;
        this.root = this.buildNode();
        persister.saveNode(this.root);
        persister.saveBTree(this);
        persister.flush();
    }

    @Override
    public Object delete(Comparable key, Object value) {
        Object o = null;
        try {
            o = this.internalDelete(this.root, new KeyAndValue(key, value));
        }
        catch (Exception e) {
            throw new BTreeNodeValidationException("Error while deleting key='" + key + "' value='" + value + "'", e);
        }
        if (o != null) {
            --this.size;
        }
        this.getPersister().saveBTree(this);
        return o;
    }

    protected Object internalDelete(IBTreeNode node, IKeyAndValue keyAndValue) throws Exception {
        int position = node.getPositionOfKey(keyAndValue.getKey());
        boolean keyIsHere = position > 0;
        int realPosition = -1;
        IBTreeNode leftNode = null;
        IBTreeNode rightNode = null;
        if (node.isLeaf()) {
            if (keyIsHere) {
                Object deletedValue = node.deleteKeyForLeafNode(keyAndValue);
                this.getPersister().saveNode(node);
                return deletedValue;
            }
            return null;
        }
        if (!keyIsHere) {
            realPosition = -position - 1;
            IBTreeNode child = node.getChildAt(realPosition, true);
            if (child.getNbKeys() == this.degree - 1) {
                node = this.prepareForDelete(node, child, realPosition);
                return this.internalDelete(node, keyAndValue);
            }
            return this.internalDelete(child, keyAndValue);
        }
        realPosition = position - 1;
        Comparable currentKey = node.getKeyAt(realPosition);
        Object currentValue = node.getValueAsObjectAt(realPosition);
        leftNode = node.getChildAt(realPosition, true);
        if (leftNode.getNbKeys() >= this.degree) {
            IKeyAndValue prev = this.getBiggest(leftNode, true);
            node.setKeyAndValueAt(prev, realPosition);
            BTreeValidator.validateNode(node, node == this.root);
            this.getPersister().saveNode(node);
            return currentValue;
        }
        rightNode = node.getChildAt(realPosition + 1, true);
        if (rightNode.getNbKeys() >= this.degree) {
            IKeyAndValue next = this.getSmallest(rightNode, true);
            node.setKeyAndValueAt(next, realPosition);
            BTreeValidator.validateNode(node, node == this.root);
            this.getPersister().saveNode(node);
            return currentValue;
        }
        node.deleteKeyAndValueAt(realPosition, true);
        leftNode.insertKeyAndValue(currentKey, currentValue);
        leftNode.mergeWith(rightNode);
        if (!node.hasParent() && node.getNbKeys() == 0) {
            this.persister.deleteNode(node);
            this.root = leftNode;
            leftNode.setParent(null);
            --this.height;
        } else {
            node.setChildAt(leftNode, realPosition);
            BTreeValidator.validateNode(node, node == this.root);
        }
        this.persister.deleteNode(rightNode);
        BTreeValidator.validateNode(leftNode, leftNode == this.root);
        this.getPersister().saveNode(node);
        this.getPersister().saveNode(leftNode);
        return this.internalDelete(leftNode, keyAndValue);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private IBTreeNode prepareForDelete(IBTreeNode parent, IBTreeNode child, int childIndex) {
        BTreeValidator.validateNode(parent);
        BTreeValidator.validateNode(child);
        IBTreeNode leftSibling = null;
        IBTreeNode rightSibling = null;
        if (childIndex > 0 && parent.getNbChildren() > 0) {
            leftSibling = parent.getChildAt(childIndex - 1, false);
        }
        if (childIndex < parent.getNbChildren() - 1) {
            rightSibling = parent.getChildAt(childIndex + 1, false);
        }
        if (leftSibling != null && leftSibling.getNbKeys() >= this.degree) {
            IKeyAndValue elementToMoveDown = parent.getKeyAndValueAt(childIndex - 1);
            IKeyAndValue elementToMoveUp = leftSibling.getLastKeyAndValue();
            parent.setKeyAndValueAt(elementToMoveUp, childIndex - 1);
            child.insertKeyAndValue(elementToMoveDown.getKey(), elementToMoveDown.getValue());
            if (leftSibling.getNbChildren() > leftSibling.getNbKeys()) {
                child.setChildAt(leftSibling, leftSibling.getNbChildren() - 1, 0, true);
                child.incrementNbChildren();
            }
            leftSibling.deleteKeyAndValueAt(leftSibling.getNbKeys() - 1, false);
            if (!leftSibling.isLeaf()) {
                leftSibling.deleteChildAt(leftSibling.getNbChildren() - 1);
            }
            this.persister.saveNode(parent);
            this.persister.saveNode(child);
            this.persister.saveNode(leftSibling);
            if (!BTreeValidator.isOn()) return parent;
            BTreeValidator.validateNode(parent, parent == this.root);
            BTreeValidator.validateNode(child, false);
            BTreeValidator.validateNode(leftSibling, false);
            BTreeValidator.checkDuplicateChildren(leftSibling, child);
            return parent;
        }
        if (rightSibling != null && rightSibling.getNbKeys() >= this.degree) {
            IKeyAndValue elementToMoveDown = parent.getKeyAndValueAt(childIndex);
            IKeyAndValue elementToMoveUp = rightSibling.getKeyAndValueAt(0);
            parent.setKeyAndValueAt(elementToMoveUp, childIndex);
            child.insertKeyAndValue(elementToMoveDown.getKey(), elementToMoveDown.getValue());
            if (rightSibling.getNbChildren() > 0) {
                child.setChildAt(rightSibling, 0, child.getNbChildren(), true);
                child.incrementNbChildren();
            }
            rightSibling.deleteKeyAndValueAt(0, true);
            this.persister.saveNode(parent);
            this.persister.saveNode(child);
            this.persister.saveNode(rightSibling);
            if (!BTreeValidator.isOn()) return parent;
            BTreeValidator.validateNode(parent, parent == this.root);
            BTreeValidator.validateNode(child, false);
            BTreeValidator.validateNode(rightSibling, false);
            BTreeValidator.checkDuplicateChildren(rightSibling, child);
            return parent;
        }
        boolean isCase3b = leftSibling != null && leftSibling.getNbKeys() == this.degree - 1 || rightSibling != null && rightSibling.getNbKeys() >= this.degree - 1;
        boolean parentWasSetToNull = false;
        if (!isCase3b) throw new BTreeNodeValidationException("Unexpected case in executing prepare for delete");
        if (leftSibling != null) {
            IKeyAndValue elementToMoveDown = parent.getKeyAndValueAt(childIndex - 1);
            leftSibling.insertKeyAndValue(elementToMoveDown.getKey(), elementToMoveDown.getValue());
            leftSibling.mergeWith(child);
            parent.deleteKeyAndValueAt(childIndex - 1, true);
            if (parent.getNbKeys() == 0) {
                if (parent.hasParent()) throw new BTreeNodeValidationException("Unexpected empty node that is node the root!");
                this.root = leftSibling;
                this.root.setParent(null);
                --this.height;
                parentWasSetToNull = true;
            } else {
                parent.setChildAt(leftSibling, childIndex - 1);
            }
            if (parentWasSetToNull) {
                this.persister.deleteNode(parent);
            } else {
                this.persister.saveNode(parent);
                BTreeValidator.validateNode(parent, parent == this.root);
            }
            this.persister.deleteNode(child);
            this.persister.saveNode(leftSibling);
            BTreeValidator.validateNode(leftSibling, leftSibling == this.root);
            if (!parentWasSetToNull) return parent;
            return this.root;
        }
        if (rightSibling == null) throw new BTreeNodeValidationException("deleting case 3b but no non null sibling!");
        IKeyAndValue elementToMoveDown = parent.getKeyAndValueAt(childIndex);
        child.insertKeyAndValue(elementToMoveDown.getKey(), elementToMoveDown.getValue());
        child.mergeWith(rightSibling);
        parent.deleteKeyAndValueAt(childIndex, true);
        if (parent.getNbKeys() == 0) {
            if (parent.hasParent()) throw new BTreeNodeValidationException("Unexpected empty root node!");
            this.root = child;
            this.root.setParent(null);
            --this.height;
            parentWasSetToNull = true;
        } else {
            parent.setChildAt(child, childIndex);
        }
        if (parentWasSetToNull) {
            this.persister.deleteNode(parent);
        } else {
            this.persister.saveNode(parent);
            BTreeValidator.validateNode(parent, parent == this.root);
        }
        this.persister.deleteNode(rightSibling);
        this.persister.saveNode(child);
        BTreeValidator.validateNode(child, child == this.root);
        if (!parentWasSetToNull) return parent;
        return this.root;
    }

    @Override
    public int getDegree() {
        return this.degree;
    }

    @Override
    public void insert(Comparable key, Object value) {
        if (this.root.isFull()) {
            IBTreeNode newRoot = this.buildNode();
            IBTreeNode oldRoot = this.root;
            newRoot.setChildAt(this.root, 0);
            newRoot.setNbChildren(1);
            this.root = newRoot;
            this.split(newRoot, oldRoot, 0);
            ++this.height;
            this.persister.saveNode(oldRoot);
            this.persister.saveNode(newRoot);
            this.persister.saveBTree(this);
            BTreeValidator.validateNode(newRoot, true);
        }
        this.insertNonFull(this.root, key, value);
        ++this.size;
        this.persister.saveBTree(this);
    }

    private void insertNonFull(IBTreeNode node, Comparable key, Object value) {
        if (node.isLeaf()) {
            node.insertKeyAndValue(key, value);
            this.persister.saveNode(node);
            return;
        }
        int position = node.getPositionOfKey(key);
        int realPosition = -position - 1;
        if (position >= 0) {
            realPosition = position - 1;
            node.insertKeyAndValue(key, value);
            this.persister.saveNode(node);
            return;
        }
        IBTreeNode nodeToDescend = node.getChildAt(realPosition, true);
        if (nodeToDescend.isFull()) {
            this.split(node, nodeToDescend, realPosition);
            if (node.getKeyAt(realPosition).compareTo(key) < 0) {
                nodeToDescend = node.getChildAt(realPosition + 1, true);
            }
        }
        this.insertNonFull(nodeToDescend, key, value);
    }

    @Override
    public void split(IBTreeNode parent, IBTreeNode node2Split, int childIndex) {
        IKeyAndValue median = node2Split.getMedian();
        parent.setKeyAndValueAt(median, childIndex, true, true);
        IBTreeNode rightPart = node2Split.extractRightPart();
        parent.setChildAt(rightPart, childIndex + 1);
        parent.setChildAt(node2Split, childIndex);
        parent.incrementNbChildren();
        this.persister.saveNode(parent);
        this.persister.saveNode(rightPart);
        this.persister.saveNode(node2Split);
        if (BTreeValidator.isOn()) {
            BTreeValidator.validateNode(parent, parent == this.root);
            BTreeValidator.validateNode(rightPart, false);
            BTreeValidator.validateNode(node2Split, false);
        }
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public IBTreeNode getRoot() {
        return this.root;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public IBTreePersister getPersister() {
        return this.persister;
    }

    @Override
    public void setPersister(IBTreePersister persister) {
        this.persister = persister;
        this.persister.setBTree(this);
        if (this.root.getBTree() == null) {
            this.root.setBTree(this);
        }
    }

    public String getName() {
        return this.name;
    }

    @Override
    public void clear() {
        this.root.clear();
    }

    @Override
    public IKeyAndValue getBiggest(IBTreeNode node, boolean delete) {
        int lastKeyIndex = node.getNbKeys() - 1;
        int lastChildIndex = node.getNbChildren() - 1;
        if (lastChildIndex > lastKeyIndex) {
            IBTreeNode child = node.getChildAt(lastChildIndex, true);
            if (child.getNbKeys() == this.degree - 1) {
                node = this.prepareForDelete(node, child, lastChildIndex);
            }
            lastChildIndex = node.getNbChildren() - 1;
            child = node.getChildAt(lastChildIndex, true);
            return this.getBiggest(child, delete);
        }
        IKeyAndValue kav = node.getKeyAndValueAt(lastKeyIndex);
        if (delete) {
            node.deleteKeyAndValueAt(lastKeyIndex, false);
            this.persister.saveNode(node);
        }
        return kav;
    }

    @Override
    public IKeyAndValue getSmallest(IBTreeNode node, boolean delete) {
        if (!node.isLeaf()) {
            IBTreeNode child = node.getChildAt(0, true);
            if (child.getNbKeys() == this.degree - 1) {
                node = this.prepareForDelete(node, child, 0);
            }
            child = node.getChildAt(0, true);
            return this.getSmallest(child, delete);
        }
        IKeyAndValue kav = node.getKeyAndValueAt(0);
        if (delete) {
            node.deleteKeyAndValueAt(0, true);
            this.persister.saveNode(node);
        }
        return kav;
    }
}

