/*
 * Decompiled with CFR 0.152.
 */
package org.jscience.mathematics.vector;

import java.util.Iterator;
import java.util.List;
import javolution.context.ObjectFactory;
import javolution.lang.MathLib;
import javolution.util.FastCollection;
import javolution.util.FastComparator;
import javolution.util.FastMap;
import javolution.util.FastTable;
import javolution.util.Index;
import org.jscience.mathematics.structure.Field;
import org.jscience.mathematics.vector.DimensionException;
import org.jscience.mathematics.vector.Matrix;
import org.jscience.mathematics.vector.SparseVector;
import org.jscience.mathematics.vector.Vector;

public final class SparseMatrix<F extends Field<F>>
extends Matrix<F> {
    int _n;
    F _zero;
    boolean _transposed;
    final FastTable<SparseVector<F>> _rows = new FastTable();
    private static final ObjectFactory<SparseMatrix> FACTORY = new ObjectFactory<SparseMatrix>(){

        @Override
        protected SparseMatrix create() {
            return new SparseMatrix();
        }

        @Override
        protected void cleanup(SparseMatrix matrix) {
            matrix._rows.reset();
        }
    };
    private static final long serialVersionUID = 1L;

    public static <F extends Field<F>> SparseMatrix<F> valueOf(Vector<F> diagonal, F zero) {
        int n = diagonal.getDimension();
        SparseMatrix<F> M = SparseMatrix.newInstance(n, zero, false);
        for (int i = 0; i < n; ++i) {
            SparseVector<F> row = SparseVector.valueOf(n, zero, i, diagonal.get(i));
            M._rows.add(row);
        }
        return M;
    }

    public static <F extends Field<F>> SparseMatrix<F> valueOf(SparseVector<F> ... rows) {
        int n = rows[0]._dimension;
        Object zero = rows[0]._zero;
        SparseMatrix M = SparseMatrix.newInstance(n, zero, false);
        for (SparseVector<F> rowi : rows) {
            if (rowi._dimension != n) {
                throw new DimensionException("All vectors must have the same dimension.");
            }
            if (!zero.equals(rowi._zero)) {
                throw new DimensionException("All vectors must have the same zero element.");
            }
            M._rows.add(rowi);
        }
        return M;
    }

    public static <F extends Field<F>> SparseMatrix<F> valueOf(List<SparseVector<F>> rows) {
        int n = rows.get((int)0)._dimension;
        Object zero = rows.get((int)0)._zero;
        SparseMatrix M = SparseMatrix.newInstance(n, zero, false);
        Iterator<SparseVector<F>> iterator = rows.iterator();
        int m = rows.size();
        for (int i = 0; i < m; ++i) {
            SparseVector<F> rowi = iterator.next();
            if (rowi.getDimension() != n) {
                throw new DimensionException("All vectors must have the same dimension.");
            }
            if (!zero.equals(rowi._zero)) {
                throw new DimensionException("All vectors must have the same zero element.");
            }
            M._rows.add(rowi);
        }
        return M;
    }

    public static <F extends Field<F>> SparseMatrix<F> valueOf(Matrix<F> that, F zero) {
        return SparseMatrix.valueOf(that, zero, FastComparator.DEFAULT);
    }

    public static <F extends Field<F>> SparseMatrix<F> valueOf(Matrix<F> that, F zero, FastComparator<? super F> comparator) {
        if (that instanceof SparseMatrix) {
            return (SparseMatrix)that;
        }
        int n = that.getNumberOfColumns();
        int m = that.getNumberOfRows();
        SparseMatrix<F> M = SparseMatrix.newInstance(n, zero, false);
        for (int i = 0; i < m; ++i) {
            SparseVector<? super F> rowi = SparseVector.valueOf(that.getRow(i), zero, comparator);
            M._rows.add(rowi);
        }
        return M;
    }

    public F getZero() {
        return this._zero;
    }

    @Override
    public int getNumberOfRows() {
        return this._transposed ? this._n : this._rows.size();
    }

    @Override
    public int getNumberOfColumns() {
        return this._transposed ? this._rows.size() : this._n;
    }

    @Override
    public F get(int i, int j) {
        return this._transposed ? this._rows.get(j).get(i) : this._rows.get(i).get(j);
    }

    @Override
    public SparseVector<F> getRow(int i) {
        if (!this._transposed) {
            return this._rows.get(i);
        }
        int n = this._rows.size();
        int m = this._n;
        if (i < 0 || i >= m) {
            throw new DimensionException();
        }
        SparseVector<F> V = SparseVector.newInstance(n, this._zero);
        for (int j = 0; j < n; ++j) {
            SparseVector<F> row = this._rows.get(j);
            Field e = (Field)row._elements.get(Index.valueOf(i));
            if (e == null) continue;
            V._elements.put(Index.valueOf(j), e);
        }
        return V;
    }

    @Override
    public SparseVector<F> getColumn(int j) {
        if (this._transposed) {
            return this._rows.get(j);
        }
        int m = this._rows.size();
        if (j < 0 || j >= this._n) {
            throw new DimensionException();
        }
        SparseVector<F> V = SparseVector.newInstance(this._n, this._zero);
        for (int i = 0; i < m; ++i) {
            SparseVector<F> row = this._rows.get(i);
            Field e = (Field)row._elements.get(Index.valueOf(j));
            if (e == null) continue;
            V._elements.put(Index.valueOf(i), e);
        }
        return V;
    }

    @Override
    public SparseVector<F> getDiagonal() {
        int m = this.getNumberOfRows();
        int n = this.getNumberOfColumns();
        int dimension = MathLib.min(m, n);
        SparseVector<F> V = SparseVector.newInstance(this._n, this._zero);
        for (int i = 0; i < dimension; ++i) {
            SparseVector<F> row = this._rows.get(i);
            Field e = (Field)row._elements.get(Index.valueOf(i));
            if (e == null) continue;
            V._elements.put(Index.valueOf(i), e);
        }
        return V;
    }

    @Override
    public SparseMatrix<F> opposite() {
        SparseMatrix<F> M = SparseMatrix.newInstance(this._n, this._zero, this._transposed);
        int p = this._rows.size();
        for (int i = 0; i < p; ++i) {
            M._rows.add((SparseVector<F>)this._rows.get(i).opposite());
        }
        return M;
    }

    @Override
    public SparseMatrix<F> plus(Matrix<F> that) {
        if (this.getNumberOfRows() != that.getNumberOfRows()) {
            throw new DimensionException();
        }
        SparseMatrix<F> M = SparseMatrix.newInstance(this._n, this._zero, this._transposed);
        int p = this._rows.size();
        for (int i = 0; i < p; ++i) {
            M._rows.add((SparseVector<F>)this._rows.get(i).plus((Vector)(this._transposed ? that.getColumn(i) : that.getRow(i))));
        }
        return M;
    }

    @Override
    public SparseMatrix<F> minus(Matrix<F> that) {
        return this.plus((Matrix)that.opposite());
    }

    @Override
    public SparseMatrix<F> times(F k) {
        SparseMatrix<F> M = SparseMatrix.newInstance(this._n, this._zero, this._transposed);
        int p = this._rows.size();
        for (int i = 0; i < p; ++i) {
            M._rows.add((SparseVector<F>)this._rows.get(i).times((Field)k));
        }
        return M;
    }

    @Override
    public SparseVector<F> times(Vector<F> v) {
        if (v.getDimension() != this.getNumberOfColumns()) {
            throw new DimensionException();
        }
        int m = this.getNumberOfRows();
        SparseVector<F> V = SparseVector.newInstance(m, this._zero);
        for (int i = 0; i < m; ++i) {
            F e = ((SparseVector)this.getRow(i)).times(v);
            if (this._zero.equals(e)) continue;
            V._elements.put(Index.valueOf(i), e);
        }
        return V;
    }

    @Override
    public SparseMatrix<F> times(Matrix<F> that) {
        int m = this.getNumberOfRows();
        int n = this.getNumberOfColumns();
        int p = that.getNumberOfColumns();
        if (that.getNumberOfRows() != n) {
            throw new DimensionException();
        }
        FastTable<SparseVector<F>> rows = this.getRows();
        SparseMatrix<F> M = SparseMatrix.newInstance(m, this._zero, true);
        for (int j = 0; j < p; ++j) {
            Vector<F> thatColj = that.getColumn(j);
            SparseVector<F> column = SparseVector.newInstance(m, this._zero);
            M._rows.add(column);
            for (int i = 0; i < m; ++i) {
                F e = rows.get(i).times(thatColj);
                if (this._zero.equals(e)) continue;
                column._elements.put(Index.valueOf(i), e);
            }
        }
        return M;
    }

    private FastTable<SparseVector<F>> getRows() {
        if (!this._transposed) {
            return this._rows;
        }
        FastTable<SparseVector<F>> rows = FastTable.newInstance();
        for (int i = 0; i < this._n; ++i) {
            rows.add((SparseVector<F>)this.getRow(i));
        }
        return rows;
    }

    @Override
    public SparseMatrix<F> inverse() {
        if (!this.isSquare()) {
            throw new DimensionException("Matrix not square");
        }
        Field detInv = (Field)this.determinant().inverse();
        Matrix A = this.adjoint();
        int m = ((SparseMatrix)A)._rows.size();
        for (int i = 0; i < m; ++i) {
            SparseVector<F> row = ((SparseMatrix)A)._rows.get(i);
            FastCollection.Record e = row._elements.head();
            FastMap.Entry end = row._elements.tail();
            while ((e = ((FastMap.Entry)e).getNext()) != end) {
                Field element = (Field)((FastMap.Entry)e).getValue();
                ((FastMap.Entry)e).setValue(detInv.times(element));
            }
        }
        return A;
    }

    @Override
    public F determinant() {
        if (!this.isSquare()) {
            throw new DimensionException("Matrix not square");
        }
        if (this._n == 1) {
            return this.get(0, 0);
        }
        Vector row0 = this.getRow(0);
        Field det = null;
        FastCollection.Record e = ((SparseVector)row0)._elements.head();
        FastMap.Entry end = ((SparseVector)row0)._elements.tail();
        while ((e = ((FastMap.Entry)e).getNext()) != end) {
            int i = ((Index)((FastMap.Entry)e).getKey()).intValue();
            Field d = (Field)((Field)((FastMap.Entry)e).getValue()).times(this.cofactor(0, i));
            if (i % 2 != 0) {
                d = (Field)d.opposite();
            }
            det = det == null ? d : det.plus(d);
        }
        return (F)(det == null ? (Field)this._zero : det);
    }

    @Override
    public Matrix<F> solve(Matrix<F> y) {
        return ((SparseMatrix)this.inverse()).times((Matrix)y);
    }

    @Override
    public SparseMatrix<F> transpose() {
        SparseMatrix<F> M = SparseMatrix.newInstance(this._n, this._zero, !this._transposed);
        M._rows.addAll(this._rows);
        return M;
    }

    @Override
    public F cofactor(int i, int j) {
        if (this._transposed) {
            int k = i;
            i = j;
            j = k;
        }
        int m = this._rows.size();
        SparseMatrix<F> M = SparseMatrix.newInstance(m - 1, this._zero, this._transposed);
        for (int k1 = 0; k1 < m; ++k1) {
            if (k1 == i) continue;
            SparseVector<F> row = this._rows.get(k1);
            SparseVector<F> V = SparseVector.newInstance(this._n - 1, this._zero);
            M._rows.add(V);
            FastCollection.Record e = row._elements.head();
            FastMap.Entry end = row._elements.tail();
            while ((e = ((FastMap.Entry)e).getNext()) != end) {
                int index = ((Index)((FastMap.Entry)e).getKey()).intValue();
                if (index < j) {
                    V._elements.put((Index)((FastMap.Entry)e).getKey(), ((FastMap.Entry)e).getValue());
                    continue;
                }
                if (index <= j) continue;
                V._elements.put(Index.valueOf(index - 1), ((FastMap.Entry)e).getValue());
            }
        }
        return M.determinant();
    }

    @Override
    public SparseMatrix<F> adjoint() {
        SparseMatrix<F> M = SparseMatrix.newInstance(this._n, this._zero, this._transposed);
        int m = this._rows.size();
        for (int i = 0; i < m; ++i) {
            SparseVector<F> row = SparseVector.newInstance(this._n, this._zero);
            M._rows.add(row);
            for (int j = 0; j < this._n; ++j) {
                F cofactor;
                F f = cofactor = this._transposed ? this.cofactor(j, i) : this.cofactor(i, j);
                if (this._zero.equals(cofactor)) continue;
                row._elements.put(Index.valueOf(j), (i + j) % 2 == 0 ? cofactor : (Field)cofactor.opposite());
            }
        }
        return M.transpose();
    }

    @Override
    public SparseMatrix<F> tensor(Matrix<F> that) {
        int thism = this.getNumberOfRows();
        int thisn = this.getNumberOfColumns();
        int thatm = that.getNumberOfRows();
        int thatn = that.getNumberOfColumns();
        int n = thisn * thatn;
        int m = thism * thatm;
        SparseMatrix<F> M = SparseMatrix.newInstance(n, this._zero, false);
        for (int i = 0; i < m; ++i) {
            int i_rem_thatm = i % thatm;
            int i_div_thatm = i / thatm;
            SparseVector<F> row = SparseVector.newInstance(n, this._zero);
            M._rows.add(row);
            Vector thisRow = this.getRow(i_div_thatm);
            FastCollection.Record e = ((SparseVector)thisRow)._elements.head();
            FastMap.Entry end = ((SparseVector)thisRow)._elements.tail();
            while ((e = ((FastMap.Entry)e).getNext()) != end) {
                Field a = (Field)((FastMap.Entry)e).getValue();
                int j = ((Index)((FastMap.Entry)e).getKey()).intValue();
                for (int k = 0; k < thatn; ++k) {
                    F b = that.get(i_rem_thatm, k);
                    if (b.equals(this._zero)) continue;
                    row._elements.put(Index.valueOf(j * thatn + k), a.times(b));
                }
            }
        }
        return M;
    }

    @Override
    public SparseVector<F> vectorization() {
        SparseVector<F> V = SparseVector.newInstance(this._n * this.getNumberOfRows(), this._zero);
        int offset = 0;
        int n = this.getNumberOfColumns();
        for (int j = 0; j < n; ++j) {
            Vector column = this.getColumn(j);
            FastCollection.Record e = ((SparseVector)column)._elements.head();
            FastMap.Entry end = ((SparseVector)column)._elements.tail();
            while ((e = ((FastMap.Entry)e).getNext()) != end) {
                V._elements.put(Index.valueOf(((Index)((FastMap.Entry)e).getKey()).intValue() + offset), ((FastMap.Entry)e).getValue());
            }
            offset += this.getNumberOfRows();
        }
        return V;
    }

    @Override
    public SparseMatrix<F> copy() {
        SparseMatrix<Field> M = SparseMatrix.newInstance(this._n, (Field)this._zero.copy(), this._transposed);
        for (SparseVector<F> row : this._rows) {
            M._rows.add((SparseVector<F>)row.copy());
        }
        return M;
    }

    static <F extends Field<F>> SparseMatrix<F> newInstance(int n, F zero, boolean transposed) {
        SparseMatrix M = FACTORY.object();
        M._n = n;
        M._zero = zero;
        M._transposed = transposed;
        return M;
    }

    private SparseMatrix() {
    }
}

