/*
 * Decompiled with CFR 0.152.
 */
package medusa.spectral;

import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.impl.SparseDoubleMatrix2D;

public class SparseMatrixOps {
    public static double[] rowSum(DoubleMatrix2D m) {
        int rows = m.rows();
        int cols = m.columns();
        double[] result = new double[rows];
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < cols; ++j) {
                int n = i;
                result[n] = result[n] + m.get(i, j);
            }
        }
        return result;
    }

    public static DoubleMatrix2D timesElement(DoubleMatrix2D m, double[] arr) {
        int rows = m.rows();
        int cols = m.columns();
        SparseDoubleMatrix2D temp = new SparseDoubleMatrix2D(rows, cols);
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < cols; ++j) {
                temp.setQuick(i, j, m.get(i, j) * arr[j]);
            }
        }
        return temp;
    }

    public static DoubleMatrix2D sqrtElement(DoubleMatrix2D m) {
        DoubleMatrix2D temp = m.copy();
        int rows = m.rows();
        int cols = m.rows();
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < cols; ++j) {
                temp.setQuick(i, j, Math.sqrt(m.get(i, j)));
            }
        }
        return temp;
    }

    public static DoubleMatrix2D identity(DoubleMatrix2D m) {
        int rows = m.rows();
        SparseDoubleMatrix2D s = new SparseDoubleMatrix2D(rows, rows);
        for (int i = 0; i < rows; ++i) {
            s.setQuick(i, i, 1.0);
        }
        return s;
    }
}

