/*
 * Decompiled with CFR 0.152.
 */
package medusa.graphedit;

import java.util.Iterator;
import javax.swing.table.AbstractTableModel;
import medusa.graph.Edge;
import medusa.graph.Graph;

public class EdgeTableModel
extends AbstractTableModel {
    private Graph g;
    protected Object[][] data;
    public String[] columnNames = new String[]{"Node 1", "Node 2", "Type", "Orient.", "Confidence", "Mark"};
    protected int columnCount;
    protected int rowCount;
    final Object[] reference = new Object[]{new String(), new String(), new Integer(0), new Double(0.0), new Float(1.0f), new Boolean(false)};

    public EdgeTableModel(Graph g) {
        this.setG(g);
        this.init();
    }

    public EdgeTableModel() {
    }

    public void init() {
        this.columnCount = 6;
        this.rowCount = this.getG().getEdgeSize();
        this.data = new Object[this.rowCount][this.columnCount];
        int count = 0;
        Iterator<Edge> edgeI = this.getG().edgesIterator();
        while (edgeI.hasNext()) {
            Edge e = edgeI.next();
            this.data[count][0] = e.getFromName();
            this.data[count][1] = e.getToName();
            this.data[count][2] = new Integer(e.getType());
            this.data[count][3] = new Double(e.getOrientation());
            this.data[count][4] = new Float(e.getConf());
            this.data[count][5] = new Boolean(false);
            ++count;
        }
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.data[rowIndex][columnIndex];
    }

    @Override
    public int getColumnCount() {
        return this.columnCount;
    }

    @Override
    public int getRowCount() {
        return this.rowCount;
    }

    @Override
    public String getColumnName(int column) {
        String retValue = this.columnNames[column];
        return retValue;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return col > 1;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        this.data[row][col] = value;
        this.fireTableCellUpdated(row, col);
    }

    public void removeEdges() {
        for (int i = 0; i < this.getRowCount(); ++i) {
            Boolean marked = (Boolean)this.data[i][5];
            if (!marked.booleanValue()) continue;
            System.out.println("removing " + this.data[i][0] + " " + this.data[i][1]);
            Edge e = new Edge((String)this.data[i][0], (String)this.data[i][1], (Integer)this.data[i][2], (Double)this.data[i][3], (Float)this.data[i][4]);
            this.g.removeEdge(e);
        }
        this.init();
    }

    public Graph getG() {
        return this.g;
    }

    public void setG(Graph g) {
        this.g = g;
    }

    public Class getColumnClass(int columnIndex) {
        Class<?> retValue = this.reference[columnIndex].getClass();
        return retValue;
    }

    public Graph getGraph() {
        Graph g = new Graph();
        for (int i = 0; i < this.getRowCount(); ++i) {
            Edge e = new Edge((String)this.data[i][0], (String)this.data[i][1], (Integer)this.data[i][2], (Double)this.data[i][3], (Float)this.data[i][4]);
            g.addEdge(e);
        }
        return g;
    }
}

