/*
 * Decompiled with CFR 0.152.
 */
package medusa.graph;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import medusa.graph.Edge;
import medusa.graph.Node;
import medusa.graph.UniqueEdge;

public class BasicGraph
implements Serializable {
    private List<Edge> edges = new ArrayList<Edge>();
    private List<UniqueEdge> uniqueEdges = new ArrayList<UniqueEdge>();
    private Map<String, Node> nodes = new HashMap<String, Node>();
    private String comment;

    public final void setComment(String argComment) {
        this.comment = argComment;
    }

    public boolean isPlanar() {
        int planar = this.getNodeSize() * 3 - 6;
        return this.getEdgeSize() < planar;
    }

    public void addEdge(Edge e) {
        if (!this.getEdges().contains(e) & e != null) {
            this.getEdges().add(e);
            this.addNode(e.getFromName());
            this.addNode(e.getToName());
            UniqueEdge ue = new UniqueEdge(e);
            if (!this.uniqueEdges.contains(ue)) {
                this.getUniqueEdges().add(ue);
            }
        }
    }

    public void addEdge(Node n1, Node n2, float conf, int type) {
        Edge e = new Edge(n1.getLabel(), n2.getLabel(), conf, type);
        if (!this.getEdges().contains(e) & e != null) {
            this.getEdges().add(e);
            this.addNode(n1);
            this.addNode(n2);
            UniqueEdge ue = new UniqueEdge(e);
            if (!this.uniqueEdges.contains(ue)) {
                this.getUniqueEdges().add(ue);
            }
        }
    }

    public void addNode(Node n) {
        if (!this.nodes.containsKey(n.getLabel())) {
            n.addConnection();
            this.getNodes().put(n.getLabel(), n);
        } else {
            Node n1 = this.getNode(n.getLabel());
            n1.addConnection();
            this.getNodes().put(n.getLabel(), n);
        }
    }

    public Node getNode(String name) {
        return this.getNodes().get(name);
    }

    public Node[] getNodesForEdge(Edge e) {
        Node[] nodeArray = new Node[]{this.getNode(e.getToName()), this.getNode(e.getFromName())};
        return nodeArray;
    }

    public void addNode(String name) {
        Node n = new Node(name);
        n.addConnection();
        if (!this.nodes.containsKey(name)) {
            this.getNodes().put(name, n);
        } else {
            n = this.getNode(name);
            n.addConnection();
            this.getNodes().put(name, n);
        }
    }

    public String getComment() {
        return this.comment;
    }

    public void clear() {
        this.getEdges().clear();
        this.getNodes().clear();
        this.getUniqueEdges().clear();
        this.setComment("");
    }

    public void addComment(String line) {
        if (line == null) {
            return;
        }
        if (line.length() > 1) {
            this.setComment(line);
        }
    }

    public void removeEdge(Edge e) {
        if (!this.getEdges().contains(e)) {
            return;
        }
        this.getEdges().remove(e);
        this.removeNode(e.getFromName());
        this.removeNode(e.getToName());
        UniqueEdge ue = new UniqueEdge(e);
        if (!this.getEdges().contains(ue)) {
            this.getUniqueEdges().remove(ue);
        }
    }

    private void removeNode(String name) {
        Node n = this.getNode(name);
        this.getNodes().remove(name);
        if (n.removeConnection()) {
            this.getNodes().put(name, n);
        }
    }

    private void removeNode(Node n) {
        this.removeNode(n.getLabel());
    }

    public Iterator<Node> nodesIterator() {
        return this.getNodes().values().iterator();
    }

    public Iterator<Edge> edgesIterator() {
        return this.getEdges().iterator();
    }

    public void copyNodeSettings(BasicGraph temp) {
        if (temp == null) {
            return;
        }
        Iterator<Node> i = temp.nodesIterator();
        while (i.hasNext()) {
            Node n = i.next();
            this.setNode(n);
        }
    }

    public String report() {
        StringBuffer sb = new StringBuffer();
        if (this.getComment() != null) {
            sb.append(this.getComment());
            sb.append("\n");
        }
        sb.append("*edges");
        Iterator<Serializable> i = this.edgesIterator();
        while (i.hasNext()) {
            Edge e = i.next();
            sb.append("\n");
            sb.append(e.report());
        }
        sb.append("\n*nodes\n");
        i = this.nodesIterator();
        while (i.hasNext()) {
            Node n = (Node)i.next();
            sb.append(n.report());
            sb.append("\n");
        }
        return sb.toString();
    }

    public void setNode(Node n) {
        if (this.getNodes().containsKey(n.getLabel())) {
            Node n2 = this.getNode(n.getLabel());
            n2.setColor(n.getColor());
            n2.setShape(n.getShape());
            n2.setX(n.getX());
            n2.setY(n.getY());
            n2.setAnnotation(n.getAnnotation());
        }
    }

    public Iterator<UniqueEdge> uniqueEdgesIterator() {
        return this.getUniqueEdges().iterator();
    }

    public List<Edge> getEdges() {
        return this.edges;
    }

    public int getNodeSize() {
        return this.getNodes().size();
    }

    public int getEdgeSize() {
        return this.getEdges().size();
    }

    public int getUniqueEdgeSize() {
        return this.getUniqueEdges().size();
    }

    public List<UniqueEdge> getUniqueEdges() {
        return this.uniqueEdges;
    }

    public Map<String, Node> getNodes() {
        return this.nodes;
    }
}

