/*
 * Decompiled with CFR 0.152.
 */
package medusa.georgios.enhanced_mcl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import medusa.georgios.enhanced_mcl.SparseVector;
import medusa.georgios.enhanced_mcl.Vectors;

public class SparseMatrix
extends ArrayList<SparseVector> {
    private static final long serialVersionUID = 1L;
    private int maxVLength;

    public SparseMatrix() {
    }

    public SparseMatrix(int rows, int cols) {
        this();
        this.adjustMaxIndex(rows - 1, cols - 1);
    }

    public SparseMatrix(double[][] x) {
        this(x.length - 1, x[0].length - 1);
        for (int i = 0; i < x.length; ++i) {
            SparseVector v = new SparseVector(x[i]);
            this.set(i, v);
        }
    }

    public SparseMatrix(SparseMatrix matrix) {
        for (SparseVector s : matrix) {
            this.add(s.copy());
        }
    }

    public double[][] getDense() {
        double[][] aa = new double[this.size()][];
        for (int i = 0; i < this.size(); ++i) {
            aa[i] = new double[this.maxVLength];
            Iterator iterator = ((SparseVector)this.get(i)).keySet().iterator();
            while (iterator.hasNext()) {
                int j = (Integer)iterator.next();
                aa[i][j] = ((SparseVector)this.get(i)).get(j);
            }
        }
        return aa;
    }

    @Override
    public SparseVector set(int i, SparseVector x) {
        this.adjustMaxIndex(i, x.getLength() - 1);
        return super.set(i, x);
    }

    public double get(int i, int j) {
        if (i > this.size() - 1) {
            return 0.0;
        }
        return ((SparseVector)this.get(i)).get(j);
    }

    public double set(int i, int j, double a) {
        this.adjustMaxIndex(i, j);
        double b = ((SparseVector)this.get(i)).get(j);
        ((SparseVector)this.get(i)).put(j, a);
        return b;
    }

    public void adjustMaxIndex(int i, int j) {
        if (i > this.size() - 1) {
            this.increase(i);
        }
        if (j >= this.maxVLength) {
            this.maxVLength = j + 1;
            for (int row = 0; row < this.size(); ++row) {
                ((SparseVector)this.get(row)).setLength(this.maxVLength);
            }
        }
    }

    private void increase(int i) {
        this.addAll(Collections.nCopies(i - this.size() + 1, new SparseVector()));
    }

    public int[] getSize() {
        return new int[]{this.size(), this.maxVLength};
    }

    public double add(int i, int j, double a) {
        this.adjustMaxIndex(i, j);
        double b = this.get(i, j);
        this.set(i, j, a += b);
        return a;
    }

    public SparseVector normalise(double rowsum) {
        SparseVector sums = new SparseVector();
        int i = 0;
        for (SparseVector vec : this) {
            sums.put(i, vec.normalise(rowsum));
            ++i;
        }
        return sums;
    }

    public void normaliseRows() {
        for (SparseVector vec : this) {
            vec.normalise();
        }
    }

    public void normaliseCols() {
        int col;
        int row;
        double[] sums = new double[this.maxVLength];
        for (row = 0; row < this.size(); ++row) {
            for (col = 0; col < ((SparseVector)this.get(row)).getLength(); ++col) {
                int n = col;
                sums[n] = sums[n] + ((SparseVector)this.get(row)).get(col);
            }
        }
        for (row = 0; row < this.size(); ++row) {
            for (col = 0; col < ((SparseVector)this.get(row)).getLength(); ++col) {
                ((SparseVector)this.get(row)).mult(col, 1.0 / sums[col]);
            }
        }
    }

    public SparseMatrix copy() {
        return new SparseMatrix(this);
    }

    public SparseVector times(SparseVector v) {
        SparseVector w = new SparseVector();
        for (int i = 0; i < this.size(); ++i) {
            w.add(i, ((SparseVector)this.get(i)).times(v));
        }
        return w;
    }

    public SparseVector vectorTimes(SparseVector v) {
        SparseVector w = new SparseVector();
        Iterator iterator = v.keySet().iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            SparseVector a = ((SparseVector)this.get(i)).copy();
            a.factor(v.get(i));
            w.add(a);
        }
        return w;
    }

    public SparseMatrix timesTransposed(SparseMatrix m) {
        for (int i = 0; i < this.size(); ++i) {
            this.set(i, m.times((SparseVector)this.get(i)));
        }
        return this;
    }

    public SparseMatrix times(SparseMatrix m) {
        SparseMatrix s = new SparseMatrix();
        for (int i = 0; i < this.size(); ++i) {
            for (int j = 0; j < m.size(); ++j) {
                Iterator iterator = ((SparseVector)this.get(i)).keySet().iterator();
                while (iterator.hasNext()) {
                    int k = (Integer)iterator.next();
                    double a = m.get(k, j);
                    if (a == 0.0) continue;
                    s.add(i, j, this.get(i, k) * a);
                }
            }
        }
        return s;
    }

    public SparseMatrix matrixTimes(SparseMatrix m) {
        return m.times(this);
    }

    public SparseMatrix transpose() {
        SparseMatrix s = new SparseMatrix();
        for (int i = 0; i < this.size(); ++i) {
            s.set(i, this.getColum(i));
        }
        return s;
    }

    public SparseVector getColum(int i) {
        SparseVector s = new SparseVector();
        for (int row = 0; row < this.size(); ++row) {
            double v = this.get(row, i);
            if (v == 0.0) continue;
            s.put(row, v);
        }
        return s;
    }

    public void hadamardProduct(SparseMatrix m) {
        for (int i = 0; i < this.size(); ++i) {
            ((SparseVector)this.get(i)).hadamardProduct((SparseVector)m.get(i));
        }
    }

    public void hadamardPower(double s) {
        for (int i = 0; i < this.size(); ++i) {
            ((SparseVector)this.get(i)).hadamardPower(s);
        }
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.size(); ++i) {
            sb.append(i).append(" => ").append(this.get(i)).append("\n");
        }
        return sb.toString();
    }

    public String toStringDense() {
        return Vectors.print(this.getDense());
    }

    public void prune(double threshold) {
        for (int i = 0; i < this.size(); ++i) {
            SparseVector a = (SparseVector)this.get(i);
            a.prune(threshold);
        }
    }
}

