/*
 * Decompiled with CFR 0.152.
 */
package medusa.georgios.enhanced_mcl;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import medusa.georgios.enhanced_mcl.List2Graph;
import medusa.georgios.enhanced_mcl.SparseMatrix;
import medusa.georgios.enhanced_mcl.SparseVector;

public class My_MarkovClustering {
    public static SparseMatrix aa;
    public static double[][] a;
    public static List2Graph g;
    int clusters = 0;
    String report;

    public static void main(String[] args) {
        System.out.println("\nrun like java -jar far_filename input_file inflation\n\n");
        String filename = "example.txt";
        g = new List2Graph(filename);
        a = g.return_double_matrix();
        aa = new SparseMatrix(a);
        aa = aa.transpose();
        double maxResidual = 0.001;
        double gammaExp = Double.parseDouble(args[1]);
        double loopGain = 0.05;
        double zeroMax = 0.001;
        System.out.println("filename:" + filename);
        System.out.println("gamma:" + gammaExp);
        My_MarkovClustering mcl = new My_MarkovClustering();
        aa = mcl.run(aa, maxResidual, gammaExp, loopGain, zeroMax);
        mcl.show_clusters();
        mcl.Save_To_File("MCL_results.txt", true);
    }

    public void show_clusters() {
        StringBuffer str = new StringBuffer();
        ArrayList<Integer> used = new ArrayList<Integer>();
        for (int i = 0; i < a.length; ++i) {
            if (used.contains(i) || aa.getColum(i).getLength() == 0) continue;
            ++this.clusters;
            str.append("----------------- Cluster: " + this.clusters + " -----------------\n");
            Iterator it = aa.getColum(i).keySet().iterator();
            while (it.hasNext()) {
                int index = (Integer)it.next();
                used.add(index);
                str.append(List2Graph.labels.get(index) + "\n");
            }
        }
        System.out.println(str.toString());
    }

    public int getNumberOfClusters() {
        return this.clusters;
    }

    public String Save_To_File(String filename, boolean storeFile) {
        try {
            this.clusters = 0;
            StringBuffer str = new StringBuffer();
            ArrayList<Integer> used = new ArrayList<Integer>();
            for (int i = 0; i < a.length; ++i) {
                if (used.contains(i) || aa.getColum(i).getLength() == 0) continue;
                ++this.clusters;
                str.append("----------------- Cluster: " + this.clusters + " -----------------\n");
                Iterator it = aa.getColum(i).keySet().iterator();
                while (it.hasNext()) {
                    int index = (Integer)it.next();
                    used.add(index);
                    str.append(List2Graph.labels.get(index) + "\n");
                }
            }
            if (storeFile) {
                BufferedWriter outp = new BufferedWriter(new FileWriter(filename));
                outp.append(str.toString());
                outp.close();
            }
            this.report = str.toString();
            return str.toString();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public String getReport() {
        return this.report;
    }

    public void setReport(String str) {
        this.report = str;
    }

    public SparseMatrix run(SparseMatrix a, double maxResidual, double pGamma, double loopGain, double maxZero) {
        System.out.println("Inflation: " + pGamma);
        this.addLoops(a, loopGain);
        if (loopGain > 0.0) {
            My_MarkovClustering.print(a, "... with added loops");
        }
        a.normaliseRows();
        double residual = 1.0;
        int i = 0;
        while (residual > maxResidual) {
            ++i;
            a = this.expand(a);
            residual = this.inflate(a, pGamma, maxZero);
        }
        return a;
    }

    private static void print(SparseMatrix a, String label) {
    }

    public My_MarkovClustering() {
    }

    public My_MarkovClustering(String filename) {
        g = new List2Graph(filename);
        a = g.return_double_matrix();
        aa = new SparseMatrix(a);
        aa = aa.transpose();
        double maxResidual = 0.001;
        double gammaExp = 2.0;
        double loopGain = 0.001;
        double zeroMax = 0.001;
        My_MarkovClustering mcl = new My_MarkovClustering();
        aa = mcl.run(aa, maxResidual, gammaExp, loopGain, zeroMax);
    }

    public My_MarkovClustering(ArrayList<String> list) {
        g = new List2Graph(list);
        a = g.return_double_matrix();
        aa = new SparseMatrix(a);
        aa = aa.transpose();
        double maxResidual = 0.001;
        double gammaExp = 2.0;
        double loopGain = 0.05;
        double zeroMax = 0.001;
        My_MarkovClustering mcl = new My_MarkovClustering();
        aa = mcl.run(aa, maxResidual, gammaExp, loopGain, zeroMax);
    }

    public double inflate(SparseMatrix m, double p, double zeromax) {
        double res = 0.0;
        m.hadamardPower(p);
        m.prune(zeromax);
        SparseVector rowsums = m.normalise(1.0);
        Iterator iterator = rowsums.keySet().iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            SparseVector row = (SparseVector)m.get(i);
            double max = row.max();
            double sumsq = row.sum(2.0);
            res = Math.max(res, max - sumsq);
        }
        return res;
    }

    public SparseMatrix expand(SparseMatrix m) {
        m = m.times(m);
        return m;
    }

    private void addLoops(SparseMatrix a, double loopGain) {
        if (loopGain <= 0.0) {
            return;
        }
        for (int i = 0; i < a.size(); ++i) {
            a.add(i, i, loopGain);
        }
    }
}

