/*
 * Decompiled with CFR 0.152.
 */
package medusa.georgios.color_factory;

import java.util.ArrayList;
import medusa.georgios.vecmathpackage.Point3f;
import medusa.georgios.vecmathpackage.Vector3f;

public abstract class AbstractCurve3f {
    private ArrayList coordinates = new ArrayList();
    private boolean useDefaultDomain = true;
    private int domainStart = 0;
    private int domainStop = 0;
    private int domainWidth = 0;

    public void setCoordinates(ArrayList coordinates) {
        this.coordinates = coordinates;
        if (this.useDefaultDomain) {
            this.setDomain(0, coordinates.size() - 1);
        } else {
            this.checkDomain();
        }
    }

    public void setUseDefaultDomain(boolean useDefaultDomain) {
        this.useDefaultDomain = useDefaultDomain;
    }

    public void setDomain(int domainStart, int domainStop) {
        this.domainStart = domainStart;
        this.domainStop = domainStop;
        this.checkDomain();
    }

    public ArrayList getCoordinates() {
        return this.coordinates;
    }

    public boolean isUseDefaultDomain() {
        return this.useDefaultDomain;
    }

    public abstract Vector3f computeTangent(float var1);

    public abstract Point3f computePoint(float var1);

    public int mapCurveParameterToSegmentIndex(float parameter) {
        int index = (int)(parameter *= (float)this.domainWidth);
        if (index < 0) {
            index = 0;
        }
        if (index >= this.domainStop) {
            index = this.domainStop - 1;
        }
        return index;
    }

    public float mapCurveParameterToSegmentParamter(int index, float parameter) {
        return (parameter *= (float)this.domainWidth) - (float)index;
    }

    private void checkDomain() {
        if (this.domainStart < 0) {
            this.domainStart = 0;
        }
        if (this.domainStop < this.domainStart) {
            this.domainStop = this.domainStart;
        }
        if (this.domainStop > this.coordinates.size() - 1) {
            this.domainStop = this.coordinates.size() - 1;
        }
        this.domainWidth = this.domainStop - this.domainStart;
    }
}

