/*
 * Decompiled with CFR 0.152.
 */
package medusa.georgios.ClusteringAlgorithms;

import java.util.ArrayList;
import java.util.Hashtable;

public class Node {
    public int id;
    public String Label;
    public boolean is_leaf;
    public Node left_child;
    public Node right_child;
    public Node parent;
    public Node higher_parent;
    public ArrayList<String> labels;
    public int id_counter = 0;
    Hashtable<Integer, Node> Index_nodes_map = new Hashtable();
    StringBuffer NHX = new StringBuffer("");

    public Node(ArrayList<String> Labels) {
        this.labels = Labels;
    }

    public Node create_node() {
        Node leaf_node = null;
        leaf_node = new Node(this.labels);
        leaf_node.id = this.id_counter++;
        leaf_node.is_leaf = true;
        leaf_node.left_child = null;
        leaf_node.right_child = null;
        leaf_node.parent = null;
        this.Index_nodes_map.put(leaf_node.id, leaf_node);
        return leaf_node;
    }

    private void calculate_tree_NewickFormat(Node cluster2) {
        if (cluster2 != null) {
            if (!cluster2.is_leaf) {
                this.NHX.append("(");
                this.calculate_tree_NewickFormat(cluster2.left_child);
            }
            if (!cluster2.is_leaf) {
                this.NHX.append(",");
            } else if (cluster2.id <= this.labels.size()) {
                this.NHX.append(this.labels.get(cluster2.id));
            }
            if (!cluster2.is_leaf) {
                this.calculate_tree_NewickFormat(cluster2.right_child);
                this.NHX.append(")");
            }
        }
    }

    public String get_tree_NewickFormat(Node cluster2) {
        this.calculate_tree_NewickFormat(cluster2);
        this.NHX.append(";");
        return this.NHX.toString();
    }

    public String get_tree_NewickFormat() {
        this.NHX.delete(0, this.NHX.length());
        this.search_higher_ancestor_of(this.Index_nodes_map.get(0));
        this.calculate_tree_NewickFormat(this.higher_parent);
        this.NHX.append(";");
        return this.NHX.toString();
    }

    public void search_higher_ancestor_of(Node cluster2) {
        if (cluster2 != null) {
            if (cluster2.parent != null) {
                this.higher_parent = cluster2.parent;
                this.search_higher_ancestor_of(cluster2.parent);
            } else {
                this.higher_parent = cluster2;
            }
        }
    }

    public boolean connection_exists(Node parent, Node child) {
        boolean connection_exists = false;
        if (parent == null || child == null) {
            return false;
        }
        if (parent.id == child.id) {
            return true;
        }
        this.search_higher_ancestor_of(parent);
        int id_n1 = this.higher_parent.id;
        this.search_higher_ancestor_of(child);
        int id_n2 = this.higher_parent.id;
        if (id_n1 == id_n2) {
            connection_exists = true;
        }
        return connection_exists;
    }

    void connect(Node parent, Node child) {
        if (parent.left_child != null && parent.right_child != null) {
            System.out.println("Has already 2 children");
        }
        if (parent.left_child != null) {
            parent.right_child = child;
        } else {
            parent.left_child = child;
        }
        child.parent = parent;
        if (parent.left_child != null || parent.right_child != null) {
            parent.is_leaf = false;
        }
    }
}

