/*
 * Decompiled with CFR 0.152.
 */
package medusa.georgios.ClusteringAlgorithms;

import medusa.georgios.ClusteringAlgorithms.Clustering_NJ_UPGMA;
import medusa.georgios.ClusteringAlgorithms.NJCluster;

public class NJ {
    int N;
    int K;
    NJCluster[] cluster;
    float[] r;
    public StringBuffer NHX = new StringBuffer("");

    public NJ(float[][] ds) {
        this.N = ds.length;
        this.cluster = new NJCluster[2 * this.N - 1];
        for (int i = 0; i < this.N; ++i) {
            this.cluster[i] = new NJCluster(i, ds[i]);
        }
        this.r = new float[2 * this.N - 1];
        this.K = this.N;
        while (this.K < 2 * this.N - 2) {
            this.findAndJoin();
        }
        int K2 = this.K - 2;
        while (!this.cluster[K2].live()) {
            --K2;
        }
        float dij = this.d(K2, this.K - 1) / 2.0f;
        this.cluster[this.K] = new NJCluster(this.K, this.cluster[K2], dij, this.cluster[this.K - 1], dij, null);
        ++this.K;
    }

    void computeR() {
        for (int i = 0; i < this.K; ++i) {
            if (!this.cluster[i].live()) continue;
            float sum = 0.0f;
            for (int k = 0; k < this.K; ++k) {
                if (!this.cluster[k].live() || k == i) continue;
                sum += this.d(i, k);
            }
            int L = 2 * this.N - this.K;
            this.r[i] = sum / (float)(L - 2);
        }
    }

    public NJCluster getRoot() {
        return this.cluster[this.K - 1];
    }

    public float d(int i, int j) {
        return this.cluster[Math.max((int)i, (int)j)].dmat[Math.min(i, j)];
    }

    void findAndJoin() {
        this.computeR();
        int mini = -1;
        int minj = -1;
        float mind = Float.POSITIVE_INFINITY;
        for (int i = 0; i < this.K; ++i) {
            if (!this.cluster[i].live()) continue;
            for (int j = 0; j < i; ++j) {
                float d;
                if (!this.cluster[j].live() || !((d = this.d(i, j) - (this.r[i] + this.r[j])) < mind)) continue;
                mind = d;
                mini = i;
                minj = j;
            }
        }
        this.join(mini, minj);
    }

    public void join(int i, int j) {
        float[] dmat = new float[this.K];
        float dij = this.d(i, j);
        for (int m = 0; m < this.K; ++m) {
            if (!this.cluster[m].live() || m == i || m == j) continue;
            dmat[m] = (this.d(i, m) + this.d(j, m) - dij) / 2.0f;
        }
        float dik = (dij + this.r[i] - this.r[j]) / 2.0f;
        float djk = dij - dik;
        this.cluster[this.K] = new NJCluster(this.K, this.cluster[i], dik, this.cluster[j], djk, dmat);
        this.cluster[i].kill();
        this.cluster[j].kill();
        ++this.K;
    }

    public boolean checkAdditivity() {
        for (int i = 0; i < this.N; ++i) {
            for (int j = i + 1; j < this.N; ++j) {
                for (int k = j + 1; k < this.N; ++k) {
                    for (int m = k + 1; m < this.N; ++m) {
                        float dijdkm = this.d(i, j) + this.d(k, m);
                        float dikdjm = this.d(i, k) + this.d(j, m);
                        float dimdjk = this.d(i, m) + this.d(j, k);
                        if (dijdkm == dikdjm && dijdkm >= dimdjk || dijdkm == dimdjk && dijdkm >= dikdjm || dikdjm == dimdjk && dikdjm >= dijdkm) continue;
                        System.out.println("(i, j, k, m) = (" + i + "," + j + "," + k + "," + m + ")");
                        return false;
                    }
                }
            }
        }
        return true;
    }

    public boolean is_internal(NJCluster cluster2) {
        return cluster2.left != null || cluster2.right != null;
    }

    public String NewickFormat(NJCluster cluster2) {
        if (this.is_internal(cluster2)) {
            this.NHX.append("(");
            this.NewickFormat(cluster2.left);
        }
        if (this.is_internal(cluster2)) {
            this.NHX.append(",");
        } else {
            this.NHX.append(Clustering_NJ_UPGMA.labels.get(cluster2.lab - 1));
        }
        if (this.is_internal(cluster2)) {
            this.NewickFormat(cluster2.right);
            this.NHX.append(")");
        }
        return this.NHX.toString() + ";";
    }
}

